/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.java.JavaLibrary;
import org.gradle.api.internal.java.JavaLibraryPlatform;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.language.jvm.tasks.ProcessResources;

public class JavaPlugin
implements Plugin<ProjectInternal> {
    public static final String PROCESS_RESOURCES_TASK_NAME = "processResources";
    public static final String CLASSES_TASK_NAME = "classes";
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    public static final String PROCESS_TEST_RESOURCES_TASK_NAME = "processTestResources";
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    public static final String COMPILE_TEST_JAVA_TASK_NAME = "compileTestJava";
    public static final String TEST_TASK_NAME = "test";
    public static final String JAR_TASK_NAME = "jar";
    public static final String JAVADOC_TASK_NAME = "javadoc";
    @Incubating
    public static final String API_CONFIGURATION_NAME = "api";
    @Incubating
    public static final String IMPLEMENTATION_CONFIGURATION_NAME = "implementation";
    @Incubating
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String COMPILE_CONFIGURATION_NAME = "compile";
    public static final String COMPILE_ONLY_CONFIGURATION_NAME = "compileOnly";
    public static final String RUNTIME_CONFIGURATION_NAME = "runtime";
    @Incubating
    public static final String RUNTIME_ONLY_CONFIGURATION_NAME = "runtimeOnly";
    @Incubating
    public static final String RUNTIME_CLASSPATH_CONFIGURATION_NAME = "runtimeClasspath";
    @Incubating
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    @Incubating
    public static final String COMPILE_CLASSPATH_CONFIGURATION_NAME = "compileClasspath";
    @Incubating
    public static final String ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "annotationProcessor";
    public static final String TEST_COMPILE_CONFIGURATION_NAME = "testCompile";
    @Incubating
    public static final String TEST_IMPLEMENTATION_CONFIGURATION_NAME = "testImplementation";
    public static final String TEST_COMPILE_ONLY_CONFIGURATION_NAME = "testCompileOnly";
    public static final String TEST_RUNTIME_CONFIGURATION_NAME = "testRuntime";
    @Incubating
    public static final String TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "testRuntimeOnly";
    @Incubating
    public static final String TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME = "testCompileClasspath";
    @Incubating
    public static final String TEST_ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "testAnnotationProcessor";
    @Incubating
    public static final String TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "testRuntimeClasspath";
    private final ObjectFactory objectFactory;

    @Inject
    public JavaPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        JavaPluginConvention javaConvention = project.getConvention().getPlugin(JavaPluginConvention.class);
        project.getServices().get(ComponentRegistry.class).setMainComponent(new BuildableJavaComponentImpl(javaConvention));
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = project.getServices().get(BuildOutputCleanupRegistry.class);
        this.configureSourceSets(javaConvention, buildOutputCleanupRegistry);
        this.configureConfigurations(project);
        this.configureJavaDoc(javaConvention);
        this.configureTest(project, javaConvention);
        this.configureArchivesAndComponent(project, javaConvention);
        this.configureBuild(project);
    }

    private void configureSourceSets(JavaPluginConvention pluginConvention, final BuildOutputCleanupRegistry buildOutputCleanupRegistry) {
        ProjectInternal project = pluginConvention.getProject();
        SourceSet main = (SourceSet)pluginConvention.getSourceSets().create("main");
        SourceSet test = (SourceSet)pluginConvention.getSourceSets().create(TEST_TASK_NAME);
        test.setCompileClasspath(project.getLayout().configurableFiles(main.getOutput(), project.getConfigurations().getByName(TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME)));
        test.setRuntimeClasspath(project.getLayout().configurableFiles(test.getOutput(), main.getOutput(), project.getConfigurations().getByName(TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME)));
        pluginConvention.getSourceSets().all(new Action<SourceSet>(){

            @Override
            public void execute(SourceSet sourceSet) {
                buildOutputCleanupRegistry.registerOutputs(sourceSet.getOutput());
            }
        });
    }

    private void configureJavaDoc(final JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        project.getTasks().register(JAVADOC_TASK_NAME, Javadoc.class, new Action<Javadoc>(){

            @Override
            public void execute(Javadoc javadoc) {
                SourceSet mainSourceSet = (SourceSet)pluginConvention.getSourceSets().getByName("main");
                javadoc.setDescription("Generates Javadoc API documentation for the main source code.");
                javadoc.setGroup("documentation");
                javadoc.setClasspath(mainSourceSet.getOutput().plus(mainSourceSet.getCompileClasspath()));
                javadoc.setSource(mainSourceSet.getAllJava());
            }
        });
    }

    private void configureArchivesAndComponent(Project project, final JavaPluginConvention pluginConvention) {
        TaskProvider<Jar> jar = project.getTasks().register(JAR_TASK_NAME, Jar.class, new Action<Jar>(){

            @Override
            public void execute(Jar jar) {
                jar.setDescription("Assembles a jar archive containing the main classes.");
                jar.setGroup("build");
                jar.from(((SourceSet)pluginConvention.getSourceSets().getByName("main")).getOutput());
            }
        });
        LazyPublishArtifact jarArtifact = new LazyPublishArtifact(jar);
        Configuration apiElementConfiguration = project.getConfigurations().getByName(API_ELEMENTS_CONFIGURATION_NAME);
        Configuration runtimeConfiguration = project.getConfigurations().getByName(RUNTIME_CONFIGURATION_NAME);
        Configuration runtimeElementsConfiguration = project.getConfigurations().getByName(RUNTIME_ELEMENTS_CONFIGURATION_NAME);
        project.getExtensions().getByType(DefaultArtifactPublicationSet.class).addCandidate(jarArtifact);
        TaskProvider<JavaCompile> javaCompile = project.getTasks().withType(JavaCompile.class).named(COMPILE_JAVA_TASK_NAME);
        TaskProvider<ProcessResources> processResources = project.getTasks().withType(ProcessResources.class).named(PROCESS_RESOURCES_TASK_NAME);
        this.addJar(apiElementConfiguration, jarArtifact);
        this.addJar(runtimeConfiguration, jarArtifact);
        this.addRuntimeVariants(runtimeElementsConfiguration, jarArtifact, javaCompile, processResources);
        project.getComponents().add(this.objectFactory.newInstance(JavaLibrary.class, project.getConfigurations(), jarArtifact));
        project.getComponents().add(this.objectFactory.newInstance(JavaLibraryPlatform.class, project.getConfigurations()));
    }

    private void addJar(Configuration configuration, PublishArtifact jarArtifact) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add(jarArtifact);
        publications.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, JAR_TASK_NAME);
    }

    private void addRuntimeVariants(Configuration configuration, PublishArtifact jarArtifact, final Provider<JavaCompile> javaCompile, final Provider<ProcessResources> processResources) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add(jarArtifact);
        publications.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, JAR_TASK_NAME);
        NamedDomainObjectContainer<ConfigurationVariant> runtimeVariants = publications.getVariants();
        ConfigurationVariant classesVariant = runtimeVariants.create(CLASSES_TASK_NAME);
        classesVariant.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime-classes"));
        classesVariant.artifact(new IntermediateJavaArtifact("java-classes-directory", javaCompile){

            @Override
            public File getFile() {
                return ((JavaCompile)javaCompile.get()).getDestinationDir();
            }
        });
        ConfigurationVariant resourcesVariant = runtimeVariants.create("resources");
        resourcesVariant.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime-resources"));
        resourcesVariant.artifact(new IntermediateJavaArtifact("java-resources-directory", processResources){

            @Override
            public File getFile() {
                return ((ProcessResources)processResources.get()).getDestinationDir();
            }
        });
    }

    private void configureBuild(Project project) {
        project.getTasks().named("buildNeeded").configure(new Action<Task>(){

            @Override
            public void execute(Task task) {
                JavaPlugin.this.addDependsOnTaskInOtherProjects(task, true, "buildNeeded", JavaPlugin.TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME);
            }
        });
        project.getTasks().named("buildDependents").configure(new Action<Task>(){

            @Override
            public void execute(Task task) {
                JavaPlugin.this.addDependsOnTaskInOtherProjects(task, false, "buildDependents", JavaPlugin.TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME);
            }
        });
    }

    private void configureTest(Project project, final JavaPluginConvention pluginConvention) {
        project.getTasks().withType(Test.class).configureEach(new Action<Test>(){

            @Override
            public void execute(Test test) {
                test.getConventionMapping().map("testClassesDirs", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getOutput().getClassesDirs();
                    }
                });
                test.getConventionMapping().map("classpath", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getRuntimeClasspath();
                    }
                });
            }
        });
        final TaskProvider<Test> test = project.getTasks().register(TEST_TASK_NAME, Test.class, new Action<Test>(){

            @Override
            public void execute(Test test) {
                test.setDescription("Runs the unit tests.");
                test.setGroup("verification");
            }
        });
        project.getTasks().named("check").configure(new Action<Task>(){

            @Override
            public void execute(Task task) {
                task.dependsOn(test);
            }
        });
    }

    private void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration defaultConfiguration = configurations.getByName("default");
        Configuration compileConfiguration = configurations.getByName(COMPILE_CONFIGURATION_NAME);
        Configuration implementationConfiguration = configurations.getByName(IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration runtimeConfiguration = configurations.getByName(RUNTIME_CONFIGURATION_NAME);
        Configuration runtimeOnlyConfiguration = configurations.getByName(RUNTIME_ONLY_CONFIGURATION_NAME);
        Configuration compileTestsConfiguration = configurations.getByName(TEST_COMPILE_CONFIGURATION_NAME);
        Configuration testImplementationConfiguration = configurations.getByName(TEST_IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration testRuntimeConfiguration = configurations.getByName(TEST_RUNTIME_CONFIGURATION_NAME);
        Configuration testRuntimeOnlyConfiguration = configurations.getByName(TEST_RUNTIME_ONLY_CONFIGURATION_NAME);
        compileTestsConfiguration.extendsFrom(compileConfiguration);
        testImplementationConfiguration.extendsFrom(implementationConfiguration);
        testRuntimeConfiguration.extendsFrom(runtimeConfiguration);
        testRuntimeOnlyConfiguration.extendsFrom(runtimeOnlyConfiguration);
        Configuration apiElementsConfiguration = (Configuration)configurations.maybeCreate(API_ELEMENTS_CONFIGURATION_NAME);
        apiElementsConfiguration.setVisible(false);
        apiElementsConfiguration.setDescription("API elements for main.");
        apiElementsConfiguration.setCanBeResolved(false);
        apiElementsConfiguration.setCanBeConsumed(true);
        apiElementsConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-api"));
        apiElementsConfiguration.extendsFrom(runtimeConfiguration);
        Configuration runtimeElementsConfiguration = (Configuration)configurations.maybeCreate(RUNTIME_ELEMENTS_CONFIGURATION_NAME);
        runtimeElementsConfiguration.setVisible(false);
        runtimeElementsConfiguration.setCanBeConsumed(true);
        runtimeElementsConfiguration.setCanBeResolved(false);
        runtimeElementsConfiguration.setDescription("Elements of runtime for main.");
        runtimeElementsConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime-jars"));
        runtimeElementsConfiguration.extendsFrom(implementationConfiguration, runtimeOnlyConfiguration, runtimeConfiguration);
        defaultConfiguration.extendsFrom(runtimeElementsConfiguration);
    }

    private void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName));
    }

    static abstract class IntermediateJavaArtifact
    extends AbstractPublishArtifact {
        private final String type;

        IntermediateJavaArtifact(String type, Object task) {
            super(task);
            this.type = type;
        }

        @Override
        public String getName() {
            return this.getFile().getName();
        }

        @Override
        public String getExtension() {
            return "";
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        @Nullable
        public String getClassifier() {
            return null;
        }

        @Override
        public Date getDate() {
            return null;
        }
    }

    private static class BuildableJavaComponentImpl
    implements BuildableJavaComponent {
        private final JavaPluginConvention convention;

        public BuildableJavaComponentImpl(JavaPluginConvention convention) {
            this.convention = convention;
        }

        @Override
        public Collection<String> getBuildTasks() {
            return Collections.singleton("build");
        }

        @Override
        public FileCollection getRuntimeClasspath() {
            ProjectInternal project = this.convention.getProject();
            SourceSet mainSourceSet = (SourceSet)this.convention.getSourceSets().getByName("main");
            FileCollection runtimeClasspath = mainSourceSet.getRuntimeClasspath();
            Configuration gradleApi = project.getConfigurations().detachedConfiguration(project.getDependencies().gradleApi(), project.getDependencies().localGroovy());
            Configuration runtimeElements = project.getConfigurations().getByName(mainSourceSet.getRuntimeElementsConfigurationName());
            FileCollection mainSourceSetArtifact = runtimeElements.getOutgoing().getArtifacts().getFiles();
            return mainSourceSetArtifact.plus(runtimeClasspath.minus(mainSourceSet.getOutput()).minus(gradleApi));
        }

        @Override
        public Configuration getCompileDependencies() {
            return this.convention.getProject().getConfigurations().getByName(JavaPlugin.COMPILE_CLASSPATH_CONFIGURATION_NAME);
        }
    }
}

