/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publication;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MavenVersionUtils;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.internal.CompositePublicationArtifactSet;
import org.gradle.api.publish.internal.DefaultPublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.api.publish.maven.MavenDependency;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.internal.artifact.DefaultMavenArtifactSet;
import org.gradle.api.publish.maven.internal.artifact.DerivedMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.SingleOutputTaskMavenArtifact;
import org.gradle.api.publish.maven.internal.dependencies.DefaultMavenDependency;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPom;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MutableMavenProjectIdentity;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class DefaultMavenPublication
implements MavenPublicationInternal {
    private static final Set<ExcludeRule> EXCLUDE_ALL_RULE = Collections.singleton(new DefaultExcludeRule("*", "*"));
    private static final Comparator<? super UsageContext> USAGE_ORDERING = new Comparator<UsageContext>(){

        @Override
        public int compare(UsageContext left, UsageContext right) {
            if (left.getUsage().getName().equals("java-api")) {
                return -1;
            }
            if (right.getUsage().getName().equals("java-api")) {
                return 1;
            }
            return left.getUsage().getName().compareTo(right.getUsage().getName());
        }
    };
    private final String name;
    private final MavenPomInternal pom;
    private final MutableMavenProjectIdentity projectIdentity;
    private final DefaultMavenArtifactSet mainArtifacts;
    private final PublicationArtifactSet<MavenArtifact> metadataArtifacts;
    private final PublicationArtifactSet<MavenArtifact> derivedArtifacts;
    private final PublicationArtifactSet<MavenArtifact> publishableArtifacts;
    private final Set<MavenDependencyInternal> runtimeDependencies = new LinkedHashSet<MavenDependencyInternal>();
    private final Set<MavenDependencyInternal> apiDependencies = new LinkedHashSet<MavenDependencyInternal>();
    private final Set<MavenDependency> runtimeDependencyConstraints = new LinkedHashSet<MavenDependency>();
    private final Set<MavenDependency> apiDependencyConstraints = new LinkedHashSet<MavenDependency>();
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final FeaturePreviews featurePreviews;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private MavenArtifact pomArtifact;
    private MavenArtifact moduleMetadataArtifact;
    private Task moduleDescriptorGenerator;
    private SoftwareComponentInternal component;
    private boolean isPublishWithOriginalFileName;
    private boolean alias;
    private boolean populated;
    private boolean artifactsOverridden;

    public DefaultMavenPublication(String name, MutableMavenProjectIdentity projectIdentity, NotationParser<Object, MavenArtifact> mavenArtifactParser, Instantiator instantiator, ObjectFactory objectFactory, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, FeaturePreviews featurePreviews, ImmutableAttributesFactory immutableAttributesFactory) {
        this.name = name;
        this.projectDependencyResolver = projectDependencyResolver;
        this.projectIdentity = projectIdentity;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.mainArtifacts = instantiator.newInstance(DefaultMavenArtifactSet.class, name, mavenArtifactParser, fileCollectionFactory);
        this.metadataArtifacts = new DefaultPublicationArtifactSet<MavenArtifact>(MavenArtifact.class, "metadata artifacts for " + name, fileCollectionFactory);
        this.derivedArtifacts = new DefaultPublicationArtifactSet<MavenArtifact>(MavenArtifact.class, "derived artifacts for " + name, fileCollectionFactory);
        this.publishableArtifacts = new CompositePublicationArtifactSet<MavenArtifact>(MavenArtifact.class, this.mainArtifacts, this.metadataArtifacts, this.derivedArtifacts);
        this.pom = instantiator.newInstance(DefaultMavenPom.class, this, instantiator, objectFactory);
        this.featurePreviews = featurePreviews;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.withTypeAndName("Maven publication", this.name);
    }

    @Override
    public boolean isLegacy() {
        return false;
    }

    @Override
    @Nullable
    public SoftwareComponentInternal getComponent() {
        return this.component;
    }

    @Override
    public MavenPomInternal getPom() {
        return this.pom;
    }

    @Override
    public void setPomGenerator(Task pomGenerator) {
        if (this.pomArtifact != null) {
            this.metadataArtifacts.remove(this.pomArtifact);
        }
        this.pomArtifact = new SingleOutputTaskMavenArtifact(pomGenerator, "pom", null);
        this.metadataArtifacts.add(this.pomArtifact);
    }

    @Override
    public void setModuleDescriptorGenerator(Task descriptorGenerator) {
        this.moduleDescriptorGenerator = descriptorGenerator;
        if (this.moduleMetadataArtifact != null) {
            this.metadataArtifacts.remove(this.moduleMetadataArtifact);
        }
        this.moduleMetadataArtifact = null;
        this.updateModuleDescriptorArtifact();
    }

    private void updateModuleDescriptorArtifact() {
        if (!this.canPublishModuleMetadata()) {
            return;
        }
        if (this.moduleDescriptorGenerator == null) {
            return;
        }
        this.moduleMetadataArtifact = new SingleOutputTaskMavenArtifact(this.moduleDescriptorGenerator, "module", null);
        this.metadataArtifacts.add(this.moduleMetadataArtifact);
        this.moduleDescriptorGenerator = null;
    }

    @Override
    public void pom(Action<? super MavenPom> configure) {
        configure.execute(this.pom);
    }

    @Override
    public boolean isAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.component != null) {
            throw new InvalidUserDataException(String.format("Maven publication '%s' cannot include multiple components", this.name));
        }
        this.component = (SoftwareComponentInternal)component;
        this.artifactsOverridden = false;
        this.updateModuleDescriptorArtifact();
    }

    private void populateFromComponent() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        if (this.component == null) {
            return;
        }
        HashSet seenArtifacts = Sets.newHashSet();
        HashSet seenDependencies = Sets.newHashSet();
        HashSet seenConstraints = Sets.newHashSet();
        for (UsageContext usageContext : this.getSortedUsageContexts()) {
            for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                ArtifactKey key = new ArtifactKey(publishArtifact.getFile(), publishArtifact.getClassifier(), publishArtifact.getExtension());
                if (this.artifactsOverridden || !seenArtifacts.add(key)) continue;
                this.artifact(publishArtifact);
            }
            Set<ExcludeRule> globalExcludes = usageContext.getGlobalExcludes();
            Set<MavenDependencyInternal> set = this.dependenciesFor(usageContext.getUsage());
            for (ModuleDependency moduleDependency : usageContext.getDependencies()) {
                if (!seenDependencies.add(moduleDependency)) continue;
                if (moduleDependency instanceof ProjectDependency) {
                    this.addProjectDependency((ProjectDependency)moduleDependency, globalExcludes, set);
                    continue;
                }
                this.addModuleDependency(moduleDependency, globalExcludes, set);
            }
            Set<MavenDependency> dependencyConstraints = this.dependencyConstraintsFor(usageContext.getUsage());
            for (DependencyConstraint dependencyConstraint : usageContext.getDependencyConstraints()) {
                if (!seenConstraints.add(dependencyConstraint) || dependencyConstraint.getVersion() == null) continue;
                this.addDependencyConstraint(dependencyConstraint, dependencyConstraints);
            }
        }
    }

    private List<UsageContext> getSortedUsageContexts() {
        ArrayList usageContexts = Lists.newArrayList(this.component.getUsages());
        Collections.sort(usageContexts, USAGE_ORDERING);
        return usageContexts;
    }

    private Set<MavenDependencyInternal> dependenciesFor(Usage usage) {
        if ("java-api".equals(usage.getName())) {
            return this.apiDependencies;
        }
        return this.runtimeDependencies;
    }

    private Set<MavenDependency> dependencyConstraintsFor(Usage usage) {
        if ("java-api".equals(usage.getName())) {
            return this.apiDependencyConstraints;
        }
        return this.runtimeDependencyConstraints;
    }

    private void addProjectDependency(ProjectDependency dependency, Set<ExcludeRule> globalExcludes, Set<MavenDependencyInternal> dependencies) {
        ModuleVersionIdentifier identifier = this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, dependency);
        dependencies.add(new DefaultMavenDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), Collections.emptyList(), DefaultMavenPublication.getExcludeRules(globalExcludes, dependency)));
    }

    private void addModuleDependency(ModuleDependency dependency, Set<ExcludeRule> globalExcludes, Set<MavenDependencyInternal> dependencies) {
        dependencies.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion(), dependency.getArtifacts(), DefaultMavenPublication.getExcludeRules(globalExcludes, dependency)));
    }

    private void addDependencyConstraint(DependencyConstraint dependency, Set<MavenDependency> dependencies) {
        dependencies.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion()));
    }

    private static Set<ExcludeRule> getExcludeRules(Set<ExcludeRule> globalExcludes, ModuleDependency dependency) {
        return dependency.isTransitive() ? Sets.union(globalExcludes, dependency.getExcludeRules()) : EXCLUDE_ALL_RULE;
    }

    @Override
    public MavenArtifact artifact(Object source) {
        return this.mainArtifacts.artifact(source);
    }

    @Override
    public MavenArtifact artifact(Object source, Action<? super MavenArtifact> config) {
        return this.mainArtifacts.artifact(source, config);
    }

    @Override
    public MavenArtifactSet getArtifacts() {
        this.populateFromComponent();
        return this.mainArtifacts;
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.artifactsOverridden = true;
        this.mainArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public String getGroupId() {
        return (String)this.projectIdentity.getGroupId().get();
    }

    @Override
    public void setGroupId(String groupId) {
        this.projectIdentity.getGroupId().set(groupId);
    }

    @Override
    public String getArtifactId() {
        return (String)this.projectIdentity.getArtifactId().get();
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.projectIdentity.getArtifactId().set(artifactId);
    }

    @Override
    public String getVersion() {
        return (String)this.projectIdentity.getVersion().get();
    }

    @Override
    public void setVersion(String version) {
        this.projectIdentity.getVersion().set(version);
    }

    @Override
    public FileCollection getPublishableFiles() {
        return this.getPublishableArtifacts().getFiles();
    }

    @Override
    public PublicationArtifactSet<MavenArtifact> getPublishableArtifacts() {
        this.populateFromComponent();
        return this.publishableArtifacts;
    }

    @Override
    public void allPublishableArtifacts(Action<? super MavenArtifact> action) {
        this.publishableArtifacts.all(action);
    }

    @Override
    public void whenPublishableArtifactRemoved(Action<? super MavenArtifact> action) {
        this.publishableArtifacts.whenObjectRemoved(action);
    }

    @Override
    public MavenArtifact addDerivedArtifact(MavenArtifact originalArtifact, Factory<File> file) {
        DerivedMavenArtifact artifact = new DerivedMavenArtifact(originalArtifact, file);
        this.derivedArtifacts.add(artifact);
        return artifact;
    }

    @Override
    public void removeDerivedArtifact(MavenArtifact artifact) {
        this.derivedArtifacts.remove(artifact);
    }

    @Override
    public MutableMavenProjectIdentity getMavenProjectIdentity() {
        return this.projectIdentity;
    }

    @Override
    public Set<MavenDependency> getApiDependencyConstraints() {
        this.populateFromComponent();
        return this.apiDependencyConstraints;
    }

    @Override
    public Set<MavenDependency> getRuntimeDependencyConstraints() {
        this.populateFromComponent();
        return this.runtimeDependencyConstraints;
    }

    @Override
    public Set<MavenDependencyInternal> getRuntimeDependencies() {
        this.populateFromComponent();
        return this.runtimeDependencies;
    }

    @Override
    public Set<MavenDependencyInternal> getApiDependencies() {
        this.populateFromComponent();
        return this.apiDependencies;
    }

    @Override
    public MavenNormalizedPublication asNormalisedPublication() {
        this.populateFromComponent();
        DomainObjectSet<MavenArtifact> existingDerivedArtifacts = this.derivedArtifacts.matching(new Spec<MavenArtifact>(){

            @Override
            public boolean isSatisfiedBy(MavenArtifact artifact) {
                return artifact.getFile().exists();
            }
        });
        CompositeDomainObjectSet<MavenArtifact> artifactsToBePublished = CompositeDomainObjectSet.create(MavenArtifact.class, this.mainArtifacts, this.metadataArtifacts, existingDerivedArtifacts);
        return new MavenNormalizedPublication(this.name, this.pom.getPackaging(), this.getPomArtifact(), this.projectIdentity, artifactsToBePublished, this.determineMainArtifact());
    }

    private MavenArtifact getPomArtifact() {
        if (this.pomArtifact == null) {
            throw new IllegalStateException("pomArtifact not set for publication");
        }
        return this.pomArtifact;
    }

    @Override
    public String determinePackagingFromArtifacts() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next().getExtension();
        }
        return "pom";
    }

    private MavenArtifact determineMainArtifact() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.isEmpty()) {
            return null;
        }
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next();
        }
        for (MavenArtifact unclassifiedArtifact : unclassifiedArtifacts) {
            String packaging = this.pom.getPackaging();
            if (!unclassifiedArtifact.getExtension().equals(packaging)) continue;
            return unclassifiedArtifact;
        }
        return null;
    }

    private Set<MavenArtifact> getUnclassifiedArtifactsWithExtension() {
        this.populateFromComponent();
        return CollectionUtils.filter(this.mainArtifacts, new Spec<MavenArtifact>(){

            @Override
            public boolean isSatisfiedBy(MavenArtifact mavenArtifact) {
                return DefaultMavenPublication.this.hasNoClassifier(mavenArtifact) && DefaultMavenPublication.this.hasExtension(mavenArtifact);
            }
        });
    }

    private boolean hasNoClassifier(MavenArtifact element) {
        return element.getClassifier() == null || element.getClassifier().length() == 0;
    }

    private boolean hasExtension(MavenArtifact element) {
        return element.getExtension() != null && element.getExtension().length() > 0;
    }

    @Override
    public ModuleVersionIdentifier getCoordinates() {
        return DefaultModuleVersionIdentifier.newId(this.getGroupId(), this.getArtifactId(), this.getVersion());
    }

    @Override
    @Nullable
    public <T> T getCoordinates(Class<T> type) {
        if (type.isAssignableFrom(ModuleVersionIdentifier.class)) {
            return type.cast(this.getCoordinates());
        }
        return null;
    }

    @Override
    public void publishWithOriginalFileName() {
        this.isPublishWithOriginalFileName = true;
    }

    private boolean canPublishModuleMetadata() {
        if (this.getComponent() == null) {
            return false;
        }
        if (this.getComponent() instanceof ComponentWithVariants) {
            return true;
        }
        return this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.GRADLE_METADATA);
    }

    @Override
    public PublicationInternal.PublishedFile getPublishedFile(PublishArtifact source) {
        this.checkThatArtifactIsPublishedUnmodified(source);
        final String publishedUrl = this.getPublishedUrl(source);
        final String publishedName = this.isPublishWithOriginalFileName ? source.getFile().getName() : publishedUrl;
        return new PublicationInternal.PublishedFile(){

            @Override
            public String getName() {
                return publishedName;
            }

            @Override
            public String getUri() {
                return publishedUrl;
            }
        };
    }

    @Override
    @Nullable
    public ImmutableAttributes getAttributes() {
        String version = (String)this.getMavenProjectIdentity().getVersion().get();
        String status = MavenVersionUtils.inferStatusFromVersionNumber(version);
        return this.immutableAttributesFactory.of(ProjectInternal.STATUS_ATTRIBUTE, status);
    }

    private void checkThatArtifactIsPublishedUnmodified(PublishArtifact source) {
        this.populateFromComponent();
        for (MavenArtifact mavenArtifact : this.mainArtifacts) {
            if (!source.getFile().equals(mavenArtifact.getFile()) || !source.getExtension().equals(mavenArtifact.getExtension()) || !Strings.nullToEmpty((String)source.getClassifier()).equals(Strings.nullToEmpty((String)mavenArtifact.getClassifier()))) continue;
            return;
        }
        throw new PublishException("Cannot publish module metadata where component artifacts are modified.");
    }

    private String getPublishedUrl(PublishArtifact source) {
        return this.getArtifactFileName(source.getClassifier(), source.getExtension());
    }

    private String getArtifactFileName(String classifier, String extension) {
        StringBuilder artifactPath = new StringBuilder();
        ModuleVersionIdentifier coordinates = this.getCoordinates();
        artifactPath.append(coordinates.getName());
        artifactPath.append('-');
        artifactPath.append(coordinates.getVersion());
        if (GUtil.isTrue(classifier)) {
            artifactPath.append('-');
            artifactPath.append(classifier);
        }
        if (GUtil.isTrue(extension)) {
            artifactPath.append('.');
            artifactPath.append(extension);
        }
        return artifactPath.toString();
    }

    private static class ArtifactKey {
        final File file;
        final String classifier;
        final String extension;

        public ArtifactKey(File file, String classifier, String extension) {
            this.file = file;
            this.classifier = classifier;
            this.extension = extension;
        }

        public boolean equals(Object obj) {
            ArtifactKey other = (ArtifactKey)obj;
            return this.file.equals(other.file) && Objects.equal((Object)this.classifier, (Object)other.classifier) && Objects.equal((Object)this.extension, (Object)other.extension);
        }

        public int hashCode() {
            return this.file.hashCode() ^ Objects.hashCode((Object[])new Object[]{this.classifier, this.extension});
        }
    }
}

