/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependents.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.reporting.dependents.internal.DependentComponentsUtils;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolvedResult;

public class DependentComponentsRenderableDependency
extends AbstractRenderableDependency {
    private final Object id;
    private final String name;
    private final String description;
    private final boolean buildable;
    private final boolean testSuite;
    private final LinkedHashSet<? extends RenderableDependency> children;

    public static DependentComponentsRenderableDependency of(ComponentSpec componentSpec, ComponentSpecInternal internalProtocol) {
        return DependentComponentsRenderableDependency.of(componentSpec, internalProtocol, null);
    }

    public static DependentComponentsRenderableDependency of(ComponentSpec componentSpec, ComponentSpecInternal internalProtocol, LinkedHashSet<DependentComponentsRenderableDependency> children) {
        ComponentSpecIdentifier id = internalProtocol.getIdentifier();
        String name = DependentComponentsUtils.getBuildScopedTerseName(id);
        String description = componentSpec.getDisplayName();
        boolean buildable = true;
        if (componentSpec instanceof VariantComponentSpec) {
            VariantComponentSpec variantComponentSpec = (VariantComponentSpec)componentSpec;
            buildable = Iterables.any(variantComponentSpec.getBinaries().values(), (Predicate)new Predicate<BinarySpec>(){

                public boolean apply(BinarySpec binarySpec) {
                    return binarySpec.isBuildable();
                }
            });
        }
        boolean testSuite = false;
        return new DependentComponentsRenderableDependency(id, name, description, buildable, testSuite, children);
    }

    public static DependentComponentsRenderableDependency of(DependentBinariesResolvedResult resolvedResult) {
        LibraryBinaryIdentifier id = resolvedResult.getId();
        String name = DependentComponentsUtils.getBuildScopedTerseName(id);
        String description = id.getDisplayName();
        boolean buildable = resolvedResult.isBuildable();
        boolean testSuite = resolvedResult.isTestSuite();
        LinkedHashSet children = Sets.newLinkedHashSet();
        for (DependentBinariesResolvedResult childResolutionResult : resolvedResult.getChildren()) {
            children.add(DependentComponentsRenderableDependency.of(childResolutionResult));
        }
        return new DependentComponentsRenderableDependency(id, name, description, buildable, testSuite, children);
    }

    public DependentComponentsRenderableDependency(Object id, String name, String description, boolean buildable, boolean testSuite, LinkedHashSet<? extends RenderableDependency> children) {
        Preconditions.checkNotNull((Object)id, (Object)"id must not be null");
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)name), (Object)"name must not be null nor empty");
        this.id = id;
        this.name = name;
        this.description = Strings.emptyToNull((String)description);
        this.buildable = buildable;
        this.testSuite = testSuite;
        this.children = children;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public RenderableDependency.ResolutionState getResolutionState() {
        return RenderableDependency.ResolutionState.RESOLVED;
    }

    @Override
    public Set<? extends RenderableDependency> getChildren() {
        return this.children;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    public boolean isTestSuite() {
        return this.testSuite;
    }
}

