/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.deployment.internal;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.deployment.internal.Deployment;
import org.gradle.deployment.internal.DeploymentInternal;
import org.gradle.internal.UncheckedException;

class SimpleBlockingDeployment
implements DeploymentInternal {
    private final Lock lock = new ReentrantLock();
    private final Condition upToDate = this.lock.newCondition();
    private final DeploymentInternal delegate;
    private boolean outOfDate;

    SimpleBlockingDeployment(DeploymentInternal delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deployment.Status status() {
        this.lock.lock();
        try {
            while (this.outOfDate) {
                try {
                    this.upToDate.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            Deployment.Status status = this.delegate.status();
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outOfDate() {
        this.lock.lock();
        try {
            this.delegate.outOfDate();
            this.outOfDate = true;
            this.upToDate.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upToDate(Throwable failure) {
        this.lock.lock();
        try {
            this.delegate.upToDate(failure);
            this.outOfDate = false;
            this.upToDate.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

