/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.component.UsageContext;

public class DefaultUsageContext
implements UsageContext,
Named {
    private final String name;
    private final Usage usage;
    private final AttributeContainer attributes;
    private final Set<? extends PublishArtifact> artifacts;
    private final Set<? extends ModuleDependency> dependencies;
    private final Set<? extends DependencyConstraint> dependencyConstraints;
    private final Set<ExcludeRule> globalExcludes;

    DefaultUsageContext(String name, Usage usage, Set<? extends PublishArtifact> artifacts, Configuration configuration) {
        this(name, usage, configuration.getAttributes(), artifacts, configuration);
    }

    public DefaultUsageContext(UsageContext usageContext, Set<? extends PublishArtifact> artifacts, Configuration configuration) {
        this(usageContext.getName(), usageContext.getUsage(), usageContext.getAttributes(), artifacts, configuration);
    }

    public DefaultUsageContext(String name, Usage usage, AttributeContainer attributes) {
        this(name, usage, attributes, null, null);
    }

    private DefaultUsageContext(String name, Usage usage, AttributeContainer attributes, Set<? extends PublishArtifact> artifacts, Configuration configuration) {
        this.name = name;
        this.usage = usage;
        this.attributes = attributes;
        this.artifacts = artifacts;
        if (configuration != null) {
            this.dependencies = configuration.getAllDependencies().withType(ModuleDependency.class);
            this.dependencyConstraints = configuration.getAllDependencyConstraints();
            this.globalExcludes = configuration.getExcludeRules();
        } else {
            this.dependencies = null;
            this.dependencyConstraints = null;
            this.globalExcludes = Collections.emptySet();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Usage getUsage() {
        return this.usage;
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<? extends PublishArtifact> getArtifacts() {
        assert (this.artifacts != null);
        return this.artifacts;
    }

    @Override
    public Set<? extends ModuleDependency> getDependencies() {
        assert (this.dependencies != null);
        return this.dependencies;
    }

    @Override
    public Set<? extends DependencyConstraint> getDependencyConstraints() {
        assert (this.dependencyConstraints != null);
        return this.dependencyConstraints;
    }

    @Override
    public Set<? extends Capability> getCapabilities() {
        return Collections.emptySet();
    }

    @Override
    public Set<ExcludeRule> getGlobalExcludes() {
        return this.globalExcludes;
    }
}

