/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.asm;

import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.impldep.org.objectweb.asm.Type;

public class AsmClassGenerator {
    private final ClassWriter visitor;
    private final String generatedTypeName;
    private final Type generatedType;
    private final Class<?> targetType;

    public AsmClassGenerator(Class<?> targetType, String classNameSuffix) {
        this.targetType = targetType;
        this.visitor = new ClassWriter(3);
        this.generatedTypeName = targetType.getName() + classNameSuffix;
        this.generatedType = Type.getType((String)("L" + this.generatedTypeName.replaceAll("\\.", "/") + ";"));
    }

    public ClassWriter getVisitor() {
        return this.visitor;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public String getGeneratedTypeName() {
        return this.generatedTypeName;
    }

    public Type getGeneratedType() {
        return this.generatedType;
    }

    public <T> Class<T> define() {
        return this.define(this.targetType.getClassLoader());
    }

    public <T> Class<T> define(ClassLoader targetClassLoader) {
        return ClassLoaderUtils.defineDecorator(this.targetType, targetClassLoader, this.generatedTypeName, this.visitor.toByteArray());
    }
}

