/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.LibraryIdentifier;

public class CachingLibraryBinaryLocator
implements LibraryBinaryLocator {
    private static final DomainObjectSet<NativeLibraryBinary> NULL_RESULT = new DefaultDomainObjectSet<NativeLibraryBinary>(NativeLibraryBinary.class);
    private final LibraryBinaryLocator delegate;
    private final Map<LibraryIdentifier, DomainObjectSet<NativeLibraryBinary>> libraries = new HashMap<LibraryIdentifier, DomainObjectSet<NativeLibraryBinary>>();

    public CachingLibraryBinaryLocator(LibraryBinaryLocator delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public DomainObjectSet<NativeLibraryBinary> getBinaries(LibraryIdentifier library) {
        DomainObjectSet<NativeLibraryBinary> libraryBinaries = this.libraries.get(library);
        if (libraryBinaries == null) {
            libraryBinaries = this.delegate.getBinaries(library);
            if (libraryBinaries == null) {
                libraryBinaries = NULL_RESULT;
            }
            this.libraries.put(library, libraryBinaries);
        }
        return libraryBinaries == NULL_RESULT ? null : libraryBinaries;
    }
}

