/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.initialization.definition.SelfResolvingPluginRequest;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.resolve.internal.ClassPathPluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

public class SelfResolvingRequestPluginResolver
implements PluginResolver {
    private static final Factory<ClassPath> EMPTY_CLASSPATH_FACTORY = Factories.constant(ClassPath.EMPTY);
    private final PluginInspector pluginInspector;

    public SelfResolvingRequestPluginResolver(PluginInspector pluginInspector) {
        this.pluginInspector = pluginInspector;
    }

    @Override
    public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result) throws InvalidPluginRequestException {
        if (pluginRequest instanceof SelfResolvingPluginRequest) {
            ClassLoaderScope classLoaderScope = ((SelfResolvingPluginRequest)pluginRequest).getClassLoaderScope();
            ClassPathPluginResolution pluginResolution = new ClassPathPluginResolution(pluginRequest.getId(), classLoaderScope, EMPTY_CLASSPATH_FACTORY, this.pluginInspector);
            result.found("injected from outer build", pluginResolution);
        }
    }
}

