/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.BuildAdapter;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.PropertiesTransformer;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ear.EarPlugin;
import org.gradle.plugins.ide.api.PropertiesFileContentMerger;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipseWtpPlugin;
import org.gradle.plugins.ide.eclipse.GenerateEclipseClasspath;
import org.gradle.plugins.ide.eclipse.GenerateEclipseJdt;
import org.gradle.plugins.ide.eclipse.GenerateEclipseProject;
import org.gradle.plugins.ide.eclipse.internal.AfterEvaluateHelper;
import org.gradle.plugins.ide.eclipse.internal.EclipseProjectMetadata;
import org.gradle.plugins.ide.eclipse.internal.LinkedResourcesCreator;
import org.gradle.plugins.ide.eclipse.model.BuildCommand;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseJdt;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.eclipse.model.Link;
import org.gradle.plugins.ide.eclipse.model.internal.EclipseJavaVersionMapper;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.plugins.ide.internal.configurer.UniqueProjectNameProvider;
import org.gradle.util.SingleMessageLogger;

public class EclipsePlugin
extends IdePlugin {
    public static final String ECLIPSE_TASK_NAME = "eclipse";
    public static final String ECLIPSE_PROJECT_TASK_NAME = "eclipseProject";
    public static final String ECLIPSE_CP_TASK_NAME = "eclipseClasspath";
    public static final String ECLIPSE_JDT_TASK_NAME = "eclipseJdt";
    private final UniqueProjectNameProvider uniqueProjectNameProvider;
    private final IdeArtifactRegistry artifactRegistry;

    @Inject
    public EclipsePlugin(UniqueProjectNameProvider uniqueProjectNameProvider, IdeArtifactRegistry artifactRegistry) {
        this.uniqueProjectNameProvider = uniqueProjectNameProvider;
        this.artifactRegistry = artifactRegistry;
    }

    @Override
    protected String getLifecycleTaskName() {
        return ECLIPSE_TASK_NAME;
    }

    @Override
    protected void onApply(Project project) {
        this.getLifecycleTask().configure(EclipsePlugin.withDescription("Generates all Eclipse files."));
        this.getCleanTask().configure(EclipsePlugin.withDescription("Cleans all Eclipse files."));
        EclipseModel model = project.getObjects().newInstance(EclipseModel.class, new Object[0]);
        project.getExtensions().add(ECLIPSE_TASK_NAME, model);
        this.configureEclipseProject((ProjectInternal)project, model);
        this.configureEclipseJdt(project, model);
        this.configureEclipseClasspath(project, model);
        this.applyEclipseWtpPluginOnWebProjects(project);
        this.configureRootProjectTask(project);
    }

    private void configureRootProjectTask(Project project) {
        if (project.getGradle().getParent() == null && project.getParent() == null) {
            this.getLifecycleTask().configure((Action<? extends Task>)new Action<Task>(){

                @Override
                public void execute(Task task) {
                    task.dependsOn(EclipsePlugin.this.artifactRegistry.getIdeProjectFiles(EclipseProjectMetadata.class));
                }
            });
        }
    }

    @Deprecated
    public void performPostEvaluationActions() {
        SingleMessageLogger.nagUserOfDiscontinuedMethod("performPostEvaluationActions");
    }

    private void configureEclipseProject(final ProjectInternal project, EclipseModel model) {
        final EclipseProject projectModel = model.getProject();
        projectModel.setName(this.uniqueProjectNameProvider.getUniqueName(project));
        final ConventionMapping convention = ((IConventionAware)((Object)projectModel)).getConventionMapping();
        convention.map("comment", new Callable<String>(){

            @Override
            public String call() {
                return project.getDescription();
            }
        });
        TaskProvider<GenerateEclipseProject> task = project.getTasks().register(ECLIPSE_PROJECT_TASK_NAME, GenerateEclipseProject.class, model.getProject());
        task.configure(new Action<GenerateEclipseProject>(){

            @Override
            public void execute(GenerateEclipseProject task) {
                task.setDescription("Generates the Eclipse project file.");
                task.setInputFile(project.file(".project"));
                task.setOutputFile(project.file(".project"));
            }
        });
        this.addWorker(task, ECLIPSE_PROJECT_TASK_NAME);
        project.getPlugins().withType(JavaBasePlugin.class, new Action<JavaBasePlugin>(){

            @Override
            public void execute(JavaBasePlugin javaBasePlugin) {
                if (!project.getPlugins().hasPlugin(EarPlugin.class)) {
                    projectModel.buildCommand("org.eclipse.jdt.core.javabuilder");
                }
                projectModel.natures("org.eclipse.jdt.core.javanature");
                convention.map("linkedResources", new Callable<Set<Link>>(){

                    @Override
                    public Set<Link> call() {
                        return new LinkedResourcesCreator().links(project);
                    }
                });
            }
        });
        project.getPlugins().withType(GroovyBasePlugin.class, new Action<GroovyBasePlugin>(){

            @Override
            public void execute(GroovyBasePlugin groovyBasePlugin) {
                projectModel.getNatures().add(projectModel.getNatures().indexOf("org.eclipse.jdt.core.javanature"), "org.eclipse.jdt.groovy.core.groovyNature");
            }
        });
        project.getPlugins().withType(ScalaBasePlugin.class, new Action<ScalaBasePlugin>(){

            @Override
            public void execute(ScalaBasePlugin scalaBasePlugin) {
                projectModel.getBuildCommands().set(Iterables.indexOf(projectModel.getBuildCommands(), (Predicate)new Predicate<BuildCommand>(){

                    public boolean apply(BuildCommand buildCommand) {
                        return buildCommand.getName().equals("org.eclipse.jdt.core.javabuilder");
                    }
                }), new BuildCommand("org.scala-ide.sdt.core.scalabuilder"));
                projectModel.getNatures().add(projectModel.getNatures().indexOf("org.eclipse.jdt.core.javanature"), "org.scala-ide.sdt.core.scalanature");
            }
        });
        this.artifactRegistry.registerIdeProject(new EclipseProjectMetadata(projectModel, project.getProjectDir(), task));
    }

    private void configureEclipseClasspath(final Project project, final EclipseModel model) {
        model.setClasspath(project.getObjects().newInstance(EclipseClasspath.class, project));
        ((IConventionAware)((Object)model.getClasspath())).getConventionMapping().map("defaultOutputDir", new Callable<File>(){

            @Override
            public File call() {
                return new File(project.getProjectDir(), "bin/default");
            }
        });
        project.getPlugins().withType(JavaBasePlugin.class, new Action<JavaBasePlugin>(){

            @Override
            public void execute(JavaBasePlugin javaBasePlugin) {
                TaskProvider<GenerateEclipseClasspath> task = project.getTasks().register(EclipsePlugin.ECLIPSE_CP_TASK_NAME, GenerateEclipseClasspath.class, model.getClasspath());
                task.configure(new Action<GenerateEclipseClasspath>(){

                    @Override
                    public void execute(GenerateEclipseClasspath task) {
                        task.setDescription("Generates the Eclipse classpath file.");
                        task.setInputFile(project.file(".classpath"));
                        task.setOutputFile(project.file(".classpath"));
                    }
                });
                EclipsePlugin.this.addWorker(task, EclipsePlugin.ECLIPSE_CP_TASK_NAME);
                XmlTransformer xmlTransformer = new XmlTransformer();
                xmlTransformer.setIndentation("\t");
                model.getClasspath().setFile(new XmlFileContentMerger(xmlTransformer));
                model.getClasspath().setSourceSets(project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets());
                AfterEvaluateHelper.afterEvaluateOrExecute(project, new Action<Project>(){

                    @Override
                    public void execute(Project p) {
                        LinkedHashSet containers = Sets.newLinkedHashSet();
                        containers.add("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + model.getJdt().getJavaRuntimeName() + "/");
                        containers.addAll(model.getClasspath().getContainers());
                        model.getClasspath().setContainers(containers);
                    }
                });
                EclipsePlugin.configureScalaDependencies(project, model);
                EclipsePlugin.configureJavaClasspath(project, task, model);
            }
        });
    }

    private static void configureJavaClasspath(final Project project, final TaskProvider<GenerateEclipseClasspath> task, final EclipseModel model) {
        project.getPlugins().withType(JavaPlugin.class, new Action<JavaPlugin>(){

            @Override
            public void execute(JavaPlugin javaPlugin) {
                model.getClasspath().setPlusConfigurations(Lists.newArrayList((Object[])new Configuration[]{project.getConfigurations().getByName("compileClasspath"), project.getConfigurations().getByName("runtimeClasspath"), project.getConfigurations().getByName("testCompileClasspath"), project.getConfigurations().getByName("testRuntimeClasspath")}));
                ((IConventionAware)((Object)model.getClasspath())).getConventionMapping().map("classFolders", new Callable<List<File>>(){

                    @Override
                    public List<File> call() {
                        SourceSetContainer sourceSets = project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets();
                        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)((SourceSet)sourceSets.getByName("main")).getOutput().getDirs(), (Iterable)((SourceSet)sourceSets.getByName("test")).getOutput().getDirs()));
                    }
                });
                task.configure(new Action<GenerateEclipseClasspath>(){

                    @Override
                    public void execute(GenerateEclipseClasspath task) {
                        SourceSetContainer sourceSets = project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets();
                        task.dependsOn(((SourceSet)sourceSets.getByName("main")).getOutput().getDirs());
                        task.dependsOn(((SourceSet)sourceSets.getByName("test")).getOutput().getDirs());
                    }
                });
            }
        });
    }

    private static void configureScalaDependencies(final Project project, final EclipseModel model) {
        project.getPlugins().withType(ScalaBasePlugin.class, new Action<ScalaBasePlugin>(){

            @Override
            public void execute(ScalaBasePlugin scalaBasePlugin) {
                model.getClasspath().containers("org.scala-ide.sdt.launching.SCALA_CONTAINER");
                project.getGradle().addBuildListener(new BuildAdapter(){

                    @Override
                    public void projectsEvaluated(Gradle gradle) {
                        final ArrayList provided = Lists.newArrayList((Object[])new String[]{"scala-library", "scala-swing", "scala-dbc"});
                        Predicate<Dependency> dependencyInProvided = new Predicate<Dependency>(){

                            public boolean apply(Dependency dependency) {
                                return provided.contains(dependency.getName());
                            }
                        };
                        ArrayList dependencies = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform(model.getClasspath().getPlusConfigurations(), (Function)new Function<Configuration, Iterable<Dependency>>(){

                            public Iterable<Dependency> apply(Configuration config) {
                                return config.getAllDependencies();
                            }
                        })), (Predicate)dependencyInProvided));
                        if (!dependencies.isEmpty()) {
                            model.getClasspath().getMinusConfigurations().add(project.getConfigurations().detachedConfiguration(dependencies.toArray(new Dependency[0])));
                        }
                    }
                });
            }
        });
    }

    private void configureEclipseJdt(final Project project, final EclipseModel model) {
        project.getPlugins().withType(JavaBasePlugin.class, new Action<JavaBasePlugin>(){

            @Override
            public void execute(JavaBasePlugin javaBasePlugin) {
                model.setJdt(project.getObjects().newInstance(EclipseJdt.class, new PropertiesFileContentMerger(new PropertiesTransformer())));
                TaskProvider<GenerateEclipseJdt> task = project.getTasks().register(EclipsePlugin.ECLIPSE_JDT_TASK_NAME, GenerateEclipseJdt.class, model.getJdt());
                task.configure(new Action<GenerateEclipseJdt>(){

                    @Override
                    public void execute(GenerateEclipseJdt task) {
                        task.setDescription("Generates the Eclipse JDT settings file.");
                        task.setOutputFile(project.file(".settings/org.eclipse.jdt.core.prefs"));
                        task.setInputFile(project.file(".settings/org.eclipse.jdt.core.prefs"));
                    }
                });
                EclipsePlugin.this.addWorker(task, EclipsePlugin.ECLIPSE_JDT_TASK_NAME);
                ConventionMapping conventionMapping = ((IConventionAware)((Object)model.getJdt())).getConventionMapping();
                conventionMapping.map("sourceCompatibility", new Callable<JavaVersion>(){

                    @Override
                    public JavaVersion call() {
                        return project.getConvention().getPlugin(JavaPluginConvention.class).getSourceCompatibility();
                    }
                });
                conventionMapping.map("targetCompatibility", new Callable<JavaVersion>(){

                    @Override
                    public JavaVersion call() {
                        return project.getConvention().getPlugin(JavaPluginConvention.class).getTargetCompatibility();
                    }
                });
                conventionMapping.map("javaRuntimeName", new Callable<String>(){

                    @Override
                    public String call() {
                        return EclipsePlugin.eclipseJavaRuntimeNameFor(project.getConvention().getPlugin(JavaPluginConvention.class).getTargetCompatibility());
                    }
                });
            }
        });
    }

    private static String eclipseJavaRuntimeNameFor(JavaVersion version) {
        String eclipseJavaVersion = EclipseJavaVersionMapper.toEclipseJavaVersion(version);
        switch (version) {
            case VERSION_1_1: {
                return "JRE-1.1";
            }
            case VERSION_1_2: 
            case VERSION_1_3: 
            case VERSION_1_4: 
            case VERSION_1_5: {
                return "J2SE-" + eclipseJavaVersion;
            }
        }
        return "JavaSE-" + eclipseJavaVersion;
    }

    private void applyEclipseWtpPluginOnWebProjects(Project project) {
        Action<Plugin<Project>> action = this.createActionApplyingEclipseWtpPlugin();
        project.getPlugins().withType(WarPlugin.class, action);
        project.getPlugins().withType(EarPlugin.class, action);
    }

    private Action<Plugin<Project>> createActionApplyingEclipseWtpPlugin() {
        return new Action<Plugin<Project>>(){

            @Override
            public void execute(Plugin<Project> plugin) {
                EclipsePlugin.this.project.getPluginManager().apply(EclipseWtpPlugin.class);
            }
        };
    }
}

