/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.tooling.internal.gradle.BasicGradleProject;
import org.gradle.tooling.internal.gradle.DefaultGradleBuild;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.internal.gradle.PartialBasicGradleProject;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class GradleBuildBuilder
implements ToolingModelBuilder {
    @Override
    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.gradle.GradleBuild");
    }

    @Override
    public DefaultGradleBuild buildAll(String modelName, Project target) {
        Gradle gradle = target.getGradle();
        return this.convert(gradle, new ArrayList<DefaultGradleBuild>());
    }

    private DefaultGradleBuild convert(Gradle gradle, Collection<DefaultGradleBuild> all) {
        DefaultGradleBuild model = new DefaultGradleBuild();
        LinkedHashMap<Project, BasicGradleProject> convertedProjects = new LinkedHashMap<Project, BasicGradleProject>();
        Project rootProject = gradle.getRootProject();
        BasicGradleProject convertedRootProject = this.convert(rootProject, convertedProjects);
        model.setRootProject(convertedRootProject);
        for (Project project : rootProject.getAllprojects()) {
            model.addProject((PartialBasicGradleProject)convertedProjects.get(project));
        }
        if (gradle.getParent() != null) {
            all.add(model);
        }
        for (IncludedBuild includedBuild : gradle.getIncludedBuilds()) {
            GradleInternal includedGradle = ((IncludedBuildState)((Object)includedBuild)).getConfiguredBuild();
            DefaultGradleBuild convertedIncludedBuild = this.convert(includedGradle, all);
            model.addIncludedBuild(convertedIncludedBuild);
        }
        if (gradle.getParent() == null) {
            model.addBuilds(all);
        }
        return model;
    }

    private BasicGradleProject convert(Project project, Map<Project, BasicGradleProject> convertedProjects) {
        DefaultProjectIdentifier id = new DefaultProjectIdentifier(project.getRootDir(), project.getPath());
        BasicGradleProject converted = new BasicGradleProject().setName(project.getName()).setProjectIdentifier(id);
        converted.setProjectDirectory(project.getProjectDir());
        if (project.getParent() != null) {
            converted.setParent(convertedProjects.get(project.getParent()));
        }
        convertedProjects.put(project, converted);
        for (Project child : project.getChildProjects().values()) {
            converted.addChild(this.convert(child, convertedProjects));
        }
        return converted;
    }
}

