/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.signatory.pgp;

import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Project;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.signatory.SignatoryProvider;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatory;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatoryFactory;
import org.gradle.util.ConfigureUtil;

public class PgpSignatoryProvider
implements SignatoryProvider<PgpSignatory> {
    private final PgpSignatoryFactory factory = new PgpSignatoryFactory();
    private final Map<String, PgpSignatory> signatories = new LinkedHashMap<String, PgpSignatory>();

    @Override
    public void configure(final SigningExtension settings, Closure closure) {
        ConfigureUtil.configure(closure, new Object(){

            public void methodMissing(String name, Object args) {
                PgpSignatoryProvider.this.createSignatoryFor(settings.getProject(), name, (Object[])DefaultGroovyMethods.asType((Object)args, Object[].class));
            }
        });
    }

    private void createSignatoryFor(Project project, String name, Object[] args) {
        switch (args.length) {
            case 3: {
                String keyId = args[0].toString();
                File keyRing = project.file(args[1].toString());
                String password = args[2].toString();
                this.signatories.put(name, this.factory.createSignatory(name, keyId, keyRing, password));
                break;
            }
            case 0: {
                this.signatories.put(name, this.factory.createSignatory(project, name, true));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid args (" + name + ": " + String.valueOf(args) + ")");
            }
        }
    }

    @Override
    public PgpSignatory getDefaultSignatory(Project project) {
        return this.factory.createSignatory(project);
    }

    @Override
    public PgpSignatory getSignatory(String name) {
        return this.signatories.get(name);
    }

    public PgpSignatory propertyMissing(String signatoryName) {
        return this.getSignatory(signatoryName);
    }
}

