/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.rdtext.impl.ot;

import com.jetbrains.rider.rdtext.impl.intrinsics.RdChangeOrigin;
import com.jetbrains.rider.rdtext.impl.ot.DeleteText;
import com.jetbrains.rider.rdtext.impl.ot.InsertText;
import com.jetbrains.rider.rdtext.impl.ot.OtChange;
import com.jetbrains.rider.rdtext.impl.ot.OtOperation;
import com.jetbrains.rider.rdtext.impl.ot.OtOperationKind;
import com.jetbrains.rider.rdtext.impl.ot.OtOperationKt$WhenMappings;
import com.jetbrains.rider.rdtext.impl.ot.Retain;
import com.jetbrains.rider.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rider.rdtext.intrinsics.RdTextChangeKind;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\n\u00a8\u0006\u0010"}, d2={"createTextChange", "Lcom/jetbrains/rider/rdtext/intrinsics/RdTextChange;", "offset", "", "insert", "Lcom/jetbrains/rider/rdtext/impl/ot/InsertText;", "delete", "Lcom/jetbrains/rider/rdtext/impl/ot/DeleteText;", "documentLength", "toOperation", "Lcom/jetbrains/rider/rdtext/impl/ot/OtOperation;", "origin", "Lcom/jetbrains/rider/rdtext/impl/intrinsics/RdChangeOrigin;", "ts", "toRdTextChanges", "", "rd-text"})
public final class OtOperationKt {
    @NotNull
    public static final List<RdTextChange> toRdTextChanges(@NotNull OtOperation $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        int documentLength = $receiver.documentLengthBefore();
        int currOffset = 0;
        InsertText lastInsert = null;
        DeleteText lastDelete = null;
        List res = new ArrayList();
        for (OtChange change : $receiver.getChanges()) {
            OtChange otChange = change;
            if (otChange instanceof Retain) {
                if (lastDelete != null || lastInsert != null) {
                    res.add(OtOperationKt.createTextChange(currOffset, lastInsert, lastDelete, documentLength));
                    lastDelete = null;
                    lastInsert = null;
                }
            } else if (otChange instanceof InsertText) {
                if (lastInsert != null) {
                    res.add(OtOperationKt.createTextChange(currOffset, lastInsert, lastDelete, documentLength));
                    lastDelete = null;
                }
                documentLength += change.getTextLengthAfter();
                lastInsert = (InsertText)change;
            } else if (otChange instanceof DeleteText) {
                if (lastDelete != null) {
                    res.add(OtOperationKt.createTextChange(currOffset, lastInsert, lastDelete, documentLength));
                    lastInsert = null;
                }
                documentLength -= change.getTextLengthBefore();
                lastDelete = (DeleteText)change;
            }
            currOffset += change.getTextLengthAfter();
        }
        if (lastDelete != null || lastInsert != null) {
            res.add(OtOperationKt.createTextChange(currOffset, lastInsert, lastDelete, documentLength));
        }
        return res;
    }

    private static final RdTextChange createTextChange(int offset, InsertText insert, DeleteText delete, int documentLength) {
        RdTextChangeKind rdTextChangeKind;
        Object object;
        Object newText;
        Object object2 = insert;
        if (object2 == null || (object2 = ((InsertText)object2).getText()) == null) {
            object2 = newText = "";
        }
        if ((object = delete) == null || (object = ((DeleteText)object).getText()) == null) {
            object = "";
        }
        Object oldText = object;
        InsertText insertText = insert;
        int startOffset = offset - (insertText != null ? insertText.getTextLengthAfter() : 0);
        if (insert != null && delete != null) {
            rdTextChangeKind = RdTextChangeKind.Replace;
        } else if (insert != null) {
            rdTextChangeKind = RdTextChangeKind.Insert;
        } else if (delete != null) {
            rdTextChangeKind = RdTextChangeKind.Remove;
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        RdTextChangeKind kind = rdTextChangeKind;
        return new RdTextChange(kind, startOffset, (String)oldText, (String)newText, documentLength);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final OtOperation toOperation(@NotNull RdTextChange $receiver, @NotNull RdChangeOrigin origin, int ts) {
        boolean bl;
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)origin), (String)"origin");
        List $receiver2 = list = (List)new ArrayList();
        $receiver2.add(new Retain($receiver.getStartOffset()));
        switch (OtOperationKt$WhenMappings.$EnumSwitchMapping$0[$receiver.getKind().ordinal()]) {
            case 1: {
                $receiver2.add(new InsertText($receiver.getNew()));
                break;
            }
            case 2: {
                $receiver2.add(new DeleteText($receiver.getOld()));
                break;
            }
            case 3: {
                $receiver2.add(new InsertText($receiver.getNew()));
                $receiver2.add(new DeleteText($receiver.getOld()));
                break;
            }
            case 4: {
                $receiver2.add(new InsertText($receiver.getNew()));
            }
        }
        Iterable $receiver$iv = $receiver2;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void p1;
            OtChange otChange = (OtChange)element$iv;
            int n = sum$iv;
            int n2 = p1.getTextLengthAfter();
            sum$iv = n + n2;
        }
        int currentOffset = sum$iv;
        $receiver2.add(new Retain($receiver.getFullTextLength() - currentOffset));
        List changes = list;
        OtOperationKind kind = $receiver.getKind() == RdTextChangeKind.Reset ? OtOperationKind.Reset : OtOperationKind.Normal;
        OtOperation operation = new OtOperation(changes, origin, ts, kind);
        boolean bl2 = bl = operation.documentLengthAfter() == $receiver.getFullTextLength();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return operation;
    }
}

