/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.descriptor;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.html.impl.RelaxedHtmlFromSchemaElementDescriptor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.webcomponents.descriptor.TagWithNameDescriptor;
import com.intellij.webcomponents.index.WebComponentsIndex;
import com.intellij.webcomponents.util.WebComponentsUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ComponentTagDescriptor
extends TagWithNameDescriptor {
    public ComponentTagDescriptor(XmlTag xmlTag) {
        super(xmlTag);
    }

    public PsiElement getDeclaration() {
        ArrayList<PsiElement> declarations = WebComponentsIndex.findDeclarations(Collections.singleton(this.myName), this.myXmlTag.getManager(), GlobalSearchScope.allScope((Project)this.myXmlTag.getProject()));
        return (PsiElement)ContainerUtil.getFirstItem(declarations);
    }

    @Override
    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        ArrayList<XmlAttributeDescriptor> result = new ArrayList<XmlAttributeDescriptor>(Arrays.asList(super.getAttributesDescriptors(context)));
        result.add((XmlAttributeDescriptor)new AnyXmlAttributeDescriptor("is"));
        PsiFile myContextFile = (PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)this.myXmlTag.getContainingFile());
        VirtualFile rootFile = myContextFile.getVirtualFile();
        if (rootFile == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        HashSet processedNames = new HashSet();
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(this.myName);
        while (!queue.isEmpty()) {
            String name = (String)queue.poll();
            if (processedNames.contains(name)) continue;
            ComponentTagDescriptor.processElementTags(myContextFile, (Processor<XmlAttribute>)((Processor)xmlAttribute -> {
                XmlTag tag = xmlAttribute.getParent();
                ComponentTagDescriptor.getAttributes(tag, result);
                String superElement = tag.getAttributeValue("extends");
                if (superElement != null) {
                    queue.add(superElement);
                }
                return true;
            }), name);
            processedNames.add(name);
        }
        Object[] common = HtmlNSDescriptorImpl.getCommonAttributeDescriptors((XmlTag)context);
        return RelaxedHtmlFromSchemaElementDescriptor.addAttrDescriptorsForFacelets((XmlTag)context, (XmlAttributeDescriptor[])((XmlAttributeDescriptor[])ArrayUtil.mergeArrayAndCollection((Object[])common, result, (ArrayFactory)XmlAttributeDescriptor.ARRAY_FACTORY)));
    }

    private static void getAttributes(XmlTag tag, List<XmlAttributeDescriptor> result) {
        String attributes = tag.getAttributeValue("attributes");
        if (attributes != null) {
            for (String attribute : attributes.split(" ")) {
                result.add((XmlAttributeDescriptor)new PolymerAttributeDescriptor(attribute, (PsiElement)tag.getAttribute("attributes")));
            }
        } else {
            ComponentTagDescriptor.getAttributesFromJS(result, (PsiElement)tag);
            ComponentTagDescriptor.getAttributesFromJS(result, tag.getParent());
        }
    }

    private static void getAttributesFromJS(final List<XmlAttributeDescriptor> result, PsiElement parent) {
        List tags = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parent, XmlTag.class);
        for (XmlTag xmlTag : tags) {
            if (!"script".equalsIgnoreCase(xmlTag.getName())) continue;
            JSEmbeddedContent js = (JSEmbeddedContent)PsiTreeUtil.findChildOfType((PsiElement)xmlTag, JSEmbeddedContent.class);
            if (js == null) break;
            js.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

                public void visitJSProperty(JSProperty node) {
                    if ("properties".equals(node.getName())) {
                        JSExpression value = node.getValue();
                        if (value instanceof JSObjectLiteralExpression) {
                            for (JSProperty property : ((JSObjectLiteralExpression)value).getProperties()) {
                                result.add(new PolymerAttributeDescriptor(ComponentTagDescriptor.getAttributeName(property.getName()), (PsiElement)property));
                            }
                        }
                        this.stopWalking();
                    }
                }
            });
            break;
        }
    }

    public static String getAttributeName(String text) {
        String[] split = StringUtil.unquoteString((String)text).split("(?=[A-Z])");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtil.decapitalize((String)split[i]);
        }
        return StringUtil.join((String[])split, (String)"-");
    }

    private static void processElementTags(PsiFile myContextFile, Processor<XmlAttribute> processor, String elementName) {
        PsiManager psiManager = myContextFile.getManager();
        FileBasedIndex.getInstance().processValues(WebComponentsIndex.WEB_COMPONENTS_INDEX, (Object)elementName, null, (file, value) -> {
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile == null) {
                return true;
            }
            return WebComponentsUtil.processElementTags(psiFile, (Processor<? super XmlAttribute>)((Processor)xmlAttribute -> !elementName.equalsIgnoreCase(xmlAttribute.getValue()) || processor.process(xmlAttribute)));
        }, GlobalSearchScope.allScope((Project)myContextFile.getProject()));
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        return (XmlAttributeDescriptor)ContainerUtil.find((Object[])this.getAttributesDescriptors(context), descriptor -> attributeName.equalsIgnoreCase(descriptor.getName()));
    }

    private static class PolymerAttributeDescriptor
    extends AnyXmlAttributeDescriptor {
        private final PsiElement myDeclaration;

        PolymerAttributeDescriptor(String attribute, PsiElement declaration) {
            super(attribute);
            this.myDeclaration = declaration;
        }

        public PsiElement getDeclaration() {
            return this.myDeclaration;
        }
    }
}

