/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.util;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.webcomponents.index.WebComponentsIndex;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebComponentsUtil {
    public static final String ELEMENT = "element";
    public static final String POLYMER_ELEMENT = "polymer-element";
    public static final String DOM_MODULE = "dom-module";
    public static final String TEMPLATE = "template";
    public static final String NAME = "name";
    public static final String EXTENDS = "extends";
    public static final String CONSTRUCTOR = "constructor";
    public static final String DECORATOR = "decorator";
    public static final String SHADOW = "shadow";
    public static final String CONTENT = "content";
    public static final String ID = "id";
    public static final String IF = "if";
    public static final String IS = "is";
    public static final String SELECT = "select";
    public static final String RESET_STYLE_INHERITANCE = "resetstyleinheritance";
    public static final String POLYMER_HTML = "polymer.html";
    private static final Set<String> myTagNames = ContainerUtil.immutableSet((Object[])new String[]{"element", "polymer-element", "template", "decorator", "shadow", "content"});
    public static final Key<ParameterizedCachedValue<Boolean, PsiElement>> IS_POLYMER_PROJECT_KEY = Key.create((String)"is.polymer.project");
    public static final ParameterizedCachedValueProvider<Boolean, PsiElement> IS_POLYMER_PROJECT_PROVIDER = new ParameterizedCachedValueProvider<Boolean, PsiElement>(){

        @NotNull
        public CachedValueProvider.Result<Boolean> compute(PsiElement param) {
            GlobalSearchScope scope;
            Project project = param.getProject();
            CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)(FilenameIndex.getFilesByName((Project)project, (String)WebComponentsUtil.POLYMER_HTML, (GlobalSearchScope)(scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)param))).length > 0 ? 1 : 0), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
            if (result == null) {
                1.$$$reportNull$$$0(0);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/util/WebComponentsUtil$1", "compute"));
        }
    };

    public static boolean processElementTags(PsiFile psiFile, final Processor<? super XmlAttribute> processor) {
        final Ref result = Ref.create((Object)true);
        PsiFile xmlFile = psiFile.getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE);
        if (xmlFile != null) {
            xmlFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    boolean needToGoDeeper = true;
                    String tagName = tag.getName();
                    boolean polymer10 = WebComponentsUtil.DOM_MODULE.equalsIgnoreCase(tagName);
                    if (WebComponentsUtil.ELEMENT.equalsIgnoreCase(tagName) || WebComponentsUtil.POLYMER_ELEMENT.equalsIgnoreCase(tagName) || polymer10) {
                        XmlAttribute xmlAttribute = polymer10 ? tag.getAttribute(WebComponentsUtil.ID) : tag.getAttribute(WebComponentsUtil.NAME);
                        needToGoDeeper = xmlAttribute == null || xmlAttribute.getValue() == null || processor.process((Object)xmlAttribute);
                    }
                    result.set((Object)needToGoDeeper);
                    if (needToGoDeeper) {
                        super.visitXmlTag(tag);
                    }
                }
            });
        }
        return (Boolean)result.get();
    }

    public static boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            WebComponentsUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            WebComponentsUtil.$$$reportNull$$$0(1);
        }
        if (myTagNames.contains(selector)) {
            return true;
        }
        Ref result = Ref.create((Object)false);
        FileBasedIndex.getInstance().processValues(WebComponentsIndex.WEB_COMPONENTS_INDEX, (Object)selector, null, (file, value) -> {
            result.set((Object)true);
            return false;
        }, GlobalSearchScope.allScope((Project)context.getProject()));
        return (Boolean)result.get();
    }

    @NotNull
    public static Set<String> getSelectors(@NotNull Project project) {
        Collection<String> namesFromIndex;
        if (project == null) {
            WebComponentsUtil.$$$reportNull$$$0(2);
        }
        Set<String> set = (namesFromIndex = WebComponentsIndex.getNames(project)).isEmpty() ? myTagNames : WebComponentsUtil.concatinateToImmutable(myTagNames, namesFromIndex);
        if (set == null) {
            WebComponentsUtil.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static Set<String> concatinateToImmutable(@NotNull Collection<String> collection1, @NotNull Collection<String> collection2) {
        if (collection1 == null) {
            WebComponentsUtil.$$$reportNull$$$0(4);
        }
        if (collection2 == null) {
            WebComponentsUtil.$$$reportNull$$$0(5);
        }
        THashSet result = new THashSet(collection1.size() + collection2.size());
        result.addAll(collection1);
        result.addAll(collection2);
        return Collections.unmodifiableSet(result);
    }

    public static boolean hasPolymerJs(@NotNull PsiElement element) {
        if (element == null) {
            WebComponentsUtil.$$$reportNull$$$0(6);
        }
        Project project = element.getProject();
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        return (Boolean)manager.getParameterizedCachedValue((UserDataHolder)project, IS_POLYMER_PROJECT_KEY, IS_POLYMER_PROJECT_PROVIDER, false, (Object)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcomponents/util/WebComponentsUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcomponents/util/WebComponentsUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleSelector";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectors";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "concatinateToImmutable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasPolymerJs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

