/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.dialects.DefinitionProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.UtilKt;
import com.intellij.database.script.generator.ui.ScriptGeneratorTool;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateSqlActions {
    private static final ScriptingOptions SCRIPTING_OPTIONS_FOR_CLIPBOARD = DefaultScriptingOptions.INSTANCE;
    private static final ScriptingOptions SCRIPTING_OPTIONS_FOR_CONSOLE = new CustomScriptingOptions((Map<ScriptingOption<?>, ? extends Object>)ImmutableMap.of(ScriptingOptionStatic.CREATE_OR_REPLACE, (Object)true, ScriptingOptionStatic.CREATE_IF_NOT_EXISTS, (Object)true));

    @NotNull
    private static JBIterable<DbElement> getElements(AnActionEvent e, boolean scriptableOnly) {
        JBIterable result2 = DatabaseView.getSelectedElements(e.getDataContext(), (Condition<DatabaseStructure.Group>)((Condition)o -> o instanceof DatabaseStructure.FamilyGroup && ((DatabaseStructure.FamilyGroup)o).dasParent instanceof DasNamespace));
        JBIterable jBIterable = scriptableOnly ? result2.filter(GenerateSqlActions::isScriptable) : result2;
        if (jBIterable == null) {
            GenerateSqlActions.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    public static CompletionStage<Void> generateDbDdl(@NotNull DefinitionProvider provider, @NotNull List<DbElement> objects, @NotNull ErrorHandler handler, @NotNull StringBuilder builder, boolean markDb) {
        List<Object> current;
        DbElement first;
        LocalDataSource dataSource;
        if (provider == null) {
            GenerateSqlActions.$$$reportNull$$$0(1);
        }
        if (objects == null) {
            GenerateSqlActions.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            GenerateSqlActions.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            GenerateSqlActions.$$$reportNull$$$0(4);
        }
        LocalDataSource localDataSource = dataSource = (first = (DbElement)ContainerUtil.getFirstItem(objects)) == null ? null : DbImplUtil.getMaybeLocalDataSource((DasDataSource)first.getDataSource());
        if (dataSource == null) {
            return CompletableFuture.completedFuture(null);
        }
        ObjectPath path = ObjectPaths.of((DasObject)DasUtil.getNamespace((DasObject)first));
        ArrayList rest = ContainerUtil.newArrayList();
        if (JdbcUrlParserUtil.isDatabaseBounded(dataSource)) {
            current = ContainerUtil.newArrayList();
            for (DbElement object : objects) {
                (JdbcUrlParserUtil.outOfBounds(dataSource, path, ObjectPaths.of((DasObject)object)) ? rest : current).add(object);
            }
        } else {
            current = objects;
        }
        Project project = first.getProject();
        SearchPath searchPath = SearchPath.of((ObjectPath)path);
        return DatabaseSessionManager.facade(project, dataSource, searchPath, handler, DGDepartment.CODE_GENERATION).runAsync(SessionsUtil.function(connection2 -> {
            if (builder == null) {
                GenerateSqlActions.$$$reportNull$$$0(15);
            }
            if (provider == null) {
                GenerateSqlActions.$$$reportNull$$$0(16);
            }
            if (!rest.isEmpty() || markDb) {
                builder.append("-- Database ").append(DasUtil.getCatalog((DasObject)first)).append("\n");
            }
            provider.load((Iterable<? extends DasObject>)current, (DatabaseConnection)connection2, builder);
            return null;
        })).thenComposeAsync(r -> {
            if (provider == null) {
                GenerateSqlActions.$$$reportNull$$$0(12);
            }
            if (handler == null) {
                GenerateSqlActions.$$$reportNull$$$0(13);
            }
            if (builder == null) {
                GenerateSqlActions.$$$reportNull$$$0(14);
            }
            return rest.isEmpty() ? CompletableFuture.completedFuture(null) : GenerateSqlActions.generateDbDdl(provider, rest, handler, builder, true);
        });
    }

    private static boolean isScriptable(@Nullable DbElement element2) {
        if (element2 == null) {
            return false;
        }
        if (element2 instanceof DasSchemaChild) {
            return true;
        }
        return element2.getDelegate() instanceof BasicElement;
    }

    @NotNull
    private static String doGenerateDDL(@NotNull Collection<DbElement> selectedElements, boolean forConsole) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(5);
        }
        ArrayList<BasicElement> list1 = new ArrayList<BasicElement>(selectedElements.size());
        ArrayList<DbElement> list2 = new ArrayList<DbElement>(selectedElements.size());
        for (DbElement e : selectedElements) {
            Object d2 = e.getDelegate();
            if (d2 instanceof BasicElement) {
                list1.add((BasicElement)d2);
                continue;
            }
            if (d2 instanceof LocalDataSource) {
                LocalDataSource lds = (LocalDataSource)d2;
                DasModel m = lds.getModel();
                if (!(m instanceof BasicModel)) continue;
                list1.add(((BasicModel)m).getRoot());
                continue;
            }
            list2.add(e);
        }
        String string = GenerateSqlActions.doGenerateDDLUsingScriptingService(list1, list2, forConsole);
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(@NotNull Collection<BasicElement> selectedElements, Collection<DbElement> unknown, boolean forConsole) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(7);
        }
        Map<BasicModel, List<BasicElement>> groupedByModels = ModelFun.groupByModel(selectedElements);
        StringBuilder b2 = new StringBuilder();
        for (Map.Entry<BasicModel, List<BasicElement>> entry : groupedByModels.entrySet()) {
            List elements;
            BasicModel m = entry.getKey();
            String text2 = GenerateSqlActions.doGenerateDDLUsingScriptingService(m, elements = JBIterable.from((Iterable)entry.getValue()).toList(), forConsole);
            if (text2.length() <= 0) continue;
            if (b2.length() > 0) {
                b2.append("\n\n");
            }
            b2.append(text2);
        }
        for (DbElement element2 : unknown) {
            if (b2.length() > 0) {
                b2.append("\n\n");
            }
            b2.append("Unexpected: ").append(element2.getDelegate().getClass().getSimpleName());
        }
        String string = b2.toString();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(@NotNull BasicModel model, @NotNull Iterable<? extends BasicElement> selectedElements, boolean forConsole) {
        JBIterable explicitSchemata;
        if (model == null) {
            GenerateSqlActions.$$$reportNull$$$0(9);
        }
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(10);
        }
        ScriptGenerator scriptGenerator = ScriptGenerators.INSTANCE.byModel(model);
        JBIterable selection = JBIterable.from(selectedElements);
        JBIterable visibleDatabasesOfRoot = selection.filter(BasicMultiDatabaseRoot.class).flatten(r -> r.getDatabases()).filter(BasicDatabase.class).filter(BasicNamespace::isVisible);
        JBIterable databasesSchemata = visibleDatabasesOfRoot.append((Iterable)selection.filter(BasicDatabase.class).filter(db -> !visibleDatabasesOfRoot.contains(db))).flatten(db -> db.getSchemas()).filter(BasicSchema.class).filter(s -> !s.isNameSurrogate()).filter(BasicMateNamespace::isVisible);
        List schemata = databasesSchemata.append((Iterable)(explicitSchemata = selection.filter(BasicSchema.class).filter(s -> !databasesSchemata.contains(s)))).toList();
        BasicSchema schema = schemata.size() == 1 ? (BasicSchema)schemata.get(0) : null;
        ScriptingSingleModelTaskBuilder taskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_COMPLETE);
        JBIterable.from((Iterable)schemata).flatten(UtilKt::getScriptableMajorObjects).append((Iterable)selection.filter(o -> !(o instanceof BasicSchemaObject) || !schemata.contains(o.getSchema()))).addAllTo(taskBuilder.getElements());
        taskBuilder.setCurrentSchema(schema);
        taskBuilder.setOptions(forConsole ? SCRIPTING_OPTIONS_FOR_CONSOLE : SCRIPTING_OPTIONS_FOR_CLIPBOARD);
        ScriptingResult result2 = scriptGenerator.makeScript(taskBuilder.build());
        String string = result2.getScriptText();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions";
                break;
            }
            case 1: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDDL";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDDLUsingScriptingService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDbDdl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDL";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDLUsingScriptingService";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateDbDdl$2";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateDbDdl$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ShowSqlGeneratorAction
    extends DumbAwareAction {
        ShowSqlGeneratorAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            DbElement single;
            if (e == null) {
                ShowSqlGeneratorAction.$$$reportNull$$$0(0);
            }
            boolean enabled = (single = (DbElement)GenerateSqlActions.getElements(e, true).single()) != null && single.getDelegate() instanceof BasicElement;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element2;
            BasicElement delegate;
            if (e == null) {
                ShowSqlGeneratorAction.$$$reportNull$$$0(1);
            }
            BasicElement basicElement = delegate = (element2 = (DbElement)GenerateSqlActions.getElements(e, true).single()) == null ? null : (BasicElement)ObjectUtils.tryCast((Object)element2.getDelegate(), BasicElement.class);
            if (delegate == null) {
                return;
            }
            BasicModel model = (BasicModel)ObjectUtils.notNull((Object)delegate.getModel());
            ScriptGeneratorTool.INSTANCE.show(element2.getProject(), model, Collections.singleton(delegate));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$ShowSqlGeneratorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OpenDdlInConsoleAction
    extends DumbAwareAction {
        OpenDdlInConsoleAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenDdlInConsoleAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(!GenerateSqlActions.getElements(e, true).isEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List elements;
            String ddl;
            if (e == null) {
                OpenDdlInConsoleAction.$$$reportNull$$$0(1);
            }
            if (StringUtil.isEmpty((String)(ddl = GenerateSqlActions.doGenerateDDL(elements = GenerateSqlActions.getElements(e, true).unique().toList(), true)))) {
                return;
            }
            DbUIUtil.openInConsole((DbElement)elements.get(0), ddl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$OpenDdlInConsoleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CopyDdlAction
    extends DumbAwareAction {
        CopyDdlAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyDdlAction.$$$reportNull$$$0(0);
            }
            boolean enabled = !GenerateSqlActions.getElements(e, false).isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List objects;
            if (e == null) {
                CopyDdlAction.$$$reportNull$$$0(1);
            }
            if ((objects = GenerateSqlActions.getElements(e, false).unique().toList()).isEmpty()) {
                return;
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(GenerateSqlActions.doGenerateDDL(objects, false)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CopyDdlFromDbAction
    extends DumbAwareAction {
        CopyDdlFromDbAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(0);
            }
            JBIterable<DbElement> objects = this.getObjects(e.getDataContext());
            JBIterable<DbElement> supported = this.filterSupported(objects);
            boolean visible = !objects.isEmpty();
            boolean enabled = visible && !supported.isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable<DbElement> objects;
            DbElement first;
            DefinitionProvider provider;
            if (e == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(1);
            }
            if ((provider = this.getProvider(first = (DbElement)(objects = this.getObjects(e.getDataContext())).first())) == null || first == null) {
                return;
            }
            ErrorHandler handler = new ErrorHandler();
            StringBuilder builder = new StringBuilder();
            ProgressIndicatorEx indicator = AsyncUtil.createBackgroundIndicator(first.getProject(), "Loading Sources");
            AsyncUtil.runTask(() -> {
                if (e == null) {
                    CopyDdlFromDbAction.$$$reportNull$$$0(6);
                }
                return GenerateSqlActions.generateDbDdl(provider, objects.filter(provider::isSupported).toList(), handler, builder, false).whenCompleteAsync((s, throwable) -> {
                    if (e == null) {
                        CopyDdlFromDbAction.$$$reportNull$$$0(7);
                    }
                    if (throwable != null) {
                        Dbms dbms = DbImplUtil.getDbms((DbElement)first.getDataSource());
                        AsyncUtil.addUnhandledError(handler, throwable, StringUtil.notNullize((String)e.getPresentation().getText()), dbms);
                        if (handler.hasErrors()) {
                            DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(handler.getSummary(), MessageType.ERROR).notify(e.getProject());
                        }
                    } else {
                        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(builder.toString()));
                    }
                }, AsyncUtil.EDT_EXECUTOR);
            }, indicator);
        }

        @NotNull
        JBIterable<DbElement> getObjects(DataContext context) {
            JBIterable objects = JBIterable.from(DatabaseView.getSelectedElements(context, DbElement.class));
            DbElement first = (DbElement)objects.first();
            if (first == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    CopyDdlFromDbAction.$$$reportNull$$$0(2);
                }
                return jBIterable;
            }
            DbDataSource dataSource = first.getDataSource();
            JBIterable jBIterable = objects.filter(o -> o != dataSource && o.getDataSource() == dataSource);
            if (jBIterable == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @NotNull
        JBIterable<DbElement> filterSupported(@NotNull JBIterable<DbElement> objects) {
            DefinitionProvider provider;
            if (objects == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = (provider = this.getProvider((DbElement)objects.first())) == null ? JBIterable.empty() : objects.filter(provider::isSupported);
            if (jBIterable == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Nullable
        DefinitionProvider getProvider(@Nullable DbElement first) {
            if (first == null) {
                return null;
            }
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)first.getDataSource());
            if (localDataSource == null) {
                return null;
            }
            return AbstractDefinitionProvider.find(localDataSource);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlFromDbAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlFromDbAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterSupported";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "filterSupported";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$actionPerformed$1";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

