/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.session.AbstractMessageBusSession;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionManager$sam$com_intellij_openapi_util_Computable$0;
import com.intellij.database.console.session.MessageBusSession;
import com.intellij.database.console.session.VisibleDatabaseSession;
import com.intellij.database.console.session.VisibleMessageBusSession;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.session.Session;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b%&'()*+,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0003J!\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"H\u0002\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager;", "", "()V", "projectSessions", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions;", "facade", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade;", "project", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "path", "Lcom/intellij/database/util/SearchPath;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "findSession", "Lcom/intellij/database/console/session/DatabaseSession;", "content", "Lcom/intellij/ui/content/Content;", "getSession", "Lcom/intellij/database/console/session/VisibleDatabaseSession;", "title", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSilentSession", "caller", "", "onEdt", "T", "computable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "projectScopedSessions", "Facade", "Factories", "Factory", "MultiConnection", "ProjectSessions", "SingleConnection", "TemporaryAuditor", "TemporaryClient", "intellij.database.impl"})
public final class DatabaseSessionManager {
    private static final ConcurrentMap<Project, ProjectSessions> projectSessions;
    public static final DatabaseSessionManager INSTANCE;

    @JvmStatic
    @NotNull
    public static final VisibleDatabaseSession getSession(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        ApplicationManager.getApplication().assertIsDispatchThread();
        return INSTANCE.projectScopedSessions(project).getSession(project, dataSource, title);
    }

    @JvmStatic
    @NotNull
    public static /* synthetic */ VisibleDatabaseSession getSession$default(Project project, LocalDataSource localDataSource, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return DatabaseSessionManager.getSession(project, localDataSource, string);
    }

    @JvmStatic
    @NotNull
    public static final VisibleDatabaseSession getSession(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ApplicationManager.getApplication().assertIsDispatchThread();
        return INSTANCE.projectScopedSessions(project).getSession(project, dataSource, title, file);
    }

    @JvmStatic
    @NotNull
    public static /* synthetic */ VisibleDatabaseSession getSession$default(Project project, LocalDataSource localDataSource, String string, VirtualFile virtualFile, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return DatabaseSessionManager.getSession(project, localDataSource, string, virtualFile);
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession getSilentSession(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        return DatabaseSessionManager.getSilentSession(project, dataSource, 2);
    }

    @JvmStatic
    @Nullable
    public static final DatabaseSession findSession(@NotNull Content content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)content.getComponent());
        Object object = dataContext.getData(Session.SESSION_KEY);
        if (!(object instanceof DatabaseSession)) {
            object = null;
        }
        return (DatabaseSession)object;
    }

    @JvmStatic
    @NotNull
    public static final Facade facade(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable SearchPath path, @Nullable ErrorHandler handler, @NotNull DatabaseDepartment department) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)department, (String)"department");
        return new Facade(dataSource, project, path, handler, department);
    }

    @JvmStatic
    @NotNull
    public static /* synthetic */ Facade facade$default(Project project, LocalDataSource localDataSource, SearchPath searchPath, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, Object object) {
        if ((n & 4) != 0) {
            searchPath = null;
        }
        if ((n & 8) != 0) {
            errorHandler = null;
        }
        return DatabaseSessionManager.facade(project, localDataSource, searchPath, errorHandler, databaseDepartment);
    }

    @JvmStatic
    private static final DatabaseSession getSilentSession(Project project, LocalDataSource dataSource, int caller) {
        Object object = ReflectionUtil.findCallerClass((int)(caller + 1));
        if (object == null || (object = ((Class)object).getSimpleName()) == null || (object = StringKt.nullize((String)object, (boolean)true)) == null) {
            object = "Silent Session";
        }
        Object title = object;
        return INSTANCE.projectScopedSessions(project).getSilentSession(project, dataSource, (String)title);
    }

    private final ProjectSessions projectScopedSessions(Project project) {
        ProjectSessions projectSessions;
        ProjectSessions sessions = new ProjectSessions(project);
        ProjectSessions result2 = DatabaseSessionManager.projectSessions.putIfAbsent(project, sessions);
        if (result2 == null) {
            Disposer.register((Disposable)((Disposable)project), (Disposable)new Disposable(project){
                final /* synthetic */ Project $project;

                public final void dispose() {
                    DatabaseSessionManager.access$getProjectSessions$p(DatabaseSessionManager.INSTANCE).remove(this.$project);
                }
                {
                    this.$project = project;
                }
            });
            sessions.init();
        }
        if ((projectSessions = result2) == null) {
            projectSessions = sessions;
        }
        return projectSessions;
    }

    private final <T> T onEdt(Function0<? extends T> computable) {
        Object object = computable;
        if (object != null) {
            Function0<? extends T> function0 = object;
            object = new DatabaseSessionManager$sam$com_intellij_openapi_util_Computable$0(function0);
        }
        return (T)UIUtil.invokeAndWaitIfNeeded((Computable)((Computable)object));
    }

    private DatabaseSessionManager() {
    }

    static {
        DatabaseSessionManager databaseSessionManager;
        INSTANCE = databaseSessionManager = new DatabaseSessionManager();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap()");
        projectSessions = concurrentMap;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentMap access$getProjectSessions$p(DatabaseSessionManager $this) {
        DatabaseSessionManager databaseSessionManager = $this;
        return projectSessions;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000eJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u001f\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00122\u0006\u0010\u0015\u001a\u0002H\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "map", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factories;", "getFactories", "dataSource", "getSession", "Lcom/intellij/database/console/session/VisibleDatabaseSession;", "title", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSilentSession", "Lcom/intellij/database/console/session/DatabaseSession;", "index", "T", "session", "(Lcom/intellij/database/console/session/DatabaseSession;)Lcom/intellij/database/console/session/DatabaseSession;", "init", "", "intellij.database.impl"})
    private static final class ProjectSessions {
        private final Map<LocalDataSource, Factories> map;
        private final Project project;

        @NotNull
        public final VisibleDatabaseSession getSession(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            return (VisibleDatabaseSession)INSTANCE.onEdt((Function0)new Function0<VisibleDatabaseSession>(this, dataSource, project, title){
                final /* synthetic */ ProjectSessions this$0;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;

                @NotNull
                public final VisibleDatabaseSession invoke() {
                    return (VisibleDatabaseSession)ProjectSessions.access$index(this.this$0, ProjectSessions.access$getFactories(this.this$0, this.$dataSource).chooseOneFor(this.$dataSource).instance(this.$project, this.$dataSource, this.$title));
                }
                {
                    this.this$0 = projectSessions;
                    this.$dataSource = localDataSource;
                    this.$project = project;
                    this.$title = string;
                    super(0);
                }
            });
        }

        @NotNull
        public static /* synthetic */ VisibleDatabaseSession getSession$default(ProjectSessions projectSessions, Project project, LocalDataSource localDataSource, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "";
            }
            return projectSessions.getSession(project, localDataSource, string);
        }

        @NotNull
        public final VisibleDatabaseSession getSession(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title, @NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return (VisibleDatabaseSession)INSTANCE.onEdt((Function0)new Function0<VisibleDatabaseSession>(this, dataSource, project, title, file){
                final /* synthetic */ ProjectSessions this$0;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ VirtualFile $file;

                @NotNull
                public final VisibleDatabaseSession invoke() {
                    return (VisibleDatabaseSession)ProjectSessions.access$index(this.this$0, ProjectSessions.access$getFactories(this.this$0, this.$dataSource).chooseOneFor(this.$dataSource).instance(this.$project, this.$dataSource, this.$title, this.$file));
                }
                {
                    this.this$0 = projectSessions;
                    this.$dataSource = localDataSource;
                    this.$project = project;
                    this.$title = string;
                    this.$file = virtualFile;
                    super(0);
                }
            });
        }

        @NotNull
        public static /* synthetic */ VisibleDatabaseSession getSession$default(ProjectSessions projectSessions, Project project, LocalDataSource localDataSource, String string, VirtualFile virtualFile, int n, Object object) {
            if ((n & 4) != 0) {
                string = "";
            }
            return projectSessions.getSession(project, localDataSource, string, virtualFile);
        }

        @NotNull
        public final DatabaseSession getSilentSession(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            return (DatabaseSession)INSTANCE.onEdt((Function0)new Function0<DatabaseSession>(this, dataSource, project, title){
                final /* synthetic */ ProjectSessions this$0;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;

                @NotNull
                public final DatabaseSession invoke() {
                    return ProjectSessions.access$index(this.this$0, ProjectSessions.access$getFactories(this.this$0, this.$dataSource).chooseOneFor(this.$dataSource).silentInstance(this.$project, this.$dataSource, this.$title));
                }
                {
                    this.this$0 = projectSessions;
                    this.$dataSource = localDataSource;
                    this.$project = project;
                    this.$title = string;
                    super(0);
                }
            });
        }

        @NotNull
        public static /* synthetic */ DatabaseSession getSilentSession$default(ProjectSessions projectSessions, Project project, LocalDataSource localDataSource, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "";
            }
            return projectSessions.getSilentSession(project, localDataSource, string);
        }

        public final void init() {
            this.project.getMessageBus().connect().subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(this){
                final /* synthetic */ ProjectSessions this$0;

                public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                    Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
                    DatabaseSessionManager.access$onEdt(DatabaseSessionManager.INSTANCE, (Function0)new Function0<Factories>(this, dataSource){
                        final /* synthetic */ init.1 this$0;
                        final /* synthetic */ LocalDataSource $dataSource;

                        @Nullable
                        public final Factories invoke() {
                            return (Factories)ProjectSessions.access$getMap$p(this.this$0.this$0).remove(this.$dataSource);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$dataSource = localDataSource;
                            super(0);
                        }
                    });
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final Factories getFactories(LocalDataSource dataSource) {
            Factories factories;
            Map<LocalDataSource, Factories> $receiver$iv = this.map;
            Factories value$iv = $receiver$iv.get(dataSource);
            if (value$iv == null) {
                Factories answer$iv = new Factories();
                $receiver$iv.put(dataSource, answer$iv);
                factories = answer$iv;
            } else {
                void var3_3;
                factories = var3_3;
            }
            return factories;
        }

        private final <T extends DatabaseSession> T index(T session2) {
            Disposer.register((Disposable)((Disposable)this.project), (Disposable)session2);
            session2.init();
            return session2;
        }

        public ProjectSessions(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.project = project;
            this.map = new HashMap();
        }

        @NotNull
        public static final /* synthetic */ DatabaseSession access$index(ProjectSessions $this, @NotNull DatabaseSession session2) {
            return $this.index(session2);
        }

        @NotNull
        public static final /* synthetic */ Factories access$getFactories(ProjectSessions $this, @NotNull LocalDataSource dataSource) {
            return $this.getFactories(dataSource);
        }

        @NotNull
        public static final /* synthetic */ Map access$getMap$p(ProjectSessions $this) {
            return $this.map;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Factories;", "", "()V", "singleConnection", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "chooseOneFor", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.database.impl"})
    private static final class Factories {
        private final Factory singleConnection = new SingleConnection(MultiConnection.INSTANCE);

        @NotNull
        public final Factory chooseOneFor(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            return dataSource.isSingleConnection() ? this.singleConnection : (Factory)MultiConnection.INSTANCE;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J \u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "", "instance", "Lcom/intellij/database/console/session/VisibleDatabaseSession;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "title", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "silentInstance", "Lcom/intellij/database/console/session/DatabaseSession;", "intellij.database.impl"})
    public static interface Factory {
        @NotNull
        public VisibleDatabaseSession instance(@NotNull Project var1, @NotNull LocalDataSource var2, @NotNull String var3);

        @NotNull
        public VisibleDatabaseSession instance(@NotNull Project var1, @NotNull LocalDataSource var2, @NotNull String var3, @NotNull VirtualFile var4);

        @NotNull
        public DatabaseSession silentInstance(@NotNull Project var1, @NotNull LocalDataSource var2, @NotNull String var3);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$MultiConnection;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "()V", "instance", "Lcom/intellij/database/console/session/VisibleDatabaseSession;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "title", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "silentInstance", "Lcom/intellij/database/console/session/DatabaseSession;", "intellij.database.impl"})
    private static final class MultiConnection
    implements Factory {
        public static final MultiConnection INSTANCE;

        @Override
        @NotNull
        public VisibleDatabaseSession instance(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            return new VisibleMessageBusSession(project, dataSource, (AbstractMessageBusSession.SessionKernel)new AbstractMessageBusSession.NaturalKernel(project, title, dataSource), title);
        }

        @Override
        @NotNull
        public VisibleDatabaseSession instance(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title, @NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return new VisibleMessageBusSession(project, dataSource, new AbstractMessageBusSession.NaturalKernel(project, title, dataSource), title, file);
        }

        @Override
        @NotNull
        public DatabaseSession silentInstance(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            return new MessageBusSession(project, dataSource, new AbstractMessageBusSession.NaturalKernel(project, title, dataSource), title);
        }

        private MultiConnection() {
        }

        static {
            MultiConnection multiConnection;
            INSTANCE = multiConnection = new MultiConnection();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$SingleConnection;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "honestFactory", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;)V", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "instance", "Lcom/intellij/database/console/session/VisibleDatabaseSession;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "title", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "silentInstance", "intellij.database.impl"})
    private static final class SingleConnection
    implements Factory {
        private DatabaseSession session;
        private final Factory honestFactory;

        @Override
        @NotNull
        public VisibleDatabaseSession instance(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            DatabaseSession parent2 = this.session(project, dataSource, title);
            return new VisibleMessageBusSession(project, dataSource, (AbstractMessageBusSession.SessionKernel)new AbstractMessageBusSession.WrapperKernel(parent2), title);
        }

        @Override
        @NotNull
        public VisibleDatabaseSession instance(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title, @NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            DatabaseSession parent2 = this.session(project, dataSource, title);
            return new VisibleMessageBusSession(project, dataSource, new AbstractMessageBusSession.WrapperKernel(parent2), title, file);
        }

        @Override
        @NotNull
        public DatabaseSession silentInstance(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String title) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            DatabaseSession parent2 = this.session(project, dataSource, title);
            return new MessageBusSession(project, dataSource, new AbstractMessageBusSession.WrapperKernel(parent2), title);
        }

        private final DatabaseSession session(Project project, LocalDataSource dataSource, String title) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.session == null) {
                DatabaseSession databaseSession = this.session = this.honestFactory.silentInstance(project, dataSource, title);
                if (databaseSession == null) {
                    Intrinsics.throwNpe();
                }
                Disposer.register((Disposable)databaseSession, (Disposable)new Disposable(this){
                    final /* synthetic */ SingleConnection this$0;

                    public final void dispose() {
                        DatabaseSessionManager.access$onEdt(DatabaseSessionManager.INSTANCE, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ session.1 this$0;

                            public final void invoke() {
                                SingleConnection.access$setSession$p(this.this$0.this$0, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = singleConnection;
                    }
                });
            }
            DatabaseSession databaseSession = this.session;
            if (databaseSession == null) {
                Intrinsics.throwNpe();
            }
            return databaseSession;
        }

        public SingleConnection(@NotNull Factory honestFactory) {
            Intrinsics.checkParameterIsNotNull((Object)honestFactory, (String)"honestFactory");
            this.honestFactory = honestFactory;
        }

        @Nullable
        public static final /* synthetic */ DatabaseSession access$getSession$p(SingleConnection $this) {
            return $this.session;
        }

        public static final /* synthetic */ void access$setSession$p(SingleConnection $this, @Nullable DatabaseSession databaseSession) {
            $this.session = databaseSession;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 (2\u00020\u0001:\b()*+,-./B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J7\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120 H\u0002J6\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00170\"\"\u0004\b\u0000\u0010\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00170\"2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u00170\u0019H\u0002J&\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00170%\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u0019J%\u0010&\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\u0010'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade;", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/database/util/SearchPath;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "(Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/util/SearchPath;Lcom/intellij/database/util/ErrorHandler;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;)V", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "checkBounds", "", "info", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "client", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "Lcom/intellij/database/console/session/DatabaseSession;", "compute", "T", "work", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "connection", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "(Lkotlin/jvm/functions/Function1;Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/datagrid/DataRequest$Context;)Ljava/lang/Object;", "connect", "Lcom/intellij/database/util/GuardedRef;", "perform", "Ljava/util/concurrent/CompletableFuture;", "future", "runAsync", "Ljava/util/concurrent/CompletionStage;", "runSync", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "ConnectionInfo", "ConnectionReference", "ConnectionsRouter", "Lockpick", "MultipleSessionsRouter", "Routers", "SingleSessionRouter", "intellij.database.impl"})
    public static final class Facade {
        @NotNull
        private final LocalDataSource dataSource;
        private final Project project;
        private final SearchPath path;
        private final ErrorHandler handler;
        private final DatabaseDepartment department;
        @NotNull
        private static final Routers routers;
        @Deprecated
        public static final Companion Companion;

        @NotNull
        public final <T> CompletionStage<T> runAsync(@NotNull Function1<? super DatabaseConnection, ? extends T> work2) {
            Intrinsics.checkParameterIsNotNull(work2, (String)"work");
            CompletableFuture future = new CompletableFuture();
            return this.perform(future, (Function1)new Function1<ConnectionInfo, T>(this, work2){
                final /* synthetic */ Facade this$0;
                final /* synthetic */ Function1 $work;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T invoke(@NotNull ConnectionInfo info) {
                    Object object;
                    Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                    ConnectionReference reference = new ConnectionReference(info, null, 2, null);
                    ConnectionsRouter router = Facade.access$Companion().getRouters().choose(this.this$0.getDataSource());
                    router.save(reference);
                    try {
                        object = Facade.access$compute(this.this$0, this.$work, info.getConnection(), info.getContext());
                    }
                    finally {
                        router.remove();
                    }
                    return (T)object;
                }
                {
                    this.this$0 = facade;
                    this.$work = function1;
                    super(1);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T runSync(@NotNull Function1<? super DatabaseConnection, ? extends T> work2) {
            T t;
            Intrinsics.checkParameterIsNotNull(work2, (String)"work");
            AutoCloseable autoCloseable = this.connection();
            Throwable throwable = null;
            try {
                GuardedRef it = (GuardedRef)autoCloseable;
                t = this.compute(work2, ((ConnectionInfo)it.get()).getConnection(), ((ConnectionInfo)it.get()).getContext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return t;
        }

        @NotNull
        public final GuardedRef<DatabaseConnection> connect() throws Exception {
            GuardedRef<ConnectionInfo> infoRef = this.connection();
            return new GuardedRef<DatabaseConnection>(infoRef, (Object)infoRef.get().getConnection()){
                final /* synthetic */ GuardedRef $infoRef;

                protected void close(@NotNull DatabaseConnection ref) {
                    Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
                    this.$infoRef.close();
                }
                {
                    this.$infoRef = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            };
        }

        private final GuardedRef<ConnectionInfo> connection() {
            ConnectionsRouter router = routers.choose(this.dataSource);
            ConnectionReference current = router.getCurrent();
            if (current != null) {
                this.checkBounds(current.getResource());
                return new Lockpick(current, router);
            }
            CountDownLatch latch = new CountDownLatch(1);
            CompletableFuture emptyFuture = new CompletableFuture();
            CompletableFuture resultFuture = new CompletableFuture();
            emptyFuture.exceptionally(new Function<Throwable, Unit>(resultFuture){
                final /* synthetic */ CompletableFuture $resultFuture;

                public final void apply(Throwable it) {
                    this.$resultFuture.completeExceptionally(it);
                }
                {
                    this.$resultFuture = completableFuture;
                }
            });
            this.perform(emptyFuture, (Function1)new Function1<ConnectionInfo, Unit>(resultFuture, latch){
                final /* synthetic */ CompletableFuture $resultFuture;
                final /* synthetic */ CountDownLatch $latch;

                public final void invoke(@NotNull ConnectionInfo it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$resultFuture.complete(it);
                    this.$latch.await();
                }
                {
                    this.$resultFuture = completableFuture;
                    this.$latch = countDownLatch;
                    super(1);
                }
            });
            try {
                ConnectionInfo result2;
                ConnectionInfo connectionInfo = result2 = (ConnectionInfo)resultFuture.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)connectionInfo, (String)"result");
                ConnectionReference reference = new ConnectionReference(connectionInfo, latch);
                router.save(reference);
                return new Lockpick(reference, router);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Throwable throwable = cause;
                if (throwable == null) {
                    throwable = new ProcessCanceledException();
                }
                throw throwable;
            }
        }

        private final void checkBounds(ConnectionInfo info) {
            if (this.path == null) {
                return;
            }
            SearchPath searchPath = info.getContext().getSearchPath();
            if (!JdbcUrlParserUtil.outOfBounds(info.getConnection().getConnectionPoint(), (ObjectPath)(searchPath != null ? searchPath.getCurrent() : null), this.path.getCurrent())) {
                return;
            }
            throw (Throwable)new IllegalStateException("Cannot switch a database. The connection is used by another client. Disable the single connection mode and try again");
        }

        @NotNull
        public final DatabaseSessionClient<DatabaseSession> client() {
            DatabaseSession session2 = DatabaseSessionManager.getSilentSession(this.project, this.dataSource, 3);
            TemporaryClient client = new TemporaryClient(session2, this.department, this.path);
            session2.attach(client);
            return client;
        }

        private final <T> T compute(Function1<? super DatabaseConnection, ? extends T> work2, DatabaseConnection connection2, DataRequest.Context context) {
            Object object;
            try {
                object = work2.invoke((Object)connection2);
            }
            catch (Exception e) {
                if (!AsyncUtil.isCancellation(e)) {
                    context.reportException(e, null);
                }
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final <T> CompletableFuture<T> perform(CompletableFuture<T> future, Function1<? super ConnectionInfo, ? extends T> work2) {
            void client;
            boolean submitted = false;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            try {
                client.element = this.client();
                TemporaryAuditor<T> auditor = new TemporaryAuditor<T>(future, (DatabaseSessionClient)client.element, this.handler);
                ((DatabaseSessionClient)client.element).getMessageBus().addAuditor(auditor);
                ((DatabaseSessionClient)client.element).getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(auditor, future, work2, (Ref.ObjectRef)client, (DatabaseSessionClient)client.element){
                    final /* synthetic */ TemporaryAuditor $auditor;
                    final /* synthetic */ CompletableFuture $future;
                    final /* synthetic */ Function1 $work;
                    final /* synthetic */ Ref.ObjectRef $client;

                    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection2) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
                        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
                        if (this.$auditor.hasErrors()) {
                            return;
                        }
                        try {
                            this.$future.complete(this.$work.invoke((Object)new ConnectionInfo(connection2, context)));
                        }
                        catch (InterruptedException e) {
                            ProcessCanceledException ex = new ProcessCanceledException((Throwable)e);
                            this.$future.completeExceptionally(ex);
                            throw (Throwable)ex;
                        }
                        catch (Throwable t) {
                            this.$future.completeExceptionally(t);
                            throw (Throwable)new ProcessCanceledException(t);
                        }
                    }
                    {
                        this.$auditor = $captured_local_variable$0;
                        this.$future = $captured_local_variable$1;
                        this.$work = $captured_local_variable$2;
                        this.$client = $captured_local_variable$3;
                        super($super_call_param$4);
                    }
                });
                submitted = auditor.getSubmitted();
                if (submitted) return future;
            }
            catch (Throwable throwable) {
                if ((DatabaseSessionClient)client.element != null) {
                    Disposer.dispose((Disposable)((DatabaseSessionClient)client.element));
                }
                future.completeExceptionally(new ProcessCanceledException());
                throw throwable;
            }
            if ((DatabaseSessionClient)client.element != null) {
                Disposer.dispose((Disposable)((DatabaseSessionClient)client.element));
            }
            future.completeExceptionally(new ProcessCanceledException());
            return future;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        public Facade(@NotNull LocalDataSource dataSource, @NotNull Project project, @Nullable SearchPath path, @Nullable ErrorHandler handler, @NotNull DatabaseDepartment department) {
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)department, (String)"department");
            this.dataSource = dataSource;
            this.project = project;
            this.path = path;
            this.handler = handler;
            this.department = department;
        }

        public /* synthetic */ Facade(LocalDataSource localDataSource, Project project, SearchPath searchPath, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                searchPath = null;
            }
            if ((n & 8) != 0) {
                errorHandler = null;
            }
            this(localDataSource, project, searchPath, errorHandler, databaseDepartment);
        }

        static {
            Companion = new Companion(null);
            routers = new Routers(MultipleSessionsRouter.INSTANCE, new SingleSessionRouter());
        }

        public static final /* synthetic */ Object access$compute(Facade $this, @NotNull Function1 work2, @NotNull DatabaseConnection connection2, @NotNull DataRequest.Context context) {
            return $this.compute(work2, connection2, context);
        }

        @NotNull
        public static final /* synthetic */ Companion access$Companion() {
            return Companion;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/datagrid/DataRequest$Context;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnection;", "getContext", "()Lcom/intellij/database/datagrid/DataRequest$Context;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
        private static final class ConnectionInfo {
            @NotNull
            private final DatabaseConnection connection;
            @NotNull
            private final DataRequest.Context context;

            @NotNull
            public final DatabaseConnection getConnection() {
                return this.connection;
            }

            @NotNull
            public final DataRequest.Context getContext() {
                return this.context;
            }

            public ConnectionInfo(@NotNull DatabaseConnection connection2, @NotNull DataRequest.Context context) {
                Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
                Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
                this.connection = connection2;
                this.context = context;
            }

            @NotNull
            public final DatabaseConnection component1() {
                return this.connection;
            }

            @NotNull
            public final DataRequest.Context component2() {
                return this.context;
            }

            @NotNull
            public final ConnectionInfo copy(@NotNull DatabaseConnection connection2, @NotNull DataRequest.Context context) {
                Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
                Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
                return new ConnectionInfo(connection2, context);
            }

            @NotNull
            public static /* synthetic */ ConnectionInfo copy$default(ConnectionInfo connectionInfo, DatabaseConnection databaseConnection, DataRequest.Context context, int n, Object object) {
                if ((n & 1) != 0) {
                    databaseConnection = connectionInfo.connection;
                }
                if ((n & 2) != 0) {
                    context = connectionInfo.context;
                }
                return connectionInfo.copy(databaseConnection, context);
            }

            @NotNull
            public String toString() {
                return "ConnectionInfo(connection=" + this.connection + ", context=" + (Object)((Object)this.context) + ")";
            }

            public int hashCode() {
                DatabaseConnection databaseConnection = this.connection;
                DataRequest.Context context = this.context;
                return (databaseConnection != null ? databaseConnection.hashCode() : 0) * 31 + (context != null ? ((Object)((Object)context)).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ConnectionInfo)) break block3;
                        ConnectionInfo connectionInfo = (ConnectionInfo)object;
                        if (!Intrinsics.areEqual((Object)this.connection, (Object)connectionInfo.connection) || !Intrinsics.areEqual((Object)((Object)this.context), (Object)((Object)connectionInfo.context))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "", "resource", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "engineLatch", "Ljava/util/concurrent/CountDownLatch;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;Ljava/util/concurrent/CountDownLatch;)V", "getEngineLatch", "()Ljava/util/concurrent/CountDownLatch;", "referenced", "", "getReferenced", "()I", "setReferenced", "(I)V", "getResource", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.database.impl"})
        private static final class ConnectionReference {
            private int referenced;
            @NotNull
            private final ConnectionInfo resource;
            @Nullable
            private final CountDownLatch engineLatch;

            public final int getReferenced() {
                return this.referenced;
            }

            public final void setReferenced(int n) {
                this.referenced = n;
            }

            @NotNull
            public final ConnectionInfo getResource() {
                return this.resource;
            }

            @Nullable
            public final CountDownLatch getEngineLatch() {
                return this.engineLatch;
            }

            public ConnectionReference(@NotNull ConnectionInfo resource, @Nullable CountDownLatch engineLatch) {
                Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
                this.resource = resource;
                this.engineLatch = engineLatch;
            }

            public /* synthetic */ ConnectionReference(ConnectionInfo connectionInfo, CountDownLatch countDownLatch, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    countDownLatch = null;
                }
                this(connectionInfo, countDownLatch);
            }

            @NotNull
            public final ConnectionInfo component1() {
                return this.resource;
            }

            @Nullable
            public final CountDownLatch component2() {
                return this.engineLatch;
            }

            @NotNull
            public final ConnectionReference copy(@NotNull ConnectionInfo resource, @Nullable CountDownLatch engineLatch) {
                Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
                return new ConnectionReference(resource, engineLatch);
            }

            @NotNull
            public static /* synthetic */ ConnectionReference copy$default(ConnectionReference connectionReference, ConnectionInfo connectionInfo, CountDownLatch countDownLatch, int n, Object object) {
                if ((n & 1) != 0) {
                    connectionInfo = connectionReference.resource;
                }
                if ((n & 2) != 0) {
                    countDownLatch = connectionReference.engineLatch;
                }
                return connectionReference.copy(connectionInfo, countDownLatch);
            }

            @NotNull
            public String toString() {
                return "ConnectionReference(resource=" + this.resource + ", engineLatch=" + this.engineLatch + ")";
            }

            public int hashCode() {
                ConnectionInfo connectionInfo = this.resource;
                CountDownLatch countDownLatch = this.engineLatch;
                return (connectionInfo != null ? ((Object)connectionInfo).hashCode() : 0) * 31 + (countDownLatch != null ? countDownLatch.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ConnectionReference)) break block3;
                        ConnectionReference connectionReference = (ConnectionReference)object;
                        if (!Intrinsics.areEqual((Object)this.resource, (Object)connectionReference.resource) || !Intrinsics.areEqual((Object)this.engineLatch, (Object)connectionReference.engineLatch)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Lockpick;", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "reference", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "router", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;)V", "getReference", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "close", "", "info", "intellij.database.impl"})
        private static final class Lockpick
        extends GuardedRef<ConnectionInfo> {
            @NotNull
            private final ConnectionReference reference;
            private final ConnectionsRouter router;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void close(@NotNull ConnectionInfo info) {
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                ConnectionReference connectionReference = this.reference;
                int n = connectionReference.getReferenced();
                connectionReference.setReferenced(n + -1);
                if (this.reference.getReferenced() != 0) {
                    return;
                }
                try {
                    this.router.remove();
                }
                finally {
                    CountDownLatch countDownLatch = this.reference.getEngineLatch();
                    if (countDownLatch != null) {
                        countDownLatch.countDown();
                    }
                }
            }

            @NotNull
            public final ConnectionReference getReference() {
                return this.reference;
            }

            public Lockpick(@NotNull ConnectionReference reference, @NotNull ConnectionsRouter router) {
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                Intrinsics.checkParameterIsNotNull((Object)router, (String)"router");
                super(reference.getResource());
                this.reference = reference;
                this.router = router;
                ConnectionReference connectionReference = this.reference;
                int n = connectionReference.getReferenced();
                connectionReference.setReferenced(n + 1);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "remove", "", "save", "reference", "intellij.database.impl"})
        private static interface ConnectionsRouter {
            @Nullable
            public ConnectionReference getCurrent();

            public void save(@NotNull ConnectionReference var1);

            public void remove();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "()V", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "localRefs", "Ljava/lang/ThreadLocal;", "remove", "", "save", "reference", "intellij.database.impl"})
        private static final class SingleSessionRouter
        implements ConnectionsRouter {
            private final ThreadLocal<ConnectionReference> localRefs = new ThreadLocal();

            @Override
            @Nullable
            public ConnectionReference getCurrent() {
                return this.localRefs.get();
            }

            @Override
            public void save(@NotNull ConnectionReference reference) {
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                this.localRefs.set(reference);
            }

            @Override
            public void remove() {
                this.localRefs.remove();
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "()V", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "remove", "", "save", "reference", "intellij.database.impl"})
        private static final class MultipleSessionsRouter
        implements ConnectionsRouter {
            @Nullable
            private static final ConnectionReference current;
            public static final MultipleSessionsRouter INSTANCE;

            @Override
            @Nullable
            public ConnectionReference getCurrent() {
                return current;
            }

            @Override
            public void save(@NotNull ConnectionReference reference) {
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
            }

            @Override
            public void remove() {
            }

            private MultipleSessionsRouter() {
            }

            static {
                MultipleSessionsRouter multipleSessionsRouter;
                INSTANCE = multipleSessionsRouter = new MultipleSessionsRouter();
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "", "multi", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;", "single", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;)V", "choose", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
        private static final class Routers {
            private final MultipleSessionsRouter multi;
            private final SingleSessionRouter single;

            @NotNull
            public final ConnectionsRouter choose(@NotNull LocalDataSource dataSource) {
                Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
                return dataSource.isSingleConnection() ? (ConnectionsRouter)this.single : (ConnectionsRouter)this.multi;
            }

            public Routers(@NotNull MultipleSessionsRouter multi, @NotNull SingleSessionRouter single) {
                Intrinsics.checkParameterIsNotNull((Object)multi, (String)"multi");
                Intrinsics.checkParameterIsNotNull((Object)single, (String)"single");
                this.multi = multi;
                this.single = single;
            }

            private final MultipleSessionsRouter component1() {
                return this.multi;
            }

            private final SingleSessionRouter component2() {
                return this.single;
            }

            @NotNull
            public final Routers copy(@NotNull MultipleSessionsRouter multi, @NotNull SingleSessionRouter single) {
                Intrinsics.checkParameterIsNotNull((Object)multi, (String)"multi");
                Intrinsics.checkParameterIsNotNull((Object)single, (String)"single");
                return new Routers(multi, single);
            }

            @NotNull
            public static /* synthetic */ Routers copy$default(Routers routers, MultipleSessionsRouter multipleSessionsRouter, SingleSessionRouter singleSessionRouter, int n, Object object) {
                if ((n & 1) != 0) {
                    multipleSessionsRouter = routers.multi;
                }
                if ((n & 2) != 0) {
                    singleSessionRouter = routers.single;
                }
                return routers.copy(multipleSessionsRouter, singleSessionRouter);
            }

            @NotNull
            public String toString() {
                return "Routers(multi=" + this.multi + ", single=" + this.single + ")";
            }

            public int hashCode() {
                MultipleSessionsRouter multipleSessionsRouter = this.multi;
                SingleSessionRouter singleSessionRouter = this.single;
                return (multipleSessionsRouter != null ? multipleSessionsRouter.hashCode() : 0) * 31 + (singleSessionRouter != null ? singleSessionRouter.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Routers)) break block3;
                        Routers routers = (Routers)object;
                        if (!Intrinsics.areEqual((Object)this.multi, (Object)routers.multi) || !Intrinsics.areEqual((Object)this.single, (Object)routers.single)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Companion;", "", "()V", "routers", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "getRouters", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "intellij.database.impl"})
        private static final class Companion {
            @NotNull
            public final Routers getRouters() {
                return routers;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u000bJ\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$TemporaryAuditor;", "T", "Lcom/intellij/database/datagrid/DataAuditor$Adapter;", "stage", "Ljava/util/concurrent/CompletableFuture;", "client", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "(Ljava/util/concurrent/CompletableFuture;Lcom/intellij/database/console/client/DatabaseSessionClient;Lcom/intellij/database/util/ErrorHandler;)V", "connected", "", "submitted", "getSubmitted", "()Z", "setSubmitted", "(Z)V", "wasError", "error", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "message", "", "th", "", "hasErrors", "jobFinished", "request", "Lcom/intellij/database/datagrid/DataRequest;", "producer", "Lcom/intellij/database/datagrid/DataProducer;", "jobSubmitted", "intellij.database.impl"})
    private static final class TemporaryAuditor<T>
    extends DataAuditor.Adapter {
        private volatile boolean connected;
        private volatile boolean wasError;
        private boolean submitted;
        private final CompletableFuture<T> stage;
        private final DatabaseSessionClient<?> client;
        private final ErrorHandler handler;

        public final boolean getSubmitted() {
            return this.submitted;
        }

        public final void setSubmitted(boolean bl) {
            this.submitted = bl;
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            Throwable throwable;
            Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
            ErrorHandler errorHandler = this.handler;
            if (errorHandler != null) {
                errorHandler.addError(message2, th);
            }
            this.wasError = true;
            if (this.connected) {
                return;
            }
            if (this.handler != null) {
                throwable = new ProcessCanceledException();
            } else if (message2 == null) {
                throwable = th;
                if (throwable == null) {
                    throwable = new ProcessCanceledException();
                }
            } else {
                throwable = new RuntimeException(message2);
            }
            this.stage.completeExceptionally(throwable);
        }

        public final boolean hasErrors() {
            this.connected = true;
            return this.wasError;
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
            this.submitted = true;
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
            if (!this.stage.isDone()) {
                this.stage.completeExceptionally(new ProcessCanceledException());
            }
            Disposer.dispose((Disposable)this.client);
        }

        public TemporaryAuditor(@NotNull CompletableFuture<T> stage, @NotNull DatabaseSessionClient<?> client, @Nullable ErrorHandler handler) {
            Intrinsics.checkParameterIsNotNull(stage, (String)"stage");
            Intrinsics.checkParameterIsNotNull(client, (String)"client");
            this.stage = stage;
            this.client = client;
            this.handler = handler;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$TemporaryClient;", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "Lcom/intellij/database/console/session/DatabaseSession;", "Lcom/intellij/database/datagrid/DataRequest$CustomSearchPathOwner;", "session", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "path", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/database/console/session/DatabaseSession;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;Lcom/intellij/database/util/SearchPath;)V", "disposed", "", "messageBus", "Lcom/intellij/database/DataBus$Consuming;", "kotlin.jvm.PlatformType", "getSession", "()Lcom/intellij/database/console/session/DatabaseSession;", "title", "", "getTitle", "()Ljava/lang/String;", "dispose", "", "getCurrentTx", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getDepartment", "getDisplayName", "getMessageBus", "getSearchPath", "isActive", "isEphemeral", "setAutoCommit", "autoCommit", "intellij.database.impl"})
    private static final class TemporaryClient
    implements DatabaseSessionClient<DatabaseSession>,
    DataRequest.CustomSearchPathOwner {
        @NotNull
        private final String title = "Temporary Session Client";
        private volatile boolean disposed;
        private final DataBus.Consuming messageBus;
        @NotNull
        private final DatabaseSession session;
        private final DatabaseDepartment department;
        private final SearchPath path;

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Override
        public boolean isActive() {
            return !this.disposed;
        }

        @Override
        @NotNull
        public DatabaseDepartment getDepartment() {
            return this.department;
        }

        @Override
        @Nullable
        public SearchPath getSearchPath() {
            return this.path;
        }

        @Override
        @NotNull
        public DataRequest.TxMarker getCurrentTx() {
            DataRequest.TxMarker txMarker = this.getSession().getCurrentTx();
            Intrinsics.checkExpressionValueIsNotNull((Object)txMarker, (String)"session.currentTx");
            return txMarker;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.getTitle();
        }

        @Override
        @NotNull
        public DataBus.Consuming getMessageBus() {
            DataBus.Consuming consuming = this.messageBus;
            Intrinsics.checkExpressionValueIsNotNull((Object)consuming, (String)"messageBus");
            return consuming;
        }

        @Override
        public boolean isEphemeral() {
            return true;
        }

        @Override
        public void setAutoCommit(boolean autoCommit) {
            this.getSession().setAutoCommit(autoCommit);
        }

        public void dispose() {
            this.disposed = true;
        }

        @Override
        @NotNull
        public DatabaseSession getSession() {
            return this.session;
        }

        public TemporaryClient(@NotNull DatabaseSession session2, @NotNull DatabaseDepartment department, @Nullable SearchPath path) {
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            Intrinsics.checkParameterIsNotNull((Object)department, (String)"department");
            this.session = session2;
            this.department = department;
            this.path = path;
            this.title = "Temporary Session Client";
            this.messageBus = this.getSession().getMessageBus().filterFor(this);
        }
    }
}

