/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.google.common.util.concurrent.Atomics;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorageLocal;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.SafeFileOutputStream;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.ReaderWrapper;
import com.thoughtworks.xstream.io.json.AbstractJsonWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.thoughtworks.xstream.io.xml.JDomReader;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jdom.JDOMInterner;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class DataSourceStorage
extends SimpleModificationTracker
implements Disposable {
    public static final Topic<Listener> TOPIC = Topic.create((String)"DATA_SOURCE_STORAGE", Listener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_CHILDREN);
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.DataSourceStorage");
    public static final String MULTIFILE_MODEL = "multifile-model";
    private boolean myMultiFileModel;
    @NonNls
    static final String STORAGE_ENTRY_NAME = "dataSources";
    @NonNls
    static final String STATE_FILE = "dataSources.xml";
    @NonNls
    static final String APP_STORAGE_FILE = "dataSources.ids";
    @NonNls
    static final String COMPONENT_NAME = "dataSourceStorage";
    @NonNls
    static final String COMPRESSED_ATTR_NAME = "compressed";
    @NonNls
    static final String FORMAT_ATTR_NAME = "format";
    @Nullable
    private final DataSourceStorage myParentStorage;
    @NotNull
    private final List<LocalDataSource> myDataSources;
    @NotNull
    private final AtomicReference<Promise<Void>> myLoadedPromise;
    @NotNull
    private final Listener myDispatcher;
    private final Map<String, Object> myLocks;
    private Format myFormat;
    private final LocalDataSource.Listener myDataSourceListener;

    public static DataSourceStorage getStorage() {
        return (DataSourceStorage)((Object)ServiceManager.getService(App.class));
    }

    public static DataSourceStorage getProjectStorage(Project project) {
        return (DataSourceStorage)((Object)ServiceManager.getService((Project)project, Prj.class));
    }

    public DataSourceStorage(@Nullable DataSourceStorage parentStorage, @NotNull MessageBus messageBus) {
        if (messageBus == null) {
            DataSourceStorage.$$$reportNull$$$0(0);
        }
        this.myMultiFileModel = true;
        this.myDataSources = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLoadedPromise = Atomics.newReference((Object)Promises.resolvedPromise(null));
        this.myLocks = FactoryMap.create(key2 -> new Object((String)key2){
            final /* synthetic */ String val$key;
            {
                this.val$key = string;
            }

            public String toString() {
                return this.val$key;
            }
        });
        this.myFormat = Format.XML;
        this.myParentStorage = parentStorage;
        this.myDispatcher = (Listener)messageBus.syncPublisher(TOPIC);
        this.myDataSourceListener = o -> {
            if (messageBus == null) {
                DataSourceStorage.$$$reportNull$$$0(42);
            }
            if (messageBus.isDisposed()) {
                return;
            }
            this.incModificationCount();
            this.myDispatcher.dataSourceChanged(o);
        };
    }

    public void doWhenInitialized(@NotNull Runnable runnable) {
        if (runnable == null) {
            DataSourceStorage.$$$reportNull$$$0(1);
        }
        Promise promise = this.myParentStorage == null ? this.myLoadedPromise.get() : Promises.all(Arrays.asList(this.myParentStorage.myLoadedPromise.get(), this.myLoadedPromise.get()));
        promise.onSuccess(ignored -> {
            if (runnable == null) {
                DataSourceStorage.$$$reportNull$$$0(41);
            }
            runnable.run();
        });
    }

    @NotNull
    public List<LocalDataSource> getOwnDataSources() {
        List<LocalDataSource> list = this.myDataSources;
        if (list == null) {
            DataSourceStorage.$$$reportNull$$$0(2);
        }
        return list;
    }

    private void addDataSourcesInner(@NotNull Iterable<LocalDataSource> dataSources2) {
        if (dataSources2 == null) {
            DataSourceStorage.$$$reportNull$$$0(3);
        }
        for (LocalDataSource dataSource : dataSources2) {
            this.addDataSourceInner(dataSource);
        }
    }

    private void addDataSourceInner(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(4);
        }
        this.myDataSources.add(dataSource);
        dataSource.addListener(this.myDataSourceListener);
    }

    private boolean removeDataSourceInner(@NotNull LocalDataSource dataSource) {
        boolean removed;
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(5);
        }
        if (removed = this.myDataSources.remove(dataSource)) {
            dataSource.removeListener(this.myDataSourceListener);
        }
        return removed;
    }

    private void removeAllDataSources() {
        ArrayList<LocalDataSource> existentDataSources = new ArrayList<LocalDataSource>(this.myDataSources);
        for (LocalDataSource dataSource : existentDataSources) {
            this.removeDataSourceInner(dataSource);
        }
    }

    @NotNull
    public List<LocalDataSource> getDataSources() {
        List list = this.getDataSourcesImpl().toList();
        if (list == null) {
            DataSourceStorage.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public JBIterable<LocalDataSource> getDataSourcesImpl() {
        JBIterable jBIterable = JBIterable.from(this.myDataSources).append(this.myParentStorage != null ? this.myParentStorage.myDataSources : null);
        if (jBIterable == null) {
            DataSourceStorage.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    public void addDataSource(LocalDataSource dataSource) {
        LocalDataSource existing;
        LocalDataSource localDataSource = existing = dataSource.getUniqueId() == null ? null : this.getDataSourceById(dataSource.getUniqueId());
        if (existing != null) {
            LOG.error(String.format("Unable to add %s datasource '%s' (%s@%d): '%s' (%s@%d) has the same id: %s", this.myParentStorage == null ? "global" : "project", dataSource.getName(), dataSource.getClass().getSimpleName(), dataSource.hashCode(), existing.getName(), existing.getClass().getSimpleName(), existing.hashCode(), dataSource.getUniqueId()));
        }
        if (dataSource.isGlobal() && this.myParentStorage != null) {
            this.myParentStorage.addDataSource(dataSource);
        } else {
            dataSource.init();
            this.addDataSourceInner(dataSource);
            this.incModificationCount();
            this.myDispatcher.dataSourceAdded(dataSource);
        }
        DatabaseCredentials.getInstance().persistCredentials(dataSource);
    }

    @Nullable
    public LocalDataSource getDataSourceById(String id) {
        return DataSourceStorage.getDataSourcesByIdInner(id, this.getDataSources());
    }

    @Nullable
    private static <L extends AbstractDataSource> L getDataSourcesByIdInner(@Nullable String id, @NotNull Collection<? extends L> dataSources2) {
        if (dataSources2 == null) {
            DataSourceStorage.$$$reportNull$$$0(8);
        }
        for (AbstractDataSource dataSource : dataSources2) {
            LOG.assertTrue(dataSource.getUniqueId() != null);
            if (!dataSource.getUniqueId().equals(id)) continue;
            return (L)dataSource;
        }
        return null;
    }

    public void removeDataSource(LocalDataSource dataSource) {
        if (this.removeDataSourceInner(dataSource)) {
            this.incModificationCount();
            this.myDispatcher.dataSourceRemoved(dataSource);
        } else if (this.myParentStorage != null) {
            this.myParentStorage.removeDataSource(dataSource);
        }
    }

    public void updateDataSource(LocalDataSource dataSource) {
        dataSource.incModificationCount();
        boolean isMy = this.myDataSources.contains(dataSource);
        if (this.myParentStorage != null && dataSource.isGlobal() == isMy) {
            this.removeDataSource(dataSource);
            this.addDataSource(dataSource);
        } else if (isMy) {
            this.incModificationCount();
            this.myDispatcher.dataSourceChanged(dataSource);
        } else if (this.myParentStorage != null) {
            this.myParentStorage.updateDataSource(dataSource);
        }
    }

    public long getModificationCount() {
        if (this.myParentStorage != null) {
            return super.getModificationCount() + this.myParentStorage.getModificationCount();
        }
        return super.getModificationCount();
    }

    public void dispose() {
    }

    public Element getState() {
        Element element2 = new Element(COMPONENT_NAME);
        this.writeState(null, element2);
        return element2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DataSourceStorage.$$$reportNull$$$0(9);
        }
        this.readState(null, state);
    }

    public void writeLocalState(@Nullable Project project) {
        Element element2 = new Element("dataSourceStorageLocal");
        JDomWriter serializer = new JDomWriter(element2);
        for (LocalDataSource dataSource : this.myDataSources) {
            dataSource.serialize(project, (HierarchicalStreamWriter)serializer, LocalDataSource.SaveMode.LOCAL_CONFIG);
        }
        DataSourceStorageLocal.getInstance(project).loadState(element2);
    }

    private static void readLocalState(@Nullable Element element2, @Nullable Project project, boolean isGlobal, @NotNull Collection<LocalDataSource> dataSources2, @Nullable Consumer<LocalDataSource> newDataSourcesConsumer) {
        if (dataSources2 == null) {
            DataSourceStorage.$$$reportNull$$$0(10);
        }
        if (element2 == null) {
            for (LocalDataSource dataSource : dataSources2) {
                if (!StringUtil.isEmpty((String)dataSource.getUsername())) continue;
                dataSource.setUseMasterKeyStorage(false);
            }
        } else {
            DataSourceStorage.readDataSources((HierarchicalStreamReader)new JDomReader(element2), LocalDataSource.SaveMode.LOCAL_CONFIG, project, isGlobal, (Function<String, LocalDataSource>)((Function)uuid -> {
                if (dataSources2 == null) {
                    DataSourceStorage.$$$reportNull$$$0(40);
                }
                return (LocalDataSource)DataSourceStorage.getDataSourcesByIdInner(uuid, dataSources2);
            }), newDataSourcesConsumer);
        }
    }

    void readState(final @Nullable Project project, @NotNull Element element2) {
        if (element2 == null) {
            DataSourceStorage.$$$reportNull$$$0(11);
        }
        if (project != null && project.isDefault()) {
            return;
        }
        this.myFormat = DataSourceStorage.readFormat(element2);
        this.myMultiFileModel = DataSourceStorage.isMultiFileModel(element2);
        final AsyncPromise promise = new AsyncPromise();
        this.myLoadedPromise.set((Promise<Void>)promise);
        this.incModificationCount();
        this.removeAllDataSources();
        boolean isGlobal = this.myParentStorage == null;
        DataSourceStorageLocal storageLocal = DataSourceStorageLocal.getInstance(project);
        ArrayList<LocalDataSource> newDataSources = new ArrayList<LocalDataSource>();
        JDomReader domReader = new JDomReader(JDOMInterner.isInterned((Element)element2) ? element2.clone() : element2);
        DataSourceStorage.readDataSources((HierarchicalStreamReader)domReader, LocalDataSource.SaveMode.CONFIG, project, isGlobal, (Function<String, LocalDataSource>)((Function)uuid -> null), (Consumer<LocalDataSource>)((Consumer)newDataSources::add));
        DataSourceStorage.readLocalState(storageLocal.getState(), project, isGlobal, newDataSources, (Consumer<LocalDataSource>)((Consumer)newDataSources::add));
        for (LocalDataSource dataSource : newDataSources) {
            dataSource.setLoading(true);
            dataSource.init();
            dataSource.resolveDriver();
            if (dataSource.getDatabaseDriver() != null && dataSource.getOwnClasspath().isEmpty()) continue;
            dataSource.ensureDriverConfigured();
        }
        this.addDataSourcesInner(newDataSources);
        this.myDispatcher.dataSourceChanged(null);
        Application application = ApplicationManager.getApplication();
        Application disposable = project == null ? application : project;
        final Condition condition = disposable.getDisposed();
        new Task.Backgroundable(project, "Loading Data Sources...", false, (ComponentManager)disposable){
            final /* synthetic */ ComponentManager val$disposable;
            {
                this.val$disposable = componentManager;
                super(arg0, arg1, arg2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                ErrorHandler errorHandler;
                block12: {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (condition.value(null)) {
                        promise.cancel();
                        return;
                    }
                    errorHandler = new ErrorHandler();
                    try {
                        DataSourceStorage.this.loadModels(project, errorHandler, (PairConsumer<LocalDataSource, DasModel>)(dataSource, model) -> {
                            if (promise != DataSourceStorage.this.myLoadedPromise.get()) {
                                throw new ProcessCanceledException();
                            }
                            DataSourceStorage.migrateStorage(project, dataSource, model);
                            GuiUtils.invokeLaterIfNeeded(() -> {
                                dataSource.setModel((DasModel)model);
                                dataSource.setLoading(false);
                            }, (ModalityState)ModalityState.defaultModalityState(), (Condition)condition);
                        });
                        if (promise == DataSourceStorage.this.myLoadedPromise.get()) break block12;
                        return;
                    }
                    catch (ProcessCanceledException e) {
                        block13: {
                            try {
                                if (promise != DataSourceStorage.this.myLoadedPromise.get()) {
                                    ((Promise)DataSourceStorage.this.myLoadedPromise.get()).processed((Promise)promise);
                                } else {
                                    promise.setError((Throwable)e);
                                }
                                if (promise == DataSourceStorage.this.myLoadedPromise.get()) break block13;
                                return;
                            }
                            catch (Throwable throwable) {
                                if (promise != DataSourceStorage.this.myLoadedPromise.get()) {
                                    return;
                                }
                                TransactionGuard.submitTransaction((Disposable)this.val$disposable, () -> {
                                    final ArrayList unsuccessful = ContainerUtil.newArrayList();
                                    for (LocalDataSource dataSource : DataSourceStorage.this.myDataSources) {
                                        if (!dataSource.isLoading()) continue;
                                        dataSource.setModel(DasUtil.emptyModel());
                                        dataSource.setLoading(false);
                                        unsuccessful.add(dataSource);
                                    }
                                    DataSourceStorage.this.myDispatcher.dataSourceChanged(null);
                                    promise.setResult(null);
                                    FileContentUtil.reparseOpenedFiles();
                                    String summary = errorHandler.getSummary();
                                    if (StringUtil.isNotEmpty((String)summary)) {
                                        String title = (project == null ? "Global" : "Project") + " Data Sources: <a href=\"sync\">re-sync</a> required";
                                        Notification notification = new Notification("System Messages", title, summary, NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

                                            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                                                if (notification == null) {
                                                    1.$$$reportNull$$$0(0);
                                                }
                                                if (e == null) {
                                                    1.$$$reportNull$$$0(1);
                                                }
                                                for (LocalDataSource dataSource : unsuccessful) {
                                                    DataSourceUiUtil.performAutoSyncTask(LoaderContext.loadAll(this.getProject(), dataSource));
                                                }
                                            }

                                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                                Object[] objectArray;
                                                Object[] objectArray2 = new Object[3];
                                                switch (n) {
                                                    default: {
                                                        objectArray = objectArray2;
                                                        objectArray2[0] = "notification";
                                                        break;
                                                    }
                                                    case 1: {
                                                        objectArray = objectArray2;
                                                        objectArray2[0] = "e";
                                                        break;
                                                    }
                                                }
                                                objectArray[1] = "com/intellij/database/dataSource/DataSourceStorage$2$1";
                                                objectArray[2] = "hyperlinkActivated";
                                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                            }
                                        });
                                        notification.notify(project);
                                    }
                                });
                                if (DbSrcValidator.isEnabled()) {
                                    Project p2 = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
                                    DataSourceStorage.validateModels(p2, DataSourceStorage.this.myDataSources);
                                }
                                throw throwable;
                            }
                        }
                        TransactionGuard.submitTransaction((Disposable)this.val$disposable, () -> {
                            final ArrayList unsuccessful = ContainerUtil.newArrayList();
                            for (LocalDataSource dataSource : DataSourceStorage.this.myDataSources) {
                                if (!dataSource.isLoading()) continue;
                                dataSource.setModel(DasUtil.emptyModel());
                                dataSource.setLoading(false);
                                unsuccessful.add(dataSource);
                            }
                            DataSourceStorage.this.myDispatcher.dataSourceChanged(null);
                            promise.setResult(null);
                            FileContentUtil.reparseOpenedFiles();
                            String summary = errorHandler.getSummary();
                            if (StringUtil.isNotEmpty((String)summary)) {
                                String title = (project == null ? "Global" : "Project") + " Data Sources: <a href=\"sync\">re-sync</a> required";
                                Notification notification = new Notification("System Messages", title, summary, NotificationType.ERROR, (NotificationListener)new /* invalid duplicate definition of identical inner class */);
                                notification.notify(project);
                            }
                        });
                        if (DbSrcValidator.isEnabled()) {
                            Project p3 = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
                            DataSourceStorage.validateModels(p3, DataSourceStorage.this.myDataSources);
                        }
                    }
                }
                TransactionGuard.submitTransaction((Disposable)this.val$disposable, () -> {
                    final ArrayList unsuccessful = ContainerUtil.newArrayList();
                    for (LocalDataSource dataSource : DataSourceStorage.this.myDataSources) {
                        if (!dataSource.isLoading()) continue;
                        dataSource.setModel(DasUtil.emptyModel());
                        dataSource.setLoading(false);
                        unsuccessful.add(dataSource);
                    }
                    DataSourceStorage.this.myDispatcher.dataSourceChanged(null);
                    promise.setResult(null);
                    FileContentUtil.reparseOpenedFiles();
                    String summary = errorHandler.getSummary();
                    if (StringUtil.isNotEmpty((String)summary)) {
                        String title = (project == null ? "Global" : "Project") + " Data Sources: <a href=\"sync\">re-sync</a> required";
                        Notification notification = new Notification("System Messages", title, summary, NotificationType.ERROR, (NotificationListener)new /* invalid duplicate definition of identical inner class */);
                        notification.notify(project);
                    }
                });
                if (DbSrcValidator.isEnabled()) {
                    Project p4 = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
                    DataSourceStorage.validateModels(p4, DataSourceStorage.this.myDataSources);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DataSourceStorage$2", "run"));
            }
        }.queue();
    }

    private static void migrateStorage(Project project, LocalDataSource source, DasModel model) {
        String dataSourceId;
        DbSrcStorageManager storageManager = DbSrcStorageManager.getInstance(project);
        if (!storageManager.isStoredInNewFormat(dataSourceId = source.getUniqueId())) {
            storageManager.migrate(dataSourceId, model);
        }
    }

    private static void validateModels(@NotNull Project project, @NotNull List<LocalDataSource> dataSources2) {
        if (project == null) {
            DataSourceStorage.$$$reportNull$$$0(12);
        }
        if (dataSources2 == null) {
            DataSourceStorage.$$$reportNull$$$0(13);
        }
        if (project.isDisposed()) {
            return;
        }
        Couple<List<LocalDataSource>> result2 = new DbSrcValidator().collect(project, dataSources2);
        if (project.isDisposed() || ((List)result2.first).isEmpty() && ((List)result2.second).isEmpty()) {
            return;
        }
        if (!((List)result2.second).isEmpty()) {
            DbSrcValidator.suggestIntrospecting(project, (List)result2.second);
        }
        if (!((List)result2.first).isEmpty()) {
            DbSrcValidator.regenerateSources(project, (List)result2.first);
        }
    }

    private static boolean isMultiFileModel(Element element2) {
        return "true".equals(element2.getAttributeValue(MULTIFILE_MODEL));
    }

    private boolean loadModels(@Nullable Project project, @NotNull ErrorHandler errorHandler, @NotNull PairConsumer<LocalDataSource, DasModel> consumer2) {
        if (errorHandler == null) {
            DataSourceStorage.$$$reportNull$$$0(14);
        }
        if (consumer2 == null) {
            DataSourceStorage.$$$reportNull$$$0(15);
        }
        if (project != null && project.isDisposed()) {
            return false;
        }
        ArrayList newDataSources = ContainerUtil.newArrayList(this.myDataSources);
        String path = DataSourceStorage.getStoragePath(project);
        boolean migrating = !this.myMultiFileModel && FileUtil.exists((String)path);
        this.myMultiFileModel = true;
        boolean failed = migrating && this.loadFromDisk(project, path, LocalDataSource.SaveMode.SCHEMA, errorHandler) == null;
        for (LocalDataSource source : newDataSources) {
            try {
                boolean loaded = this.readModel(project, source, false, consumer2);
                if (!loaded) {
                    if (migrating && source.getModel() != DasUtil.emptyModel()) {
                        failed |= !this.writeModel(project, source);
                    } else if (!migrating && (loaded = this.readModel(project, source, true, consumer2))) {
                        failed |= !this.writeModel(project, source);
                    }
                }
                if (loaded) continue;
                consumer2.consume((Object)source, (Object)DasUtil.emptyModel());
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            catch (Exception e) {
                failed = true;
                String file = this.getModelPath(project, source, false);
                if (file != null) {
                    DataSourceStorage.processCorruption(new File(file), e);
                }
                errorHandler.addError(e.getMessage(), e);
            }
        }
        if (failed) {
            return false;
        }
        Application app = ApplicationManager.getApplication();
        Condition expired = project == null ? app.getDisposed() : project.getDisposed();
        app.invokeLater(() -> app.runWriteAction(() -> this.cleanupOldFiles(project, newDataSources)), ModalityState.NON_MODAL, expired);
        this.incModificationCount();
        return true;
    }

    private void cleanupOldFiles(@Nullable Project project, @NotNull List<LocalDataSource> newDataSources) {
        VirtualFile root2;
        if (newDataSources == null) {
            DataSourceStorage.$$$reportNull$$$0(16);
        }
        String dir = DataSourceStorage.getStorageDir(project);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile virtualFile = root2 = dir == null ? null : lfs.refreshAndFindFileByPath(dir);
        if (root2 == null) {
            return;
        }
        HashSet toKeep = ContainerUtil.newHashSet();
        HashSet uids = ContainerUtil.newHashSet();
        for (LocalDataSource source : newDataSources) {
            uids.add(source.getUniqueId());
            if (source.getModel() == DasUtil.emptyModel()) continue;
            String path = this.getModelPath(project, source, false);
            ContainerUtil.addIfNotNull((Collection)toKeep, path == null ? null : lfs.findFileByPath(path));
        }
        Pattern filePattern = Pattern.compile("\\p{XDigit}{8}(?:-\\p{XDigit}{4}){3}-\\p{XDigit}{12}\\.xml");
        Condition keep = f -> toKeep.contains(f) || uids.stream().anyMatch(uid -> f.getName().startsWith((String)uid));
        for (VirtualFile file : root2.getChildren()) {
            if (!filePattern.matcher(file.getName()).matches() || keep.value((Object)file)) continue;
            try {
                file.delete((Object)this);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    @NotNull
    private static Format readFormat(@NotNull Element element2) {
        String formatAttr;
        if (element2 == null) {
            DataSourceStorage.$$$reportNull$$$0(17);
        }
        if ((formatAttr = element2.getAttributeValue(FORMAT_ATTR_NAME)) != null) {
            Format format;
            try {
                format = Format.valueOf(formatAttr.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                Format format2 = Format.XML;
                if (format2 == null) {
                    DataSourceStorage.$$$reportNull$$$0(19);
                }
                return format2;
            }
            if (format == null) {
                DataSourceStorage.$$$reportNull$$$0(18);
            }
            return format;
        }
        String oldCompressedAttr = element2.getAttributeValue(COMPRESSED_ATTR_NAME);
        Format format = Boolean.parseBoolean(oldCompressedAttr) ? Format.COMPRESSED_XML : Format.XML;
        if (format == null) {
            DataSourceStorage.$$$reportNull$$$0(20);
        }
        return format;
    }

    void writeState(Project project, Element element2) {
        if (project != null && project.isDefault()) {
            return;
        }
        this.writeStateInner(project, element2);
    }

    @Nullable
    public static @SystemIndependent String getStoragePath(@Nullable Project project) {
        String path;
        if (project == null) {
            path = FileUtil.toSystemIndependentName((String)(PathManager.getOptionsPath() + File.separator + APP_STORAGE_FILE));
        } else {
            if (project.isDisposed()) {
                return null;
            }
            if (ProjectKt.isDirectoryBased((Project)project)) {
                String ideaFolder = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
                if (ideaFolder == null) {
                    return null;
                }
                return ideaFolder + '/' + APP_STORAGE_FILE;
            }
            String projectFilePath = project.getProjectFilePath();
            if (projectFilePath == null) {
                return null;
            }
            path = FileUtil.getNameWithoutExtension((String)projectFilePath) + "." + "ids";
        }
        return path;
    }

    @Nullable
    public static String getStorageDir(@Nullable Project project) {
        IProjectStore projectStore;
        String path = DataSourceStorage.getStoragePath(project);
        if (project != null && !project.isDisposed() && path != null && (projectStore = ProjectKt.getStateStore((Project)project)).getStorageScheme() == StorageScheme.DEFAULT) {
            return PathUtil.getParentPath((String)path) + "/.ideaDataSources";
        }
        return path == null ? null : PathUtil.getParentPath((String)path) + "/dataSources";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeModel(@Nullable Project project, @NotNull LocalDataSource dataSource) throws IOException {
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(21);
        }
        if (project != null && (project.isDefault() || project.isDisposed())) {
            return false;
        }
        String path = this.getModelPath(project, dataSource, false);
        if (path == null) {
            return false;
        }
        if (DataSourceStorage.isReadonly(project, path)) {
            LOG.warn("Unable to save model. File is readonly: " + path);
            return false;
        }
        if (project != null && project.isDisposed()) {
            return false;
        }
        File file = new File(path);
        FileUtil.createParentDirs((File)file);
        DasModel model = dataSource.getModel();
        if (model.getModelRoots().isEmpty()) {
            FileUtil.delete((File)file);
            return false;
        }
        Object object = this.lock(dataSource);
        synchronized (object) {
            return DataSourceStorage.writeModel(file, model, dataSource.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeModel(@NotNull File file, @NotNull DasModel model, @NotNull String name) throws IOException {
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(22);
        }
        if (model == null) {
            DataSourceStorage.$$$reportNull$$$0(23);
        }
        if (name == null) {
            DataSourceStorage.$$$reportNull$$$0(24);
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new SafeFileOutputStream(file), StandardCharsets.UTF_8));
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        try (PrettyPrintWriter writer = new PrettyPrintWriter((Writer)printWriter);){
            writer.startNode("dataSource");
            writer.addAttribute("name", name);
            ModelSerializerKt.serialize(model, (HierarchicalStreamWriter)writer);
            writer.endNode();
            boolean bl = true;
            return bl;
        }
    }

    private static boolean isReadonly(@Nullable Project project, @NotNull String path) {
        VirtualFile virtualFile;
        if (path == null) {
            DataSourceStorage.$$$reportNull$$$0(25);
        }
        VirtualFile virtualFile2 = virtualFile = project == null ? null : VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        if (virtualFile == null) {
            return false;
        }
        boolean[] readOnly = new boolean[1];
        UIUtil.invokeAndWaitIfNeeded(() -> NonProjectFileWritingAccessProvider.disableChecksDuring(() -> {
            readOnly[0] = !project.isDisposed() && !ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile});
        }));
        return readOnly[0];
    }

    public boolean readModel(@Nullable Project project, @NotNull LocalDataSource dataSource, boolean oldMistakenFile, @NotNull PairConsumer<LocalDataSource, DasModel> consumer2) throws IOException {
        File file;
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(26);
        }
        if (consumer2 == null) {
            DataSourceStorage.$$$reportNull$$$0(27);
        }
        if (project != null && project.isDefault()) {
            return false;
        }
        String path = this.getModelPath(project, dataSource, oldMistakenFile);
        File file2 = file = path == null ? null : new File(path);
        if (file == null || !file.exists()) {
            return false;
        }
        DasModel model = DataSourceStorage.readModel(DbSrcModelStorage.createFactory(project, dataSource), file, dataSource.getName());
        if (model == null) {
            return false;
        }
        consumer2.consume((Object)dataSource, (Object)model);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DasModel readModel(@NotNull ModelFactory modelFactory, @NotNull File file, @Nullable String dataSourceName) throws IOException {
        if (modelFactory == null) {
            DataSourceStorage.$$$reportNull$$$0(28);
        }
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(29);
        }
        try (XppReader reader = new XppReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), (XmlPullParser)new MXParser());){
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("database-model".equals(reader.getNodeName())) {
                    BasicModModel basicModModel = ModelSerializerKt.deserialize((HierarchicalStreamReader)reader, modelFactory, dataSourceName);
                    return basicModModel;
                }
                reader.moveUp();
            }
        }
        return null;
    }

    @Nullable
    protected String getModelPath(@Nullable Project project, @NotNull LocalDataSource dataSource, boolean oldMistakenPlace) {
        String dir;
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(30);
        }
        if ((dir = DataSourceStorage.getStorageDir(project)) != null && project != null && oldMistakenPlace) {
            dir = PathUtil.getParentPath((String)dir) + "/" + project.getName();
        }
        return dir == null ? null : dir + "/" + dataSource.getUniqueId() + ".xml";
    }

    public Element getStateInner(@Nullable Project project) {
        Element element2 = new Element(COMPONENT_NAME);
        this.writeStateInner(project, element2);
        return element2;
    }

    private void writeStateInner(Project project, Element element2) {
        boolean notEmpty;
        boolean bl = notEmpty = !this.myDataSources.isEmpty();
        if (notEmpty || this.myFormat != Format.XML) {
            element2.setAttribute(FORMAT_ATTR_NAME, this.myFormat.name().toLowerCase(Locale.ENGLISH));
            if (this.myMultiFileModel) {
                element2.setAttribute(MULTIFILE_MODEL, "true");
            }
        }
        if (notEmpty) {
            JDomWriter serializer = new JDomWriter(element2);
            for (LocalDataSource dataSource : this.myDataSources) {
                dataSource.serialize(project, (HierarchicalStreamWriter)serializer, LocalDataSource.SaveMode.CONFIG);
            }
        }
        this.writeLocalState(project);
    }

    private static void readDataSources(@NotNull HierarchicalStreamReader xmlReader, @NotNull LocalDataSource.SaveMode mode, @Nullable Project project, boolean isGlobal, @NotNull Function<String, LocalDataSource> dataSourceLocator, @Nullable Consumer<LocalDataSource> newDataSourcesConsumer) {
        if (xmlReader == null) {
            DataSourceStorage.$$$reportNull$$$0(31);
        }
        if (mode == null) {
            DataSourceStorage.$$$reportNull$$$0(32);
        }
        if (dataSourceLocator == null) {
            DataSourceStorage.$$$reportNull$$$0(33);
        }
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String source = xmlReader.getAttribute("source");
            if ("data-source".equals(xmlReader.getNodeName())) {
                LocalDataSource existingDataSource;
                String uuid = xmlReader.getAttribute("uuid");
                LocalDataSource localDataSource = existingDataSource = uuid == null ? null : (LocalDataSource)dataSourceLocator.fun((Object)uuid);
                if (existingDataSource != null || mode.includeConfig()) {
                    LocalDataSource dataSource;
                    if (existingDataSource != null) {
                        dataSource = existingDataSource;
                    } else if (source == null || "LOCAL".equals(source)) {
                        dataSource = new LocalDataSource();
                    } else {
                        LOG.warn("Unsupported source: " + source);
                        dataSource = null;
                    }
                    if (dataSource != null) {
                        dataSource.deserialize(project, xmlReader, mode);
                        dataSource.setGlobal(isGlobal);
                        if (existingDataSource != dataSource && newDataSourcesConsumer != null) {
                            newDataSourcesConsumer.consume((Object)dataSource);
                        }
                    }
                }
            }
            xmlReader.moveUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToDisk(@Nullable Project project, @NotNull String storagePath, LocalDataSource.SaveMode mode) {
        if (storagePath == null) {
            DataSourceStorage.$$$reportNull$$$0(34);
        }
        File original = new File(PathUtil.toPresentableUrl((String)storagePath));
        if (this.myDataSources.isEmpty()) {
            FileUtil.delete((File)original);
            return true;
        }
        if (!original.exists()) {
            FileUtil.createParentDirs((File)original);
        }
        Object serializer = null;
        String errorMessage = null;
        try {
            Object os;
            SafeFileOutputStream safeStream = new SafeFileOutputStream(original);
            boolean compressed = this.myFormat == Format.COMPRESSED_XML || this.myFormat == Format.COMPRESSED_JSON;
            boolean isXml = this.myFormat == Format.XML || this.myFormat == Format.COMPRESSED_XML;
            Object object = os = compressed ? new ZipOutputStream((OutputStream)safeStream) : safeStream;
            if (os instanceof ZipOutputStream) {
                ((ZipOutputStream)os).putNextEntry(new ZipEntry(STORAGE_ENTRY_NAME + (isXml ? ".xml" : ".json")));
            }
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
            if (isXml) {
                serializer = new PrettyPrintWriter((Writer)printWriter);
                printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            } else {
                serializer = new JsonWriter(printWriter, new JsonWriter.Format(new char[]{' '}, new char[]{'\n'}, 2)){

                    protected void addValue(String value, AbstractJsonWriter.Type type) {
                        super.addValue(value, AbstractJsonWriter.Type.STRING);
                    }
                };
            }
            serializer.startNode("component");
            serializer.addAttribute("name", COMPONENT_NAME);
            for (LocalDataSource dataSource : this.myDataSources) {
                dataSource.serialize(project, (HierarchicalStreamWriter)serializer, mode);
            }
            serializer.endNode();
            serializer.close();
        }
        catch (XStreamException e) {
            errorMessage = e.getMessage();
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        finally {
            if (serializer != null) {
                try {
                    serializer.close();
                }
                catch (Exception e) {
                    errorMessage = e.getMessage();
                }
            }
        }
        if (errorMessage != null) {
            LOG.warn(errorMessage);
            DataSourceUiUtil.showNotification(project, "", "Failed to save data sources:<br>" + errorMessage, true);
            return false;
        }
        return true;
    }

    public void loadTestsStorage(@Nullable Project project, @NotNull String storagePath) {
        if (storagePath == null) {
            DataSourceStorage.$$$reportNull$$$0(35);
        }
        JBIterable.from(this.loadFromDisk(project, storagePath, LocalDataSource.SaveMode.ALL, null)).consumeEach(this::addDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<LocalDataSource> loadFromDisk(@Nullable Project project, String storagePath, LocalDataSource.SaveMode mode, @Nullable ErrorHandler errorHandler) {
        block22: {
            List<LocalDataSource> list;
            File file;
            File file2 = file = storagePath == null ? null : new File(PathUtil.toPresentableUrl((String)storagePath));
            if (file == null || !file.exists() || file.isDirectory()) {
                return null;
            }
            boolean isGlobal = this.myParentStorage == null;
            Function dataSourceLocator = uuid -> DataSourceStorage.getDataSourcesByIdInner(uuid, this.myDataSources);
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                boolean isReallyZip = false;
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    boolean isXml = Comparing.equal((String)zipEntry.getName(), (String)STATE_FILE);
                    if (isXml || Comparing.equal((String)zipEntry.getName(), (String)"dataSources.json")) {
                        List<LocalDataSource> list2 = DataSourceStorage.loadFromDisk(zis, isXml, mode, project, errorHandler, isGlobal, (Function<String, LocalDataSource>)dataSourceLocator);
                        return list2;
                    }
                    isReallyZip = true;
                    zipEntry = zis.getNextEntry();
                }
                if (isReallyZip) {
                    LOG.warn("No datasource entries found in: " + file);
                    break block22;
                }
                list = DataSourceStorage.loadFromDisk(new FileInputStream(file), DataSourceStorage.checkXml(file), mode, project, errorHandler, isGlobal, (Function<String, LocalDataSource>)dataSourceLocator);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (AssertionError | Exception e) {
                DataSourceStorage.processCorruption(file, (Throwable)e);
                break block22;
            }
            finally {
                if (zis != null) {
                    try {
                        zis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return list;
        }
        return null;
    }

    public static void processCorruption(File file, Throwable e) {
        String reason = ExceptionUtil.getThrowableText((Throwable)e);
        String message2 = e.getMessage();
        if (message2 != null && message2.length() > 1024) {
            RuntimeException truncated = new RuntimeException(message2.substring(0, 1024) + "...");
            truncated.setStackTrace(e.getStackTrace());
            e = truncated;
        }
        LOG.warn(e);
        DataSourceStorage.backupCorruptedVersion(file, reason);
    }

    protected static boolean checkXml(File file) throws IOException {
        try (InputStreamReader formatPicker = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            boolean bl = StringUtil.isNotEmpty((String)NanoXmlUtil.parseHeader((Reader)formatPicker).getRootTagLocalName());
            return bl;
        }
    }

    public List<LocalDataSource> loadFromDisk(Project project, InputStream stream, LocalDataSource.SaveMode mode, ErrorHandler handler) {
        return DataSourceStorage.loadFromDisk(stream, true, mode, project, handler, this.myParentStorage == null, (Function<String, LocalDataSource>)((Function)uuid -> DataSourceStorage.getDataSourcesByIdInner(uuid, this.myDataSources)));
    }

    protected static List<LocalDataSource> loadFromDisk(InputStream stream, boolean isXml, LocalDataSource.SaveMode mode, @Nullable Project project, @Nullable ErrorHandler errorHandler, boolean isGlobal, Function<String, LocalDataSource> dataSourceLocator) {
        InputStreamReader fileReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        return DataSourceStorage.loadDataSources((HierarchicalStreamReader)(isXml ? new XppReader((Reader)fileReader) : new JettisonMappedXmlDriver().createReader((Reader)fileReader)), mode, project, errorHandler, isGlobal, dataSourceLocator);
    }

    private static void backupCorruptedVersion(File file, String reason) {
        if (file.exists()) {
            try {
                String backupPrefix = FileUtil.getNameWithoutExtension((File)file) + ".corrupted." + new SimpleDateFormat("yyyyMMdd-hhmmss").format(new Date(System.currentTimeMillis()));
                String backupName = backupPrefix + "." + FileUtilRt.getExtension((String)file.getName());
                String backupReason = backupPrefix + ".reason.txt";
                File backup = new File(file.getParentFile(), backupName);
                FileUtil.copy((File)file, (File)backup);
                FileUtil.writeToFile((File)new File(file.getParentFile(), backupReason), (String)reason);
                String message2 = file.getAbsolutePath() + " is corrupted. Backup copy " + backup.getName() + " is created.";
                Notification notification = new Notification("System Messages", "Failed to load data sources", message2, NotificationType.ERROR);
                Notifications.Bus.notify((Notification)notification);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<LocalDataSource> loadDataSources(HierarchicalStreamReader reader, LocalDataSource.SaveMode mode, Project project, final ErrorHandler errorHandler, boolean isGlobal, Function<String, LocalDataSource> dataSourceLocator) {
        MyReader wrapper = new MyReader(reader){

            public void appendErrors(ErrorWriter errorWriter) {
                super.appendErrors(errorWriter);
                if (errorHandler != null && errorWriter instanceof ConversionException) {
                    errorHandler.addError(((ConversionException)errorWriter).getShortMessage(), null);
                }
            }
        };
        try {
            if ("component".equals(reader.getNodeName())) {
                ArrayList<LocalDataSource> newDataSources = new ArrayList<LocalDataSource>();
                DataSourceStorage.readDataSources((HierarchicalStreamReader)wrapper, mode, project, isGlobal, dataSourceLocator, (Consumer<LocalDataSource>)((Consumer)newDataSources::add));
                ArrayList<LocalDataSource> arrayList = newDataSources;
                return arrayList;
            }
            List<LocalDataSource> list = Collections.emptyList();
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @NotNull
    Listener createSavingListener(final @NotNull ThrowableConsumer<LocalDataSource, IOException> consumer2) {
        if (consumer2 == null) {
            DataSourceStorage.$$$reportNull$$$0(36);
        }
        Listener listener = new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    5.$$$reportNull$$$0(0);
                }
                Map map = DataSourceStorage.this.myLocks;
                synchronized (map) {
                    DataSourceStorage.this.myLocks.remove(dataSource.getUniqueId());
                }
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
                if (dataSource == null) {
                    return;
                }
                if (dataSource.isInBatch() || dataSource.isLoading()) {
                    return;
                }
                if (!DataSourceStorage.this.myDataSources.contains(dataSource)) {
                    return;
                }
                try {
                    consumer2.consume((Object)dataSource);
                }
                catch (IOException e) {
                    LOG.error("Failed to save model for: " + dataSource.getName(), (Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceStorage$5", "dataSourceRemoved"));
            }
        };
        if (listener == null) {
            DataSourceStorage.$$$reportNull$$$0(37);
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Object lock(@NotNull LocalDataSource ds) {
        if (ds == null) {
            DataSourceStorage.$$$reportNull$$$0(38);
        }
        Map<String, Object> map = this.myLocks;
        // MONITORENTER : map
        Object object = this.myLocks.get(ds.getUniqueId());
        // MONITOREXIT : map
        if (object != null) return object;
        DataSourceStorage.$$$reportNull$$$0(39);
        return object;
    }

    public void prune() {
        this.removeAllDataSources();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 37: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceStorage";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = STORAGE_ENTRY_NAME;
                break;
            }
            case 4: 
            case 5: 
            case 21: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 15: 
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDataSources";
                break;
            }
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceLocator";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnDataSources";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourcesImpl";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "readFormat";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createSavingListener";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "lock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doWhenInitialized";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 37: 
            case 39: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDataSourcesInner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDataSourceInner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSourceInner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesByIdInner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readLocalState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validateModels";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadModels";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cleanupOldFiles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readFormat";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "writeModel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isReadonly";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readModel";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getModelPath";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "readDataSources";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "writeToDisk";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadTestsStorage";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSavingListener";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lock";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readLocalState$3";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWhenInitialized$2";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReader
    extends ReaderWrapper {
        MyReader(HierarchicalStreamReader reader) {
            super(reader);
        }

        public String getNodeName() {
            return DbUtil.intern2((String)super.getNodeName());
        }

        public String getValue() {
            return DbUtil.intern2((String)super.getValue());
        }

        public String getAttribute(String name) {
            return DbUtil.intern2((String)super.getAttribute(name));
        }

        public String getAttribute(int index2) {
            return DbUtil.intern2((String)super.getAttribute(index2));
        }
    }

    @State(name="DataSourceManagerImpl", storages={@Storage(value="dataSources.xml")})
    public static class Prj
    extends DataSourceStorage
    implements PersistentStateComponent<Element> {
        private final Project myProject;

        public Prj(App app, Project project) {
            super(app, project.getMessageBus());
            this.myProject = project;
            project.getMessageBus().connect((Disposable)project).subscribe(TOPIC, (Object)this.createSavingListener((ThrowableConsumer<LocalDataSource, IOException>)((ThrowableConsumer)o -> this.writeModel(this.myProject, (LocalDataSource)o))));
        }

        @Override
        public void doWhenInitialized(@NotNull Runnable runnable) {
            if (runnable == null) {
                Prj.$$$reportNull$$$0(0);
            }
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
                if (runnable == null) {
                    Prj.$$$reportNull$$$0(2);
                }
                super.doWhenInitialized(runnable);
            });
        }

        @Override
        public void updateDataSource(LocalDataSource dataSource) {
            super.updateDataSource(dataSource);
            TransactionGuard.submitTransaction((Disposable)this.myProject, () -> PsiDocumentManager.getInstance((Project)this.myProject).reparseFiles(Collections.emptyList(), true));
        }

        @Override
        public void loadState(@NotNull Element state) {
            if (state == null) {
                Prj.$$$reportNull$$$0(1);
            }
            this.readState(this.myProject, state);
        }

        @Override
        public Element getState() {
            Element element2 = new Element("DataSourceManagerImpl");
            this.writeState(this.myProject, element2);
            return element2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorage$Prj";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doWhenInitialized";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$doWhenInitialized$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @State(name="dataSourceStorage", storages={@Storage(value="dataSources.xml")})
    public static class App
    extends DataSourceStorage
    implements PersistentStateComponent<Element> {
        public App(VirtualFileManager fileManager, LibraryTablesRegistrar libraryTablesRegistrar) {
            super(null, ApplicationManager.getApplication().getMessageBus());
            Application app = ApplicationManager.getApplication();
            app.getMessageBus().connect((Disposable)app).subscribe(TOPIC, (Object)this.createSavingListener((ThrowableConsumer<LocalDataSource, IOException>)((ThrowableConsumer)o -> this.writeModel(null, (LocalDataSource)o))));
        }
    }

    private static enum Format {
        XML,
        JSON,
        COMPRESSED_XML,
        COMPRESSED_JSON;

    }

    public static interface Listener
    extends EventListener {
        default public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        default public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataSource";
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorage$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

