/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.BatchesContainer;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00070\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\b\u001a.\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u0015*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b\u001a4\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00060\n\"\u0004\b\u0000\u0010\u0006*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00060 \u001a3\u0010!\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00060 \u00a2\u0006\u0002\u0010\"\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006#"}, d2={"logPath", "Ljava/nio/file/Path;", "getLogPath", "()Ljava/nio/file/Path;", "consumer", "Lkotlin/Function1;", "T", "", "Lcom/intellij/util/Consumer;", "executeBatch", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "statement", "Ljava/sql/Statement;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "batches", "Lcom/intellij/database/dataSource/connection/statements/BatchesContainer;", "trimSql", "", "sql", "maxChars", "", "message", "t", "", "runReporting", "stage", "Lcom/intellij/database/dataSource/connection/statements/StagedException$Stage;", "runnable", "Lkotlin/Function0;", "runReportingAndGet", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/statements/StagedException$Stage;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.database.impl"})
@JvmName(name="SmartStatementsUtil")
public final class SmartStatementsUtil {
    @NotNull
    public static final Either<ClosableResultsProducer> executeBatch(@NotNull Statement statement, @NotNull DatabaseConnection connection2, @NotNull SmartStatementMark mark2, @NotNull BatchesContainer batches) {
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Intrinsics.checkParameterIsNotNull((Object)batches, (String)"batches");
        return SmartStatementsUtil.runReporting(connection2, StagedException.Stage.EXECUTE, mark2, (Function0)new Function0<executeBatch.1>(connection2, batches, mark2, statement){
            final /* synthetic */ DatabaseConnection $connection;
            final /* synthetic */ BatchesContainer $batches;
            final /* synthetic */ SmartStatementMark $mark;
            final /* synthetic */ Statement $statement;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final executeBatch.1 invoke() {
                ClosableResultsProducer closableResultsProducer;
                AdvancedAuditService auditService = this.$connection.getAuditService();
                try {
                    int[] nArray;
                    try {
                        auditService.beforeSimpleStatement(this.$batches.getSql(), this.$mark);
                        nArray = this.$statement.executeBatch();
                    }
                    finally {
                        auditService.afterStatement(this.$mark);
                    }
                    int[] updates = nArray;
                    Intrinsics.checkExpressionValueIsNotNull((Object)updates, (String)"updates");
                    int sum2 = SequencesKt.sumOfInt((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((int[])updates), (Function1)executeBatch.sum.1.INSTANCE));
                    if (sum2 > 0) {
                        auditService.updateCount(sum2, this.$mark);
                    }
                    closableResultsProducer = new ClosableResultsProducer(updates){
                        private int currentIdx;
                        final /* synthetic */ int[] $updates;

                        public void processRemaining(@NotNull ResultsProducer.Processor<Unit> processor) {
                            Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
                            while (this.advance()) {
                                this.processCurrent(processor);
                            }
                        }

                        public boolean advance() {
                            executeBatch.1 v0 = this;
                            ++v0.currentIdx;
                            return v0.currentIdx < this.$updates.length;
                        }

                        public <T> T processCurrent(@NotNull ResultsProducer.Processor<T> processor) {
                            Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
                            return processor.updateCount(this.$updates[this.currentIdx], this.currentIdx);
                        }

                        @Nullable
                        public Object getParameterValue(int index2) {
                            return null;
                        }

                        public void close() {
                        }
                        {
                            this.$updates = $captured_local_variable$0;
                            this.currentIdx = -1;
                        }

                        public boolean advanceSafe() {
                            return ClosableResultsProducer.DefaultImpls.advanceSafe(this);
                        }
                    };
                }
                catch (Throwable throwable) {
                    try {
                        auditService.resultsProcessed(this.$mark);
                        this.$batches.clear();
                    }
                    catch (Throwable throwable2) {
                        this.$batches.clear();
                        SmartStatementsUtil.runReporting(this.$connection, StagedException.Stage.BATCH_CLEARING, this.$mark, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ executeBatch.1 this$0;

                            public final void invoke() {
                                this.this$0.$statement.clearBatch();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        throw throwable2;
                    }
                    SmartStatementsUtil.runReporting(this.$connection, StagedException.Stage.BATCH_CLEARING, this.$mark, (Function0)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                try {
                    auditService.resultsProcessed(this.$mark);
                    this.$batches.clear();
                }
                catch (Throwable throwable) {
                    this.$batches.clear();
                    SmartStatementsUtil.runReporting(this.$connection, StagedException.Stage.BATCH_CLEARING, this.$mark, (Function0)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                SmartStatementsUtil.runReporting(this.$connection, StagedException.Stage.BATCH_CLEARING, this.$mark, (Function0)new /* invalid duplicate definition of identical inner class */);
                return closableResultsProducer;
            }
            {
                this.$connection = databaseConnection;
                this.$batches = batchesContainer;
                this.$mark = smartStatementMark;
                this.$statement = statement;
                super(0);
            }
        });
    }

    @Nullable
    public static final String message(@NotNull DatabaseConnection $receiver, @NotNull Throwable t) {
        LocalDataSource dataSource;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        DatabaseConnectionPoint databaseConnectionPoint = $receiver.getConnectionPoint();
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseConnectionPoint, (String)"connectionPoint");
        LocalDataSource localDataSource = dataSource = databaseConnectionPoint.getDataSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"dataSource");
        return JdbcEngine.getErrorMessage(t, localDataSource.getName(), dataSource.getDbms());
    }

    @NotNull
    public static final <T> Either<T> runReporting(@NotNull DatabaseConnection $receiver, @NotNull StagedException.Stage stage, @NotNull SmartStatementMark mark2, @NotNull Function0<? extends T> runnable) {
        Either either;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)stage), (String)"stage");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Intrinsics.checkParameterIsNotNull(runnable, (String)"runnable");
        try {
            either = new Either.Right<Object>(runnable.invoke());
        }
        catch (SQLException e) {
            AdvancedAuditService advancedAuditService = $receiver.getAuditService();
            String string = SmartStatementsUtil.message($receiver, e);
            if (string == null) {
                StringBuilder stringBuilder = new StringBuilder().append('(').append(stage.getErrorText()).append(": ");
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                string = stringBuilder.append((Object)string2).toString();
            }
            advancedAuditService.error(string, mark2);
            either = new Either.Left(new StagedException(e, stage));
        }
        return either;
    }

    public static final <T> T runReportingAndGet(@NotNull DatabaseConnection $receiver, @NotNull StagedException.Stage stage, @NotNull SmartStatementMark mark2, @NotNull Function0<? extends T> runnable) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)stage), (String)"stage");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Intrinsics.checkParameterIsNotNull(runnable, (String)"runnable");
        Either<T> result2 = SmartStatementsUtil.runReporting($receiver, stage, mark2, runnable);
        if (result2.isLeft()) {
            StagedException stagedException = result2.getLeft();
            if (stagedException == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)stagedException;
        }
        T t = result2.getRight();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    @NotNull
    public static final String trimSql(@NotNull String sql, int maxChars) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        if (sql.length() <= maxChars) {
            return sql;
        }
        String string = sql;
        int n = 0;
        String string2 = string.substring(n, maxChars);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String substring = string2;
        int difference = sql.length() - maxChars;
        String moreString = "-- and " + difference + ' ' + StringUtil.pluralize((String)"character", (int)difference) + " more...";
        return moreString.length() >= difference ? sql : substring + ' ' + moreString;
    }

    @NotNull
    public static final <T> Function1<T, Unit> consumer(@NotNull Consumer<T> consumer2) {
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        return new Function1<T, Unit>(consumer2){
            final /* synthetic */ Consumer $consumer;

            public final void invoke(T it) {
                this.$consumer.consume(it);
            }
            {
                this.$consumer = consumer2;
                super(1);
            }
        };
    }

    @NotNull
    public static final Path getLogPath() {
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("database-log").resolve("database.log");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(PathManager.ge\u2026).resolve(\"database.log\")");
        return path;
    }
}

