/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.Dbms;
import com.intellij.database.script.generator.NamingService;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.sql.dialects.DbmsBean;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "Lcom/intellij/database/script/generator/NamingService;", "dbms", "Lcom/intellij/database/Dbms;", "namePattern", "Ljava/util/regex/Pattern;", "(Lcom/intellij/database/Dbms;Ljava/util/regex/Pattern;)V", "aptNamePattern", "aptPlainNamePattern", "(Lcom/intellij/database/Dbms;Ljava/util/regex/Pattern;Ljava/util/regex/Pattern;)V", "getAptNamePattern", "()Ljava/util/regex/Pattern;", "getAptPlainNamePattern", "getDbms", "()Lcom/intellij/database/Dbms;", "reservedWords", "", "", "getReservedWords", "()Ljava/util/Set;", "aptPattern", "plain", "", "enquoteName", "name", "isPlain", "nameToScript", "Companion", "intellij.database.dialects"})
public abstract class AbstractNamingService
implements NamingService {
    @NotNull
    private final Set<String> reservedWords;
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final Pattern aptNamePattern;
    @NotNull
    private final Pattern aptPlainNamePattern;
    @NotNull
    private static final Pattern aptMixedCaseNamePattern;
    @NotNull
    private static final Pattern aptLowerCaseNamePattern;
    @NotNull
    private static final Pattern aptUpperCaseNamePattern;
    public static final Companion Companion;

    @NotNull
    public final Set<String> getReservedWords() {
        return this.reservedWords;
    }

    @Override
    @NotNull
    public String nameToScript(@NotNull String name, boolean plain) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.isPlain(name, plain) ? name : this.enquoteName(name);
    }

    @NotNull
    public String enquoteName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        char c2 = '\"';
        String string = StringsKt.replace$default((String)name, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c2) + string;
        return stringBuilder.append(string2).append('\"').toString();
    }

    protected boolean isPlain(@NotNull String name, boolean plain) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        CharSequence charSequence = name;
        Pattern pattern = this.aptPattern(plain);
        pattern = new Regex(pattern);
        return pattern.matches(charSequence) && !this.reservedWords.contains(name);
    }

    private final Pattern aptPattern(boolean plain) {
        return plain ? this.aptPlainNamePattern : this.aptNamePattern;
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    public final Pattern getAptNamePattern() {
        return this.aptNamePattern;
    }

    @NotNull
    public final Pattern getAptPlainNamePattern() {
        return this.aptPlainNamePattern;
    }

    public AbstractNamingService(@NotNull Dbms dbms, @NotNull Pattern aptNamePattern, @NotNull Pattern aptPlainNamePattern) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)aptNamePattern, (String)"aptNamePattern");
        Intrinsics.checkParameterIsNotNull((Object)aptPlainNamePattern, (String)"aptPlainNamePattern");
        this.dbms = dbms;
        this.aptNamePattern = aptNamePattern;
        this.aptPlainNamePattern = aptPlainNamePattern;
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.UNKNOWN)) {
            set = SetsKt.emptySet();
        } else {
            DbmsBean dbmsBean = DbmsBean.findByDbms((Dbms)this.dbms);
            if (dbmsBean == null) {
                Intrinsics.throwNpe();
            }
            NotNullLazyValue notNullLazyValue = dbmsBean.sqlDialect;
            Intrinsics.checkExpressionValueIsNotNull((Object)notNullLazyValue, (String)"DbmsBean.findByDbms(dbms)!!.sqlDialect");
            Object object = notNullLazyValue.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"DbmsBean.findByDbms(dbms)!!.sqlDialect.value");
            Set set2 = ((SqlLanguageDialect)object).getReservedKeywords();
            set = set2;
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"DbmsBean.findByDbms(dbms\u2026ct.value.reservedKeywords");
        }
        this.reservedWords = set;
    }

    public AbstractNamingService(@NotNull Dbms dbms, @NotNull Pattern namePattern) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)namePattern, (String)"namePattern");
        this(dbms, namePattern, namePattern);
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("\\p{IsAlphabetic}[\\p{IsAlphabetic}\\d_]*");
        if (pattern == null) {
            Intrinsics.throwNpe();
        }
        aptMixedCaseNamePattern = pattern;
        Pattern pattern2 = Pattern.compile("\\p{IsLower}[\\p{IsLower}\\d_]*");
        if (pattern2 == null) {
            Intrinsics.throwNpe();
        }
        aptLowerCaseNamePattern = pattern2;
        Pattern pattern3 = Pattern.compile("\\p{IsUpper}[\\p{IsUpper}\\d_]*");
        if (pattern3 == null) {
            Intrinsics.throwNpe();
        }
        aptUpperCaseNamePattern = pattern3;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractNamingService$Companion;", "", "()V", "aptLowerCaseNamePattern", "Ljava/util/regex/Pattern;", "getAptLowerCaseNamePattern", "()Ljava/util/regex/Pattern;", "aptMixedCaseNamePattern", "getAptMixedCaseNamePattern", "aptUpperCaseNamePattern", "getAptUpperCaseNamePattern", "intellij.database.dialects"})
    public static final class Companion {
        @NotNull
        public final Pattern getAptMixedCaseNamePattern() {
            return aptMixedCaseNamePattern;
        }

        @NotNull
        public final Pattern getAptLowerCaseNamePattern() {
            return aptLowerCaseNamePattern;
        }

        @NotNull
        public final Pattern getAptUpperCaseNamePattern() {
            return aptUpperCaseNamePattern;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

