/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingInternalTask;
import com.intellij.database.script.generator.ScriptingNativeDefinitionTask;
import com.intellij.database.script.generator.ScriptingOrder;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0014J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H$J\b\u0010\u0017\u001a\u00020\u0013H\u0014J\b\u0010\u0018\u001a\u00020\u0013H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0004J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0004J)\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f\"\u00020 H\u0014\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\u00020\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractTransitionCodeGenerator;", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "deck", "Ljava/util/Deque;", "Lcom/intellij/database/model/basic/BasicElement;", "getDeck", "()Ljava/util/Deque;", "generated", "", "getGenerated", "()Ljava/util/Set;", "postponed", "Lcom/intellij/util/containers/MultiMap;", "getPostponed", "()Lcom/intellij/util/containers/MultiMap;", "finishElement", "", "element", "generate", "generateElement", "generateFooting", "generateHeading", "isNewCodeGen", "", "process", "processElement", "processInnerElements", "kinds", "", "Lcom/intellij/database/model/ObjectKind;", "(Lcom/intellij/database/model/basic/BasicElement;[Lcom/intellij/database/model/ObjectKind;)V", "setElementsToGenerate", "elements", "", "intellij.database.dialects"})
public abstract class AbstractTransitionCodeGenerator
extends AbstractCodeGenerator {
    @NotNull
    private final Deque<BasicElement> deck;
    @NotNull
    private final MultiMap<BasicElement, BasicElement> postponed;
    @NotNull
    private final Set<BasicElement> generated;

    @NotNull
    protected final Deque<BasicElement> getDeck() {
        return this.deck;
    }

    @NotNull
    protected final MultiMap<BasicElement, BasicElement> getPostponed() {
        return this.postponed;
    }

    @NotNull
    protected final Set<BasicElement> getGenerated() {
        return this.generated;
    }

    @Override
    protected boolean isNewCodeGen() {
        return false;
    }

    private final void setElementsToGenerate(Iterable<? extends BasicElement> elements) {
        TreeMap sorted = new TreeMap();
        for (BasicElement basicElement : elements) {
            Map map = sorted;
            String string = this.getContext().getHelper().getObjectPreliminaryOrder(basicElement);
            BasicElement basicElement2 = basicElement;
            map.put(string, basicElement2);
        }
        for (BasicElement basicElement : sorted.values()) {
            this.deck.offer(basicElement);
        }
    }

    public void generate() {
        this.generateHeading();
        while ((this.getContext().getTask().getCategory().getOrder() == ScriptingOrder.REVERS_ORDER ? this.deck.pollLast() : this.deck.poll()) != null) {
            BasicElement element2;
            element2 = element2;
            if (element2.isAutoCreated()) continue;
            this.process(element2);
        }
        this.generateFooting();
    }

    protected void generateHeading() {
    }

    protected void generateFooting() {
    }

    protected final void process(@NotNull BasicElement element2) {
        boolean postpone;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!this.generated.contains(element2)) {
            if (this.getContext().getTask().getCategory().getOrder() == ScriptingOrder.NORMAL_ORDER && !this.isNewCodeGen()) {
                Iterable<? extends BasicElement> predecessors = element2.getPredecessors();
                postpone = false;
                for (BasicElement string : predecessors) {
                    if (this.generated.contains(string) || !this.deck.contains(string)) continue;
                    this.postponed.putValue((Object)string, (Object)element2);
                    postpone = true;
                }
                if (postpone) {
                    return;
                }
            }
            this.processElement(element2);
            if (!this.generated.contains(element2)) {
                return;
            }
        }
        if (this.getContext().getLocus() == ScriptLocus.IN_SCHEMA || this.getContext().getLocus() == ScriptLocus.OUTSIDE) {
            Collection collection = this.postponed.get((Object)element2);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"postponed[element]");
            Iterable pendingElements = collection;
            boolean bl = postpone = !this.isNewCodeGen() || this.postponed.isEmpty();
            if (_Assertions.ENABLED && !postpone) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            for (BasicElement pendingElement : pendingElements) {
                this.process(pendingElement);
            }
        }
    }

    protected final void processElement(@NotNull BasicElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        this.generateElement(element2);
        this.finishElement(element2);
    }

    protected abstract void generateElement(@NotNull BasicElement var1);

    protected void finishElement(@NotNull BasicElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        this.generated.add(element2);
    }

    protected void processInnerElements(@NotNull BasicElement element2, ObjectKind ... kinds) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)kinds, (String)"kinds");
        ArrayList innerElements = new ArrayList();
        for (ObjectKind kind : kinds) {
            Family<? extends BasicElement> f = element2.familyOf(kind);
            if (f == null) continue;
            CollectionsKt.addAll((Collection)innerElements, (Iterable)f);
        }
        int n = innerElements.size();
        if (n == 0) {
            return;
        }
        if (n >= 2 && this.getContext().getTask().getCategory().getOrder() == ScriptingOrder.REVERS_ORDER) {
            Collections.reverse(innerElements);
        }
        Iterator iterator = innerElements.iterator();
        while (iterator.hasNext()) {
            BasicElement innerElement;
            BasicElement basicElement = innerElement = (BasicElement)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"innerElement");
            this.process(basicElement);
        }
    }

    public AbstractTransitionCodeGenerator(@NotNull ScriptingContext context) {
        Collection collection;
        ScriptingTask it;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.deck = new ArrayDeque();
        this.postponed = new MultiMap();
        this.generated = new HashSet();
        ScriptingTask scriptingTask = context.getTask();
        AbstractTransitionCodeGenerator abstractTransitionCodeGenerator = this;
        ScriptingTask scriptingTask2 = it = scriptingTask;
        if (scriptingTask2 instanceof ScriptingSingleModelTask) {
            collection = ((ScriptingSingleModelTask)it).getElements();
        } else if (scriptingTask2 instanceof ScriptingNativeDefinitionTask) {
            collection = ((ScriptingNativeDefinitionTask)it).getElements();
        } else if (scriptingTask2 instanceof ScriptingAlterTask) {
            collection = CollectionsKt.emptyList();
        } else if (scriptingTask2 instanceof ScriptingInternalTask) {
            collection = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Collection collection2 = collection;
        abstractTransitionCodeGenerator.setElementsToGenerate(collection2);
    }
}

