/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.EffectType;
import com.intellij.database.dialects.base.generator.Node;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.OperationType;
import com.intellij.database.dialects.base.generator.Producer;
import com.intellij.database.dialects.base.generator.ScenarioOperations;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.TruncateProducer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.families.Family;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\bH\u0016J$\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/base/generator/BaseTruncateGenerator;", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "prepared", "", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/dialects/base/generator/Operation;", "getPrepared", "()Ljava/util/Map;", "breakByJoinedTruncate", "", "cycle", "", "breakCycle", "elements", "", "fillDependencies", "", "fillTruncateDependants", "e", "makeOperation", "element", "makeTruncateOperation", "root", "prepareElement", "forceRoot", "prepareScenario", "Companion", "intellij.database.dialects"})
public class BaseTruncateGenerator
extends AbstractCodeGenerator {
    @NotNull
    private final Map<BasicElement, Operation> prepared;
    @NotNull
    private static final OperationType TRUNCATE;
    public static final Companion Companion;

    @NotNull
    public final Map<BasicElement, Operation> getPrepared() {
        return this.prepared;
    }

    @Override
    @Nullable
    public Operation makeOperation(@NotNull BasicElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.makeTruncateOperation(element2, this.getScenario().getRoot());
    }

    @Override
    public void prepareScenario() {
        Iterable $receiver$iv = this.elements();
        for (Object element$iv : $receiver$iv) {
            BasicElement it = (BasicElement)element$iv;
            this.makeTruncateOperation(it, this.getScenario().getRoot());
        }
        this.fillDependencies();
    }

    @Override
    protected boolean breakCycle(@NotNull List<Operation> cycle) {
        Intrinsics.checkParameterIsNotNull(cycle, (String)"cycle");
        if (this.breakByJoinedTruncate(cycle)) {
            return true;
        }
        return super.breakCycle(cycle);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean breakByJoinedTruncate(List<Operation> cycle) {
        for (Operation op : cycle) {
            if (op.getProducer() instanceof TruncateProducer) continue;
            return false;
        }
        Operation root2 = (Operation)CollectionsKt.first(cycle);
        Producer producer = root2.getProducer();
        if (producer == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.base.generator.producers.TruncateProducer<*>");
        }
        if (!((TruncateProducer)producer).canGroup()) {
            return false;
        }
        for (Operation op : cycle) {
            void $receiver$iv$iv;
            if (Intrinsics.areEqual((Object)op, (Object)root2)) continue;
            op.setParent((Node)root2);
            Iterable $receiver$iv = op.getNestedOperations();
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Operation it = (Operation)element$iv$iv;
                if (!(it.getProducer() instanceof TruncateProducer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Operation it = (Operation)element$iv;
                it.setParent((Node)root2);
            }
        }
        return true;
    }

    public final void fillDependencies() {
        Iterable $receiver$iv = this.prepared.keySet();
        for (Object element$iv : $receiver$iv) {
            BasicElement it = (BasicElement)element$iv;
            this.fillTruncateDependants(it);
        }
    }

    public final void fillTruncateDependants(@NotNull BasicElement e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Family<? extends BasicElement> family = e.familyOf(ObjectKind.FOREIGN_KEY);
        if (family != null) {
            Iterable $receiver$iv = family;
            for (Object element$iv : $receiver$iv) {
                BasicElement basicElement;
                BasicElement it = (BasicElement)element$iv;
                BasicElement basicElement2 = it;
                if (!(basicElement2 instanceof BasicForeignKey)) {
                    basicElement2 = null;
                }
                if ((basicElement = (BasicForeignKey)basicElement2) == null || (basicElement = basicElement.getRefTable()) == null) {
                    continue;
                }
                BasicElement tab = basicElement;
                Operation operation2 = this.prepared.get(tab);
                if (operation2 != null) {
                    ScenarioOperations.requires(operation2, ScenarioOperations.matches$default(EffectType.NoData, e, null, 2, null));
                }
            }
        }
    }

    private final Collection<BasicElement> elements() {
        Object object;
        ScriptingTask scriptingTask = this.getContext().getTask();
        if (!(scriptingTask instanceof ScriptingSingleModelTask)) {
            scriptingTask = null;
        }
        if ((object = (ScriptingSingleModelTask)scriptingTask) == null || (object = ((ScriptingSingleModelTask)object).getElements()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public Operation prepareElement(@NotNull BasicElement element2, @NotNull Operation root2, boolean forceRoot) {
        Operation operation2;
        block5: {
            block4: {
                Operation operation3;
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                operation2 = this.prepared.get(element2);
                if (operation2 == null) break block4;
                Operation $receiver = operation3 = operation2;
                if (forceRoot) {
                    $receiver.setParent((Node)root2);
                }
                if ((operation2 = operation3) != null) break block5;
            }
            operation2 = this.makeTruncateOperation(element2, root2);
        }
        return operation2;
    }

    @Nullable
    public static /* synthetic */ Operation prepareElement$default(BaseTruncateGenerator baseTruncateGenerator, BasicElement basicElement, Operation operation2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return baseTruncateGenerator.prepareElement(basicElement, operation2, bl);
    }

    @NotNull
    public Operation makeTruncateOperation(@NotNull BasicElement element2, @NotNull Operation root2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        return this.getContext().getHelper().createTruncateProducer(this.getContext(), element2).register(this, root2);
    }

    public BaseTruncateGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.prepared = new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        TRUNCATE = new OperationType("truncate");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/base/generator/BaseTruncateGenerator$Companion;", "", "()V", "TRUNCATE", "Lcom/intellij/database/dialects/base/generator/OperationType;", "getTRUNCATE", "()Lcom/intellij/database/dialects/base/generator/OperationType;", "intellij.database.dialects"})
    public static final class Companion {
        @NotNull
        public final OperationType getTRUNCATE() {
            return TRUNCATE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

