/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.cassandra.model.CassMetaModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassandraDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final CassandraDialect INSTANCE = new CassandraDialect();

    public CassandraDialect() {
        super(new TypeHelper.CassandraTypeHelper(), Casing.create((Case)Case.LOWER, (Case)Case.EXACT));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = CassMetaModel.MODEL;
        if (basicMetaModel == null) {
            CassandraDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public String getDisplayName() {
        if ("Cassandra" == null) {
            CassandraDialect.$$$reportNull$$$0(1);
        }
        return "Cassandra";
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CASSANDRA;
        if (dbms == null) {
            CassandraDialect.$$$reportNull$$$0(2);
        }
        return dbms;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Cassandra;
        if (icon == null) {
            CassandraDialect.$$$reportNull$$$0(3);
        }
        return icon;
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            CassandraDialect.$$$reportNull$$$0(4);
        }
        return databaseProductName != null && databaseProductName.toLowerCase(Locale.ENGLISH).contains("cassandra");
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        String s;
        if (system == null) {
            CassandraDialect.$$$reportNull$$$0(5);
        }
        if (connection2 == null) {
            CassandraDialect.$$$reportNull$$$0(6);
        }
        return StringUtil.isEmpty((String)(s = connection2.getJdbcConnection().getSchema())) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    public boolean supportsAlterColumnNull() {
        return false;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            CassandraDialect.$$$reportNull$$$0(7);
        }
        if (view == null) {
            CassandraDialect.$$$reportNull$$$0(8);
        }
        if (definition == null) {
            CassandraDialect.$$$reportNull$$$0(9);
        }
        if (checkOption == null) {
            CassandraDialect.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            CassandraDialect.$$$reportNull$$$0(11);
        }
        if (view == null) {
            CassandraDialect.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            CassandraDialect.$$$reportNull$$$0(13);
        }
        if (sequence == null) {
            CassandraDialect.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsViewDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            CassandraDialect.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException();
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            CassandraDialect.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.procedure.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            CassandraDialect.$$$reportNull$$$0(17);
        }
        if (identifier == null) {
            CassandraDialect.$$$reportNull$$$0(18);
        }
        if (qualifier == null) {
            CassandraDialect.$$$reportNull$$$0(19);
        }
        DasObject db = CassandraDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            CassandraDialect.$$$reportNull$$$0(20);
        }
        return ddlBuilder;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            CassandraDialect.$$$reportNull$$$0(21);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsNotNullColumns() {
        return false;
    }

    @Override
    public boolean supportsDefaults() {
        return false;
    }

    @Override
    public boolean supportsUniqueIndices() {
        return false;
    }

    @Override
    public boolean supportsIndexColumnOrdering() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) {
        if (builder == null) {
            CassandraDialect.$$$reportNull$$$0(22);
        }
        if (statement == null) {
            CassandraDialect.$$$reportNull$$$0(23);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            CassandraDialect.$$$reportNull$$$0(24);
        }
        return kind == ObjectKind.SCHEMA ? "KEYSPACE" : super.getNameForKind(kind);
    }

    @Override
    protected void appendFromTable(DdlBuilder builder, DasTable dasTable) {
        builder.space().keyword("FROM").space().qualifiedRef((DasObject)dasTable);
    }

    @Override
    protected void appendColumns(DdlBuilder builder, List<DasColumn> columns) {
        if (columns.isEmpty()) {
            builder.symbol("*");
        } else {
            DialectUtils.appendColumnList(null, builder, columns);
        }
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            CassandraDialect.$$$reportNull$$$0(25);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("use %s", this.quoteIdentifier(current.getDisplayName(), false, false));
    }

    @Override
    @NotNull
    public DdlBuilder sqlSelectColumns(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, @Nullable DasDataSource system, @Nullable BiConsumer<String, DdlBuilder> appendWhereClause, @Nullable Consumer<DdlBuilder> orderByAppender, @NotNull List<DasColumn> columns, boolean appendRowId, int rows) {
        if (builder == null) {
            CassandraDialect.$$$reportNull$$$0(26);
        }
        if (dasTable == null) {
            CassandraDialect.$$$reportNull$$$0(27);
        }
        if (columns == null) {
            CassandraDialect.$$$reportNull$$$0(28);
        }
        super.sqlSelectColumns(builder, dasTable, system, appendWhereClause, orderByAppender, columns, appendRowId, rows);
        if (appendWhereClause != null) {
            builder.newLine().keywords("ALLOW", "FILTERING");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            CassandraDialect.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection2) throws Exception {
        DatabaseMetaData metaData;
        if (connection2 == null) {
            CassandraDialect.$$$reportNull$$$0(30);
        }
        if ((metaData = connection2.getMetaData()) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                CassandraDialect.$$$reportNull$$$0(31);
            }
            return list;
        }
        Version version = Version.of((String)metaData.getDatabaseProductVersion());
        String query = version.isOrGreater(new int[]{3}) ? "select keyspace_name from system_schema.keyspaces" : "select keyspace_name from system.schema_keyspaces";
        List<String> list = DbImplUtil.executeAndGetResult(connection2, query, DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            CassandraDialect.$$$reportNull$$$0(32);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/cassandra/CassandraDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 6: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasTable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/cassandra/CassandraDialect";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSelectColumns";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlSelectColumns";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

