/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.cassandra.model.CassModAggregate;
import com.intellij.database.dialects.cassandra.model.CassModFunction;
import com.intellij.database.dialects.cassandra.model.CassModIndex;
import com.intellij.database.dialects.cassandra.model.CassModKey;
import com.intellij.database.dialects.cassandra.model.CassModLikeTable;
import com.intellij.database.dialects.cassandra.model.CassModMatView;
import com.intellij.database.dialects.cassandra.model.CassModRole;
import com.intellij.database.dialects.cassandra.model.CassModSchema;
import com.intellij.database.dialects.cassandra.model.CassModTable;
import com.intellij.database.dialects.cassandra.model.CassModTableColumn;
import com.intellij.database.dialects.cassandra.model.CassModTrigger;
import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaDefaults;
import com.intellij.database.dialects.cassandra.model.defaults.CassTableDefaults;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.properties.CassIndexColumn;
import com.intellij.database.model.properties.CassKeyColumn;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.cassandra.CassTypes;
import com.intellij.sql.dialects.cassandra.psi.CassSqlPrimaryKeyDefinition;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateMatViewStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlWhereClauseImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u0019\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010#J\u0019\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010&J\u0014\u0010'\u001a\u0004\u0018\u00010(2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001fH\u0002J+\u0010)\u001a\u0004\u0018\u00010\u001f2\u0006\u0010*\u001a\u00020\u001f2\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,\"\u00020-H\u0002\u00a2\u0006\u0002\u0010.J\u0012\u0010/\u001a\u0004\u0018\u00010(2\u0006\u0010*\u001a\u00020\u001fH\u0002J\u0014\u00100\u001a\u0004\u0018\u00010(2\b\u00101\u001a\u0004\u0018\u00010\u001fH\u0002J\u001e\u00102\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u000204\u0018\u0001032\u0006\u0010\u0007\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002042\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020(2\u0006\u00107\u001a\u000208H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\b2\u0006\u00107\u001a\u000208H\u0002\u00a8\u0006;"}, d2={"Lcom/intellij/database/dialects/cassandra/CassandraObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildAggregate", "Lcom/intellij/database/dialects/cassandra/model/CassModAggregate;", "buildFunction", "Lcom/intellij/database/dialects/cassandra/model/CassModFunction;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "buildKey", "Lcom/intellij/database/dialects/cassandra/model/CassModKey;", "buildLikeTable", "Lcom/intellij/database/dialects/cassandra/model/CassModLikeTable;", "buildMatView", "Lcom/intellij/database/dialects/cassandra/model/CassModMatView;", "buildRole", "Lcom/intellij/database/dialects/cassandra/model/CassModRole;", "buildSchema", "Lcom/intellij/database/dialects/cassandra/model/CassModSchema;", "buildTableColumn", "Lcom/intellij/database/dialects/cassandra/model/CassModTableColumn;", "buildTrigger", "Lcom/intellij/database/dialects/cassandra/model/CassModTrigger;", "findBoolean", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Boolean;", "findDouble", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Double;", "findInt", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "findMap", "", "findPrevSibling", "element", "skip", "", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/psi/PsiElement;", "findReferenceNameInNextSiblings", "findString", "parent", "getClusteringColOrder", "", "Lcom/intellij/database/model/properties/CassKeyColumn$Companion$ClusteringOrder;", "Lcom/intellij/sql/dialects/cassandra/psi/CassSqlPrimaryKeyDefinition;", "getClusteringOrder", "ref", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "getName", "resolve", "intellij.database.dialects"})
public final class CassandraObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof CassModTable) {
            this.buildLikeTable((CassModLikeTable)obj, source);
        } else if (basicModElement instanceof CassModTableColumn) {
            this.buildTableColumn((CassModTableColumn)obj, source);
        } else if (basicModElement instanceof CassModMatView) {
            this.buildMatView((CassModMatView)obj, source);
        } else if (basicModElement instanceof CassModKey) {
            this.buildKey((CassModKey)obj, source);
        } else if (basicModElement instanceof CassModFunction) {
            this.buildFunction((CassModFunction)obj, source);
        } else if (basicModElement instanceof CassModAggregate) {
            this.buildAggregate((CassModAggregate)obj, source);
        } else if (basicModElement instanceof CassModTrigger) {
            this.buildTrigger((CassModTrigger)obj, source);
        } else if (basicModElement instanceof CassModRole) {
            this.buildRole((CassModRole)obj, source);
        } else if (basicModElement instanceof CassModSchema) {
            this.buildSchema((CassModSchema)obj, source);
        } else {
            super.build(obj, source);
        }
    }

    private final void buildSchema(CassModSchema obj, DasObject source) {
        PsiElement first$iv$iv;
        CassandraObjectBuilder this_$iv;
        super.buildNamespace(obj, source);
        if (!(source instanceof SqlCreateStatement)) {
            return;
        }
        obj.setReplication(CassSchemaDefaults.INSTANCE.getReplication());
        obj.setDurableWrites(true);
        CassandraObjectBuilder cassandraObjectBuilder = this_$iv = this;
        for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            Object object;
            IElementType iElementType;
            PsiElement el = tmp$iv$iv;
            PsiElement psiElement = el.getFirstChild();
            IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_REPLICATION)) {
                if (this.findMap(el) != null) {
                    String replication = object;
                    obj.setReplication(replication);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_DURABLE_WRITES)) continue;
            if (this.findBoolean(el) == null) continue;
            boolean durable_writes = (Boolean)object;
            obj.setDurableWrites(durable_writes);
        }
    }

    private final void buildRole(CassModRole obj, DasObject source) {
        PsiElement first$iv$iv;
        CassandraObjectBuilder this_$iv;
        super.buildBasicElement(obj, source);
        if (!(source instanceof SqlCreateStatement)) {
            return;
        }
        obj.setSuperRole(false);
        obj.setCanLogin(false);
        CassandraObjectBuilder cassandraObjectBuilder = this_$iv = this;
        for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            Boolean bl;
            IElementType iElementType;
            PsiElement it = tmp$iv$iv;
            if (Intrinsics.areEqual((Object)this.getElementType(it), (Object)CassTypes.CASS_SUPERUSER)) {
                obj.setCanLogin(true);
            }
            PsiElement psiElement = it.getFirstChild();
            IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SUPERUSER)) {
                if (this.findBoolean(it) != null) {
                    boolean isSuperRole = bl;
                    obj.setSuperRole(isSuperRole);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_LOGIN)) continue;
            if (this.findBoolean(it) == null) continue;
            boolean canLogin = bl;
            obj.setCanLogin(canLogin);
        }
    }

    private final void buildTrigger(CassModTrigger obj, DasObject source) {
        PsiElement first$iv$iv;
        CassandraObjectBuilder this_$iv;
        super.buildTrigger(obj, source);
        if (!(source instanceof SqlCreateStatement)) {
            return;
        }
        obj.setClassName(null);
        CassandraObjectBuilder cassandraObjectBuilder = this_$iv = this;
        for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            String string;
            IElementType iElementType;
            PsiElement it = tmp$iv$iv;
            PsiElement psiElement = it.getFirstChild();
            IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_USING)) continue;
            if (this.findString(it) == null) continue;
            String className = string;
            obj.setClassName(className);
        }
    }

    private final void buildAggregate(CassModAggregate obj, DasObject source) {
        PsiElement first$iv$iv;
        CassandraObjectBuilder this_$iv;
        super.buildRoutine(obj, source);
        if (!(source instanceof SqlCreateStatement)) {
            return;
        }
        obj.setStateFunc(null);
        obj.setFinalFunc(null);
        obj.setStateType(ModelConsts.NO_DATA_TYPE);
        obj.setInitCond(null);
        CassandraObjectBuilder cassandraObjectBuilder = this_$iv = this;
        for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            SqlExpression expression;
            String funcName;
            String string;
            IElementType iElementType;
            PsiElement it = tmp$iv$iv;
            PsiElement psiElement = it.getFirstChild();
            IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SFUNC)) {
                PsiElement psiElement2 = it.getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it.firstChild");
                if (this.findReferenceNameInNextSiblings(psiElement2) != null) {
                    funcName = string;
                    obj.setStateFunc(funcName);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_FINALFUNC)) {
                PsiElement psiElement3 = it.getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"it.firstChild");
                if (this.findReferenceNameInNextSiblings(psiElement3) != null) {
                    funcName = string;
                    obj.setFinalFunc(funcName);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_STYPE)) {
                SqlTypeElement typeElement = (SqlTypeElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)it.getFirstChild(), SqlTypeElement.class);
                if (typeElement == null) continue;
                obj.setStateType(typeElement.getDataType());
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_INITCOND) || (expression = (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)it.getFirstChild(), SqlExpression.class)) == null) continue;
            obj.setInitCond(expression.getText());
        }
    }

    private final String findReferenceNameInNextSiblings(PsiElement element2) {
        SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)element2, SqlReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        DasObject dasObject = this.resolve(ref);
        return dasObject != null ? dasObject.getName() : null;
    }

    private final void buildFunction(CassModFunction obj, DasObject source) {
        PsiElement first$iv$iv;
        CassandraObjectBuilder this_$iv;
        super.buildRoutine(obj, source);
        if (!(source instanceof SqlCreateFunctionStatementImpl)) {
            return;
        }
        ((BasicModModel)obj.getModel()).writeSources(new Runnable(obj){
            final /* synthetic */ CassModFunction $obj;

            public final void run() {
                this.$obj.setSourceText(null);
            }
            {
                this.$obj = cassModFunction;
            }
        });
        obj.setCalledOnNullInput(false);
        obj.setLanguage(null);
        CassandraObjectBuilder cassandraObjectBuilder = this_$iv = this;
        for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            IElementType iElementType;
            PsiElement it = tmp$iv$iv;
            PsiElement psiElement = it.getFirstChild();
            IElementType iElementType2 = iElementType = psiElement != null ? this.getElementType(psiElement) : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_AS)) {
                SqlStringLiteralExpression stringLiteral = (SqlStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)it, SqlStringLiteralExpression.class);
                if (stringLiteral == null) continue;
                TextRange range = ElementManipulators.getValueTextRange((PsiElement)((PsiElement)stringLiteral));
                ((BasicModModel)obj.getModel()).writeSources(new Runnable(stringLiteral, range, this, obj){
                    final /* synthetic */ SqlStringLiteralExpression $stringLiteral;
                    final /* synthetic */ TextRange $range;
                    final /* synthetic */ CassandraObjectBuilder this$0;
                    final /* synthetic */ CassModFunction $obj$inlined;
                    {
                        this.$stringLiteral = sqlStringLiteralExpression;
                        this.$range = textRange;
                        this.this$0 = cassandraObjectBuilder;
                        this.$obj$inlined = cassModFunction;
                    }

                    public final void run() {
                        String string = this.$stringLiteral.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stringLiteral.text");
                        String string2 = string;
                        TextRange textRange = this.$range;
                        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"range");
                        int n = textRange.getStartOffset();
                        TextRange textRange2 = this.$range;
                        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"range");
                        int n2 = textRange2.getEndOffset();
                        CassandraObjectBuilder cassandraObjectBuilder = this.this$0;
                        CassModFunction cassModFunction = this.$obj$inlined;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring(n, n2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string5 = string4;
                        cassModFunction.setSourceText(CassandraObjectBuilder.access$asComposite(cassandraObjectBuilder, string5, CompositeText.Kind.ORIGINAL_TEXT));
                    }
                });
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CALLED)) {
                obj.setCalledOnNullInput(true);
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_LANGUAGE)) continue;
            PsiElement psiElement2 = it.getFirstChild();
            SqlTokenType sqlTokenType = SqlTokens.SQL_IDENT;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType, (String)"SQL_IDENT");
            PsiElement lang = this.findSibling(psiElement2, (IElementType)sqlTokenType);
            if (lang == null) continue;
            obj.setLanguage(lang.getText());
        }
    }

    private final void buildTableColumn(CassModTableColumn obj, DasObject source) {
        PsiElement first$iv$iv;
        CassandraObjectBuilder this_$iv;
        super.build(obj, source);
        if (!(source instanceof SqlColumnDefinition)) {
            return;
        }
        CassandraObjectBuilder cassandraObjectBuilder = this_$iv = this;
        for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            PsiElement it = tmp$iv$iv;
            if (!Intrinsics.areEqual((Object)this.getElementType(it), (Object)CassTypes.CASS_STATIC)) continue;
            obj.setStaticColumn(true);
        }
    }

    private final void buildLikeTable(CassModLikeTable obj, DasObject source) {
        PsiElement first$iv$iv;
        CassandraObjectBuilder this_$iv;
        super.buildBasicElement(obj, source);
        if (!(source instanceof PsiElement)) {
            return;
        }
        obj.setComment(CassTableDefaults.INSTANCE.getComment());
        obj.setBloomFilterFpChance(0.01);
        obj.setCaching(CassTableDefaults.INSTANCE.getCaching());
        obj.setCdc(false);
        obj.setCompaction(CassTableDefaults.INSTANCE.getCompaction());
        obj.setCompression(CassTableDefaults.INSTANCE.getCompression());
        obj.setCrcCheckChance(1.0);
        obj.setDclocalReadRepairChance(-1.0);
        obj.setDefaultTimeToLive(0);
        obj.setGcGraceSeconds(864000);
        obj.setMaxIndexInterval(2048);
        obj.setMemtableFlushPeriodInMs(0);
        obj.setMinIndexInterval(128);
        obj.setReadRepairChance(0.0);
        CassandraObjectBuilder cassandraObjectBuilder = this_$iv = this;
        for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            double d2;
            Object object;
            PsiElement el = tmp$iv$iv;
            IElementType iElementType = this.getElementType(el);
            if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) continue;
            PsiElement psiElement = el.getFirstChild();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"el.firstChild");
            IElementType iElementType2 = this.getElementType(psiElement);
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_COMMENT)) {
                obj.setComment(this.findString(el));
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_BLOOM_FILTER_FP_CHANCE)) {
                if (this.findDouble(el) != null) {
                    d2 = ((Number)object).doubleValue();
                    obj.setBloomFilterFpChance(d2);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_CACHING)) {
                if (this.findMap(el) != null) {
                    Object map = object;
                    obj.setCaching((String)map);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_CDC)) {
                if (this.findBoolean(el) != null) {
                    boolean bl = (Boolean)object;
                    obj.setCdc(bl);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_COMPACTION)) {
                if (this.findMap(el) != null) {
                    Object map = object;
                    obj.setCompaction((String)map);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_COMPRESSION)) {
                if (this.findMap(el) != null) {
                    Object map = object;
                    obj.setCompression((String)map);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_CRC_CHECK_CHANCE)) {
                if (this.findDouble(el) != null) {
                    d2 = ((Number)object).doubleValue();
                    obj.setCrcCheckChance(d2);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_DCLOCAL_READ_REPAIR_CHANCE)) {
                if (this.findDouble(el) != null) {
                    d2 = ((Number)object).doubleValue();
                    obj.setDclocalReadRepairChance(d2);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_DEFAULT_TIME_TO_LIVE)) {
                if (this.findInt(el) != null) {
                    int n = ((Number)object).intValue();
                    obj.setDefaultTimeToLive(n);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_GC_GRACE_SECONDS)) {
                if (this.findInt(el) != null) {
                    int n = ((Number)object).intValue();
                    obj.setGcGraceSeconds(n);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_MAX_INDEX_INTERVAL)) {
                if (this.findInt(el) != null) {
                    int n = ((Number)object).intValue();
                    obj.setMaxIndexInterval(n);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_MEMTABLE_FLUSH_PERIOD_IN_MS)) {
                if (this.findInt(el) != null) {
                    int n = ((Number)object).intValue();
                    obj.setMemtableFlushPeriodInMs(n);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_MIN_INDEX_INTERVAL)) {
                if (this.findInt(el) != null) {
                    int n = ((Number)object).intValue();
                    obj.setMinIndexInterval(n);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType2, (Object)CassTypes.CASS_READ_REPAIR_CHANCE)) continue;
            if (this.findDouble(el) == null) continue;
            d2 = ((Number)object).doubleValue();
            obj.setReadRepairChance(d2);
        }
    }

    private final CassKeyColumn.Companion.ClusteringOrder getClusteringOrder(SqlReferenceExpression ref) {
        SqlClause sqlClause = (SqlClause)PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)ref), SqlClause.class);
        String text2 = sqlClause != null ? sqlClause.getText() : null;
        return StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"desc") ? CassKeyColumn.Companion.ClusteringOrder.DESC : CassKeyColumn.Companion.ClusteringOrder.ASC;
    }

    private final void buildKey(CassModKey obj, DasObject source) {
        Object object;
        String it;
        Collection<CassKeyColumn> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        super.buildKey(obj, source);
        obj.setPrimary(true);
        obj.setName("primary key");
        if (!(source instanceof CassSqlPrimaryKeyDefinition)) {
            return;
        }
        MultiRef<? extends DasTypedObject> multiRef = ((CassSqlPrimaryKeyDefinition)source).getClusteringColumnsRef();
        Intrinsics.checkExpressionValueIsNotNull(multiRef, (String)"source.clusteringColumnsRef");
        List<String> clusteringColNames = this.collectNames(multiRef);
        Map<String, CassKeyColumn.Companion.ClusteringOrder> clusteringColOrder = this.getClusteringColOrder((CassSqlPrimaryKeyDefinition)source);
        Iterable iterable = clusteringColNames;
        CassModKey cassModKey = obj;
        void var6_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            Object object2 = clusteringColOrder;
            if (object2 == null || (object2 = object2.get(it)) == null) {
                object2 = CassKeyColumn.Companion.ClusteringOrder.ASC;
            }
            object = new CassKeyColumn(it, (CassKeyColumn.Companion.ClusteringOrder)((Object)object2));
            collection.add((CassKeyColumn)object);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        MultiRef<DasTypedObject> multiRef2 = ((CassSqlPrimaryKeyDefinition)source).getColumnsRef();
        Intrinsics.checkExpressionValueIsNotNull(multiRef2, (String)"source.columnsRef");
        $receiver$iv = this.collectNames(multiRef2);
        collection = collection2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (String)item$iv$iv;
            object = destination$iv$iv;
            CassKeyColumn cassKeyColumn = new CassKeyColumn(it, null);
            object.add(cassKeyColumn);
        }
        object = (List)destination$iv$iv;
        cassModKey.setColumns(CollectionsKt.plus(collection, (Iterable)((Iterable)object)));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, CassKeyColumn.Companion.ClusteringOrder> getClusteringColOrder(CassSqlPrimaryKeyDefinition source) {
        Object v3;
        Object it;
        block7: {
            SqlTableDefinition tableDef = (SqlTableDefinition)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)source), SqlTableDefinition.class);
            if (tableDef == null) {
                return null;
            }
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((PsiElement)tableDef), SqlClause.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"PsiTreeUtil.getChildrenO\u2026f, SqlClause::class.java)");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                SqlClause sqlClause = it = (SqlClause)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlClause, (String)"it");
                PsiElement psiElement = sqlClause.getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it.firstChild");
                if (!Intrinsics.areEqual((Object)this.getElementType(psiElement), (Object)CassTypes.CASS_CLUSTERING)) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        SqlClause sqlClause = v3;
        if (sqlClause != null) {
            SqlClause sqlClause2 = sqlClause;
            SqlClause el = sqlClause2;
            SqlReferenceList referenceList = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)el), SqlReferenceList.class);
            Object object = referenceList;
            if (object != null && (object = object.getReferenceList()) != null) {
                void $receiver$iv$iv;
                void $receiver$iv;
                it = (Iterable)object;
                void $i$a$1$firstOrNull = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void ref;
                    SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    void v6 = ref;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"ref");
                    Pair pair = new Pair((Object)this.getName((SqlReferenceExpression)v6), (Object)this.getClusteringOrder((SqlReferenceExpression)ref));
                    collection.add(pair);
                }
                object = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                if (object == null) {
                } else {
                    return object;
                }
            }
            Object v7 = null;
            throw null;
        }
        return null;
    }

    private final String findString(PsiElement parent2) {
        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_STRING_LITERAL");
        PsiElement string = this.findChild(parent2, (IElementType)sqlCompositeElementType);
        PsiElement psiElement = string;
        if (!(psiElement instanceof SqlStringLiteralExpressionImpl)) {
            psiElement = null;
        }
        SqlStringLiteralExpressionImpl sqlStringLiteralExpressionImpl = (SqlStringLiteralExpressionImpl)psiElement;
        return sqlStringLiteralExpressionImpl != null ? sqlStringLiteralExpressionImpl.getValue() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIndex(@NotNull BasicModIndex obj, @NotNull DasObject source) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<SqlReferenceExpression> list;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildNamedElement(obj, source);
        if (!(source instanceof PsiElement) || !(obj instanceof CassModIndex)) {
            return;
        }
        List<SqlReferenceExpression> list2 = list = SqlImplUtil.getReferenceList((SqlReferenceList)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)source), SqlReferenceList.class));
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"list");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            IElementType iElementType;
            void expression;
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v1 = expression;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"expression");
            PsiElement psiElement = (PsiElement)v1;
            IElementType[] iElementTypeArray = new IElementType[2];
            IElementType iElementType2 = CassTypes.CASS_LEFT_PAREN;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"CASS_LEFT_PAREN");
            iElementTypeArray[0] = iElementType2;
            IElementType iElementType3 = TokenType.WHITE_SPACE;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"WHITE_SPACE");
            iElementTypeArray[1] = iElementType3;
            PsiElement prevSibling = this.findPrevSibling(psiElement, iElementTypeArray);
            String modifier = prevSibling == null ? null : (Intrinsics.areEqual((Object)(iElementType = this.getElementType(prevSibling)), (Object)CassTypes.CASS_FULL) ? "full" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_KEYS) ? "keys" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_ENTRIES) ? "entries" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_VALUES) ? "values" : null))));
            CassIndexColumn cassIndexColumn = new CassIndexColumn(this.getName((SqlReferenceExpression)expression), modifier);
            collection.add(cassIndexColumn);
        }
        List columns = (List)destination$iv$iv;
        ((CassModIndex)obj).setColumns(columns);
    }

    private final PsiElement findPrevSibling(PsiElement element2, IElementType ... skip) {
        PsiElement prevSibling;
        for (prevSibling = element2.getPrevSibling(); prevSibling != null && ArraysKt.contains((Object[])skip, (Object)this.getElementType(prevSibling)); prevSibling = prevSibling.getPrevSibling()) {
        }
        return prevSibling;
    }

    private final String getName(SqlReferenceExpression ref) {
        Object object = this.resolve(ref);
        if (object == null || (object = object.getName()) == null) {
            String string = ref.getName();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ref.name");
        }
        return object;
    }

    private final DasObject resolve(SqlReferenceExpression ref) {
        ResolveResult[] resolveResultArray = ref.multiResolve(false);
        int n = resolveResultArray.length;
        for (int j = 0; j < n; ++j) {
            ResolveResult result2;
            ResolveResult resolveResult = result2 = resolveResultArray[j];
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResult, (String)"result");
            PsiElement element2 = resolveResult.getElement();
            if (!(element2 instanceof DasObject)) continue;
            return (DasObject)element2;
        }
        return null;
    }

    private final Boolean findBoolean(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        if (object != null && (object = object.getText()) != null) {
            Object object2;
            Object text2;
            Object object3;
            Object object4 = object3 = (text2 = (object2 = object));
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object4).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            switch (string) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            return null;
        }
        return null;
    }

    private final Double findDouble(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toDoubleOrNull((String)object) : null;
    }

    private final Integer findInt(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toIntOrNull((String)object) : null;
    }

    private final String findMap(PsiElement source) {
        IElementType iElementType = CassTypes.CASS_SET_OR_MAP_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"CASS_SET_OR_MAP_LITERAL");
        PsiElement psiElement = this.findChild(source, iElementType);
        return psiElement != null ? psiElement.getText() : null;
    }

    private final void buildMatView(CassModMatView obj, DasObject source) {
        SqlWhereClauseImpl whereClause;
        this.buildLikeTable(obj, source);
        if (!(source instanceof SqlCreateMatViewStatementImpl)) {
            return;
        }
        SqlFromClause fromClause = (SqlFromClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)source), SqlFromClause.class);
        if (fromClause != null) {
            SqlExpression sqlExpression = fromClause.getFromExpression();
            obj.setBaseTableName(sqlExpression != null ? sqlExpression.getText() : null);
        }
        if ((whereClause = (SqlWhereClauseImpl)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)source), SqlWhereClauseImpl.class)) != null) {
            String string;
            String string2 = whereClause.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"whereClause.text");
            String string3 = string2;
            int n = "where".length();
            CassModMatView cassModMatView = obj;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string3 = (string = string5);
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string6)).toString();
            cassModMatView.setWhereClause(string);
        }
    }

    @NotNull
    public static final /* synthetic */ SimpleCompositeText access$asComposite(CassandraObjectBuilder $this, @NotNull String $receiver, @NotNull CompositeText.Kind kind) {
        return $this.asComposite($receiver, kind);
    }
}

