/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.query.CommonPreprocessor;
import com.intellij.database.dialects.cassandra.introspector.CassandraIntroQueries;
import com.intellij.database.dialects.cassandra.introspector.CassandraIntrospector;
import com.intellij.database.dialects.cassandra.introspector.CassandraIntrospector$CassandraSchemaRetriever$ColumnSorter$WhenMappings;
import com.intellij.database.dialects.cassandra.introspector.CassandraIntrospectorHelper;
import com.intellij.database.dialects.cassandra.model.CassModAggregate;
import com.intellij.database.dialects.cassandra.model.CassModArgument;
import com.intellij.database.dialects.cassandra.model.CassModDefType;
import com.intellij.database.dialects.cassandra.model.CassModDefTypeAttribute;
import com.intellij.database.dialects.cassandra.model.CassModFunction;
import com.intellij.database.dialects.cassandra.model.CassModIndex;
import com.intellij.database.dialects.cassandra.model.CassModKey;
import com.intellij.database.dialects.cassandra.model.CassModLikeTable;
import com.intellij.database.dialects.cassandra.model.CassModMatView;
import com.intellij.database.dialects.cassandra.model.CassModModel;
import com.intellij.database.dialects.cassandra.model.CassModRole;
import com.intellij.database.dialects.cassandra.model.CassModRoot;
import com.intellij.database.dialects.cassandra.model.CassModRoutine;
import com.intellij.database.dialects.cassandra.model.CassModSchema;
import com.intellij.database.dialects.cassandra.model.CassModTable;
import com.intellij.database.dialects.cassandra.model.CassModTableColumn;
import com.intellij.database.dialects.cassandra.model.CassModTrigger;
import com.intellij.database.dialects.cassandra.model.CassRoot;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CassIndexColumn;
import com.intellij.database.model.properties.CassKeyColumn;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.remote.jdbc.RemoteCassandraConnection;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.Version;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.rmi.NoSuchObjectException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.util.StringOperator;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002JF\u0010\u0011\u001a00\u0012R,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u001c\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0015H\u0014J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u001e\u0010 \u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0014J\b\u0010\"\u001a\u00020\u000bH\u0016J\b\u0010#\u001a\u00020\u000bH\u0016J\b\u0010$\u001a\u00020\u000bH\u0002J\b\u0010%\u001a\u00020\u000bH\u0002J\u001f\u0010&\u001a\u00020\u000b2\u0014\b\u0004\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0(H\u0082\bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/cassandra/model/CassModModel;", "Lcom/intellij/database/dialects/cassandra/model/CassRoot;", "Lcom/intellij/database/dialects/cassandra/model/CassModRoot;", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "Lcom/intellij/database/dialects/cassandra/model/CassModSchema;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "applySchemas", "", "newSchemas", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneSchema;", "currentSchema", "", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntrospector$CassandraSchemaRetriever;", "schema", "hasSelectPrivilege", "", "tableName", "introspectNamespacesInTran", "tran", "introspectOneSchema", "introspectSchemasAuto", "schemas", "introspectServerObjects", "retrieveAndApplySchemas", "retrieveRoles21", "retrieveRoles22", "workWithModel", "modifier", "Lkotlin/Function1;", "CassandraSchemaRetriever", "Factory", "intellij.database.dialects"})
public class CassandraIntrospector
extends BaseSingleDatabaseIntrospector<CassModModel, CassRoot, CassModRoot, CassSchema, CassModSchema> {
    private final Logger LOG;

    @Override
    @NotNull
    protected BaseIntrospector.AbstractDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull CassRoot database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @NotNull
    protected CassandraSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull CassSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new CassandraSchemaRetriever(transaction, schema);
    }

    private final void workWithModel(Function1<? super CassModRoot, Unit> modifier) {
        ((CassModModel)this.getModel()).modify(CassModRoot.class, new ModelModifier<CassModRoot>(modifier){
            final /* synthetic */ Function1 $modifier;

            public final void perform(CassModRoot it) {
                CassModRoot cassModRoot = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModRoot, (String)"it");
                this.$modifier.invoke((Object)cassModRoot);
            }
            {
                this.$modifier = function1;
            }
        });
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        List<CassandraIntroQueries.OneSchema> schemas2;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        List<CassandraIntroQueries.OneSchema> list = schemas2 = this.getServerVersion().isOrGreater(new int[]{3, 0}) ? this.performQuery(tran, CassandraIntroQueries.Companion.getQUERIES().getRetrieveSchemas3()) : this.performQuery(tran, CassandraIntroQueries.Companion.getQUERIES().getRetrieveSchemas2());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"schemas");
        this.applySchemas(list, this.getDbConnectionInfo().schemaName);
    }

    @Override
    public void introspectServerObjects() {
        if (this.getServerVersion().isOrGreater(new int[]{2, 2})) {
            if (this.hasSelectPrivilege("system_auth.roles")) {
                this.retrieveRoles22();
            }
        } else if (this.hasSelectPrivilege("system_auth.users")) {
            this.retrieveRoles21();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasSelectPrivilege(String tableName) {
        try {
            Object object = this.getDbConnection();
            AutoCloseable autoCloseable = object != null && (object = object.getJdbcConnection()) != null ? object.createStatement() : null;
            Throwable throwable = null;
            try {
                Statement statement;
                Statement statement2 = statement = (Statement)autoCloseable;
                Boolean bl = statement2 != null ? Boolean.valueOf(statement2.execute("select * from " + tableName)) : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private final void retrieveRoles22() {
        this.inSessionUnit((Function1<DBSession, Unit>)((Function1)new Function1<DBSession, Unit>(this){
            final /* synthetic */ CassandraIntrospector this$0;

            public final void invoke(@NotNull DBSession session2) {
                Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                ((CassModModel)this.this$0.getModel()).modify((ModelModifier<? super CassModRoot>)new ModelModifier<CassModRoot>(this, session2){
                    final /* synthetic */ retrieveRoles22.1 this$0;
                    final /* synthetic */ DBSession $session;

                    public final void perform(CassModRoot root2) {
                        Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
                        CassModRoot cassModRoot = root2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)cassModRoot, (String)"root");
                        NamingFamily namingFamily = cassModRoot.getRoles();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"root.roles");
                        it.invoke((Object)namingFamily);
                        Object object = this.$session.query(CassandraIntroQueries.Companion.getQUERIES().getRetrieveRoles22().rewrite((StringOperator)CassandraIntrospector.access$getPreprocessor$p(this.this$0.this$0))).run();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"session.query(QUERIES.re\u2026rite(preprocessor)).run()");
                        Iterable $receiver$iv = (Iterable)object;
                        for (T element$iv : $receiver$iv) {
                            CassandraIntroQueries.OneRole r = (CassandraIntroQueries.OneRole)element$iv;
                            NamingFamily namingFamily2 = root2.getRoles();
                            String string = r.name;
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            E e = namingFamily2.createOrGet(string);
                            CassModRole $receiver = (CassModRole)e;
                            $receiver.setSuperRole(r.is_superuser);
                            $receiver.setCanLogin(r.can_login);
                        }
                        it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
                        NamingFamily namingFamily3 = root2.getRoles();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily3, (String)"root.roles");
                        it.invoke((Object)namingFamily3);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$session = dBSession;
                    }
                });
            }
            {
                this.this$0 = cassandraIntrospector;
                super(1);
            }
        }));
    }

    private final void retrieveRoles21() {
        this.inSessionUnit((Function1<DBSession, Unit>)((Function1)new Function1<DBSession, Unit>(this){
            final /* synthetic */ CassandraIntrospector this$0;

            public final void invoke(@NotNull DBSession session2) {
                Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                ((CassModModel)this.this$0.getModel()).modify((ModelModifier<? super CassModRoot>)new ModelModifier<CassModRoot>(this, session2){
                    final /* synthetic */ retrieveRoles21.1 this$0;
                    final /* synthetic */ DBSession $session;

                    public final void perform(CassModRoot root2) {
                        Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
                        CassModRoot cassModRoot = root2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)cassModRoot, (String)"root");
                        NamingFamily namingFamily = cassModRoot.getRoles();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"root.roles");
                        it.invoke((Object)namingFamily);
                        Object object = this.$session.query(CassandraIntroQueries.Companion.getQUERIES().getRetrieveRoles21().rewrite((StringOperator)CassandraIntrospector.access$getPreprocessor$p(this.this$0.this$0))).run();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"session.query(QUERIES.re\u2026rite(preprocessor)).run()");
                        Iterable $receiver$iv = (Iterable)object;
                        for (T element$iv : $receiver$iv) {
                            CassandraIntroQueries.OneRole r = (CassandraIntroQueries.OneRole)element$iv;
                            NamingFamily namingFamily2 = root2.getRoles();
                            String string = r.name;
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            E e = namingFamily2.createOrGet(string);
                            CassModRole $receiver = (CassModRole)e;
                            $receiver.setSuperRole(r.is_superuser);
                            $receiver.setCanLogin(true);
                        }
                        it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
                        NamingFamily namingFamily3 = root2.getRoles();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily3, (String)"root.roles");
                        it.invoke((Object)namingFamily3);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$session = dBSession;
                    }
                });
            }
            {
                this.this$0 = cassandraIntrospector;
                super(1);
            }
        }));
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemas2 = this.getServerVersion().isOrGreater(new int[]{3, 0}) ? (List)this.inTransaction(retrieveAndApplySchemas.schemas.1.INSTANCE) : (List)this.inTransaction(retrieveAndApplySchemas.schemas.2.INSTANCE);
        this.applySchemas(schemas2, this.getDbConnectionInfo().schemaName);
    }

    private final void applySchemas(List<? extends CassandraIntroQueries.OneSchema> newSchemas, String currentSchema) {
        CassandraIntrospector this_$iv = this;
        ((CassModModel)this_$iv.getModel()).modify(CassModRoot.class, new ModelModifier<CassModRoot>(newSchemas, currentSchema){
            final /* synthetic */ List $newSchemas$inlined;
            final /* synthetic */ String $currentSchema$inlined;
            {
                this.$newSchemas$inlined = list;
                this.$currentSchema$inlined = string;
            }

            public final void perform(CassModRoot it) {
                CassModRoot cassModRoot = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModRoot, (String)"it");
                CassModRoot root2 = cassModRoot;
                Function1 it2 = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
                NamingFamily namingFamily = root2.getSchemas();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"root.schemas");
                it2.invoke((Object)namingFamily);
                NamingFamily namingFamily2 = root2.getSchemas();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"root.schemas");
                boolean wasEmpty = namingFamily2.isEmpty();
                for (CassandraIntroQueries.OneSchema s : this.$newSchemas$inlined) {
                    CassModSchema schema;
                    NamingFamily namingFamily3 = root2.getSchemas();
                    String string = s.getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    CassModSchema cassModSchema = schema = (CassModSchema)namingFamily3.createOrGet(string);
                    Intrinsics.checkExpressionValueIsNotNull((Object)cassModSchema, (String)"schema");
                    cassModSchema.setDurableWrites(s.getDurableWrites());
                    if (s instanceof CassandraIntroQueries.OneSchema2) {
                        schema.setReplication(CassandraIntrospectorHelper.INSTANCE.concatClassAndOptions(((CassandraIntroQueries.OneSchema2)s).strategy_class, ((CassandraIntroQueries.OneSchema2)s).strategy_options));
                    } else if (s instanceof CassandraIntroQueries.OneSchema3) {
                        String string2;
                        CassModSchema cassModSchema2 = schema;
                        if (((CassandraIntroQueries.OneSchema3)s).replication != null) {
                            String string3;
                            CassModSchema cassModSchema3 = cassModSchema2;
                            String it3 = string3;
                            String string4 = CassandraIntrospectorHelper.jsonToCassandraMapLiteral$default(CassandraIntrospectorHelper.INSTANCE, it3, null, 2, null);
                            cassModSchema2 = cassModSchema3;
                            string2 = string4;
                        } else {
                            string2 = null;
                        }
                        cassModSchema2.setReplication(string2);
                    }
                    if (!Intrinsics.areEqual((Object)s.getName(), (Object)this.$currentSchema$inlined)) continue;
                    schema.setCurrent(true);
                }
                if (wasEmpty) {
                    String string = this.$currentSchema$inlined;
                    if (string == null) {
                        CassandraIntroQueries.OneSchema oneSchema = (CassandraIntroQueries.OneSchema)CollectionsKt.lastOrNull((List)this.$newSchemas$inlined);
                        string = oneSchema != null ? oneSchema.getName() : null;
                    }
                    if (string != null) {
                        String string5;
                        String it4 = string5 = string;
                        CassModSchema cassModSchema = (CassModSchema)root2.getSchemas().get(it4);
                        if (cassModSchema != null) {
                            cassModSchema.setVisible(true);
                        }
                    }
                }
                it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
                NamingFamily namingFamily4 = root2.getSchemas();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily4, (String)"root.schemas");
                it.invoke((Object)namingFamily4);
            }
        });
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends CassSchema> schemas2) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas2, (String)"schemas");
        for (CassSchema cassSchema : schemas2) {
            this.introspectOneSchema(tran, cassSchema);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectOneSchema(DBTransaction tran, CassSchema schema) {
        void this_$iv;
        CassandraIntrospector cassandraIntrospector = this;
        String operationName$iv = "Introspect schema " + schema.getName();
        try {
            CassandraSchemaRetriever retriever = this.createSchemaRetriever(tran, schema);
            retriever.process();
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    public CassandraIntrospector() {
        Dbms dbms = Dbms.CASSANDRA;
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"CASSANDRA");
        super(dbms, CassModModel.class, CassModRoot.class, CassModSchema.class);
        this.LOG = Logger.getInstance(CassandraIntrospector.class);
    }

    public static final /* synthetic */ void access$setServerVersion$p(CassandraIntrospector $this, @NotNull Version version) {
        $this.setServerVersion(version);
    }

    public static final /* synthetic */ void access$setDbConnection$p(CassandraIntrospector $this, @Nullable DatabaseConnection databaseConnection) {
        $this.setDbConnection(databaseConnection);
    }

    @NotNull
    public static final /* synthetic */ CommonPreprocessor access$getPreprocessor$p(CassandraIntrospector $this) {
        return $this.preprocessor;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return version.isOrGreater(new int[]{2, 0});
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            CassandraIntrospector cassandraIntrospector;
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
            CassandraIntrospector $receiver = cassandraIntrospector = new CassandraIntrospector();
            $receiver.setModelFactory$intellij_database_dialects(modelFactory);
            return cassandraIntrospector;
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@NotNull BasicElement e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return false;
        }

        @Override
        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative(this);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects"})
        public static final class VERSION
        extends PerObjectVersion {
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0084\u0004\u0018\u00002<\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001R,\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004:\u0001UB\u0017\b\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00152\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u001b2\b\u0010!\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\b\u0010$\u001a\u00020\rH\u0016J.\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0002J(\u0010(\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020*0\u0011H\u0002J(\u0010+\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020,0\u0011H\u0002J\u0018\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J.\u00107\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020*0\u0011H\u0002J\u0018\u00109\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020:H\u0002J\u0018\u0010;\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020<H\u0002J\u0018\u0010=\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\r2\u0006\u0010@\u001a\u00020\u0015H\u0002J\u0010\u0010A\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010B\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010C\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010D\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010E\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010F\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010G\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010H\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010I\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010J\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0018\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u0018H\u0002J\u001c\u0010O\u001a\u00020\r2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020R0QH\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010S\u001a\u00020\u0015H\u0002J\u0010\u0010T\u001a\u00020\u00152\u0006\u0010S\u001a\u00020\u0015H\u0002\u00a8\u0006V"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntrospector$CassandraSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "Lcom/intellij/database/dialects/cassandra/model/CassModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "Lcom/intellij/database/dialects/cassandra/model/CassModModel;", "Lcom/intellij/database/dialects/cassandra/model/CassRoot;", "Lcom/intellij/database/dialects/cassandra/model/CassModRoot;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/cassandra/model/CassSchema;)V", "createKey", "", "table", "Lcom/intellij/database/dialects/cassandra/model/CassModLikeTable;", "columns", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneColumn;", "getAggregateInitConditions", "", "", "keyspace", "getDataType", "Lcom/intellij/database/model/DataType;", "validator", "unwrapFrozen", "", "getInitCondition", "initConditions", "a", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneAggregate;", "isIndexCustom", "kind", "isPossibleToIntrospectSchemaIncrementally", "tran", "process", "processAggregate", "aggregate", "Lcom/intellij/database/dialects/cassandra/model/CassModAggregate;", "processColumns2", "tableName", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneColumn2;", "processColumns3", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneColumn3;", "processDefType", "t", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneDefType;", "objectType", "Lcom/intellij/database/dialects/cassandra/model/CassModDefType;", "processFunction", "f", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneFunction;", "function", "Lcom/intellij/database/dialects/cassandra/model/CassModFunction;", "processIndex", "indexName", "processLikeTable", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneLikeTable;", "processLikeTable2", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneLikeTable2;", "processLikeTable3", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneLikeTable3;", "progress", "what", "retrieveAggregates", "retrieveColumns", "retrieveDefTypes", "retrieveFunctions", "retrieveIndices", "retrieveIndices2", "retrieveIndices3", "retrieveMatViews", "retrieveTables", "retrieveTriggers", "setReturnType", "routine", "Lcom/intellij/database/dialects/cassandra/model/CassModRoutine;", "returnDataType", "setVersionParameters", "parameters", "", "", "s", "unwrapReversed", "ColumnSorter", "intellij.database.dialects"})
    protected final class CassandraSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever<CassSchema, CassModSchema> {
        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull CassSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            return false;
        }

        private final void setVersionParameters(Map<String, Object> parameters) {
            int n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(CassandraIntrospector.this.getServerVersion(), 3, new IntRange(n, 11), parameters);
        }

        private final void progress(String what) {
            String mode = "completely";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Introspecting schema %s (%s)";
            Object[] objectArray = new Object[]{((CassSchema)this.getSchema()).getName(), mode};
            CassandraIntrospector cassandraIntrospector = CassandraIntrospector.this;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            cassandraIntrospector.updateStatus(string3, what);
        }

        @Override
        public void process() {
            this.prepareParameters();
            this.inSchema((Function1)new Function1<CassModSchema, Unit>(this){
                final /* synthetic */ CassandraSchemaRetriever this$0;

                public final void invoke(@NotNull CassModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassandraSchemaRetriever.access$retrieveTables(this.this$0, schema);
                }
                {
                    this.this$0 = cassandraSchemaRetriever;
                    super(1);
                }
            });
            if (CassandraIntrospector.this.getServerVersion().isOrGreater(new int[]{3})) {
                this.inSchema((Function1)new Function1<CassModSchema, Unit>(this){
                    final /* synthetic */ CassandraSchemaRetriever this$0;

                    public final void invoke(@NotNull CassModSchema schema) {
                        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                        CassandraSchemaRetriever.access$retrieveMatViews(this.this$0, schema);
                    }
                    {
                        this.this$0 = cassandraSchemaRetriever;
                        super(1);
                    }
                });
            }
            this.inSchema((Function1)new Function1<CassModSchema, Unit>(this){
                final /* synthetic */ CassandraSchemaRetriever this$0;

                public final void invoke(@NotNull CassModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassandraSchemaRetriever.access$retrieveColumns(this.this$0, schema);
                }
                {
                    this.this$0 = cassandraSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<CassModSchema, Unit>(this){
                final /* synthetic */ CassandraSchemaRetriever this$0;

                public final void invoke(@NotNull CassModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassandraSchemaRetriever.access$retrieveIndices(this.this$0, schema);
                }
                {
                    this.this$0 = cassandraSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<CassModSchema, Unit>(this){
                final /* synthetic */ CassandraSchemaRetriever this$0;

                public final void invoke(@NotNull CassModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassandraSchemaRetriever.access$retrieveTriggers(this.this$0, schema);
                }
                {
                    this.this$0 = cassandraSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<CassModSchema, Unit>(this){
                final /* synthetic */ CassandraSchemaRetriever this$0;

                public final void invoke(@NotNull CassModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassandraSchemaRetriever.access$retrieveFunctions(this.this$0, schema);
                }
                {
                    this.this$0 = cassandraSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<CassModSchema, Unit>(this){
                final /* synthetic */ CassandraSchemaRetriever this$0;

                public final void invoke(@NotNull CassModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassandraSchemaRetriever.access$retrieveAggregates(this.this$0, schema);
                }
                {
                    this.this$0 = cassandraSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<CassModSchema, Unit>(this){
                final /* synthetic */ CassandraSchemaRetriever this$0;

                public final void invoke(@NotNull CassModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    CassandraSchemaRetriever.access$retrieveDefTypes(this.this$0, schema);
                }
                {
                    this.this$0 = cassandraSchemaRetriever;
                    super(1);
                }
            });
        }

        private final void retrieveTables(CassModSchema schema) {
            Iterable $receiver$iv;
            this.progress("tables");
            Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingFamily namingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"schema.tables");
            it.invoke((Object)namingFamily);
            this.getPreprocessor().setFreeParameters(schema.getName());
            if (CassandraIntrospector.this.getServerVersion().isOrGreater(new int[]{3})) {
                List<CassandraIntroQueries.OneTable3> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveTables3());
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveTables3)");
                $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    CassModTable table;
                    CassandraIntroQueries.OneTable3 t = (CassandraIntroQueries.OneTable3)element$iv;
                    NamingFamily namingFamily2 = schema.getTables();
                    String string = t.name;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    CassModTable cassModTable = table = (CassModTable)namingFamily2.createOrGet(string);
                    Intrinsics.checkExpressionValueIsNotNull((Object)cassModTable, (String)"table");
                    CassModLikeTable cassModLikeTable = cassModTable;
                    CassandraIntroQueries.OneTable3 oneTable3 = t;
                    Intrinsics.checkExpressionValueIsNotNull((Object)oneTable3, (String)"t");
                    this.processLikeTable3(cassModLikeTable, oneTable3);
                }
            } else {
                List<CassandraIntroQueries.OneTable2> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveTables2());
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveTables2)");
                $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    CassModTable table;
                    CassandraIntroQueries.OneTable2 t = (CassandraIntroQueries.OneTable2)element$iv;
                    NamingFamily namingFamily3 = schema.getTables();
                    String string = t.name;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    CassModTable cassModTable = table = (CassModTable)namingFamily3.createOrGet(string);
                    Intrinsics.checkExpressionValueIsNotNull((Object)cassModTable, (String)"table");
                    CassModLikeTable cassModLikeTable = cassModTable;
                    CassandraIntroQueries.OneTable2 oneTable2 = t;
                    Intrinsics.checkExpressionValueIsNotNull((Object)oneTable2, (String)"t");
                    this.processLikeTable2(cassModLikeTable, oneTable2);
                }
            }
            it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingFamily namingFamily4 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily4, (String)"schema.tables");
            it.invoke((Object)namingFamily4);
        }

        private final void retrieveMatViews(CassModSchema schema) {
            this.progress("materialized views");
            Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingIdentifyingFamily namingIdentifyingFamily = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.matViews");
            it.invoke((Object)namingIdentifyingFamily);
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassandraIntroQueries.OneMatView3> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveMatViews());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveMatViews)");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                String string;
                String string2;
                String string3;
                CharSequence charSequence;
                String it2;
                String string4;
                CassModMatView cassModMatView;
                CassModMatView matView;
                CassandraIntroQueries.OneMatView3 mv = (CassandraIntroQueries.OneMatView3)element$iv;
                NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getMatViews();
                String string5 = mv.name;
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                CassModMatView cassModMatView2 = matView = (CassModMatView)namingIdentifyingFamily2.createOrGet(string5);
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModMatView2, (String)"matView");
                CassModLikeTable cassModLikeTable = cassModMatView2;
                CassandraIntroQueries.OneMatView3 oneMatView3 = mv;
                Intrinsics.checkExpressionValueIsNotNull((Object)oneMatView3, (String)"mv");
                this.processLikeTable3(cassModLikeTable, oneMatView3);
                CassModMatView cassModMatView3 = matView;
                if (mv.where_clause != null) {
                    cassModMatView = cassModMatView3;
                    it2 = string4;
                    charSequence = it2;
                    string3 = charSequence.length() == 0 ? null : it2;
                    cassModMatView3 = cassModMatView;
                    string2 = string3;
                } else {
                    string2 = null;
                }
                cassModMatView3.setWhereClause(string2);
                CassModMatView cassModMatView4 = matView;
                if (mv.base_table_name != null) {
                    cassModMatView = cassModMatView4;
                    it2 = string4;
                    charSequence = it2;
                    string3 = charSequence.length() == 0 ? null : it2;
                    cassModMatView4 = cassModMatView;
                    string = string3;
                } else {
                    string = null;
                }
                cassModMatView4.setBaseTableName(string);
            }
            it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingIdentifyingFamily namingIdentifyingFamily3 = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.matViews");
            it.invoke((Object)namingIdentifyingFamily3);
        }

        private final void processLikeTable(CassModLikeTable table, CassandraIntroQueries.OneLikeTable t) {
            String string;
            String string2;
            String string3;
            String string4;
            String it;
            CassModLikeTable cassModLikeTable;
            String string5;
            CassModLikeTable cassModLikeTable2 = table;
            String string6 = t.getCachingValue();
            if (string6 != null) {
                string5 = string6;
                cassModLikeTable = cassModLikeTable2;
                it = string5;
                string4 = CassandraIntrospectorHelper.jsonToCassandraMapLiteral$default(CassandraIntrospectorHelper.INSTANCE, it, null, 2, null);
                cassModLikeTable2 = cassModLikeTable;
                string3 = string4;
            } else {
                string3 = null;
            }
            cassModLikeTable2.setCaching(string3);
            CassModLikeTable cassModLikeTable3 = table;
            String string7 = t.getComm();
            if (string7 != null) {
                string5 = string7;
                cassModLikeTable = cassModLikeTable3;
                it = string5;
                CharSequence $i$a$1$let = it;
                string4 = $i$a$1$let.length() == 0 ? null : it;
                cassModLikeTable3 = cassModLikeTable;
                string2 = string4;
            } else {
                string2 = null;
            }
            cassModLikeTable3.setComment(string2);
            CassModLikeTable cassModLikeTable4 = table;
            String string8 = t.getCompressionValue();
            if (string8 != null) {
                string5 = string8;
                cassModLikeTable = cassModLikeTable4;
                it = string5;
                string4 = CassandraIntrospectorHelper.jsonToCassandraMapLiteral$default(CassandraIntrospectorHelper.INSTANCE, it, null, 2, null);
                cassModLikeTable4 = cassModLikeTable;
                string = string4;
            } else {
                string = null;
            }
            cassModLikeTable4.setCompression(string);
            table.setBloomFilterFpChance(t.getBloomFilterFpChance());
            table.setDefaultTimeToLive(t.getDefaultTimeToLive());
            table.setGcGraceSeconds(t.getGcGraceSeconds());
            table.setMaxIndexInterval(t.getMaxIndexInterval());
            table.setMemtableFlushPeriodInMs(t.getMemtableFlushPeriodInMs());
            table.setMinIndexInterval(t.getMinIndexInterval());
            table.setReadRepairChance(t.getReadRepairChance());
        }

        private final void processLikeTable2(CassModLikeTable table, CassandraIntroQueries.OneLikeTable2 t) {
            CassandraIntroQueries.OneLikeTable2 oneLikeTable2 = t;
            if (oneLikeTable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.cassandra.introspector.CassandraIntroQueries.OneLikeTable");
            }
            this.processLikeTable(table, oneLikeTable2);
            table.setCompaction(CassandraIntrospectorHelper.INSTANCE.concatClassAndOptions(t.getCompactionStrategyClass(), t.getCompactionStrategyOptions()));
        }

        private final void processLikeTable3(CassModLikeTable table, CassandraIntroQueries.OneLikeTable3 t) {
            String string;
            CassandraIntroQueries.OneLikeTable3 oneLikeTable3 = t;
            if (oneLikeTable3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.cassandra.introspector.CassandraIntroQueries.OneLikeTable");
            }
            this.processLikeTable(table, oneLikeTable3);
            table.setCdc(t.getCdcValue());
            CassModLikeTable cassModLikeTable = table;
            String string2 = t.getCompactionValue();
            if (string2 != null) {
                String string3 = string2;
                CassModLikeTable cassModLikeTable2 = cassModLikeTable;
                String it = string3;
                String string4 = CassandraIntrospectorHelper.jsonToCassandraMapLiteral$default(CassandraIntrospectorHelper.INSTANCE, it, null, 2, null);
                cassModLikeTable = cassModLikeTable2;
                string = string4;
            } else {
                string = null;
            }
            cassModLikeTable.setCompaction(string);
            table.setCrcCheckChance(t.getCrcCheckChance());
            table.setDclocalReadRepairChance(t.getDclocalReadRepairChance());
        }

        private final void retrieveColumns(CassModSchema schema) {
            List list$iv$iv;
            ArrayList answer$iv$iv$iv;
            Object value$iv$iv$iv;
            String key$iv$iv;
            Map $receiver$iv$iv$iv;
            CassandraIntroQueries.OneColumn it;
            Iterable $receiver$iv$iv;
            Map destination$iv$iv;
            Iterable $receiver$iv;
            CassModMatView v;
            CassModTable t;
            this.progress("table columns");
            Function1 it2 = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingFamily namingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"schema.tables");
            Iterable $receiver$iv2 = namingFamily;
            for (Object element$iv : $receiver$iv2) {
                CassModTable cassModTable = t = (CassModTable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModTable, (String)"t");
                PositioningNamingFamily positioningNamingFamily = cassModTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"t.columns");
                it2.invoke((Object)positioningNamingFamily);
            }
            NamingIdentifyingFamily namingIdentifyingFamily = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.matViews");
            $receiver$iv2 = namingIdentifyingFamily;
            for (Object element$iv : $receiver$iv2) {
                CassModMatView cassModMatView = v = (CassModMatView)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModMatView, (String)"v");
                PositioningNamingFamily positioningNamingFamily = cassModMatView.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"v.columns");
                it2.invoke((Object)positioningNamingFamily);
            }
            this.getPreprocessor().setFreeParameters(schema.getName());
            if (CassandraIntrospector.this.getServerVersion().isOrGreater(new int[]{3, 0})) {
                List<CassandraIntroQueries.OneColumn3> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveColumns3());
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveColumns3)");
                $receiver$iv = list;
                $receiver$iv2 = $receiver$iv;
                destination$iv$iv = new LinkedHashMap();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    Object object;
                    it = (CassandraIntroQueries.OneColumn3)element$iv$iv;
                    $receiver$iv$iv$iv = destination$iv$iv;
                    key$iv$iv = it.table_name;
                    value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        answer$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                destination$iv$iv.forEach((BiConsumer)new BiConsumer<String, List<? extends CassandraIntroQueries.OneColumn3>>(this, schema){
                    final /* synthetic */ CassandraSchemaRetriever this$0;
                    final /* synthetic */ CassModSchema $schema$inlined;
                    {
                        this.this$0 = cassandraSchemaRetriever;
                        this.$schema$inlined = cassModSchema;
                    }

                    public final void accept(@Nullable String tableName, @NotNull List<CassandraIntroQueries.OneColumn3> columns) {
                        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
                        CassandraSchemaRetriever.access$processColumns3(this.this$0, this.$schema$inlined, tableName, columns);
                    }
                });
            } else {
                List<CassandraIntroQueries.OneColumn2> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveColumns2());
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveColumns2)");
                $receiver$iv = list;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new LinkedHashMap();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    Object object;
                    it = (CassandraIntroQueries.OneColumn2)element$iv$iv;
                    $receiver$iv$iv$iv = destination$iv$iv;
                    key$iv$iv = ((CassandraIntroQueries.OneColumn2)it).table_name;
                    value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        answer$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                destination$iv$iv.forEach((BiConsumer)new BiConsumer<String, List<? extends CassandraIntroQueries.OneColumn2>>(this, schema){
                    final /* synthetic */ CassandraSchemaRetriever this$0;
                    final /* synthetic */ CassModSchema $schema$inlined;
                    {
                        this.this$0 = cassandraSchemaRetriever;
                        this.$schema$inlined = cassModSchema;
                    }

                    public final void accept(@Nullable String tableName, @NotNull List<CassandraIntroQueries.OneColumn2> columns) {
                        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
                        CassandraSchemaRetriever.access$processColumns2(this.this$0, this.$schema$inlined, tableName, columns);
                    }
                });
            }
            it2 = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingFamily namingFamily2 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"schema.tables");
            $receiver$iv2 = namingFamily2;
            for (Object element$iv : $receiver$iv2) {
                CassModTable cassModTable = t = (CassModTable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModTable, (String)"t");
                PositioningNamingFamily positioningNamingFamily = cassModTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"t.columns");
                it2.invoke((Object)positioningNamingFamily);
            }
            NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.matViews");
            $receiver$iv2 = namingIdentifyingFamily2;
            for (Object element$iv : $receiver$iv2) {
                CassModMatView cassModMatView = v = (CassModMatView)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModMatView, (String)"v");
                PositioningNamingFamily positioningNamingFamily = cassModMatView.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"v.columns");
                it2.invoke((Object)positioningNamingFamily);
            }
        }

        private final void processColumns3(CassModSchema schema, String tableName, List<CassandraIntroQueries.OneColumn3> columns) {
            NamingFamily namingFamily = schema.getTables();
            String string = tableName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            CassModTable cassModTable = (CassModTable)namingFamily.get(string);
            CassModLikeTable cassModLikeTable = cassModTable != null ? (CassModLikeTable)cassModTable : (CassModLikeTable)schema.getMatViews().get(tableName);
            if (cassModLikeTable == null) {
                return;
            }
            CassModLikeTable table = cassModLikeTable;
            ColumnSorter columnSorter = new ColumnSorter(columns);
            Iterable $receiver$iv = columns;
            for (Object element$iv : $receiver$iv) {
                BasicModTableOrViewColumn column2;
                CassandraIntroQueries.OneColumn3 c2 = (CassandraIntroQueries.OneColumn3)element$iv;
                ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)table.getColumns();
                short s = columnSorter.idx(c2);
                String string2 = c2.name;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                BasicModTableOrViewColumn basicModTableOrViewColumn = column2 = (BasicModTableOrViewColumn)modPositioningNamingFamily.renewAt(s, string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)basicModTableOrViewColumn, (String)"column");
                String string3 = c2.type;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                basicModTableOrViewColumn.setDataType(DataTypeFactory.of(string3));
                if (!(column2 instanceof CassModTableColumn)) continue;
                ((CassModTableColumn)column2).setStaticColumn(Intrinsics.areEqual((Object)c2.kind, (Object)"static"));
            }
            this.createKey(table, columns);
        }

        private final void createKey(CassModLikeTable table, List<? extends CassandraIntroQueries.OneColumn> columns) {
            CassandraIntroQueries.OneColumn it;
            Iterable $receiver$iv$iv;
            CassKeyColumn cassKeyColumn;
            Object object;
            CassandraIntroQueries.OneColumn it2;
            Iterable $receiver$iv$iv2;
            Iterable $receiver$iv;
            CassModKey k = (CassModKey)table.getKeys().createOrGet("primary key");
            Iterable iterable = $receiver$iv = (Iterable)columns;
            Object destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                it2 = (CassandraIntroQueries.OneColumn)element$iv$iv;
                if (!(it2.getK() == CassandraIntroQueries.ColumnKind.PARTITIONING)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv2 = $receiver$iv;
            destination$iv$iv = new Comparator<T>(){

                public final int compare(T a, T b2) {
                    CassandraIntroQueries.OneColumn it = (CassandraIntroQueries.OneColumn)a;
                    Comparable comparable = Integer.valueOf(it.getPos());
                    it = (CassandraIntroQueries.OneColumn)b2;
                    Comparable comparable2 = comparable;
                    Integer n = it.getPos();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            $receiver$iv = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv2, (Comparator)destination$iv$iv);
            $receiver$iv$iv2 = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                it2 = (CassandraIntroQueries.OneColumn)item$iv$iv;
                object = destination$iv$iv;
                String string = it2.getColName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                cassKeyColumn = new CassKeyColumn(string, null);
                object.add(cassKeyColumn);
            }
            List partitioningCols = (List)destination$iv$iv;
            Iterable $receiver$iv2 = columns;
            destination$iv$iv = $receiver$iv2;
            Object destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (CassandraIntroQueries.OneColumn)element$iv$iv;
                if (!(it.getK() == CassandraIntroQueries.ColumnKind.CLUSTERING)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            $receiver$iv$iv = $receiver$iv2;
            destination$iv$iv2 = new Comparator<T>(){

                public final int compare(T a, T b2) {
                    CassandraIntroQueries.OneColumn it = (CassandraIntroQueries.OneColumn)a;
                    Comparable comparable = Integer.valueOf(it.getPos());
                    it = (CassandraIntroQueries.OneColumn)b2;
                    Comparable comparable2 = comparable;
                    Integer n = it.getPos();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            $receiver$iv2 = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)destination$iv$iv2);
            $receiver$iv$iv = $receiver$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (CassandraIntroQueries.OneColumn)item$iv$iv;
                object = destination$iv$iv2;
                String string = it.getColName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                cassKeyColumn = new CassKeyColumn(string, it.getOrder());
                object.add(cassKeyColumn);
            }
            List clusteringCols = (List)destination$iv$iv2;
            CassModKey cassModKey = k;
            Intrinsics.checkExpressionValueIsNotNull((Object)cassModKey, (String)"k");
            cassModKey.setColumns(CollectionsKt.plus((Collection)partitioningCols, (Iterable)clusteringCols));
        }

        private final void processColumns2(CassModSchema schema, String tableName, List<CassandraIntroQueries.OneColumn2> columns) {
            NamingFamily namingFamily = schema.getTables();
            String string = tableName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            CassModTable cassModTable = (CassModTable)namingFamily.get(string);
            CassModLikeTable cassModLikeTable = cassModTable != null ? (CassModLikeTable)cassModTable : (CassModLikeTable)schema.getMatViews().get(tableName);
            if (cassModLikeTable == null) {
                return;
            }
            CassModLikeTable table = cassModLikeTable;
            ColumnSorter columnSorter = new ColumnSorter(columns);
            Iterable $receiver$iv = columns;
            for (Object element$iv : $receiver$iv) {
                String string2;
                String it;
                String string3;
                BasicModTableOrViewColumn column2;
                CassandraIntroQueries.OneColumn2 c2 = (CassandraIntroQueries.OneColumn2)element$iv;
                ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)table.getColumns();
                short s = columnSorter.idx(c2);
                String string4 = c2.name;
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                if ((column2 = (BasicModTableOrViewColumn)modPositioningNamingFamily.renewAt(s, string4)) instanceof CassModTableColumn) {
                    ((CassModTableColumn)column2).setStaticColumn(Intrinsics.areEqual((Object)c2.type, (Object)"static"));
                }
                if ((string3 = c2.validator) == null || (string3 = this.unwrapReversed(it = (string2 = string3))) == null) {
                    continue;
                }
                String validator = string3;
                DataType dataType = CassandraSchemaRetriever.getDataType$default(this, validator, false, 2, null);
                if (dataType == null) continue;
                it = string2 = dataType;
                BasicModTableOrViewColumn basicModTableOrViewColumn = column2;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicModTableOrViewColumn, (String)"column");
                basicModTableOrViewColumn.setDataType((DataType)it);
            }
            this.createKey(table, columns);
        }

        private final String unwrapReversed(String s) {
            if (StringsKt.startsWith$default((String)s, (String)"org.apache.cassandra.db.marshal.ReversedType", (boolean)false, (int)2, null)) {
                String string = s;
                int n = StringsKt.indexOf$default((CharSequence)s, (char)'(', (int)0, (boolean)false, (int)6, null) + 1;
                int n2 = StringsKt.lastIndexOf$default((CharSequence)s, (char)')', (int)0, (boolean)false, (int)6, null);
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
            return s;
        }

        private final void retrieveIndices(CassModSchema schema) {
            this.progress("indices");
            if (CassandraIntrospector.this.getServerVersion().isOrGreater(new int[]{3})) {
                this.retrieveIndices3(schema);
            } else {
                this.retrieveIndices2(schema);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveIndices2(CassModSchema schema) {
            void $receiver$iv$iv;
            Object element$iv3;
            CassModTable t;
            Object element$iv2;
            this.getPreprocessor().setFreeParameters(schema.getName());
            Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingFamily namingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"schema.tables");
            Object $receiver$iv = namingFamily;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                element$iv2 = iterator.next();
                CassModTable cassModTable = t = (CassModTable)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModTable, (String)"t");
                NamingFamily namingFamily2 = cassModTable.getIndices();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"t.indices");
                it.invoke((Object)namingFamily2);
            }
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassandraIntroQueries.OneIndex2> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveIndices2());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveIndices2)");
            Iterable $receiver$iv2 = list;
            for (Object element$iv3 : $receiver$iv2) {
                String indexName;
                CassModTable table;
                String tableName;
                CassandraIntroQueries.OneIndex2 i2 = (CassandraIntroQueries.OneIndex2)element$iv3;
                String fullName = i2.name;
                if (fullName == null) continue;
                int dot = StringsKt.indexOf$default((CharSequence)fullName, (char)'.', (int)0, (boolean)false, (int)6, null);
                String $i$f$forEach = fullName;
                int $i$a$1$cleanupFamilies22 = 0;
                Intrinsics.checkExpressionValueIsNotNull((Object)$i$f$forEach.substring($i$a$1$cleanupFamilies22, dot), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String $i$a$1$cleanupFamilies22 = fullName;
                int n = dot + 1;
                Intrinsics.checkExpressionValueIsNotNull((Object)$i$a$1$cleanupFamilies22.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                if ((CassModTable)schema.getTables().get(tableName) == null) {
                    continue;
                }
                table.getIndices().createOrGet(indexName);
            }
            it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingFamily namingFamily3 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily3, (String)"schema.tables");
            $receiver$iv = namingFamily3;
            element$iv3 = $receiver$iv.iterator();
            while (element$iv3.hasNext()) {
                element$iv2 = element$iv3.next();
                CassModTable cassModTable = t = (CassModTable)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModTable, (String)"t");
                NamingFamily namingFamily4 = cassModTable.getIndices();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily4, (String)"t.indices");
                it.invoke((Object)namingFamily4);
            }
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassandraIntroQueries.OneColumn2> list2 = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveColumns2());
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"performQuery(QUERIES.retrieveColumns2)");
            $receiver$iv2 = list2;
            $receiver$iv = $receiver$iv2;
            Map destination$iv$iv = new LinkedHashMap();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Object object;
                Pair key$iv$iv;
                Map $receiver$iv$iv$iv;
                Object value$iv$iv$iv;
                CassandraIntroQueries.OneColumn2 it2 = (CassandraIntroQueries.OneColumn2)element$iv$iv;
                String string = it2.table_name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = it2.index_name;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((value$iv$iv$iv = ($receiver$iv$iv$iv = destination$iv$iv).get(key$iv$iv = new Pair((Object)string, (Object)string2))) == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            destination$iv$iv.forEach((BiConsumer)new BiConsumer<Pair<? extends String, ? extends String>, List<? extends CassandraIntroQueries.OneColumn2>>(this, schema){
                final /* synthetic */ CassandraSchemaRetriever this$0;
                final /* synthetic */ CassModSchema $schema;

                public final void accept(@NotNull Pair<String, String> $tableName_indexName, @NotNull List<CassandraIntroQueries.OneColumn2> columns) {
                    Intrinsics.checkParameterIsNotNull($tableName_indexName, (String)"<name for destructuring parameter 0>");
                    Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
                    String tableName = (String)$tableName_indexName.component1();
                    String indexName = (String)$tableName_indexName.component2();
                    CassandraSchemaRetriever.access$processIndex(this.this$0, this.$schema, tableName, indexName, columns);
                }
                {
                    this.this$0 = cassandraSchemaRetriever;
                    this.$schema = cassModSchema;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void processIndex(CassModSchema schema, String tableName, String indexName, List<CassandraIntroQueries.OneColumn2> columns) {
            Collection<CassIndexColumn> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            CassModTable cassModTable = (CassModTable)schema.getTables().get(tableName);
            if (cassModTable == null) {
                return;
            }
            CassModTable table = cassModTable;
            CassModIndex cassModIndex = (CassModIndex)table.getIndices().get(indexName);
            if (cassModIndex == null) {
                return;
            }
            CassModIndex index2 = cassModIndex;
            CassandraIntroQueries.OneColumn2 oneColumn2 = (CassandraIntroQueries.OneColumn2)CollectionsKt.firstOrNull(columns);
            if (oneColumn2 == null) {
                return;
            }
            CassandraIntroQueries.OneColumn2 firstCol = oneColumn2;
            index2.setCustom(this.isIndexCustom(firstCol.index_type));
            Iterable iterable = columns;
            CassModIndex cassModIndex2 = index2;
            void var9_10 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String columnName;
                void c2;
                CassandraIntroQueries.OneColumn2 oneColumn22 = (CassandraIntroQueries.OneColumn2)item$iv$iv;
                collection = destination$iv$iv;
                if (c2.name == null) {
                    Intrinsics.throwNpe();
                }
                String options = c2.index_options;
                String modifier = null;
                if (options != null) {
                    if (CassandraIntrospectorHelper.INSTANCE.hasKey(options, "index_keys_and_values")) {
                        modifier = "entries";
                    } else if (CassandraIntrospectorHelper.INSTANCE.hasKey(options, "index_keys")) {
                        modifier = "keys";
                    } else {
                        Object object = (CassModTableColumn)table.getColumns().get(columnName);
                        if (object != null && (object = object.getDataType()) != null && (object = ((DataType)object).typeName) != null ? StringsKt.startsWith$default((String)object, (String)"frozen<", (boolean)false, (int)2, null) : false) {
                            modifier = "full";
                        }
                    }
                }
                CassIndexColumn cassIndexColumn = new CassIndexColumn(columnName, modifier);
                collection.add(cassIndexColumn);
            }
            collection = (List)destination$iv$iv;
            cassModIndex2.setColumns(CollectionsKt.toList((Iterable)collection));
        }

        private final void retrieveIndices3(CassModSchema schema) {
            CassModTable t;
            Object element$iv;
            this.getPreprocessor().setFreeParameters(schema.getName());
            Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingFamily namingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"schema.tables");
            Object $receiver$iv = namingFamily;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                CassModTable cassModTable = t = (CassModTable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModTable, (String)"t");
                NamingFamily namingFamily2 = cassModTable.getIndices();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"t.indices");
                it.invoke((Object)namingFamily2);
            }
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassandraIntroQueries.OneIndex3> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveIndices3());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveIndices3)");
            Iterable $receiver$iv2 = list;
            for (Object element$iv2 : $receiver$iv2) {
                String $i$a$1$cleanupFamilies;
                CassModIndex index2;
                CassModTable table;
                CassandraIntroQueries.OneIndex3 i2 = (CassandraIntroQueries.OneIndex3)element$iv2;
                NamingFamily namingFamily3 = schema.getTables();
                String string = i2.table_name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((CassModTable)namingFamily3.get(string) == null) {
                    continue;
                }
                NamingFamily namingFamily4 = table.getIndices();
                String string2 = i2.name;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                CassModIndex cassModIndex = index2 = (CassModIndex)namingFamily4.createOrGet(string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModIndex, (String)"index");
                cassModIndex.setCustom(this.isIndexCustom(i2.kind));
                String options = i2.options;
                if (options == null) continue;
                if (CassandraIntrospectorHelper.INSTANCE.getValue(options, "target") != null) {
                    String string3;
                    String modificator;
                    String string4;
                    String target = $i$a$1$cleanupFamilies;
                    int parenth = StringsKt.indexOf$default((CharSequence)target, (String)"(", (int)0, (boolean)false, (int)6, null);
                    if (parenth != -1) {
                        String string5 = target;
                        int n = 0;
                        String string6 = string5;
                        if (string6 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string7 = string6.substring(n, parenth);
                        string4 = string7;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    } else {
                        string4 = modificator = null;
                    }
                    if (modificator != null) {
                        String string8 = target;
                        int n = parenth + 1;
                        int n2 = target.length() - 1;
                        String string9 = string8;
                        if (string9 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string10 = string9.substring(n, n2);
                        string3 = string10;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    } else {
                        string3 = target;
                    }
                    String colName = string3;
                    index2.setColumns(CollectionsKt.listOf((Object)new CassIndexColumn(colName, StringUtil.toLowerCase((String)modificator))));
                }
                if (CassandraIntrospectorHelper.INSTANCE.getValue(options, "class_name") != null) {
                    String it2 = $i$a$1$cleanupFamilies;
                    index2.setClassName(it2);
                }
                index2.setOptions(CassandraIntrospectorHelper.INSTANCE.jsonToCassandraMapLiteral(options, (Function1<? super String, Boolean>)((Function1)retrieveIndices3.2.1.3.INSTANCE)));
            }
            it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingFamily namingFamily5 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily5, (String)"schema.tables");
            $receiver$iv = namingFamily5;
            iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                CassModTable cassModTable = t = (CassModTable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModTable, (String)"t");
                NamingFamily namingFamily6 = cassModTable.getIndices();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily6, (String)"t.indices");
                it.invoke((Object)namingFamily6);
            }
        }

        private final boolean isIndexCustom(String kind) {
            return StringUtil.equalsIgnoreCase((CharSequence)kind, (CharSequence)"custom");
        }

        private final void retrieveTriggers(CassModSchema schema) {
            CassModTable t;
            Object element$iv;
            this.progress("triggers");
            Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingFamily namingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"schema.tables");
            Object $receiver$iv = namingFamily;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                CassModTable cassModTable = t = (CassModTable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModTable, (String)"t");
                NamingFamily namingFamily2 = cassModTable.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"t.triggers");
                it.invoke((Object)namingFamily2);
            }
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassandraIntroQueries.OneTrigger> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveTriggers());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveTriggers)");
            Iterable $receiver$iv2 = list;
            for (Object element$iv2 : $receiver$iv2) {
                String $i$f$forEach;
                String it2;
                CassModTable table;
                CassandraIntroQueries.OneTrigger t2 = (CassandraIntroQueries.OneTrigger)element$iv2;
                NamingFamily namingFamily3 = schema.getTables();
                String string = t2.table_name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((CassModTable)namingFamily3.get(string) == null) {
                    continue;
                }
                NamingFamily namingFamily4 = table.getTriggers();
                String string2 = t2.name;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                CassModTrigger trigger = (CassModTrigger)namingFamily4.createOrGet(string2);
                String string3 = t2.options;
                if (string3 == null || (string3 = CassandraIntrospectorHelper.INSTANCE.getValue(it2 = ($i$f$forEach = string3), "class")) == null) continue;
                it2 = $i$f$forEach = string3;
                CassModTrigger cassModTrigger = trigger;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModTrigger, (String)"trigger");
                cassModTrigger.setClassName(it2);
            }
            it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingFamily namingFamily5 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily5, (String)"schema.tables");
            $receiver$iv = namingFamily5;
            iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                CassModTable cassModTable = t = (CassModTable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModTable, (String)"t");
                NamingFamily namingFamily6 = cassModTable.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily6, (String)"t.triggers");
                it.invoke((Object)namingFamily6);
            }
        }

        private final void retrieveFunctions(CassModSchema schema) {
            if (!CassandraIntrospector.this.getServerVersion().isOrGreater(new int[]{2, 2})) {
                return;
            }
            this.progress("functions");
            Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingIdentifyingFamily namingIdentifyingFamily = schema.getFunctions();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.functions");
            it.invoke((Object)namingIdentifyingFamily);
            it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getFunctions();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.functions");
            it.invoke((Object)namingIdentifyingFamily2);
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassandraIntroQueries.OneFunction> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveFunctions());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveFunctions)");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                CassModFunction function2;
                CassandraIntroQueries.OneFunction f = (CassandraIntroQueries.OneFunction)element$iv;
                CassModFunction cassModFunction = function2 = (CassModFunction)schema.getFunctions().createNewOne();
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModFunction, (String)"function");
                String string = f.name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                cassModFunction.setName(string);
                CassandraIntroQueries.OneFunction oneFunction = f;
                Intrinsics.checkExpressionValueIsNotNull((Object)oneFunction, (String)"f");
                this.processFunction(oneFunction, function2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processFunction(CassandraIntroQueries.OneFunction f, CassModFunction function2) {
            String string = f.return_type;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            DataType dataType = this.getDataType(string, true);
            if (dataType != null) {
                DataType dataType2;
                DataType it = dataType2 = dataType;
                this.setReturnType(function2, it);
            }
            if (f.argument_names == null) {
                Intrinsics.throwNpe();
            }
            String[] $receiver$iv = f.argument_names;
            int index$iv = 0;
            for (String item$iv : $receiver$iv) {
                DataType dataType3;
                void argumentName;
                int n = index$iv++;
                String string2 = item$iv;
                int index2 = n;
                CassModArgument argument = (CassModArgument)function2.getArguments().renewAt((short)(index2 + 2), (String)argumentName);
                if (f.argument_types == null) {
                    Intrinsics.throwNpe();
                }
                if (this.getDataType(f.argument_types[index2], true) == null) continue;
                DataType it = dataType3;
                CassModArgument cassModArgument = argument;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModArgument, (String)"argument");
                cassModArgument.setDataType(it);
            }
            function2.setCalledOnNullInput(f.called_on_null_input);
            function2.setLanguage(f.language);
            ((BasicModModel)function2.getModel()).writeSources(new Runnable(function2, f){
                final /* synthetic */ CassModFunction $function;
                final /* synthetic */ CassandraIntroQueries.OneFunction $f;

                public final void run() {
                    String string = this.$f.body;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$function.setSourceText(BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT));
                }
                {
                    this.$function = cassModFunction;
                    this.$f = oneFunction;
                }
            });
        }

        private final void setReturnType(CassModRoutine routine, DataType returnDataType) {
            CassModArgument argument;
            CassModArgument cassModArgument = argument = (CassModArgument)routine.getArguments().renewAt((short)1, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)cassModArgument, (String)"argument");
            cassModArgument.setDataType(returnDataType);
            argument.setArgumentDirection(DasArgument.Direction.RETURN);
        }

        private final DataType getDataType(String validator, boolean unwrapFrozen) {
            String string;
            if (CassandraIntrospector.this.getServerVersion().isOrGreater(new int[]{3, 0})) {
                string = validator;
            } else {
                string = CassandraIntrospectorHelper.INSTANCE.parseDataType(validator);
                if (string == null) {
                    return null;
                }
            }
            String specification = string;
            return DataTypeFactory.of(unwrapFrozen ? this.unwrapFrozen(specification) : specification);
        }

        static /* synthetic */ DataType getDataType$default(CassandraSchemaRetriever cassandraSchemaRetriever, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return cassandraSchemaRetriever.getDataType(string, bl);
        }

        private final String unwrapFrozen(String s) {
            if (StringsKt.startsWith$default((String)s, (String)"frozen<", (boolean)false, (int)2, null)) {
                String string = s;
                int n = "frozen<".length();
                int n2 = s.length() - 1;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
            return s;
        }

        private final void retrieveAggregates(CassModSchema schema) {
            if (!CassandraIntrospector.this.getServerVersion().isOrGreater(new int[]{2, 2})) {
                return;
            }
            this.progress("aggregates");
            Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingIdentifyingFamily namingIdentifyingFamily = schema.getAggregates();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.aggregates");
            it.invoke((Object)namingIdentifyingFamily);
            it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getAggregates();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.aggregates");
            it.invoke((Object)namingIdentifyingFamily2);
            String string = schema.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schema.name");
            Map<String, String> initConditions = this.getAggregateInitConditions(string);
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassandraIntroQueries.OneAggregate> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveAggregate());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveAggregate)");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                CassModAggregate aggregate;
                CassandraIntroQueries.OneAggregate a = (CassandraIntroQueries.OneAggregate)element$iv;
                CassModAggregate cassModAggregate = aggregate = (CassModAggregate)schema.getAggregates().createNewOne();
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModAggregate, (String)"aggregate");
                String string2 = a.name;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                cassModAggregate.setName(string2);
                CassandraIntroQueries.OneAggregate oneAggregate = a;
                Intrinsics.checkExpressionValueIsNotNull((Object)oneAggregate, (String)"a");
                this.processAggregate(oneAggregate, aggregate, initConditions);
            }
        }

        private final Map<String, String> getAggregateInitConditions(String keyspace) {
            DatabaseConnection databaseConnection = CassandraIntrospector.this.getDbConnection();
            RemoteConnection connection2 = (RemoteConnection)RemoteUtil.castToRemote((Object)(databaseConnection != null ? databaseConnection.getJdbcConnection() : null), RemoteConnection.class);
            if (connection2 == null || !(connection2 instanceof RemoteCassandraConnection)) {
                return null;
            }
            try {
                return ((RemoteCassandraConnection)connection2).getAggregateInitConditions(keyspace);
            }
            catch (NoSuchObjectException e) {
                CassandraIntrospector.this.LOG.error((Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processAggregate(CassandraIntroQueries.OneAggregate a, CassModAggregate aggregate, Map<String, String> initConditions) {
            block5: {
                DataType dataType;
                String string = a.return_type;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                DataType dataType2 = this.getDataType(string, true);
                if (dataType2 != null) {
                    DataType it = dataType = dataType2;
                    this.setReturnType(aggregate, it);
                }
                if (a.signature == null) {
                    Intrinsics.throwNpe();
                }
                String[] $receiver$iv = a.signature;
                int index$iv = 0;
                for (String item$iv : $receiver$iv) {
                    void type;
                    CassModArgument argument;
                    int n = index$iv++;
                    String string2 = item$iv;
                    int index2 = n;
                    CassModArgument cassModArgument = argument = (CassModArgument)aggregate.getArguments().renewAt((short)(index2 + 2), "");
                    Intrinsics.checkExpressionValueIsNotNull((Object)cassModArgument, (String)"argument");
                    cassModArgument.setDataType(DataTypeFactory.of(this.unwrapFrozen((String)type)));
                }
                aggregate.setFinalFunc(a.final_func);
                aggregate.setStateFunc(a.state_func);
                aggregate.setInitCond(this.getInitCondition(initConditions, a));
                String string3 = a.state_type;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                DataType dataType3 = this.getDataType(string3, true);
                if (dataType3 == null) break block5;
                DataType it = dataType = dataType3;
                aggregate.setStateType(it);
            }
        }

        private final String getInitCondition(Map<String, String> initConditions, CassandraIntroQueries.OneAggregate a) {
            if (initConditions == null) {
                return "???";
            }
            StringBuilder stringBuilder = new StringBuilder().append(a.name).append('(');
            if (a.signature == null) {
                Intrinsics.throwNpe();
            }
            String signature2 = stringBuilder.append(ArraysKt.joinToString$default((Object[])a.signature, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
                final /* synthetic */ CassandraSchemaRetriever this$0;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return CassandraSchemaRetriever.access$unwrapFrozen(this.this$0, it);
                }
                {
                    this.this$0 = cassandraSchemaRetriever;
                    super(1);
                }
            }), (int)31, null)).append(')').toString();
            return initConditions.get(signature2);
        }

        private final void retrieveDefTypes(CassModSchema schema) {
            this.progress("types");
            Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingIdentifyingFamily namingIdentifyingFamily = schema.getDefTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.defTypes");
            it.invoke((Object)namingIdentifyingFamily);
            this.getPreprocessor().setFreeParameters(schema.getName());
            List<CassandraIntroQueries.OneDefType> list = this.performQuery(CassandraIntroQueries.Companion.getQUERIES().getRetrieveDefTypes());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(QUERIES.retrieveDefTypes)");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                CassandraIntroQueries.OneDefType t = (CassandraIntroQueries.OneDefType)element$iv;
                NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getDefTypes();
                String string = t.name;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                CassModDefType objectType = (CassModDefType)namingIdentifyingFamily2.createOrGet(string);
                CassandraIntroQueries.OneDefType oneDefType = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)oneDefType, (String)"t");
                CassModDefType cassModDefType = objectType;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModDefType, (String)"objectType");
                this.processDefType(oneDefType, cassModDefType);
            }
            it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingIdentifyingFamily namingIdentifyingFamily3 = schema.getDefTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.defTypes");
            it.invoke((Object)namingIdentifyingFamily3);
        }

        /*
         * WARNING - void declaration
         */
        private final void processDefType(CassandraIntroQueries.OneDefType t, CassModDefType objectType) {
            if (t.field_names == null) {
                Intrinsics.throwNpe();
            }
            String[] $receiver$iv = t.field_names;
            int index$iv = 0;
            for (String item$iv : $receiver$iv) {
                DataType dataType;
                void objectTypeName;
                int n = index$iv++;
                String string = item$iv;
                int index2 = n;
                CassModDefTypeAttribute attribute = (CassModDefTypeAttribute)objectType.getAttributes().renewAt((short)(index2 + 1), (String)objectTypeName);
                if (t.field_types == null) {
                    Intrinsics.throwNpe();
                }
                if (CassandraSchemaRetriever.getDataType$default(this, t.field_types[index2], false, 2, null) == null) continue;
                DataType it = dataType;
                CassModDefTypeAttribute cassModDefTypeAttribute = attribute;
                Intrinsics.checkExpressionValueIsNotNull((Object)cassModDefTypeAttribute, (String)"attribute");
                cassModDefTypeAttribute.setDataType(it);
            }
        }

        public CassandraSchemaRetriever(@NotNull DBTransaction transaction, CassSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)CassandraIntrospector.this, transaction, (BasicSchema)schema);
            this.setVersionParameters(this.getQueryParameters());
        }

        public static final /* synthetic */ void access$retrieveTables(CassandraSchemaRetriever $this, @NotNull CassModSchema schema) {
            $this.retrieveTables(schema);
        }

        public static final /* synthetic */ void access$retrieveMatViews(CassandraSchemaRetriever $this, @NotNull CassModSchema schema) {
            $this.retrieveMatViews(schema);
        }

        public static final /* synthetic */ void access$retrieveColumns(CassandraSchemaRetriever $this, @NotNull CassModSchema schema) {
            $this.retrieveColumns(schema);
        }

        public static final /* synthetic */ void access$retrieveIndices(CassandraSchemaRetriever $this, @NotNull CassModSchema schema) {
            $this.retrieveIndices(schema);
        }

        public static final /* synthetic */ void access$retrieveTriggers(CassandraSchemaRetriever $this, @NotNull CassModSchema schema) {
            $this.retrieveTriggers(schema);
        }

        public static final /* synthetic */ void access$retrieveFunctions(CassandraSchemaRetriever $this, @NotNull CassModSchema schema) {
            $this.retrieveFunctions(schema);
        }

        public static final /* synthetic */ void access$retrieveAggregates(CassandraSchemaRetriever $this, @NotNull CassModSchema schema) {
            $this.retrieveAggregates(schema);
        }

        public static final /* synthetic */ void access$retrieveDefTypes(CassandraSchemaRetriever $this, @NotNull CassModSchema schema) {
            $this.retrieveDefTypes(schema);
        }

        public static final /* synthetic */ void access$processColumns3(CassandraSchemaRetriever $this, @NotNull CassModSchema schema, @Nullable String tableName, @NotNull List columns) {
            $this.processColumns3(schema, tableName, columns);
        }

        public static final /* synthetic */ void access$processColumns2(CassandraSchemaRetriever $this, @NotNull CassModSchema schema, @Nullable String tableName, @NotNull List columns) {
            $this.processColumns2(schema, tableName, columns);
        }

        public static final /* synthetic */ void access$processIndex(CassandraSchemaRetriever $this, @NotNull CassModSchema schema, @NotNull String tableName, @NotNull String indexName, @NotNull List columns) {
            $this.processIndex(schema, tableName, indexName, columns);
        }

        @NotNull
        public static final /* synthetic */ String access$unwrapFrozen(CassandraSchemaRetriever $this, @NotNull String s) {
            return $this.unwrapFrozen(s);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntrospector$CassandraSchemaRetriever$ColumnSorter;", "", "columns", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntroQueries$OneColumn;", "(Lcom/intellij/database/dialects/cassandra/introspector/CassandraIntrospector$CassandraSchemaRetriever;Ljava/util/List;)V", "clusteringColsCount", "", "partitionColsCount", "regularColumnsCount", "idx", "", "c", "intellij.database.dialects"})
        private final class ColumnSorter {
            private final int partitionColsCount;
            private final int clusteringColsCount;
            private int regularColumnsCount;

            public final short idx(@NotNull CassandraIntroQueries.OneColumn c2) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c");
                switch (CassandraIntrospector$CassandraSchemaRetriever$ColumnSorter$WhenMappings.$EnumSwitchMapping$0[c2.getK().ordinal()]) {
                    case 1: {
                        n = c2.getPos();
                        break;
                    }
                    case 2: {
                        n = c2.getPos() + this.partitionColsCount;
                        break;
                    }
                    default: {
                        int n2 = this.regularColumnsCount;
                        this.regularColumnsCount = n2 + 1;
                        n = this.partitionColsCount + this.clusteringColsCount + n2;
                    }
                }
                return (short)(1 + n);
            }

            public ColumnSorter(List<? extends CassandraIntroQueries.OneColumn> columns) {
                int n;
                int n2;
                int count$iv;
                int n3;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
                Iterable iterable = columns;
                ColumnSorter columnSorter = this;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    n3 = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $receiver$iv) {
                        CassandraIntroQueries.OneColumn it = (CassandraIntroQueries.OneColumn)element$iv;
                        if (!(it.getK() == CassandraIntroQueries.ColumnKind.PARTITIONING) || (it = ++count$iv) >= 0) continue;
                        throw (Throwable)new ArithmeticException("Count overflow has happened.");
                    }
                    n3 = count$iv;
                }
                columnSorter.partitionColsCount = n2 = n3;
                $receiver$iv = columns;
                columnSorter = this;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    n = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $receiver$iv) {
                        int n4;
                        CassandraIntroQueries.OneColumn it = (CassandraIntroQueries.OneColumn)element$iv;
                        if (!(it.getK() == CassandraIntroQueries.ColumnKind.CLUSTERING) || (n4 = ++count$iv) >= 0) continue;
                        throw (Throwable)new ArithmeticException("Count overflow has happened.");
                    }
                    n = count$iv;
                }
                columnSorter.clusteringColsCount = n2 = n;
            }
        }
    }
}

