/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.hsql.model.HsqlMetaModel;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HsqlDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final HsqlDialect INSTANCE = new HsqlDialect();

    protected HsqlDialect() {
        super(new TypeHelper.HSQLTypeHelper(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = HsqlMetaModel.MODEL;
        if (basicMetaModel == null) {
            HsqlDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.HSQL;
        if (dbms == null) {
            HsqlDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Hsqldb;
        if (icon == null) {
            HsqlDialect.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("HSQLDB" == null) {
            HsqlDialect.$$$reportNull$$$0(3);
        }
        return "HSQLDB";
    }

    @Override
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            HsqlDialect.$$$reportNull$$$0(4);
        }
        return "x" + super.getBinaryLiteralString(binaryData);
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            HsqlDialect.$$$reportNull$$$0(5);
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("HSQL");
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return true;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        if (system == null) {
            HsqlDialect.$$$reportNull$$$0(6);
        }
        if (connection2 == null) {
            HsqlDialect.$$$reportNull$$$0(7);
        }
        Map<String, Object> rs = DbImplUtil.resultRowAsMap(connection2, "select current_catalog d, current_schema s from (values (1))", new String[0]);
        String d2 = (String)ObjectUtils.tryCast((Object)rs.get("D"), String.class);
        String s = (String)ObjectUtils.tryCast((Object)rs.get("S"), String.class);
        return StringUtil.isEmpty((String)s) || StringUtil.isEmpty((String)d2) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)d2, (ObjectKind)ObjectKind.DATABASE).append(s, ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            HsqlDialect.$$$reportNull$$$0(8);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", this.quoteIdentifier(current.getName(), false, false));
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> getSupportedFkDeferrable() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class);
        if (valuesCapability == null) {
            HsqlDialect.$$$reportNull$$$0(9);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            HsqlDialect.$$$reportNull$$$0(10);
        }
        if (view == null) {
            HsqlDialect.$$$reportNull$$$0(11);
        }
        if (definition == null) {
            HsqlDialect.$$$reportNull$$$0(12);
        }
        if (checkOption == null) {
            HsqlDialect.$$$reportNull$$$0(13);
        }
        builder.keywords("CREATE", "VIEW").space();
        builder.qualifiedRef((DasObject)view);
        JBIterable columns = view.getDasChildren(ObjectKind.COLUMN);
        if (!columns.isEmpty()) {
            builder.symbol("(");
            int offset = builder.length();
            for (DasObject column2 : columns) {
                if (builder.length() != offset) {
                    builder.symbol(", ");
                }
                builder.identifier(column2);
            }
            builder.symbol(")");
        }
        builder.space().keyword("AS").space();
        builder.plain(definition);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqlDialect.$$$reportNull$$$0(14);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            HsqlDialect.$$$reportNull$$$0(15);
        }
        if (sequence == null) {
            HsqlDialect.$$$reportNull$$$0(16);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "SEQUENCE").space().qualifiedRef(sequence);
        if (ddlBuilder == null) {
            HsqlDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            HsqlDialect.$$$reportNull$$$0(18);
        }
        if (view == null) {
            HsqlDialect.$$$reportNull$$$0(19);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "VIEW").space().qualifiedRef((DasObject)view);
        if (ddlBuilder == null) {
            HsqlDialect.$$$reportNull$$$0(20);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            HsqlDialect.$$$reportNull$$$0(21);
        }
        String templateStr = "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = ''{0}'' and TABLE_SCHEMA = ''{1}'' ";
        return Pair.create((Object)MessageFormat.format(templateStr, element2.getName(), DasUtil.getSchema((DasObject)element2)), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            HsqlDialect.$$$reportNull$$$0(22);
        }
        String templateStr = "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = ''{0}'' and ROUTINE_SCHEMA = ''{1}'' ";
        Pair pair = Pair.create((Object)MessageFormat.format(templateStr, element2.getName(), DasUtil.getSchema((DasObject)element2)), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            HsqlDialect.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        char c0;
        if (identifier == null) {
            HsqlDialect.$$$reportNull$$$0(24);
        }
        if (!Character.isLetter(c0 = identifier.charAt(0)) && c0 != '$' && c0 != '#') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c2 = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '$' || c2 == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            HsqlDialect.$$$reportNull$$$0(25);
        }
        if (qualifier == null) {
            HsqlDialect.$$$reportNull$$$0(26);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            HsqlDialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            HsqlDialect.$$$reportNull$$$0(28);
        }
        if (statement == null) {
            HsqlDialect.$$$reportNull$$$0(29);
        }
        if (analyze) {
            throw new UnsupportedOperationException("HSQLDB does not support EXPLAIN ANALYZE");
        }
        builder.keywords("explain", "plan", "for").space();
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            HsqlDialect.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/hsql/HsqlDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/hsql/HsqlDialect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDeferrable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

