/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTsqlDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected AbstractTsqlDialect(TypeHelper typeHelper, Casing casing) {
        super(typeHelper, casing);
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> getSupportedFkDeferrable() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class);
        if (valuesCapability == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(0);
        }
        return valuesCapability;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        char c0;
        if (identifier == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(1);
        }
        if (!Character.isLetter(c0 = identifier.charAt(0)) && c0 != '_' && c0 != '#') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c2 = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '$' || c2 == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(2);
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 2, false);
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(3);
        }
        if (view == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(4);
        }
        if (definition == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(5);
        }
        if (checkOption == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(6);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewWithCheckOptionSQL(builder, view, definition, checkOption);
        if (ddlBuilder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(8);
        }
        if (sequence == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(10);
        }
        if (view == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(11);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, null);
        if (ddlBuilder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(12);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.DATABASE;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        Map<String, Object> map;
        Object db;
        if (system == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(13);
        }
        if (connection2 == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(14);
        }
        return (db = (map = DbImplUtil.resultRowAsMap(connection2, "select db_name() as a", new String[0])).get("a")) == null ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)db.toString(), (ObjectKind)ObjectKind.DATABASE));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(15);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.DATABASE) {
            return null;
        }
        return String.format("use %s", this.quoteIdentifier(current.getName(), false, false));
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(16);
        }
        String string = "0x" + DialectUtils.toHexString(binaryData);
        if (string == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    protected AbstractDatabaseDialect.LimitPlace getPlaceForLimit(@Nullable DasDataSource system) {
        AbstractDatabaseDialect.LimitPlace limitPlace = AbstractDatabaseDialect.LimitPlace.BEGIN;
        if (limitPlace == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(18);
        }
        return limitPlace;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DasDataSource system, int rows) {
        if (builder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(19);
        }
        DdlBuilder ddlBuilder = AbstractTsqlDialect.top(builder, "TOP", rows);
        if (ddlBuilder == null) {
            AbstractTsqlDialect.$$$reportNull$$$0(20);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/AbstractTsqlDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDeferrable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/AbstractTsqlDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForLimit";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLimit";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendLimit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

