/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BinaryMaxDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Float1Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IdentityDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.ReadOnlyDomain;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextMaxDomain;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ms05Domains
extends DomainRegistry {
    static final int TS_FRACTION = 3;
    private static final int MAX_BINARY = 8000;
    private static final int MAX_PRECISION = 38;
    private static final int MAX_CHAR = 4000;
    private static final long MAX_TEXT = 0x3FFFFFFFL;
    private static final int MONEY_PRECISION = 19;
    private static final int SMALLMONEY_PRECISION = 10;
    private static final int MONEY_SCALE = 4;

    public Ms05Domains() {
        super(Dbms.MSSQL);
        this.add(new Float1Domain("float", ConversionPoint.SINGLE_PRECISION, new DomainRegistry.Limits(new DomainRegistry.Limit(24, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE)), new DomainRegistry.Limit(53, -1.7976931348623157E308, Double.MAX_VALUE))));
        this.add(new ReadOnlyDomain(new BinaryDomain("timestamp", ConversionPoint.BINARY, 8L)));
        this.add(new BinaryMaxDomain("binary", ConversionPoint.BINARY, Integer.MAX_VALUE, 8000L, 1L));
        this.add(new BinaryMaxDomain("varbinary", ConversionPoint.VARBINARY, Integer.MAX_VALUE, 8000L, 1L));
        this.add(new BinaryDomain("image", ConversionPoint.GRAPHIC, Integer.MAX_VALUE));
        this.add(new BooleanDomain("bit", ConversionPoint.BOOLEAN));
        this.add(new IdentityDomain(new IntegerDomain("int", ConversionPoint.SERIAL_NUMBER, -2.147483648E9, 2.147483647E9)));
        this.add(new IdentityDomain(new IntegerDomain("smallint", ConversionPoint.SERIAL_NUMBER, -32768.0, 32767.0)));
        this.add(new IdentityDomain(new IntegerDomain("tinyint", ConversionPoint.SERIAL_NUMBER, -128.0, 127.0)));
        this.add(new IdentityDomain(new IntegerDomain("bigint", ConversionPoint.SERIAL_NUMBER, -9.223372036854776E18, 9.223372036854776E18)));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add(new Number2Domain("dec", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add(new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add(new IdentityDomain(new Number2Domain("decimal", ConversionPoint.SERIAL_NUMBER, 38, 0, true)));
        this.add(new IdentityDomain(new Number2Domain("dec", ConversionPoint.SERIAL_NUMBER, 38, 0, true)));
        this.add(new IdentityDomain(new Number2Domain("numeric", ConversionPoint.SERIAL_NUMBER, 38, 0, true)));
        this.add(new Number2Domain("smallmoney", ConversionPoint.MONEY, 10, 4, false));
        this.add(new Number2Domain("money", ConversionPoint.MONEY, 19, 4, false));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new TextDomain("ntext", ConversionPoint.NTEXT, 0x3FFFFFFFL));
        this.add(new SimpleDomain("uniqueidentifier", ConversionPoint.UUID, PhysicalDomainType.TEXT));
        this.add(new TextDomain("nchar", ConversionPoint.NCHAR, 4000L, 1L, true));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 4000L, 1L, true));
        this.add(new TextMaxDomain("varchar", ConversionPoint.VARCHAR, Integer.MAX_VALUE, 8000L, 1L));
        this.add(new TextMaxDomain("nvarchar", ConversionPoint.NVARCHAR, Integer.MAX_VALUE, 8000L, 1L));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE));
        this.add(new FractionDomain("datetime", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 3));
    }

    @Override
    public boolean isSuitable(@NotNull Dbms dbms, @Nullable Version productVersion) {
        if (dbms == null) {
            Ms05Domains.$$$reportNull$$$0(0);
        }
        return dbms.isMicrosoft() && (productVersion == null || !DataSourceUiUtil.isMsSql2008(productVersion));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dialects/mssql/Ms05Domains", "isSuitable"));
    }
}

