/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dialects.mssql.Ms05Domains;
import com.intellij.database.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ms08Domains
extends Ms05Domains {
    private static final int MAX_TIME_FRACTION = 7;

    public Ms08Domains() {
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 7, 7, true));
        this.add(new FractionDomain("datetime2", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 3));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
    }

    @Override
    public boolean isSuitable(@NotNull Dbms dbms, @Nullable Version productVersion) {
        if (dbms == null) {
            Ms08Domains.$$$reportNull$$$0(0);
        }
        return dbms.isMicrosoft() && productVersion != null && DataSourceUiUtil.isMsSql2008(productVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dialects/mssql/Ms08Domains", "isSuitable"));
    }
}

