/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ssrp;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dialects.mssql.ssrp.SsrpConstants;
import com.intellij.database.dialects.mssql.ssrp.SsrpInfo;
import com.intellij.database.dialects.mssql.ssrp.SsrpNet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.SofterReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.WeakList;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpInfoCache {
    private static final SsrpInfoCache INSTANCE = new SsrpInfoCache();
    public static final Function<Ref<String>, String> DEREF = ref -> (String)ref.get();
    public static final Condition<String> HOST_FILTER = s -> !StringUtil.isEmptyOrSpaces((String)s);
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);
    private SofterReference<SsrpInfo> myInfo;
    private final WeakList<Ref<String>> myHosts = new WeakList();
    private boolean myQueued;
    private final Task.Backgroundable myUpdateTask = new MyBaseTask("Discovering Reachable SQL Server Instances"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                1.$$$reportNull$$$0(0);
            }
            try {
                Set<SsrpNet.Response> responses = SsrpNet.queryNetworkInstances(1434, 5000);
                SsrpInfo info = new SsrpInfo();
                for (SsrpNet.Response resp : responses) {
                    info.merge(resp);
                }
                THashSet hosts = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                JBIterable.from((Iterable)SsrpInfoCache.this.myHosts.toStrongList()).transform(DEREF).filter(HOST_FILTER).addAllTo((Collection)hosts);
                responses = SsrpNet.queryNetworkInstances((Set<String>)hosts, 1434, 5000);
                for (SsrpNet.Response resp : responses) {
                    info.merge(resp);
                }
                SsrpInfoCache ssrpInfoCache = INSTANCE;
                synchronized (ssrpInfoCache) {
                    INSTANCE.myInfo = new SofterReference((Object)info);
                }
                ((Listener)SsrpInfoCache.this.myDispatcher.getMulticaster()).consume(null);
            }
            catch (SsrpConstants.SsrpException e) {
                ((Listener)SsrpInfoCache.this.myDispatcher.getMulticaster()).consume(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mssql/ssrp/SsrpInfoCache$1", "run"));
        }
    };

    private SsrpInfoCache() {
    }

    public static void addListener(@NotNull Listener listener, @NotNull Disposable parent2) {
        if (listener == null) {
            SsrpInfoCache.$$$reportNull$$$0(0);
        }
        if (parent2 == null) {
            SsrpInfoCache.$$$reportNull$$$0(1);
        }
        SsrpInfoCache.INSTANCE.myDispatcher.addListener((EventListener)listener, parent2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SsrpInfo get() {
        SsrpInfoCache ssrpInfoCache = INSTANCE;
        synchronized (ssrpInfoCache) {
            return SsrpInfoCache.INSTANCE.myInfo == null ? null : (SsrpInfo)SsrpInfoCache.INSTANCE.myInfo.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static Ref<String> addHost() {
        SsrpInfoCache ssrpInfoCache = INSTANCE;
        // MONITORENTER : ssrpInfoCache
        Ref result2 = Ref.create();
        SsrpInfoCache.INSTANCE.myHosts.add((Object)result2);
        Ref ref = result2;
        // MONITOREXIT : ssrpInfoCache
        if (ref != null) return ref;
        SsrpInfoCache.$$$reportNull$$$0(2);
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateHost(boolean async, @NotNull String host) {
        if (host == null) {
            SsrpInfoCache.$$$reportNull$$$0(3);
        }
        SsrpInfoCache ssrpInfoCache = INSTANCE;
        synchronized (ssrpInfoCache) {
            if (SsrpInfoCache.INSTANCE.myQueued) {
                return;
            }
            SsrpInfoCache.INSTANCE.myQueued = true;
        }
        MyHostUpdater updater = new MyHostUpdater(host);
        if (async) {
            DataSourceUiUtil.runAsyncWithCorrectModality(updater);
        } else {
            DataSourceUiUtil.runSynchronously((Task)updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(boolean async) {
        SsrpInfoCache ssrpInfoCache = INSTANCE;
        synchronized (ssrpInfoCache) {
            if (SsrpInfoCache.INSTANCE.myQueued) {
                return;
            }
            SsrpInfoCache.INSTANCE.myQueued = true;
        }
        if (async) {
            DataSourceUiUtil.runAsyncWithCorrectModality(SsrpInfoCache.INSTANCE.myUpdateTask);
        } else {
            DataSourceUiUtil.runSynchronously((Task)SsrpInfoCache.INSTANCE.myUpdateTask);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/ssrp/SsrpInfoCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/ssrp/SsrpInfoCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateHost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener
    extends EventListener,
    Consumer<SsrpConstants.SsrpException> {
    }

    private static abstract class MyBaseTask
    extends Task.Backgroundable {
        MyBaseTask(@NotNull String title) {
            if (title == null) {
                MyBaseTask.$$$reportNull$$$0(0);
            }
            super(null, title, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCancel() {
            SsrpInfoCache ssrpInfoCache = INSTANCE;
            synchronized (ssrpInfoCache) {
                INSTANCE.myQueued = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess() {
            SsrpInfoCache ssrpInfoCache = INSTANCE;
            synchronized (ssrpInfoCache) {
                INSTANCE.myQueued = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/dialects/mssql/ssrp/SsrpInfoCache$MyBaseTask", "<init>"));
        }
    }

    private static class MyHostUpdater
    extends MyBaseTask {
        private final String myHost;

        MyHostUpdater(@NotNull String host) {
            if (host == null) {
                MyHostUpdater.$$$reportNull$$$0(0);
            }
            super("Discovering Instances on " + host);
            this.myHost = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyHostUpdater.$$$reportNull$$$0(1);
            }
            try {
                SsrpNet.Response resp = SsrpNet.queryInstances(this.myHost, 1434, 5000);
                SsrpInfo info = new SsrpInfo(SsrpInfoCache.get(), SsrpInfo.extractServers(resp.response));
                info.merge(resp);
                SsrpInfoCache ssrpInfoCache = INSTANCE;
                synchronized (ssrpInfoCache) {
                    INSTANCE.myInfo = new SofterReference((Object)info);
                }
                ((Listener)INSTANCE.myDispatcher.getMulticaster()).consume(null);
            }
            catch (SsrpConstants.SsrpException e) {
                ((Listener)INSTANCE.myDispatcher.getMulticaster()).consume(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/mssql/ssrp/SsrpInfoCache$MyHostUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

