/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.mysql.model.MysqlMetaModel;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final MysqlDialect INSTANCE = new MysqlDialect();

    public MysqlDialect() {
        super(new TypeHelper.MySQLTypeHelper(), Casing.create((Case)Case.LOWER, (Case)Case.LOWER));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = MysqlMetaModel.MODEL;
        if (basicMetaModel == null) {
            MysqlDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public String getDisplayName() {
        if ("MySQL" == null) {
            MysqlDialect.$$$reportNull$$$0(1);
        }
        return "MySQL";
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MYSQL;
        if (dbms == null) {
            MysqlDialect.$$$reportNull$$$0(2);
        }
        return dbms;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Mysql;
        if (icon == null) {
            MysqlDialect.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            MysqlDialect.$$$reportNull$$$0(4);
        }
        return kind == ObjectKind.SCHEDULED_EVENT ? "EVENT" : super.getNameForKind(kind);
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            MysqlDialect.$$$reportNull$$$0(5);
        }
        if (identifier.isEmpty() || !Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '$' || i2 > 0 && c2 == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(6);
        }
        if (view == null) {
            MysqlDialect.$$$reportNull$$$0(7);
        }
        if (definition == null) {
            MysqlDialect.$$$reportNull$$$0(8);
        }
        if (checkOption == null) {
            MysqlDialect.$$$reportNull$$$0(9);
        }
        builder.keywords("CREATE", "OR", "REPLACE", "VIEW").space();
        builder.qualifiedRef((DasObject)view).space();
        builder.keyword("AS").space();
        builder.plain(definition).space();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(10);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(11);
        }
        if (view == null) {
            MysqlDialect.$$$reportNull$$$0(12);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, cascade);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            MysqlDialect.$$$reportNull$$$0(14);
        }
        return Pair.create((Object)("SELECT view_definition FROM information_schema.views WHERE table_name = '" + element2.getName() + "' AND table_schema = '" + MysqlDialect.getDBName(element2) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            MysqlDialect.$$$reportNull$$$0(15);
        }
        Pair pair = Pair.create((Object)("SELECT routine_definition FROM information_schema.routines WHERE routine_name = '" + element2.getName() + "' AND routine_schema = '" + MysqlDialect.getDBName((DasObject)element2) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlDialect.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine procedure, @NotNull DatabaseConnection connection2) throws Exception {
        if (procedure == null) {
            MysqlDialect.$$$reportNull$$$0(17);
        }
        if (connection2 == null) {
            MysqlDialect.$$$reportNull$$$0(18);
        }
        String type = procedure.getRoutineKind().name();
        String query = new DdlBuilder().withDialect(this).qualifyReferences(true).keywords("SHOW", "CREATE", type).space().qualifiedRef((DasObject)procedure).getStatement();
        String string = SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.resultsTransformer(rs -> {
            if (procedure == null) {
                MysqlDialect.$$$reportNull$$$0(60);
            }
            if (!rs.next()) {
                return "-- failed to load definition";
            }
            DdlBuilder builder = new DdlBuilder().withDialect(this).qualifyReferences(true).splitStatements(true);
            this.sqlDropProcedure(builder, procedure).newStatement().plain(rs.getString(3));
            return DialectUtils.sqlConcat(builder.getStatements());
        }, ""));
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(19);
        }
        return string;
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            MysqlDialect.$$$reportNull$$$0(20);
        }
        if (databaseProductName == null || !databaseProductName.trim().toLowerCase(Locale.ENGLISH).startsWith("mysql")) {
            return false;
        }
        return databaseProductVersion.startsWith("5");
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public boolean supportsSystemViewDefinition() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(21);
        }
        if (procedure == null) {
            MysqlDialect.$$$reportNull$$$0(22);
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure(builder, procedure, true);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> getSupportedFkDeferrable() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class);
        if (valuesCapability == null) {
            MysqlDialect.$$$reportNull$$$0(24);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            MysqlDialect.$$$reportNull$$$0(25);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                MysqlDialect.$$$reportNull$$$0(26);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("DOUBLE".equals(typeName) && jdbcType == 8 && precision == 22 && scale == 0) {
            if ("double" == null) {
                MysqlDialect.$$$reportNull$$$0(27);
            }
            return "double";
        }
        if ("MEDIUMINT".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            if ("mediumint" == null) {
                MysqlDialect.$$$reportNull$$$0(28);
            }
            return "mediumint";
        }
        if ("MEDIUMINT UNSIGNED".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            if ("mediumint unsigned" == null) {
                MysqlDialect.$$$reportNull$$$0(29);
            }
            return "mediumint unsigned";
        }
        if ("MEDIUMBLOB".equals(typeName) && jdbcType == -4 && precision == 0xFFFFFF && scale == 0) {
            if ("mediumblob" == null) {
                MysqlDialect.$$$reportNull$$$0(30);
            }
            return "mediumblob";
        }
        if ("TINYBLOB".equals(typeName) && jdbcType == -2 && precision == 255 && scale == 0) {
            if ("tinyblob" == null) {
                MysqlDialect.$$$reportNull$$$0(31);
            }
            return "tinyblob";
        }
        if ("DATETIME".equals(typeName) && jdbcType == 93 && precision == 19 && scale == 0) {
            if ("datetime" == null) {
                MysqlDialect.$$$reportNull$$$0(32);
            }
            return "datetime";
        }
        String name = super.getTypeName(dataType);
        String unsigned = "unsigned";
        String string = StringUtil.endsWithIgnoreCase((String)typeName, (String)unsigned) && !StringUtil.endsWithIgnoreCase((String)name, (String)unsigned) ? name + " " + unsigned : name;
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(34);
        }
        if (sequence == null) {
            MysqlDialect.$$$reportNull$$$0(35);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            MysqlDialect.$$$reportNull$$$0(36);
        }
        DdlBuilder builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
        Pair pair = Pair.create((Object)("SHOW CREATE TABLE " + builder.qualifiedRef(element2).getStatement()), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlDialect.$$$reportNull$$$0(37);
        }
        return pair;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element2, @NotNull DatabaseConnection connection2) throws Exception {
        if (element2 == null) {
            MysqlDialect.$$$reportNull$$$0(38);
        }
        if (connection2 == null) {
            MysqlDialect.$$$reportNull$$$0(39);
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection2, String.format("show table status from `%s` like '%s'", MysqlDialect.getDBName((DasObject)element2), DbImplUtil.escapeStr(element2.getName())), "TABLE_ROWS", "rows", "ENGINE", "engine", "TABLE_COLLATION", "collation", "CREATE_TIME", "created");
        if (map == null) {
            MysqlDialect.$$$reportNull$$$0(40);
        }
        return map;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection2) throws Exception {
        if (table == null) {
            MysqlDialect.$$$reportNull$$$0(41);
        }
        if (connection2 == null) {
            MysqlDialect.$$$reportNull$$$0(42);
        }
        Dbms dbms = connection2.getDbms();
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection2, dbms, (String)pair.first, 2, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(43);
        }
        return string;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            MysqlDialect.$$$reportNull$$$0(44);
        }
        if (connection2 == null) {
            MysqlDialect.$$$reportNull$$$0(45);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection2, dbms = connection2.getDbms(), "select database()", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            MysqlDialect.$$$reportNull$$$0(46);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("use %s", this.quoteIdentifier(current.getDisplayName(), false, false));
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    @NotNull
    private static String getDBName(@NotNull DasObject qualifier) {
        if (qualifier == null) {
            MysqlDialect.$$$reportNull$$$0(47);
        }
        String string = DasUtil.getName((DasObject)MysqlDialect.getDB(qualifier));
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(48);
        }
        return string;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            MysqlDialect.$$$reportNull$$$0(49);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            MysqlDialect.$$$reportNull$$$0(50);
        }
        if (qualifier == null) {
            MysqlDialect.$$$reportNull$$$0(51);
        }
        DasObject db = MysqlDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(52);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            MysqlDialect.$$$reportNull$$$0(53);
        }
        String string = "0x" + DialectUtils.toHexString(binaryData);
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(54);
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(55);
        }
        if (statement == null) {
            MysqlDialect.$$$reportNull$$$0(56);
        }
        if (analyze) {
            throw new UnsupportedOperationException("MYSQL does not support EXPLAIN ANALYZE");
        }
        builder.keywords("explain", "extended").space();
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(57);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection2) throws SQLException {
        if (connection2 == null) {
            MysqlDialect.$$$reportNull$$$0(58);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection2, "SHOW DATABASES", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            MysqlDialect.$$$reportNull$$$0(59);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysql/MysqlDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: 
            case 11: 
            case 21: 
            case 34: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 14: 
            case 15: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 22: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 18: 
            case 39: 
            case 42: 
            case 45: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 47: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysql/MysqlDialect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDeferrable";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getDBName";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getDBName";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryToLoadProcedureDefinition$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

