/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.postgres.introspector.PgIntroQueries;
import com.intellij.database.dialects.postgres.introspector.PgIntrospectorKt;
import com.intellij.database.dialects.postgres.introspector.PostgresIntrospector;
import com.intellij.database.dialects.postgres.introspector.PostgresIntrospector$MySchemaRetriever$retrieveRulesSources$;
import com.intellij.database.dialects.postgres.model.PgDatabase;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgres.model.PgLocalTable;
import com.intellij.database.dialects.postgres.model.PgMatView;
import com.intellij.database.dialects.postgres.model.PgModAccessMethod;
import com.intellij.database.dialects.postgres.model.PgModAggregate;
import com.intellij.database.dialects.postgres.model.PgModCheck;
import com.intellij.database.dialects.postgres.model.PgModCollation;
import com.intellij.database.dialects.postgres.model.PgModDatabase;
import com.intellij.database.dialects.postgres.model.PgModDefType;
import com.intellij.database.dialects.postgres.model.PgModDefTypeCheck;
import com.intellij.database.dialects.postgres.model.PgModExtension;
import com.intellij.database.dialects.postgres.model.PgModForeignDataWrapper;
import com.intellij.database.dialects.postgres.model.PgModForeignServer;
import com.intellij.database.dialects.postgres.model.PgModForeignTable;
import com.intellij.database.dialects.postgres.model.PgModForeignTableColumn;
import com.intellij.database.dialects.postgres.model.PgModIndex;
import com.intellij.database.dialects.postgres.model.PgModKey;
import com.intellij.database.dialects.postgres.model.PgModLikeStoredTable;
import com.intellij.database.dialects.postgres.model.PgModLocalTable;
import com.intellij.database.dialects.postgres.model.PgModMatView;
import com.intellij.database.dialects.postgres.model.PgModModel;
import com.intellij.database.dialects.postgres.model.PgModModelFun;
import com.intellij.database.dialects.postgres.model.PgModOperator;
import com.intellij.database.dialects.postgres.model.PgModRole;
import com.intellij.database.dialects.postgres.model.PgModRoot;
import com.intellij.database.dialects.postgres.model.PgModRoutine;
import com.intellij.database.dialects.postgres.model.PgModRule;
import com.intellij.database.dialects.postgres.model.PgModSchema;
import com.intellij.database.dialects.postgres.model.PgModSequence;
import com.intellij.database.dialects.postgres.model.PgModTable;
import com.intellij.database.dialects.postgres.model.PgModTableColumn;
import com.intellij.database.dialects.postgres.model.PgModTrigger;
import com.intellij.database.dialects.postgres.model.PgModUserMapping;
import com.intellij.database.dialects.postgres.model.PgModView;
import com.intellij.database.dialects.postgres.model.PgModelFun;
import com.intellij.database.dialects.postgres.model.PgRoot;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgView;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBaseKt;
import com.intellij.database.dialects.postgresbase.introspector.PostgresIntrospectorBase;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseModAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseModCatalogObject;
import com.intellij.database.dialects.postgresbase.model.PgBaseModDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseModForeignKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseModKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseModLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseModLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseModOperator;
import com.intellij.database.dialects.postgresbase.model.PgBaseModRoutine;
import com.intellij.database.dialects.postgresbase.model.PgBaseModSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseModTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.IdentifyingFamily;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.PgAccessMethodType;
import com.intellij.database.model.properties.PgAggregateKind;
import com.intellij.database.model.properties.PgCheckOption;
import com.intellij.database.model.properties.PgDataTypeSubCategory;
import com.intellij.database.model.properties.PgDataTypeSubKind;
import com.intellij.database.model.properties.PgFireMode;
import com.intellij.database.model.properties.PgRelation;
import com.intellij.database.model.properties.PgRoutineConcurrencyKind;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.Version;
import com.intellij.util.text.StringKt;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001b2,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0001:\u0004\u001b\u001c\u001d\u001eB\u0007\b\u0016\u00a2\u0006\u0002\u0010\tJ<\u0010\n\u001a6\u0012\u0004\u0012\u00020\f0\u000bR,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\rH\u0014JF\u0010\u000e\u001a00\u000fR,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\u001c\u0010\u0013\u001a\u00060\u0014R\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0007H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0011H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PostgresIntrospector;", "Lcom/intellij/database/dialects/postgresbase/introspector/PostgresIntrospectorBase;", "Lcom/intellij/database/dialects/postgres/model/PgModModel;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgModRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgres/model/PgModDatabase;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "Lcom/intellij/database/dialects/postgres/model/PgModSchema;", "()V", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$IdNameCommentOwner;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PostgresIntrospector$MySchemaRetriever;", "schema", "initConnectionRelatedState", "", "introspectServerObjects", "retrieveRoles", "tran", "Companion", "Factory", "MyDatabaseRetriever", "MySchemaRetriever", "intellij.database.dialects"})
public final class PostgresIntrospector
extends PostgresIntrospectorBase<PgModModel, PgRoot, PgModRoot, PgDatabase, PgModDatabase, PgSchema, PgModSchema> {
    @JvmField
    @NotNull
    public static final PgIntroQueries QUERIES;
    @NotNull
    private static final Map<ObjectKind, String> NATIVE_DEFINITIONS_QUERIES;
    public static final Companion Companion;

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        Companion.setVersionParameters(this.getServerVersion(), this.queryParameters);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<PgBaseIntroQueries.IdNameCommentOwner> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<PgBaseIntroQueries.IdNameCommentOwner>(this){
            final /* synthetic */ PostgresIntrospector this$0;

            @NotNull
            protected List<PgBaseIntroQueries.IdNameCommentOwner> listDatabases(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                return (List)PostgresIntrospector.access$performQuery(this.this$0, tran, PostgresIntrospector.QUERIES.getListDatabases());
            }

            @NotNull
            protected PgModDatabase applyDatabase(@NotNull ModNamingIdentifyingFamily<?> databases, @NotNull PgBaseIntroQueries.IdNameCommentOwner db) {
                Intrinsics.checkParameterIsNotNull(databases, (String)"databases");
                Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                MD MD = this.renew(databases, db.id, db.name);
                PgModDatabase $receiver = (PgModDatabase)MD;
                $receiver.setStateNumber(db.state_number);
                $receiver.setComment(db.description);
                $receiver.setOwner(db.getOwnerName());
                return (PgModDatabase)MD;
            }

            protected boolean shouldUpdateCurrent(@NotNull Iterable<?> databases) {
                Intrinsics.checkParameterIsNotNull(databases, (String)"databases");
                return CollectionsKt.firstOrNull(databases) == null;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Override
    public void introspectServerObjects() {
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){

            public final void invoke(@NotNull DBTransaction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                PostgresIntrospector.access$retrieveRoles((PostgresIntrospector)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(PostgresIntrospector.class);
            }

            public final String getName() {
                return "retrieveRoles";
            }

            public final String getSignature() {
                return "retrieveRoles(Lorg/jetbrains/dekaf/core/DBTransaction;)V";
            }
        }));
    }

    private final void retrieveRoles(DBTransaction tran) {
        List<PgIntroQueries.OneRole> roles = this.performQuery(tran, QUERIES.getRetrieveRoles());
        ((PgModModel)this.getModel()).modify(PgModRoot.class, new ModelModifier<PgModRoot>(roles){
            final /* synthetic */ List $roles;

            public final void perform(PgModRoot it) {
                NamingIdentifyingFamily namingIdentifyingFamily;
                PgModRoot pgModRoot = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgModRoot, (String)"it");
                NamingIdentifyingFamily $receiver = namingIdentifyingFamily = pgModRoot.getRoles();
                $receiver.markChildrenAsSyncPending();
                for (PgIntroQueries.OneRole role : this.$roles) {
                    E e = $receiver.renew(role.role_id, role.role_name);
                    PgModRole $receiver2 = (PgModRole)e;
                    $receiver2.setSuperRole(role.is_super);
                    $receiver2.setInherit(role.is_inherit);
                    $receiver2.setCreateRole(role.can_createrole);
                    $receiver2.setCreateDb(role.can_createdb);
                    $receiver2.setCanLogin(role.can_login);
                    $receiver2.setReplication(role.is_replication);
                    Long l = role.conn_limit;
                    $receiver2.setConnectionLimit(l != null ? l : -1L);
                    $receiver2.setValidUntil(role.valid_until);
                    $receiver2.setBypassRls(role.bypass_rls);
                    Object object = role.config;
                    if (role.config == null || (object = ArraysKt.asList((Object[])object)) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    $receiver2.setConfig((List<String>)object);
                    $receiver2.setComment(role.description);
                }
                $receiver.removeSyncPendingChildren();
                $receiver.sort();
            }
            {
                this.$roles = list;
            }
        });
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.BaseDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull PgDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new MyDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected MySchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull PgSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new MySchemaRetriever(transaction, schema);
    }

    public PostgresIntrospector() {
        Dbms dbms = Dbms.POSTGRES;
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"Dbms.POSTGRES");
        super(dbms, PgModModel.class, PgModRoot.class, PgDatabase.class, PgSchema.class, PgModDatabase.class, PgModSchema.class, QUERIES);
    }

    static {
        Companion = new Companion(null);
        Scriptum scriptum = Scriptum.of(PgIntroQueries.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptum, (String)"Scriptum.of(PgIntroQueries::class.java)");
        QUERIES = new PgIntroQueries(scriptum);
        NATIVE_DEFINITIONS_QUERIES = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ObjectKind.ROUTINE, (Object)"select pg_get_functiondef(?)"), TuplesKt.to((Object)ObjectKind.INDEX, (Object)"select pg_get_indexdef(?)"), TuplesKt.to((Object)ObjectKind.RULE, (Object)"select pg_get_ruledef(?)"), TuplesKt.to((Object)ObjectKind.TRIGGER, (Object)"select pg_get_triggerdef(?)")});
    }

    public static final /* synthetic */ void access$handleErrors(PostgresIntrospector $this, @NotNull String operationName, @NotNull Function0 operation2) {
        $this.handleErrors(operationName, (Function0<Unit>)operation2);
    }

    public static final /* synthetic */ void access$setServerVersion$p(PostgresIntrospector $this, @NotNull Version version) {
        $this.setServerVersion(version);
    }

    public static final /* synthetic */ void access$writeSources(PostgresIntrospector $this, @NotNull Function0 r) {
        $this.writeSources((Function0<Unit>)r);
    }

    public static final /* synthetic */ Object access$performQuery(PostgresIntrospector $this, @NotNull DBTransaction transaction, @NotNull SqlQuery query) {
        return $this.performQuery(transaction, query);
    }

    public static final /* synthetic */ void access$retrieveRoles(PostgresIntrospector $this, @NotNull DBTransaction tran) {
        $this.retrieveRoles(tran);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PostgresIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return version.isOrGreater(new int[]{9});
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            PostgresIntrospector postgresIntrospector;
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
            PostgresIntrospector $receiver = postgresIntrospector = new PostgresIntrospector();
            $receiver.setModelFactory$intellij_database_dialects(modelFactory);
            return postgresIntrospector;
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@NotNull BasicElement e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return PgIntrospectorBaseKt.canCheckOutdated(e);
        }

        @Override
        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative(this);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PostgresIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects"})
        public static final class VERSION
        extends PerObjectVersion {
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0002B\u0015\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J)\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0014H\u0002J\b\u0010!\u001a\u00020\u0014H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0014H\u0002J\b\u0010&\u001a\u00020\u0014H\u0002J\b\u0010'\u001a\u00020\u0014H\u0002J\b\u0010(\u001a\u00020\u0014H\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+H\u0002J8\u0010,\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0302H\u0014J\b\u00104\u001a\u00020\u0014H\u0016J\u0010\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u000207H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PostgresIntrospector$MyDatabaseRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PostgresIntrospectorBase$DatabaseRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PostgresIntrospectorBase;", "Lcom/intellij/database/dialects/postgres/model/PgModModel;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgModRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgres/model/PgModDatabase;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "Lcom/intellij/database/dialects/postgres/model/PgModSchema;", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "(Lcom/intellij/database/dialects/postgres/introspector/PostgresIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgDatabase;)V", "myIncremental", "", "myState", "", "mySuper", "beforeObjectsRetrieval", "", "findObjectById", "Lcom/intellij/database/model/basic/BasicModElement;", "db", "kind", "", "id", "(Lcom/intellij/database/dialects/postgres/model/PgModDatabase;Ljava/lang/Character;J)Lcom/intellij/database/model/basic/BasicModElement;", "introspectAccessMethods", "introspectComments", "introspectDatabase", "introspectForeignServers", "introspectRelations", "introspectUserMappings", "progress", "what", "", "removeDroppedDatabaseComments", "removeDroppedDatabaseObjects", "retrieveExtensions", "retrieveForeignDataWrappers", "retrieveForeignServers", "foreignDataWrapper", "Lcom/intellij/database/dialects/postgres/model/PgModForeignDataWrapper;", "retrieveNativeDefinitionsFor", "Lcom/intellij/database/model/ObjectKind;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "result", "", "", "retrieveObjects", "retrieveUserMappings", "foreignServer", "Lcom/intellij/database/dialects/postgres/model/PgModForeignServer;", "intellij.database.dialects"})
    private final class MyDatabaseRetriever
    extends PostgresIntrospectorBase.DatabaseRetriever {
        private boolean myIncremental;
        private boolean mySuper;
        private long myState;

        private final void progress(String what) {
            String string = ((PgDatabase)this.getDatabase()).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"database.name");
            PostgresIntrospector.this.progress(this.myIncremental, "database", string, what);
        }

        @Override
        protected void beforeObjectsRetrieval() {
            Boolean bl = this.performQuery(QUERIES.isSuperUser());
            this.mySuper = bl != null ? bl : false;
            Long l = this.performQuery(QUERIES.getCountDatabaseStateNumber());
            this.myState = l != null ? l : 0L;
            this.myIncremental = true;
            if (this.myIncremental) {
                String string = IntrospectionMode.INCREMENT.code;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IntrospectionMode.INCREMENT.code");
                this.setQueryParameter$intellij_database_dialects(string, true);
            }
            this.setQueryParameter$intellij_database_dialects("super", this.mySuper);
            this.setQueryParameter$intellij_database_dialects("tx", ((PgDatabase)this.getDatabase()).getIntrospectionStateNumber());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            String query = Companion.getNATIVE_DEFINITIONS_QUERIES().get(kind);
            if (query == null) {
                return;
            }
            for (BasicModIdentifiedElement element2 : CollectionsKt.filterIsInstance(elements, BasicModIdentifiedElement.class)) {
                void this_$iv;
                String message$iv;
                PostgresIntrospector postgresIntrospector = PostgresIntrospector.this;
                String operationName$iv = "Retrieve native definition for " + element2.getName();
                try {
                    String definition = (String)this.getTransaction().query(query, Layouts.rowOf((RowLayout)Layouts.oneOf(String.class))).withParams(new Object[]{element2.getObjectId()}).run();
                    Map<BasicElement, String[]> map = result2;
                    BasicModIdentifiedElement basicModIdentifiedElement = element2;
                    String[] stringArray = new String[1];
                    String string = definition;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"definition");
                    stringArray[0] = string;
                    String[] stringArray2 = stringArray;
                    map.put(basicModIdentifiedElement, stringArray2);
                }
                catch (InterruptedException ie$iv) {
                    throw (Throwable)ie$iv;
                }
                catch (DBException d$iv) {
                    message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
                    this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
                }
                catch (NullPointerException npe$iv) {
                    message$iv = "NPE encountered when performing " + operationName$iv;
                    this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
                    BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
                }
                catch (Exception e$iv) {
                    message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
                    this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
                }
            }
        }

        @Override
        public void retrieveObjects() {
            super.retrieveObjects();
            if (this.myIncremental) {
                this.removeDroppedDatabaseObjects();
                this.removeDroppedDatabaseComments();
            } else {
                this.inDatabase(retrieveObjects.1.INSTANCE);
            }
            this.inDatabase(retrieveObjects.2.INSTANCE);
            this.introspectDatabase();
        }

        private final void removeDroppedDatabaseObjects() {
            TLongHashSet ids = new TLongHashSet(this.performQuery(QUERIES.getListDatabaseExistentClasses()));
            this.inDatabase((Function1)new Function1<PgModDatabase, Unit>(this, ids){
                final /* synthetic */ MyDatabaseRetriever this$0;
                final /* synthetic */ TLongHashSet $ids;

                public final void invoke(@NotNull PgModDatabase it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[1];
                    NamingIdentifyingFamily namingIdentifyingFamily = it.getAccessMethods();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"it.accessMethods");
                    modIdentifyingFamilyArray[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily);
                    PgIntrospectorBaseKt.removeDroppedChildren(this.$ids, modIdentifyingFamilyArray);
                    ModIdentifyingFamily[] modIdentifyingFamilyArray2 = new ModIdentifyingFamily[1];
                    NamingIdentifyingFamily namingIdentifyingFamily2 = it.getExtensions();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"it.extensions");
                    modIdentifyingFamilyArray2[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily2);
                    PgIntrospectorBaseKt.removeDroppedChildren(this.$ids, modIdentifyingFamilyArray2);
                    ModIdentifyingFamily[] modIdentifyingFamilyArray3 = new ModIdentifyingFamily[1];
                    NamingIdentifyingFamily namingIdentifyingFamily3 = it.getForeignDataWrappers();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"it.foreignDataWrappers");
                    modIdentifyingFamilyArray3[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily3);
                    PgIntrospectorBaseKt.removeDroppedChildren(this.$ids, modIdentifyingFamilyArray3);
                    for (PgModForeignDataWrapper foreignDataWrapper : it.getForeignDataWrappers()) {
                        ModIdentifyingFamily[] modIdentifyingFamilyArray4 = new ModIdentifyingFamily[1];
                        PgModForeignDataWrapper pgModForeignDataWrapper = foreignDataWrapper;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModForeignDataWrapper, (String)"foreignDataWrapper");
                        NamingIdentifyingFamily namingIdentifyingFamily4 = pgModForeignDataWrapper.getForeignServers();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"foreignDataWrapper.foreignServers");
                        modIdentifyingFamilyArray4[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily4);
                        PgIntrospectorBaseKt.removeDroppedChildren(this.$ids, modIdentifyingFamilyArray4);
                        for (PgModForeignServer foreignServer : foreignDataWrapper.getForeignServers()) {
                            if (MyDatabaseRetriever.access$getMySuper$p(this.this$0)) {
                                ModIdentifyingFamily[] modIdentifyingFamilyArray5 = new ModIdentifyingFamily[1];
                                PgModForeignServer pgModForeignServer = foreignServer;
                                Intrinsics.checkExpressionValueIsNotNull((Object)pgModForeignServer, (String)"foreignServer");
                                NamingIdentifyingFamily namingIdentifyingFamily5 = pgModForeignServer.getUserMappings();
                                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"foreignServer.userMappings");
                                modIdentifyingFamilyArray5[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily5);
                                PgIntrospectorBaseKt.removeDroppedChildren(this.$ids, modIdentifyingFamilyArray5);
                                continue;
                            }
                            PgModForeignServer pgModForeignServer = foreignServer;
                            Intrinsics.checkExpressionValueIsNotNull((Object)pgModForeignServer, (String)"foreignServer");
                            pgModForeignServer.getUserMappings().clear();
                        }
                    }
                }
                {
                    this.this$0 = myDatabaseRetriever;
                    this.$ids = tLongHashSet;
                    super(1);
                }
            });
        }

        private final void removeDroppedDatabaseComments() {
            TLongHashSet ids = new TLongHashSet(this.performQuery(QUERIES.getListExistentDatabaseComments()));
            this.inDatabase((Function1)new Function1<PgModDatabase, Unit>(ids){
                final /* synthetic */ TLongHashSet $ids;

                public final void invoke(@NotNull PgModDatabase it) {
                    PgBaseModCatalogObject it2;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    NamingIdentifyingFamily namingIdentifyingFamily = it.getAccessMethods();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"it.accessMethods");
                    Iterable $receiver$iv = namingIdentifyingFamily;
                    for (T element$iv : $receiver$iv) {
                        it2 = (PgModAccessMethod)element$iv;
                        PgModAccessMethod pgModAccessMethod = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModAccessMethod, (String)"it");
                        if (this.$ids.contains(pgModAccessMethod.getObjectId())) continue;
                        it2.setComment(null);
                    }
                    NamingIdentifyingFamily namingIdentifyingFamily2 = it.getExtensions();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"it.extensions");
                    $receiver$iv = namingIdentifyingFamily2;
                    for (T element$iv : $receiver$iv) {
                        PgBaseModCatalogObject pgBaseModCatalogObject = it2 = (PgModExtension)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseModCatalogObject, (String)"it");
                        if (this.$ids.contains(pgBaseModCatalogObject.getObjectId())) continue;
                        it2.setComment(null);
                    }
                    NamingIdentifyingFamily namingIdentifyingFamily3 = it.getForeignDataWrappers();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"it.foreignDataWrappers");
                    $receiver$iv = namingIdentifyingFamily3;
                    for (T element$iv : $receiver$iv) {
                        PgBaseModCatalogObject pgBaseModCatalogObject = it2 = (PgModForeignDataWrapper)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseModCatalogObject, (String)"it");
                        if (!this.$ids.contains(pgBaseModCatalogObject.getObjectId())) {
                            it2.setComment(null);
                        }
                        NamingIdentifyingFamily namingIdentifyingFamily4 = it2.getForeignServers();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"it.foreignServers");
                        Iterable $receiver$iv2 = namingIdentifyingFamily4;
                        for (T element$iv2 : $receiver$iv2) {
                            PgModForeignServer it3;
                            PgModForeignServer pgModForeignServer = it3 = (PgModForeignServer)element$iv2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)pgModForeignServer, (String)"it");
                            if (this.$ids.contains(pgModForeignServer.getObjectId())) continue;
                            it3.setComment(null);
                        }
                    }
                }
                {
                    this.$ids = tLongHashSet;
                    super(1);
                }
            });
        }

        private final void introspectDatabase() {
            this.introspectAccessMethods();
            this.retrieveForeignDataWrappers();
            this.retrieveExtensions();
            this.introspectForeignServers();
            this.introspectUserMappings();
            this.introspectComments();
            this.introspectRelations();
            this.inDatabase((Function1)new Function1<PgModDatabase, Unit>(this){
                final /* synthetic */ MyDatabaseRetriever this$0;

                public final void invoke(@NotNull PgModDatabase it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    it.setIntrospectionStateNumber(MyDatabaseRetriever.access$getMyState$p(this.this$0));
                }
                {
                    this.this$0 = myDatabaseRetriever;
                    super(1);
                }
            });
        }

        private final void introspectRelations() {
            this.progress("dependencies");
            List<PgIntroQueries.OneRelation> dependencies = this.performQuery(QUERIES.getRetrieveRelations());
            this.inDatabase((Function1)new Function1<PgModDatabase, Unit>(dependencies){
                final /* synthetic */ List $dependencies;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull PgModDatabase db) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                    Iterable iterable = $receiver$iv = (Iterable)this.$dependencies;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        PgIntroQueries.OneRelation oneRelation = (PgIntroQueries.OneRelation)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        V v = ObjectKind.ourKinds.get(it.dependent_kind);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        ObjectKind objectKind = (ObjectKind)v;
                        V v2 = ObjectKind.ourKinds.get(it.owner_kind);
                        if (v2 == null) {
                            Intrinsics.throwNpe();
                        }
                        PgRelation pgRelation = new PgRelation(objectKind, (ObjectKind)v2, it.dependent_id, it.owner_id, it.owner_subobject_id);
                        collection.add(pgRelation);
                    }
                    Set mapped = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    db.setRelations(mapped);
                }
                {
                    this.$dependencies = list;
                    super(1);
                }
            });
        }

        private final void introspectComments() {
            this.progress("comments");
            List<PgBaseIntroQueries.OneComment> comments = this.performQuery(QUERIES.getRetrieveDatabaseComments());
            if (comments.isEmpty()) {
                return;
            }
            this.inDatabase((Function1)new Function1<PgModDatabase, Unit>(this, comments){
                final /* synthetic */ MyDatabaseRetriever this$0;
                final /* synthetic */ List $comments;

                public final void invoke(@NotNull PgModDatabase db) {
                    Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                    Iterable $receiver$iv = this.$comments;
                    for (T element$iv : $receiver$iv) {
                        BasicModNamedElement obj;
                        PgBaseIntroQueries.OneComment it = (PgBaseIntroQueries.OneComment)element$iv;
                        BasicModElement basicModElement = MyDatabaseRetriever.access$findObjectById(this.this$0, db, it.kind, it.id);
                        if (!(basicModElement instanceof BasicModNamedElement)) {
                            basicModElement = null;
                        }
                        if ((BasicModNamedElement)basicModElement == null) {
                            continue;
                        }
                        obj.setComment(it.description);
                    }
                }
                {
                    this.this$0 = myDatabaseRetriever;
                    this.$comments = list;
                    super(1);
                }
            });
        }

        private final BasicModElement findObjectById(PgModDatabase db, Character kind, long id) {
            BasicModElement basicModElement;
            Character c2;
            Character c3 = c2 = kind;
            if (c3 != null && c3.charValue() == 'W') {
                basicModElement = (BasicModElement)db.getForeignDataWrappers().getByObjectId(id);
            } else {
                Character c4 = c2;
                if (c4 != null && c4.charValue() == 'S') {
                    Object v5;
                    block7: {
                        NamingIdentifyingFamily namingIdentifyingFamily = db.getForeignDataWrappers();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"db.foreignDataWrappers");
                        Family $receiver$iv = namingIdentifyingFamily;
                        Iterable $receiver$iv$iv = $receiver$iv;
                        for (Object element$iv$iv : $receiver$iv$iv) {
                            BasicElement it$iv;
                            BasicElement basicElement = it$iv = (BasicElement)element$iv$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                            PgModForeignDataWrapper $receiver = (PgModForeignDataWrapper)basicElement;
                            Object res$iv = ((IdentifyingFamily)$receiver.getForeignServers()).getByObjectId(id);
                            if (res$iv == null) continue;
                            v5 = res$iv;
                            break block7;
                        }
                        v5 = null;
                    }
                    basicModElement = v5;
                } else {
                    Character c5 = c2;
                    if (c5 != null && c5.charValue() == 'A') {
                        basicModElement = (BasicModElement)db.getAccessMethods().getByObjectId(id);
                    } else {
                        Character c6 = c2;
                        basicModElement = c6 != null && c6.charValue() == 'E' ? (BasicModElement)db.getExtensions().getByObjectId(id) : null;
                    }
                }
            }
            return basicModElement;
        }

        private final void introspectAccessMethods() {
            this.progress("access methods");
            List<PgIntroQueries.OneAccessMethod> methodList = this.performQuery(QUERIES.getRetrieveAccessMethods());
            this.inDatabase((Function1)new Function1<PgModDatabase, Unit>(methodList){
                final /* synthetic */ List $methodList;

                public final void invoke(@NotNull PgModDatabase it) {
                    NamingIdentifyingFamily namingIdentifyingFamily;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    NamingIdentifyingFamily $receiver = namingIdentifyingFamily = it.getAccessMethods();
                    for (PgIntroQueries.OneAccessMethod m : this.$methodList) {
                        PgModAccessMethod method;
                        PgModAccessMethod pgModAccessMethod = method = (PgModAccessMethod)$receiver.renew(m.access_method_id, m.access_method_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModAccessMethod, (String)"method");
                        pgModAccessMethod.setStateNumber(m.state_number);
                        method.setHandler(m.handler_name);
                        method.setHandlerId(m.handler_id);
                        if (m.access_method_type == null) continue;
                        Character c2 = m.access_method_type;
                        if (c2 == null) {
                            Intrinsics.throwNpe();
                        }
                        method.setType(PgAccessMethodType.of(c2.charValue()));
                    }
                }
                {
                    this.$methodList = list;
                    super(1);
                }
            });
        }

        private final void retrieveForeignDataWrappers() {
            this.progress("foreign data wrappers");
            List<PgIntroQueries.OneForeignDataWrapper> fdwList = this.performQuery(QUERIES.getRetrieveForeignDataWrappers());
            this.inDatabase((Function1)new Function1<PgModDatabase, Unit>(fdwList){
                final /* synthetic */ List $fdwList;

                public final void invoke(@NotNull PgModDatabase it) {
                    NamingIdentifyingFamily namingIdentifyingFamily;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    NamingIdentifyingFamily $receiver = namingIdentifyingFamily = it.getForeignDataWrappers();
                    for (PgIntroQueries.OneForeignDataWrapper fdw : this.$fdwList) {
                        PgModForeignDataWrapper wrapper;
                        PgModForeignDataWrapper pgModForeignDataWrapper = wrapper = (PgModForeignDataWrapper)$receiver.renew(fdw.id, fdw.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModForeignDataWrapper, (String)"wrapper");
                        pgModForeignDataWrapper.setStateNumber(fdw.state_number);
                        wrapper.setHandler(fdw.handler);
                        wrapper.setHandlerSchema(fdw.handler_schema);
                        wrapper.setValidator(fdw.validator);
                        wrapper.setValidatorSchema(fdw.validator_schema);
                        wrapper.setOptions(ArraysKt.toList((Object[])fdw.options));
                        wrapper.setOwner(fdw.getOwnerName());
                    }
                    $receiver.sort();
                }
                {
                    this.$fdwList = list;
                    super(1);
                }
            });
        }

        private final void introspectForeignServers() {
            this.progress("foreign servers");
            this.inDatabase((Function1)new Function1<PgModDatabase, Unit>(this){
                final /* synthetic */ MyDatabaseRetriever this$0;

                public final void invoke(@NotNull PgModDatabase it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Iterator<T> iterator = it.getForeignDataWrappers().iterator();
                    while (iterator.hasNext()) {
                        PgModForeignDataWrapper foreignDataWrapper;
                        PgModForeignDataWrapper pgModForeignDataWrapper = foreignDataWrapper = (PgModForeignDataWrapper)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModForeignDataWrapper, (String)"foreignDataWrapper");
                        MyDatabaseRetriever.access$retrieveForeignServers(this.this$0, pgModForeignDataWrapper);
                    }
                }
                {
                    this.this$0 = myDatabaseRetriever;
                    super(1);
                }
            });
        }

        private final void retrieveForeignServers(PgModForeignDataWrapper foreignDataWrapper) {
            NamingIdentifyingFamily namingIdentifyingFamily;
            this.setQueryParameter$intellij_database_dialects("fdw_id", foreignDataWrapper.getObjectId());
            List<PgIntroQueries.OneForeignServer> servers = this.performQuery(QUERIES.getRetrieveForeignServers());
            NamingIdentifyingFamily $receiver = namingIdentifyingFamily = foreignDataWrapper.getForeignServers();
            for (PgIntroQueries.OneForeignServer s : servers) {
                PgModForeignServer server;
                PgModForeignServer pgModForeignServer = server = (PgModForeignServer)$receiver.renew(s.id, s.name);
                Intrinsics.checkExpressionValueIsNotNull((Object)pgModForeignServer, (String)"server");
                pgModForeignServer.setStateNumber(s.state_number);
                server.setOptions(ArraysKt.toList((Object[])s.options));
                server.setType(s.type);
                server.setVersion(s.version);
                server.setOwner(s.getOwnerName());
            }
            $receiver.sort();
        }

        private final void introspectUserMappings() {
            this.progress("user mappings");
            this.inDatabase((Function1)new Function1<PgModDatabase, Unit>(this){
                final /* synthetic */ MyDatabaseRetriever this$0;

                public final void invoke(@NotNull PgModDatabase it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Iterator<T> iterator = it.getForeignDataWrappers().iterator();
                    while (iterator.hasNext()) {
                        PgModForeignDataWrapper wrapper;
                        PgModForeignDataWrapper pgModForeignDataWrapper = wrapper = (PgModForeignDataWrapper)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModForeignDataWrapper, (String)"wrapper");
                        Iterator<T> iterator2 = pgModForeignDataWrapper.getForeignServers().iterator();
                        while (iterator2.hasNext()) {
                            PgModForeignServer foreignServer;
                            PgModForeignServer pgModForeignServer = foreignServer = (PgModForeignServer)iterator2.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)pgModForeignServer, (String)"foreignServer");
                            MyDatabaseRetriever.access$retrieveUserMappings(this.this$0, pgModForeignServer);
                        }
                    }
                }
                {
                    this.this$0 = myDatabaseRetriever;
                    super(1);
                }
            });
        }

        private final void retrieveUserMappings(PgModForeignServer foreignServer) {
            NamingIdentifyingFamily namingIdentifyingFamily;
            this.setQueryParameter$intellij_database_dialects("server_id", foreignServer.getObjectId());
            List<PgIntroQueries.OneUserMapping> mappings = this.performQuery(this.mySuper ? QUERIES.getRetrieveUserMappingsSuperUser() : QUERIES.getRetrieveUserMappings());
            NamingIdentifyingFamily $receiver = namingIdentifyingFamily = foreignServer.getUserMappings();
            for (PgIntroQueries.OneUserMapping m : mappings) {
                PgModUserMapping mapping;
                String string = m.user;
                if (string == null) {
                    string = "public";
                }
                String userName = string;
                PgModUserMapping pgModUserMapping = mapping = (PgModUserMapping)$receiver.renew(m.id, userName);
                Intrinsics.checkExpressionValueIsNotNull((Object)pgModUserMapping, (String)"mapping");
                pgModUserMapping.setOptions(ArraysKt.toList((Object[])m.options));
                mapping.setUser(userName);
            }
            $receiver.sort();
        }

        private final void retrieveExtensions() {
            if (!PostgresIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1})) {
                return;
            }
            this.progress("extensions");
            List<PgIntroQueries.OneExtension> extensions = this.performQuery(QUERIES.getRetrieveExtensions());
            if (extensions.isEmpty()) {
                return;
            }
            this.inDatabase((Function1)new Function1<PgModDatabase, Unit>(extensions){
                final /* synthetic */ List $extensions;

                public final void invoke(@NotNull PgModDatabase db) {
                    Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                    for (PgIntroQueries.OneExtension extension : this.$extensions) {
                        PgModExtension newExt;
                        PgModExtension pgModExtension = newExt = (PgModExtension)db.getExtensions().renew(extension.id, extension.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModExtension, (String)"newExt");
                        pgModExtension.setStateNumber(extension.state_number);
                        newExt.setVersion(extension.version);
                        newExt.setSchemaId(extension.schema_id);
                        newExt.setSchemaName(extension.schema_name);
                        newExt.setAvailableUpdates(ArraysKt.toList((Object[])extension.available_updates));
                    }
                    db.getExtensions().sort();
                }
                {
                    this.$extensions = list;
                    super(1);
                }
            });
        }

        public MyDatabaseRetriever(@NotNull DBTransaction tran, PgDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            super((PostgresIntrospectorBase)PostgresIntrospector.this, tran, (PgBaseDatabase)database);
        }

        public static final /* synthetic */ boolean access$getMySuper$p(MyDatabaseRetriever $this) {
            return $this.mySuper;
        }

        public static final /* synthetic */ void access$setMySuper$p(MyDatabaseRetriever $this, boolean bl) {
            $this.mySuper = bl;
        }

        public static final /* synthetic */ long access$getMyState$p(MyDatabaseRetriever $this) {
            return $this.myState;
        }

        public static final /* synthetic */ void access$setMyState$p(MyDatabaseRetriever $this, long l) {
            $this.myState = l;
        }

        @Nullable
        public static final /* synthetic */ BasicModElement access$findObjectById(MyDatabaseRetriever $this, @NotNull PgModDatabase db, @Nullable Character kind, long id) {
            return $this.findObjectById(db, kind, id);
        }

        public static final /* synthetic */ void access$retrieveForeignServers(MyDatabaseRetriever $this, @NotNull PgModForeignDataWrapper foreignDataWrapper) {
            $this.retrieveForeignServers(foreignDataWrapper);
        }

        public static final /* synthetic */ void access$retrieveUserMappings(MyDatabaseRetriever $this, @NotNull PgModForeignServer foreignServer) {
            $this.retrieveUserMappings(foreignServer);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002<\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001R,\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004B\u0017\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\rJb\u0010\u0012\u001a\u00020\u0013\"\b\b\u0000\u0010\u0014*\u00020\u0015\"\u0010\b\u0001\u0010\u0016*\n\u0012\u0006\b\u0001\u0012\u0002H\u00140\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002H\u00160\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00140\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0014J)\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\f\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0014\u00a2\u0006\u0002\u0010+J#\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020/0.0-2\u0006\u0010\f\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u00100J\"\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\f\u001a\u00020\u00032\u0006\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020*H\u0014J \u00105\u001a\u00020\u00132\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u000209H\u0014J\u0010\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020=H\u0014J\b\u0010>\u001a\u00020\u000fH\u0014J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0014J\u0014\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0-0AH\u0014J\u001e\u0010C\u001a\u0004\u0018\u0001072\b\u0010\u001a\u001a\u0004\u0018\u0001072\b\u0010\u0018\u001a\u0004\u0018\u000107H\u0002J\u0018\u0010D\u001a\u00020\u00132\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0014J\u0018\u0010I\u001a\u00020\u00132\u0006\u00106\u001a\u00020J2\u0006\u0010<\u001a\u00020=H\u0014J0\u0010K\u001a\u00020\u00132\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u000e\u0010P\u001a\n\u0012\u0006\b\u0001\u0012\u00020O0Q2\u0006\u00106\u001a\u000207H\u0014J \u0010R\u001a\u00020\u00132\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010\f\u001a\u00020\u0003H\u0014J(\u0010W\u001a\u00020\u00132\u0006\u0010X\u001a\u00020Y2\u0006\u00106\u001a\u00020J2\u0006\u0010<\u001a\u00020=2\u0006\u0010\f\u001a\u00020\u0003H\u0014J \u0010Z\u001a\u00020\u00132\u0006\u0010[\u001a\u00020\\2\u0006\u00106\u001a\u00020J2\u0006\u0010<\u001a\u00020=H\u0014J\u0018\u0010]\u001a\u00020\u00132\u0006\u00106\u001a\u00020J2\u0006\u0010^\u001a\u00020_H\u0014J\u0018\u0010`\u001a\u00020\u00132\u0006\u00106\u001a\u0002072\u0006\u0010^\u001a\u00020_H\u0014J\u0018\u0010a\u001a\u00020\u00132\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0014J \u0010f\u001a\u00020\u00132\u0006\u00106\u001a\u0002072\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010g\u001a\u00020_H\u0014J\u001e\u0010h\u001a\u00020\u00132\f\u0010i\u001a\b\u0012\u0004\u0012\u00020_0j2\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u001c\u0010k\u001a\u00020\u00132\b\u0010l\u001a\u0004\u0018\u0001072\b\u0010m\u001a\u0004\u0018\u000109H\u0014J$\u0010n\u001a\u00020\u00132\u0012\u0010o\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0-0A2\u0006\u0010p\u001a\u00020/H\u0014J\u0018\u0010q\u001a\u00020\u00132\u0006\u0010r\u001a\u00020s2\u0006\u0010\f\u001a\u00020\u0003H\u0014J*\u0010t\u001a\u0004\u0018\u0001072\u0006\u0010\f\u001a\u00020\u00032\u0006\u00103\u001a\u00020(2\u0006\u0010u\u001a\u00020*2\u0006\u0010v\u001a\u000209H\u0014J\b\u0010w\u001a\u00020\u0013H\u0002J\b\u0010x\u001a\u00020\u0013H\u0014J\b\u0010y\u001a\u00020\u0013H\u0002J\b\u0010z\u001a\u00020\u0013H\u0002J\b\u0010{\u001a\u00020\u0013H\u0002J\b\u0010|\u001a\u00020\u0013H\u0002J\b\u0010}\u001a\u00020\u0013H\u0002J\b\u0010~\u001a\u00020\u0013H\u0002J\b\u0010\u007f\u001a\u00020\u0013H\u0002J\t\u0010\u0080\u0001\u001a\u00020\u000fH\u0014J\u0011\u0010\u0081\u0001\u001a\u00020\u00132\u0006\u00106\u001a\u00020JH\u0014J\u0016\u0010\u0082\u0001\u001a\t\u0012\u0005\u0012\u00030\u0083\u00010-H\u0014\u00a2\u0006\u0003\u0010\u0084\u0001J\t\u0010\u0085\u0001\u001a\u00020\u000fH\u0014R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0086\u0001"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PostgresIntrospector$MySchemaRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PostgresIntrospectorBase$SchemaRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "Lcom/intellij/database/dialects/postgres/model/PgModSchema;", "Lcom/intellij/database/dialects/postgresbase/introspector/PostgresIntrospectorBase;", "Lcom/intellij/database/dialects/postgres/model/PgModModel;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgModRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgres/model/PgModDatabase;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/postgres/introspector/PostgresIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgSchema;)V", "wasDomains", "", "wasEnums", "wasMatViews", "copyFamily", "", "T", "Lcom/intellij/database/model/basic/BasicModElement;", "F", "Lcom/intellij/database/model/families/ModFamily;", "existing", "Lcom/intellij/database/dialects/postgres/model/PgModLocalTable;", "newRelation", "Lcom/intellij/database/dialects/postgres/model/PgModView;", "familyGetter", "Lkotlin/Function1;", "factory", "Lkotlin/Function2;", "copyObjects", "createRoutine", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModRoutine;", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;", "findObjectById", "Lcom/intellij/database/model/basic/BasicElement;", "kind", "", "id", "", "(Lcom/intellij/database/dialects/postgres/model/PgModSchema;Ljava/lang/Character;J)Lcom/intellij/database/model/basic/BasicElement;", "getSchemaChildrenToDrop", "", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "(Lcom/intellij/database/dialects/postgres/model/PgModSchema;)[Lcom/intellij/database/model/families/ModIdentifyingFamily;", "getTableOrView", "Lcom/intellij/database/dialects/postgres/model/PgModLikeStoredTable;", "relKind", "tableId", "handleColumnRenaming", "table", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModLikeStoredTable;", "oldName", "", "tableName", "hasReference", "con", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;", "incrementalViewSources", "isTableKind", "listExistentComments", "Lgnu/trove/TLongObjectHashMap;", "", "preventDuplicates", "processAggregate", "agg", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModAggregate;", "processCheck", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModTable;", "processColumn", "col", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModLikeColumn;", "columns", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "processDataType", "dataType", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModDefType;", "oneType", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;", "processForeignKey", "fkey", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModForeignKey;", "processKey", "key", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModKey;", "processModTable", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "processModView", "processOperator", "o", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneOperator;", "operator", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModOperator;", "processTable", "oneTable", "processTables", "ts", "", "processViewSource", "view", "sourceText", "removeComments", "existentComments", "e", "removeDroppedClasses", "existentIds", "Lgnu/trove/TLongHashSet;", "renewTableOrView", "objectId", "objectName", "retrieveCollations", "retrieveDataTypes", "retrieveEnumLabels", "retrieveForeignTables", "retrieveIndices", "retrieveRules", "retrieveRulesSources", "retrieveSequences", "retrieveTriggers", "shouldIntrospectTableRelatedDataIncremental", "sortConstraints", "steps", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "()[Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "wasDataTables", "intellij.database.dialects"})
    protected final class MySchemaRetriever
    extends PostgresIntrospectorBase.SchemaRetriever<PgSchema, PgModSchema> {
        private boolean wasEnums;
        private boolean wasMatViews;
        private boolean wasDomains;

        @Override
        @NotNull
        protected IntroStep[] steps() {
            return (IntroStep[])ArraysKt.plus((Object[])super.steps(), (Object[])new IntroStep[]{new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveSequences(this.this$0);
                }

                public int priority() {
                    return 1;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveForeignTables(this.this$0);
                }

                public int priority() {
                    return 21;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveCollations(this.this$0);
                }

                public int priority() {
                    return 51;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveEnumLabels(this.this$0);
                }

                public int priority() {
                    return 61;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveIndices(this.this$0);
                }

                public int priority() {
                    return 71;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveRules(this.this$0);
                }

                public int priority() {
                    return 81;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveTriggers(this.this$0);
                }

                public int priority() {
                    return 82;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }, new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveRulesSources(this.this$0);
                }

                public int priority() {
                    return 101;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            }});
        }

        @Override
        @NotNull
        protected TLongObjectHashMap<Short[]> listExistentComments() {
            TLongObjectHashMap existentComments = new TLongObjectHashMap();
            Iterable $receiver$iv = this.performQuery(QUERIES.getListExistentSchemaComments());
            for (Object element$iv : $receiver$iv) {
                PgIntroQueries.IdAndSubIds it = (PgIntroQueries.IdAndSubIds)element$iv;
                existentComments.put(it.id, (Object)PgIntrospectorBaseKt.optimizeFor0(it.sub_ids));
            }
            return existentComments;
        }

        @Override
        protected void removeComments(@NotNull TLongObjectHashMap<Short[]> existentComments, @NotNull BasicModIdentifiedElement e) {
            PgBaseModCatalogObject c2;
            Iterator iterator;
            Intrinsics.checkParameterIsNotNull(existentComments, (String)"existentComments");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            super.removeComments(existentComments, e);
            if (e instanceof PgModDefType) {
                iterator = ((PgModDefType)e).getChecks().iterator();
                while (iterator.hasNext()) {
                    PgModDefTypeCheck pgModDefTypeCheck = c2 = (PgModDefTypeCheck)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pgModDefTypeCheck, (String)"c");
                    this.removeComments(existentComments, pgModDefTypeCheck);
                }
            }
            if (e instanceof PgModTable) {
                iterator = ((PgModTable)e).getTriggers().iterator();
                while (iterator.hasNext()) {
                    PgModTrigger t;
                    PgModTrigger pgModTrigger = t = (PgModTrigger)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pgModTrigger, (String)"t");
                    this.removeComments(existentComments, pgModTrigger);
                }
                iterator = ((PgModTable)e).getRules().iterator();
                while (iterator.hasNext()) {
                    PgModRule r;
                    PgModRule pgModRule = r = (PgModRule)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pgModRule, (String)"r");
                    this.removeComments(existentComments, pgModRule);
                }
                iterator = ((PgModTable)e).getIndices().iterator();
                while (iterator.hasNext()) {
                    BasicIndex idx;
                    BasicIndex basicIndex = idx = (BasicIndex)iterator.next();
                    if (basicIndex == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.postgres.model.PgModIndex");
                    }
                    this.removeComments(existentComments, (PgModIndex)basicIndex);
                }
                iterator = ((PgModTable)e).getChecks().iterator();
                while (iterator.hasNext()) {
                    PgBaseModCatalogObject pgBaseModCatalogObject = c2 = (PgModCheck)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseModCatalogObject, (String)"c");
                    this.removeComments(existentComments, pgBaseModCatalogObject);
                }
            }
        }

        private final void retrieveForeignTables() {
            if (!PostgresIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1})) {
                return;
            }
            this.progress("foreign tables");
            List<PgIntroQueries.OneForeignTable> tables = this.performQuery(QUERIES.getRetrieveForeignTables());
            this.inSchema((Function1)new Function1<PgModSchema, Unit>(tables){
                final /* synthetic */ List $tables;

                public final void invoke(@NotNull PgModSchema it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    for (PgIntroQueries.OneForeignTable t : this.$tables) {
                        PgModForeignTable table;
                        if ((PgModForeignTable)it.getForeignTables().getByObjectId(t.table_id) == null) {
                            continue;
                        }
                        table.setServer(t.table_server);
                        table.setOptions(ArraysKt.toList((Object[])t.table_options));
                        table.setOwner(t.getOwnerName());
                    }
                }
                {
                    this.$tables = list;
                    super(1);
                }
            });
        }

        private final void retrieveCollations() {
            if (!PostgresIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1})) {
                return;
            }
            this.progress("collations");
            List<PgIntroQueries.OneCollation> collations = this.performQuery(QUERIES.getRetrieveCollations());
            if (collations.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<PgModSchema, Unit>(collations){
                final /* synthetic */ List $collations;

                public final void invoke(@NotNull PgModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (PgIntroQueries.OneCollation c2 : this.$collations) {
                        PgModCollation collation;
                        PgModCollation pgModCollation = collation = (PgModCollation)schema.getCollations().renew(c2.id, c2.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModCollation, (String)"collation");
                        pgModCollation.setStateNumber(c2.state_number);
                        String string = c2.lc_collate;
                        collation.setCollate(string != null ? StringKt.nullize$default((String)string, (boolean)false, (int)1, null) : null);
                        String string2 = c2.lc_ctype;
                        collation.setCType(string2 != null ? StringKt.nullize$default((String)string2, (boolean)false, (int)1, null) : null);
                        collation.setOwner(c2.getOwnerName());
                    }
                }
                {
                    this.$collations = list;
                    super(1);
                }
            });
        }

        @Override
        @NotNull
        protected ModIdentifyingFamily<? extends BasicModIdentifiedElement>[] getSchemaChildrenToDrop(@NotNull PgModSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Object[] objectArray = super.getSchemaChildrenToDrop((PgBaseModSchema)schema);
            ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray = new ModNamingIdentifyingFamily[4];
            NamingIdentifyingFamily namingIdentifyingFamily = schema.getForeignTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.foreignTables");
            modNamingIdentifyingFamilyArray[0] = namingIdentifyingFamily;
            NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getSequences();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.sequences");
            modNamingIdentifyingFamilyArray[1] = namingIdentifyingFamily2;
            NamingIdentifyingFamily namingIdentifyingFamily3 = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.matViews");
            modNamingIdentifyingFamilyArray[2] = namingIdentifyingFamily3;
            NamingIdentifyingFamily namingIdentifyingFamily4 = schema.getCollations();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.collations");
            modNamingIdentifyingFamilyArray[3] = namingIdentifyingFamily4;
            return (ModIdentifyingFamily[])ArraysKt.plus((Object[])objectArray, (Object[])modNamingIdentifyingFamilyArray);
        }

        @Override
        protected void removeDroppedClasses(@NotNull TLongHashSet existentIds, @NotNull PgModSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)existentIds, (String)"existentIds");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super.removeDroppedClasses(existentIds, (PgBaseModSchema)schema);
            for (PgModTable t : schema.getTables()) {
                ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[4];
                PgModLocalTable pgModLocalTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgModLocalTable, (String)"t");
                NamingIdentifyingFamily namingIdentifyingFamily = pgModLocalTable.getIndices();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"t.indices");
                modIdentifyingFamilyArray[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily);
                NamingIdentifyingFamily namingIdentifyingFamily2 = t.getChecks();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"t.checks");
                modIdentifyingFamilyArray[1] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily2);
                NamingIdentifyingFamily namingIdentifyingFamily3 = t.getRules();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"t.rules");
                modIdentifyingFamilyArray[2] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily3);
                NamingIdentifyingFamily namingIdentifyingFamily4 = t.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"t.triggers");
                modIdentifyingFamilyArray[3] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily4);
                PgIntrospectorBaseKt.removeDroppedChildren(existentIds, modIdentifyingFamilyArray);
            }
            for (PgModTable t : schema.getForeignTables()) {
                ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[3];
                PgModTable pgModTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgModTable, (String)"t");
                NamingIdentifyingFamily namingIdentifyingFamily = pgModTable.getChecks();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"t.checks");
                modIdentifyingFamilyArray[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily);
                NamingIdentifyingFamily namingIdentifyingFamily5 = t.getRules();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"t.rules");
                modIdentifyingFamilyArray[1] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily5);
                NamingIdentifyingFamily namingIdentifyingFamily6 = t.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily6, (String)"t.triggers");
                modIdentifyingFamilyArray[2] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily6);
                PgIntrospectorBaseKt.removeDroppedChildren(existentIds, modIdentifyingFamilyArray);
            }
            for (PgModDefType d2 : schema.getDefTypes()) {
                ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[1];
                PgModDefType pgModDefType = d2;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgModDefType, (String)"d");
                NamingIdentifyingFamily namingIdentifyingFamily = pgModDefType.getChecks();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"d.checks");
                modIdentifyingFamilyArray[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily);
                PgIntrospectorBaseKt.removeDroppedChildren(existentIds, modIdentifyingFamilyArray);
            }
            for (PgModMatView m : schema.getMatViews()) {
                ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[3];
                PgModMatView pgModMatView = m;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgModMatView, (String)"m");
                NamingIdentifyingFamily namingIdentifyingFamily = pgModMatView.getIndices();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"m.indices");
                modIdentifyingFamilyArray[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily);
                NamingIdentifyingFamily namingIdentifyingFamily7 = m.getRules();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily7, (String)"m.rules");
                modIdentifyingFamilyArray[1] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily7);
                NamingIdentifyingFamily namingIdentifyingFamily8 = m.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily8, (String)"m.triggers");
                modIdentifyingFamilyArray[2] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily8);
                PgIntrospectorBaseKt.removeDroppedChildren(existentIds, modIdentifyingFamilyArray);
            }
            for (PgModView v : schema.getViews()) {
                ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[2];
                PgModView pgModView = v;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgModView, (String)"v");
                NamingIdentifyingFamily namingIdentifyingFamily = pgModView.getRules();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"v.rules");
                modIdentifyingFamilyArray[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily);
                NamingIdentifyingFamily namingIdentifyingFamily9 = v.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily9, (String)"v.triggers");
                modIdentifyingFamilyArray[1] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily9);
                PgIntrospectorBaseKt.removeDroppedChildren(existentIds, modIdentifyingFamilyArray);
            }
        }

        private final void retrieveSequences() {
            this.progress("sequences");
            SqlQuery<List<PgIntroQueries.OneSequence>> query = PostgresIntrospector.this.getServerVersion().isOrGreater(new int[]{10, -10}) ? QUERIES.getRetrieveSequences10() : QUERIES.getRetrieveSequences();
            List<PgIntroQueries.OneSequence> sqs = this.performQuery(query);
            if (sqs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<PgModSchema, Unit>(sqs){
                final /* synthetic */ List $sqs;

                public final void invoke(@NotNull PgModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (PgIntroQueries.OneSequence sq : this.$sqs) {
                        PgModSequence sequence;
                        PgModSequence pgModSequence = sequence = (PgModSequence)schema.getSequences().renew(sq.sequence_id, sq.sequence_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModSequence, (String)"sequence");
                        pgModSequence.setStateNumber(sq.sequence_state_number);
                        sequence.setOwner(sq.getOwnerName());
                        PgIntrospectorKt.access$assignSequenceParams(sequence, sq);
                    }
                    schema.getSequences().sort();
                }
                {
                    this.$sqs = list;
                    super(1);
                }
            });
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected void retrieveDataTypes() {
            super.retrieveDataTypes();
            v0 = this;
            if (this.wasDomains) ** GOTO lbl-1000
            v1 = ((PgSchema)this.getSchema()).getDefTypes().jbi();
            Intrinsics.checkExpressionValueIsNotNull(v1, (String)"schema.defTypes.jbi()");
            var1_1 = (Iterable)v1;
            var8_2 = v0;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                v2 = 0;
            } else {
                count$iv = 0;
                for (T element$iv : $receiver$iv) {
                    v3 = it = (PgDefType)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                    if (!(v3.getSubKind() == PgDataTypeSubKind.DOMAIN) || (var5_7 = ++count$iv) >= 0) continue;
                    throw (Throwable)new ArithmeticException("Count overflow has happened.");
                }
                v2 = var2_3;
            }
            var9_8 = v2;
            v0 = var8_2;
            if (var9_8 > 0) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = v0.wasDomains = false;
            }
            if (!this.wasDomains) {
                return;
            }
            dcs = this.performQuery(PostgresIntrospector.QUERIES.getRetrieveDataTypeChecks());
            if (dcs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<PgModSchema, Unit>(dcs){
                final /* synthetic */ List $dcs;

                public final void invoke(@NotNull PgModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (PgIntroQueries.OneDataTypeCheck dc : this.$dcs) {
                        PgModDefType defType;
                        PgModDefTypeCheck check;
                        if ((PgModDefType)schema.getDefTypes().getByObjectId(dc.type_id) == null) {
                            continue;
                        }
                        PgModDefTypeCheck pgModDefTypeCheck = check = (PgModDefTypeCheck)defType.getChecks().renew(dc.constraint_id, dc.constraint_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModDefTypeCheck, (String)"check");
                        pgModDefTypeCheck.setStateNumber(dc.constraint_state_number);
                        check.setPredicate(dc.predicate);
                    }
                }
                {
                    this.$dcs = list;
                    super(1);
                }
            });
        }

        @Override
        protected void processDataType(@NotNull PgBaseModDefType dataType, @NotNull PgBaseIntroQueries.OneDataType oneType, @NotNull PgModSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)dataType, (String)"dataType");
            Intrinsics.checkParameterIsNotNull((Object)oneType, (String)"oneType");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super.processDataType(dataType, oneType, (PgBaseModSchema)schema);
            if (!(dataType instanceof PgModDefType)) {
                return;
            }
            PgDataTypeSubKind subKind = ((PgModDefType)dataType).getSubKind();
            ((PgModDefType)dataType).setSubCategory(PgDataTypeSubCategory.of(oneType.type_category));
            ((PgModDefType)dataType).setOwner(oneType.getOwnerName());
            this.wasEnums |= subKind == PgDataTypeSubKind.ENUM;
            if (this.wasDomains == this.wasDomains || subKind != PgDataTypeSubKind.DOMAIN) {
                // empty if block
            }
        }

        @Override
        protected void processTables(@NotNull List<PgBaseIntroQueries.OneTable> ts2, @NotNull PgModSchema schema) {
            Intrinsics.checkParameterIsNotNull(ts2, (String)"ts");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super.processTables(ts2, (PgBaseModSchema)schema);
            if (this.wasMatViews) {
                schema.getMatViews().sort();
            }
            if (this.getWasTables$intellij_database_dialects()) {
                schema.getForeignTables().sort();
            }
        }

        @Override
        protected void processTable(@NotNull PgBaseModLikeStoredTable table, @NotNull PgModSchema schema, @NotNull PgBaseIntroQueries.OneTable oneTable) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)oneTable, (String)"oneTable");
            super.processTable(table, (PgBaseModSchema)schema, oneTable);
            this.setWasTables$intellij_database_dialects(this.getWasTables$intellij_database_dialects() || oneTable.table_kind == 'f');
            this.wasMatViews = this.wasMatViews || oneTable.table_kind == 'm';
        }

        @Override
        protected void processModTable(@NotNull PgBaseModTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            if (!(table instanceof PgModTable)) {
                return;
            }
            if (table instanceof PgModLocalTable) {
                ((PgModLocalTable)table).setWithOids(t.table_with_oids);
            }
            ((PgModTable)table).setPartitioned(t.table_kind == 'p');
            ((PgModTable)table).setPartition(t.is_partition);
            ((PgModTable)table).setPartitionKey(t.partition_key);
            ((PgModTable)table).setPartitionExpression(t.partition_expression);
            ((PgModTable)table).setAncestorIds(PgIntrospectorKt.access$parseListOfLongs(t.ancestors));
            ((PgModTable)table).setSuccessorIds(PgIntrospectorKt.access$parseSmallSetOfLongs(t.successors));
            for (PgTable ancestor : PgModelFun.getAncestors((PgTable)((Object)table))) {
                PgTable pgTable = ancestor;
                if (!(pgTable instanceof PgModTable)) {
                    pgTable = null;
                }
                PgModTable pgModTable = (PgModTable)pgTable;
                if (pgModTable == null) continue;
                PgModModelFun.addSuccessor(pgModTable, ((PgModTable)table).getObjectId());
            }
            if (t.tablespace_id <= 0L) {
                // empty if block
            }
        }

        @Override
        protected void processModView(@NotNull PgBaseModLikeStoredTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            if (!(table instanceof PgModView)) {
                return;
            }
            String string = t.options;
            if (string == null) {
                string = "";
            }
            String o = string;
            ((PgModView)table).setCheckOption(StringsKt.contains$default((CharSequence)o, (CharSequence)"check_option=local", (boolean)false, (int)2, null) ? PgCheckOption.LOCAL : (StringsKt.contains$default((CharSequence)o, (CharSequence)"check_option=cascaded", (boolean)false, (int)2, null) ? PgCheckOption.CASCADED : PgCheckOption.NONE));
        }

        @Override
        protected void handleColumnRenaming(@NotNull PgBaseModLikeStoredTable table, @NotNull String oldName, @NotNull String tableName) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)oldName, (String)"oldName");
            Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
            super.handleColumnRenaming(table, oldName, tableName);
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.INDEX");
            this.handleColumnRenaming(table, objectKind, oldName, tableName);
            ObjectKind objectKind2 = ObjectKind.CHECK;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"ObjectKind.CHECK");
            this.handleColumnRenaming(table, objectKind2, oldName, tableName);
        }

        private final void retrieveEnumLabels() {
            if (!(this.wasEnums || this.getMode$intellij_database_dialects().increment && ((PgSchema)this.getSchema()).getDefTypes().hasChildren())) {
                return;
            }
            this.progress("enums");
            Map<Long, String[]> els = this.performQuery(QUERIES.getRetrieveEnumLabels());
            if (els.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<PgModSchema, Unit>(els){
                final /* synthetic */ Map $els;

                public final void invoke(@NotNull PgModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Map map = this.$els;
                    Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        PgModDefType defType;
                        String[] stringArray;
                        String[] stringArray2 = stringArray = iterator.next();
                        long type_id = ((Number)stringArray2.getKey()).longValue();
                        stringArray2 = stringArray;
                        String[] labels = (String[])stringArray2.getValue();
                        if (type_id == 0L || labels == null || (stringArray2 = labels).length == 0 || (defType = (PgModDefType)schema.getDefTypes().getByObjectId(type_id)) == null) continue;
                        defType.setLabels(CollectionsKt.listOf((Object[])Arrays.copyOf(labels, labels.length)));
                    }
                }
                {
                    this.$els = map;
                    super(1);
                }
            });
        }

        @Override
        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseModLikeColumn column2, @NotNull ModPositioningNamingFamily<? extends PgBaseModLikeColumn> columns, @NotNull PgBaseModLikeStoredTable table) {
            Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
            Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
            Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            super.processColumn(col, column2, columns, table);
            if (!(column2 instanceof PgModTableColumn)) {
                return;
            }
            ((PgModTableColumn)column2).setTypeId(col.type_id);
            ((PgModTableColumn)column2).setInherited(col.column_is_inherited);
            if (column2 instanceof PgModForeignTableColumn) {
                ((PgModForeignTableColumn)column2).setOptions(ArraysKt.toList((Object[])col.options));
            }
        }

        private final void retrieveIndices() {
            this.progress("indices");
            List<PgIntroQueries.OneIndex> inds = this.performQuery(QUERIES.getRetrieveIndices());
            if (inds.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<PgModSchema, Unit>(this, inds){
                final /* synthetic */ MySchemaRetriever this$0;
                final /* synthetic */ List $inds;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull PgModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    HashSet<NamingIdentifyingFamily> affectedIndexFamilies = new HashSet<NamingIdentifyingFamily>(this.$inds.size() / 2);
                    for (PgIntroQueries.OneIndex oneIndex : this.$inds) {
                        void $receiver$iv$iv;
                        Iterable $receiver$iv;
                        PgModIndex index2;
                        PgModIndex pgModIndex;
                        PgModLikeStoredTable table;
                        if (this.this$0.getTableOrView(schema, oneIndex.table_kind, oneIndex.table_id) == null) {
                            continue;
                        }
                        PgModLikeStoredTable pgModLikeStoredTable = table;
                        if (pgModLikeStoredTable instanceof PgModLocalTable) {
                            affectedIndexFamilies.add(((PgModLocalTable)table).getIndices());
                            pgModIndex = (PgModIndex)((PgModLocalTable)table).getIndices().renew(oneIndex.index_id, oneIndex.index_name);
                        } else {
                            if (!(pgModLikeStoredTable instanceof PgModMatView)) continue;
                            affectedIndexFamilies.add(((PgModMatView)table).getIndices());
                            pgModIndex = (PgModIndex)((PgModMatView)table).getIndices().renew(oneIndex.index_id, oneIndex.index_name);
                        }
                        PgModIndex pgModIndex2 = index2 = pgModIndex;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModIndex2, (String)"index");
                        pgModIndex2.setStateNumber(oneIndex.state_number);
                        index2.setUnique(oneIndex.is_unique);
                        index2.setFunctionBased(oneIndex.expressions != null);
                        index2.setCondition(StringKt.nullize((String)oneIndex.condition, (boolean)true));
                        if (oneIndex.expressions == null) {
                            String string = oneIndex.column_positions;
                            String string2 = "Index " + oneIndex.index_name + " column positions";
                            PositioningNamingFamily positioningNamingFamily = table.getColumns();
                            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"table.columns");
                            index2.setColNames(PgIntrospectorBaseKt.peekColNames(string, string2, positioningNamingFamily));
                        } else {
                            String string = oneIndex.expressions;
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            List items = StringsKt.split$default((CharSequence)string, (char[])new char[]{'\u001c'}, (boolean)false, (int)0, (int)6, null);
                            index2.setColNames(CollectionsKt.toList((Iterable)items));
                        }
                        if (!oneIndex.can_order || oneIndex.column_options == null) continue;
                        List<Short> options = PgIntrospectorBaseKt.parseArrayOfPositions(oneIndex.column_options, "Index " + oneIndex.index_name + " options");
                        Iterable iterable = $receiver$iv = (Iterable)options;
                        Collection destination$iv$iv = new ArrayList<E>();
                        void $receiver$iv$iv$iv = $receiver$iv$iv;
                        int index$iv$iv$iv = 0;
                        for (T item$iv$iv$iv : $receiver$iv$iv$iv) {
                            String string;
                            String string3;
                            void opt;
                            void element$iv$iv;
                            int n;
                            if ((n = index$iv$iv$iv++) < 0) {
                                throw (Throwable)new ArithmeticException("Index overflow has happened.");
                            }
                            int n2 = n;
                            T t = item$iv$iv$iv;
                            int index$iv$iv = n2;
                            short s = ((Number)element$iv$iv).shortValue();
                            int idx = index$iv$iv;
                            if ((opt & 1) == 1) {
                                List<String> list = index2.getColNames();
                                Intrinsics.checkExpressionValueIsNotNull(list, (String)"index.colNames");
                                string3 = (String)CollectionsKt.getOrNull(list, (int)idx);
                            } else {
                                string3 = null;
                            }
                            if (string3 == null) continue;
                            String it$iv$iv = string = string3;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        Set descColumns = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                        index2.setReverseColNames(descColumns);
                    }
                    for (ModFamily modFamily : affectedIndexFamilies) {
                        modFamily.sort();
                    }
                }
                {
                    this.this$0 = mySchemaRetriever;
                    this.$inds = list;
                    super(1);
                }
            });
        }

        @Override
        protected void processKey(@NotNull PgBaseModKey key2, @NotNull PgBaseModTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)con, (String)"con");
            super.processKey(key2, table, con);
            if (!(table instanceof PgModLocalTable) || !(key2 instanceof PgModKey)) {
                return;
            }
            ((PgModKey)key2).setDeferrable(con.is_deferrable);
            ((PgModKey)key2).setInitiallyDeferred(con.is_init_deferred);
            PgModIndex index2 = (PgModIndex)((PgModLocalTable)table).getIndices().getByObjectId(con.index_id);
            PgModIndex pgModIndex = index2;
            ((PgModKey)key2).setUnderlyingIndexName(pgModIndex != null ? pgModIndex.getRealName() : null);
        }

        @Override
        protected void processForeignKey(@NotNull PgBaseModForeignKey fkey, @NotNull PgBaseModTable table, @NotNull PgBaseIntroQueries.OneConstraint con, @NotNull PgModSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)fkey, (String)"fkey");
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)con, (String)"con");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super.processForeignKey(fkey, table, con, (PgBaseModSchema)schema);
            if (!this.hasReference(con)) {
                return;
            }
            fkey.setDeferrable(con.is_deferrable);
            fkey.setInitiallyDeferred(con.is_init_deferred);
            fkey.setOnUpdate(PgIntrospectorKt.access$cascadeRule(con.on_update));
            fkey.setOnDelete(PgIntrospectorKt.access$cascadeRule(con.on_delete));
        }

        @Override
        protected boolean hasReference(@NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkParameterIsNotNull((Object)con, (String)"con");
            return con.ref_table_id > 0L && con.index_id > 0L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void processCheck(@NotNull PgBaseModTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            int len;
            String predicate;
            PgModCheck check;
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)con, (String)"con");
            if (!(table instanceof PgModTable)) {
                return;
            }
            PgModCheck pgModCheck = check = (PgModCheck)((PgModTable)table).getChecks().renew(con.con_id, con.con_name);
            Intrinsics.checkExpressionValueIsNotNull((Object)pgModCheck, (String)"check");
            pgModCheck.setStateNumber(con.con_state_id);
            String string = con.con_columns;
            String string2 = "Check " + con.con_name + " column positions";
            PositioningNamingFamily positioningNamingFamily = ((PgModTable)table).getColumns();
            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"table.columns");
            check.setColNames(PgIntrospectorBaseKt.peekColNames(string, string2, positioningNamingFamily));
            String string3 = predicate = con.con_expression;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            if ((len = string3.length()) > 2 && predicate.charAt(0) == '(' && predicate.charAt(len - 1) == ')') {
                void $receiver$iv;
                String string4 = predicate;
                int n = 1;
                int n2 = len - 1;
                String string5 = string4.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string4 = string5;
                CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $receiver$iv$iv.charAt(index$iv$iv);
                    boolean bl = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                predicate = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            }
            check.setPredicate(predicate);
            check.setDeferrable(con.is_deferrable);
            check.setInitiallyDeferred(con.is_init_deferred);
        }

        @Override
        protected void sortConstraints(@NotNull PgBaseModTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            super.sortConstraints(table);
            if (!(table instanceof PgModTable)) {
                return;
            }
            ((PgModTable)table).getChecks().sort();
        }

        @Override
        @NotNull
        protected PgBaseModRoutine createRoutine(@NotNull PgModSchema schema, @NotNull PgBaseIntroQueries.OneRoutine r) {
            PgModRoutine routine;
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
            PgModRoutine pgModRoutine = routine = (PgModRoutine)schema.getRoutines().renew(r.r_id, r.r_name);
            Intrinsics.checkExpressionValueIsNotNull((Object)pgModRoutine, (String)"routine");
            pgModRoutine.setStrict(r.is_strict);
            routine.setConcurrencyKind(PgRoutineConcurrencyKind.of(r.concurrency_kind));
            routine.setSecurityDefiner(r.is_security_definer);
            routine.setWindow(r.kind == 'w');
            routine.setCost(r.cost);
            routine.setRows(r.rows);
            routine.setLeakproof(r.is_leakproof);
            routine.setOwner(r.getOwnerName());
            if (r.configuration_parameters != null) {
                if (r.configuration_parameters == null) {
                    Intrinsics.throwNpe();
                }
                routine.setConfigurationParameters(ArraysKt.toMutableList((Object[])r.configuration_parameters));
            }
            return routine;
        }

        @Override
        protected void processAggregate(@NotNull PgBaseIntroQueries.OneAggregate agg, @NotNull PgBaseModAggregate aggregate) {
            Intrinsics.checkParameterIsNotNull((Object)agg, (String)"agg");
            Intrinsics.checkParameterIsNotNull((Object)aggregate, (String)"aggregate");
            super.processAggregate(agg, aggregate);
            PgModAggregate cfr_ignored_0 = (PgModAggregate)aggregate;
            ((PgModAggregate)aggregate).setSortOperatorId(agg.sort_operator_id);
            ((PgModAggregate)aggregate).setSortOperator(agg.sort_operator_name);
            ((PgModAggregate)aggregate).setStateSize(agg.state_size);
            ((PgModAggregate)aggregate).setFinalExtra(agg.final_extra);
            ((PgModAggregate)aggregate).setMovingTransitionId(agg.moving_transition_id);
            ((PgModAggregate)aggregate).setMovingTransition(agg.moving_transition_name);
            ((PgModAggregate)aggregate).setInverseTransitionId(agg.inverse_transition_id);
            ((PgModAggregate)aggregate).setInverseTransition(agg.inverse_transition_name);
            PgModAggregate pgModAggregate = (PgModAggregate)aggregate;
            DataType dataType = this.getMyTypes().get(agg.moving_state_type);
            if (dataType == null) {
                dataType = DataType.UNKNOWN;
            }
            pgModAggregate.setMovingStateType(dataType);
            ((PgModAggregate)aggregate).setMovingStateSize(agg.moving_state_size);
            ((PgModAggregate)aggregate).setMovingFinalId(agg.moving_final_id);
            ((PgModAggregate)aggregate).setMovingFinal(agg.moving_final_name);
            ((PgModAggregate)aggregate).setMovingFinalExtra(agg.moving_final_extra);
            ((PgModAggregate)aggregate).setMovingInitialValue(agg.moving_initial_value);
            ((PgModAggregate)aggregate).setAggregateKind(PgAggregateKind.of(agg.aggregate_kind));
            ((PgModAggregate)aggregate).setDirectArgs(agg.direct_args);
            ((PgModAggregate)aggregate).setCombine(agg.combine_function_name);
            ((PgModAggregate)aggregate).setCombineId(agg.combine_function_id);
            ((PgModAggregate)aggregate).setSerialization(agg.serialization_function_name);
            ((PgModAggregate)aggregate).setSerializationId(agg.serialization_function_id);
            ((PgModAggregate)aggregate).setDeserialization(agg.deserialization_function_name);
            ((PgModAggregate)aggregate).setDeserializationId(agg.deserialization_function_id);
            ((PgModAggregate)aggregate).setConcurrencyKind(PgRoutineConcurrencyKind.of(agg.concurrency_kind));
            ((PgModAggregate)aggregate).setOwner(agg.getOwnerName());
        }

        @Override
        protected void processOperator(@NotNull PgBaseIntroQueries.OneOperator o, @NotNull PgBaseModOperator operator) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            Intrinsics.checkParameterIsNotNull((Object)operator, (String)"operator");
            super.processOperator(o, operator);
            PgBaseModOperator pgBaseModOperator = operator;
            if (!(pgBaseModOperator instanceof PgModOperator)) {
                pgBaseModOperator = null;
            }
            if ((PgModOperator)pgBaseModOperator == null) {
                return;
            }
            ((PgModOperator)operator).setOwner(o.getOwnerName());
        }

        private final void retrieveRules() {
            if (!this.shouldIntrospectTableRelatedData()) {
                return;
            }
            this.progress("rules");
            List<PgIntroQueries.OneRule> rs = this.performQuery(QUERIES.getRetrieveRules());
            this.inSchema((Function1)new Function1<PgModSchema, Unit>(this, rs){
                final /* synthetic */ MySchemaRetriever this$0;
                final /* synthetic */ List $rs;

                public final void invoke(@NotNull PgModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    HashSet<PgModLikeStoredTable> affectedTables = new HashSet<PgModLikeStoredTable>();
                    for (PgIntroQueries.OneRule r : this.$rs) {
                        PgModLikeStoredTable table;
                        PgModRule rule;
                        if (this.this$0.getTableOrView(schema, '\u0000', r.table_id) == null) {
                            continue;
                        }
                        PgModRule pgModRule = rule = (PgModRule)table.getRules().renew(r.rule_id, r.rule_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModRule, (String)"rule");
                        pgModRule.setStateNumber(r.rule_state_number);
                        rule.setEvents(Collections.singleton(TrigEvent.of((char)r.rule_event_code)));
                        rule.setTurn(r.rule_is_instead ? TrigTurn.INSTEAD_OF : TrigTurn.ALSO);
                        PgFireMode pgFireMode = PgFireMode.of(r.rule_fire_mode);
                        if (pgFireMode == null) {
                            pgFireMode = PgFireMode.ORIGIN;
                        }
                        rule.setFireMode(pgFireMode);
                        affectedTables.add(table);
                    }
                    Iterator<E> iterator = affectedTables.iterator();
                    while (iterator.hasNext()) {
                        PgModLikeStoredTable affectedTable;
                        PgModLikeStoredTable pgModLikeStoredTable = affectedTable = (PgModLikeStoredTable)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModLikeStoredTable, (String)"affectedTable");
                        pgModLikeStoredTable.getRules().sort();
                    }
                }
                {
                    this.this$0 = mySchemaRetriever;
                    this.$rs = list;
                    super(1);
                }
            });
        }

        private final void retrieveTriggers() {
            boolean toIntrospect;
            boolean bl = toIntrospect = this.getWasTables$intellij_database_dialects() || this.getMode$intellij_database_dialects().increment && ((PgSchema)this.getSchema()).getTables().hasChildren();
            if (!toIntrospect) {
                return;
            }
            this.progress("triggers");
            List<PgIntroQueries.OneTrigger> ts2 = this.performQuery(QUERIES.getRetrieveTriggers());
            this.inSchema((Function1)new Function1<PgModSchema, Unit>(ts2){
                final /* synthetic */ List $ts;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull PgModSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    HashSet<PgModTable> affectedTables = new HashSet<PgModTable>();
                    for (PgIntroQueries.OneTrigger t : this.$ts) {
                        TrigTurn trigTurn;
                        void that$iv;
                        void $receiver$iv;
                        PgModTable table;
                        PgModTrigger trigger;
                        PgBaseModTable pgBaseModTable = PgModModelFun.findModTableByObjectId(schema, t.table_id);
                        if (!(pgBaseModTable instanceof PgModTable)) {
                            pgBaseModTable = null;
                        }
                        if ((PgModTable)pgBaseModTable == null) {
                            continue;
                        }
                        PgModTrigger pgModTrigger = trigger = (PgModTrigger)table.getTriggers().renew(t.trigger_id, t.trigger_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModTrigger, (String)"trigger");
                        pgModTrigger.setCallRoutineId(t.function_id);
                        trigger.setStateNumber(t.trigger_state_number);
                        byte by = t.bits;
                        int n = 28;
                        PgModTrigger pgModTrigger2 = trigger;
                        void $receiver$iv$iv = $receiver$iv;
                        byte by2 = (byte)(Byte.toUnsignedInt((byte)$receiver$iv$iv) & that$iv);
                        pgModTrigger2.setEvents(PgIntrospectorKt.access$makeTrigEvents(by2));
                        switch (t.bits & 3) {
                            case 0: {
                                trigTurn = TrigTurn.AFTER_STMT;
                                break;
                            }
                            case 1: {
                                trigTurn = TrigTurn.AFTER_ROW;
                                break;
                            }
                            case 2: {
                                trigTurn = TrigTurn.BEFORE_STMT;
                                break;
                            }
                            case 3: {
                                trigTurn = TrigTurn.BEFORE_ROW;
                                break;
                            }
                            default: {
                                trigTurn = null;
                            }
                        }
                        trigger.setTurn(trigTurn);
                        PgFireMode pgFireMode = PgFireMode.of(t.trigger_fire_mode);
                        if (pgFireMode == null) {
                            pgFireMode = PgFireMode.ORIGIN;
                        }
                        trigger.setFireMode(pgFireMode);
                        affectedTables.add(table);
                    }
                    Iterator<E> iterator = affectedTables.iterator();
                    while (iterator.hasNext()) {
                        PgModLikeStoredTable affectedTable;
                        PgModLikeStoredTable pgModLikeStoredTable = affectedTable = (PgModLikeStoredTable)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)pgModLikeStoredTable, (String)"affectedTable");
                        pgModLikeStoredTable.getTriggers().sort();
                    }
                }
                {
                    this.$ts = list;
                    super(1);
                }
            });
        }

        @Override
        protected void processViewSource(@Nullable PgBaseModLikeStoredTable view, @Nullable String sourceText) {
            block1: {
                super.processViewSource(view, sourceText);
                PgBaseModLikeStoredTable pgBaseModLikeStoredTable = view;
                if (!(pgBaseModLikeStoredTable instanceof PgModMatView)) {
                    pgBaseModLikeStoredTable = null;
                }
                PgModMatView pgModMatView = (PgModMatView)pgBaseModLikeStoredTable;
                if (pgModMatView == null) break block1;
                PgIntrospectorKt.access$applySourceText(pgModMatView, sourceText);
            }
        }

        @Override
        protected boolean incrementalViewSources() {
            return PostgresIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 2});
        }

        private final void retrieveRulesSources() {
            if (!this.getWithSources$intellij_database_dialects()) {
                return;
            }
            NamingIdentifyingFamily<? extends PgLocalTable> namingIdentifyingFamily = ((PgSchema)this.getSchema()).getTables();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.tables");
            if (namingIdentifyingFamily.isEmpty()) {
                NamingIdentifyingFamily<? extends PgMatView> namingIdentifyingFamily2 = ((PgSchema)this.getSchema()).getMatViews();
                Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily2, (String)"schema.matViews");
                if (namingIdentifyingFamily2.isEmpty()) {
                    NamingIdentifyingFamily<? extends PgView> namingIdentifyingFamily3 = ((PgSchema)this.getSchema()).getViews();
                    Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily3, (String)"schema.views");
                    if (namingIdentifyingFamily3.isEmpty()) {
                        return;
                    }
                }
            }
            this.progress("rule and trigger sources");
            List<PgIntroQueries.OneRuleSource> rs = this.performQuery(QUERIES.getRetrieveRuleSources());
            if (rs.isEmpty()) {
                return;
            }
            PostgresIntrospector this_$iv = PostgresIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, rs){
                final /* synthetic */ MySchemaRetriever this$0;
                final /* synthetic */ List $rs$inlined;
                {
                    this.this$0 = mySchemaRetriever;
                    this.$rs$inlined = list;
                }

                public final void run() {
                    MySchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<PgModSchema, Unit>(this){
                        final /* synthetic */ MySchemaRetriever$retrieveRulesSources$$inlined$writeSources$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(@NotNull PgModSchema schema) {
                            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                            for (PgIntroQueries.OneRuleSource r : this.this$0.$rs$inlined) {
                                BasicNode basicNode = this.this$0.this$0.getTableOrView(schema, r.table_kind, r.table_id);
                                if (basicNode == null || (basicNode = basicNode.getRules()) == null || (basicNode = (PgModRule)basicNode.getByObjectId(r.rule_id)) == null) {
                                    continue;
                                }
                                BasicNode rule = basicNode;
                                String string = r.source_text;
                                if (string == null) {
                                    Intrinsics.throwNpe();
                                }
                                rule.setSourceText(BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT));
                            }
                        }
                    });
                }
            });
        }

        @Nullable
        protected PgModLikeStoredTable getTableOrView(@NotNull PgModSchema schema, char relKind, long tableId) {
            PgModLikeStoredTable pgModLikeStoredTable;
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            PgBaseModLikeStoredTable pgBaseModLikeStoredTable = super.getTableOrView((PgBaseModSchema)schema, relKind, tableId);
            if (!(pgBaseModLikeStoredTable instanceof PgModLikeStoredTable)) {
                pgBaseModLikeStoredTable = null;
            }
            if ((pgModLikeStoredTable = (PgModLikeStoredTable)pgBaseModLikeStoredTable) == null) {
                char c2 = relKind;
                switch (Character.toLowerCase(c2)) {
                    case 'm': {
                        pgModLikeStoredTable = (PgModLikeStoredTable)schema.getMatViews().getByObjectId(tableId);
                        break;
                    }
                    case 'f': {
                        pgModLikeStoredTable = (PgModLikeStoredTable)schema.getForeignTables().getByObjectId(tableId);
                        break;
                    }
                    case '\u0000': {
                        PgModMatView pgModMatView = (PgModMatView)schema.getMatViews().getByObjectId(tableId);
                        if (pgModMatView != null) {
                            pgModLikeStoredTable = pgModMatView;
                            break;
                        }
                        pgModLikeStoredTable = (PgModLikeStoredTable)schema.getForeignTables().getByObjectId(tableId);
                        break;
                    }
                    default: {
                        pgModLikeStoredTable = null;
                    }
                }
            }
            return pgModLikeStoredTable;
        }

        @Override
        @Nullable
        protected BasicElement findObjectById(@NotNull PgModSchema schema, @Nullable Character kind, long id) {
            BasicElement basicElement;
            Character c2;
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Character c3 = c2 = kind;
            if (c3 != null && c3.charValue() == 'i') {
                Object v3;
                Object res$iv;
                PgModLikeStoredTable $receiver;
                BasicElement it$iv;
                Iterable $receiver$iv$iv;
                Family $receiver$iv;
                block36: {
                    NamingIdentifyingFamily namingIdentifyingFamily = schema.getTables();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tables");
                    $receiver$iv = namingIdentifyingFamily;
                    $receiver$iv$iv = $receiver$iv;
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        BasicElement basicElement2 = it$iv = (BasicElement)element$iv$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicElement2, (String)"it");
                        $receiver = (PgModLocalTable)basicElement2;
                        res$iv = ((IdentifyingFamily)$receiver.getIndices()).getByObjectId(id);
                        if (res$iv == null) continue;
                        v3 = res$iv;
                        break block36;
                    }
                    v3 = null;
                }
                PgModIndex pgModIndex = v3;
                if (pgModIndex != null) {
                    basicElement = pgModIndex;
                } else {
                    Object v8;
                    block37: {
                        NamingIdentifyingFamily namingIdentifyingFamily = schema.getMatViews();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.matViews");
                        $receiver$iv = namingIdentifyingFamily;
                        $receiver$iv$iv = $receiver$iv;
                        for (Object element$iv$iv : $receiver$iv$iv) {
                            BasicElement basicElement3 = it$iv = (BasicElement)element$iv$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement3, (String)"it");
                            $receiver = (PgModMatView)basicElement3;
                            res$iv = ((IdentifyingFamily)$receiver.getIndices()).getByObjectId(id);
                            if (res$iv == null) continue;
                            v8 = res$iv;
                            break block37;
                        }
                        v8 = null;
                    }
                    basicElement = v8;
                }
            } else {
                Character c4 = c2;
                if (c4 != null && c4.charValue() == 'z') {
                    BasicElement basicElement4;
                    Object v12;
                    Object res$iv;
                    PgBaseModCatalogObject $receiver;
                    BasicElement it$iv;
                    Iterable $receiver$iv$iv;
                    Family $receiver$iv;
                    block38: {
                        NamingIdentifyingFamily namingIdentifyingFamily = schema.getTables();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tables");
                        $receiver$iv = namingIdentifyingFamily;
                        $receiver$iv$iv = $receiver$iv;
                        for (Object element$iv$iv : $receiver$iv$iv) {
                            BasicElement basicElement5 = it$iv = (BasicElement)element$iv$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement5, (String)"it");
                            $receiver = (PgModLocalTable)basicElement5;
                            res$iv = ((IdentifyingFamily)$receiver.getChecks()).getByObjectId(id);
                            if (res$iv == null) continue;
                            v12 = res$iv;
                            break block38;
                        }
                        v12 = null;
                    }
                    PgModCheck pgModCheck = v12;
                    if (pgModCheck != null) {
                        basicElement4 = pgModCheck;
                    } else {
                        Object v17;
                        block39: {
                            NamingIdentifyingFamily namingIdentifyingFamily = schema.getForeignTables();
                            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.foreignTables");
                            $receiver$iv = namingIdentifyingFamily;
                            $receiver$iv$iv = $receiver$iv;
                            for (Object element$iv$iv : $receiver$iv$iv) {
                                BasicElement basicElement6 = it$iv = (BasicElement)element$iv$iv;
                                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement6, (String)"it");
                                $receiver = (PgModForeignTable)basicElement6;
                                res$iv = ((IdentifyingFamily)$receiver.getChecks()).getByObjectId(id);
                                if (res$iv == null) continue;
                                v17 = res$iv;
                                break block39;
                            }
                            v17 = null;
                        }
                        basicElement4 = basicElement = (BasicElement)v17;
                    }
                    if (basicElement4 == null) {
                        Object v20;
                        block40: {
                            NamingIdentifyingFamily namingIdentifyingFamily = schema.getDefTypes();
                            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.defTypes");
                            $receiver$iv = namingIdentifyingFamily;
                            $receiver$iv$iv = $receiver$iv;
                            for (Object element$iv$iv : $receiver$iv$iv) {
                                BasicElement basicElement7 = it$iv = (BasicElement)element$iv$iv;
                                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement7, (String)"it");
                                $receiver = (PgModDefType)basicElement7;
                                res$iv = ((IdentifyingFamily)$receiver.getChecks()).getByObjectId(id);
                                if (res$iv == null) continue;
                                v20 = res$iv;
                                break block40;
                            }
                            v20 = null;
                        }
                        basicElement = v20;
                    }
                } else {
                    Character c5 = c2;
                    if (c5 != null && c5.charValue() == 't') {
                        BasicElement basicElement8;
                        BasicElement basicElement9;
                        Object v24;
                        Object res$iv;
                        PgModLikeStoredTable $receiver;
                        BasicElement it$iv;
                        Iterable $receiver$iv$iv;
                        Family $receiver$iv;
                        block41: {
                            NamingIdentifyingFamily namingIdentifyingFamily = schema.getTables();
                            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tables");
                            $receiver$iv = namingIdentifyingFamily;
                            $receiver$iv$iv = $receiver$iv;
                            for (Object element$iv$iv : $receiver$iv$iv) {
                                BasicElement basicElement10 = it$iv = (BasicElement)element$iv$iv;
                                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement10, (String)"it");
                                $receiver = (PgModLocalTable)basicElement10;
                                res$iv = ((IdentifyingFamily)$receiver.getTriggers()).getByObjectId(id);
                                if (res$iv == null) continue;
                                v24 = res$iv;
                                break block41;
                            }
                            v24 = null;
                        }
                        PgModTrigger pgModTrigger = v24;
                        if (pgModTrigger != null) {
                            basicElement9 = pgModTrigger;
                        } else {
                            Object v29;
                            block42: {
                                NamingIdentifyingFamily namingIdentifyingFamily = schema.getForeignTables();
                                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.foreignTables");
                                $receiver$iv = namingIdentifyingFamily;
                                $receiver$iv$iv = $receiver$iv;
                                for (Object element$iv$iv : $receiver$iv$iv) {
                                    BasicElement basicElement11 = it$iv = (BasicElement)element$iv$iv;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)basicElement11, (String)"it");
                                    $receiver = (PgModForeignTable)basicElement11;
                                    res$iv = ((IdentifyingFamily)$receiver.getTriggers()).getByObjectId(id);
                                    if (res$iv == null) continue;
                                    v29 = res$iv;
                                    break block42;
                                }
                                v29 = null;
                            }
                            basicElement9 = basicElement8 = (BasicElement)v29;
                        }
                        if (basicElement9 == null) {
                            Object v33;
                            block43: {
                                NamingIdentifyingFamily namingIdentifyingFamily = schema.getViews();
                                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.views");
                                $receiver$iv = namingIdentifyingFamily;
                                $receiver$iv$iv = $receiver$iv;
                                for (Object element$iv$iv : $receiver$iv$iv) {
                                    BasicElement basicElement12 = it$iv = (BasicElement)element$iv$iv;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)basicElement12, (String)"it");
                                    $receiver = (PgModView)basicElement12;
                                    res$iv = ((IdentifyingFamily)$receiver.getTriggers()).getByObjectId(id);
                                    if (res$iv == null) continue;
                                    v33 = res$iv;
                                    break block43;
                                }
                                v33 = null;
                            }
                            basicElement8 = basicElement = (BasicElement)v33;
                        }
                        if (basicElement8 == null) {
                            Object v36;
                            block44: {
                                NamingIdentifyingFamily namingIdentifyingFamily = schema.getMatViews();
                                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.matViews");
                                $receiver$iv = namingIdentifyingFamily;
                                $receiver$iv$iv = $receiver$iv;
                                for (Object element$iv$iv : $receiver$iv$iv) {
                                    BasicElement basicElement13 = it$iv = (BasicElement)element$iv$iv;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)basicElement13, (String)"it");
                                    $receiver = (PgModMatView)basicElement13;
                                    res$iv = ((IdentifyingFamily)$receiver.getTriggers()).getByObjectId(id);
                                    if (res$iv == null) continue;
                                    v36 = res$iv;
                                    break block44;
                                }
                                v36 = null;
                            }
                            basicElement = v36;
                        }
                    } else {
                        Character c6 = c2;
                        if (c6 != null && c6.charValue() == 'R') {
                            BasicElement basicElement14;
                            BasicElement basicElement15;
                            Object v40;
                            Object res$iv;
                            PgModLikeStoredTable $receiver;
                            BasicElement it$iv;
                            Iterable $receiver$iv$iv;
                            Family $receiver$iv;
                            block45: {
                                NamingIdentifyingFamily namingIdentifyingFamily = schema.getTables();
                                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tables");
                                $receiver$iv = namingIdentifyingFamily;
                                $receiver$iv$iv = $receiver$iv;
                                for (Object element$iv$iv : $receiver$iv$iv) {
                                    BasicElement basicElement16 = it$iv = (BasicElement)element$iv$iv;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)basicElement16, (String)"it");
                                    $receiver = (PgModLocalTable)basicElement16;
                                    res$iv = ((IdentifyingFamily)$receiver.getRules()).getByObjectId(id);
                                    if (res$iv == null) continue;
                                    v40 = res$iv;
                                    break block45;
                                }
                                v40 = null;
                            }
                            PgModRule pgModRule = v40;
                            if (pgModRule != null) {
                                basicElement15 = pgModRule;
                            } else {
                                Object v45;
                                block46: {
                                    NamingIdentifyingFamily namingIdentifyingFamily = schema.getForeignTables();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.foreignTables");
                                    $receiver$iv = namingIdentifyingFamily;
                                    $receiver$iv$iv = $receiver$iv;
                                    for (Object element$iv$iv : $receiver$iv$iv) {
                                        BasicElement basicElement17 = it$iv = (BasicElement)element$iv$iv;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)basicElement17, (String)"it");
                                        $receiver = (PgModForeignTable)basicElement17;
                                        res$iv = ((IdentifyingFamily)$receiver.getRules()).getByObjectId(id);
                                        if (res$iv == null) continue;
                                        v45 = res$iv;
                                        break block46;
                                    }
                                    v45 = null;
                                }
                                basicElement15 = basicElement14 = (BasicElement)v45;
                            }
                            if (basicElement15 == null) {
                                Object v49;
                                block47: {
                                    NamingIdentifyingFamily namingIdentifyingFamily = schema.getViews();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.views");
                                    $receiver$iv = namingIdentifyingFamily;
                                    $receiver$iv$iv = $receiver$iv;
                                    for (Object element$iv$iv : $receiver$iv$iv) {
                                        BasicElement basicElement18 = it$iv = (BasicElement)element$iv$iv;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)basicElement18, (String)"it");
                                        $receiver = (PgModView)basicElement18;
                                        res$iv = ((IdentifyingFamily)$receiver.getRules()).getByObjectId(id);
                                        if (res$iv == null) continue;
                                        v49 = res$iv;
                                        break block47;
                                    }
                                    v49 = null;
                                }
                                basicElement14 = basicElement = (BasicElement)v49;
                            }
                            if (basicElement14 == null) {
                                Object v52;
                                block48: {
                                    NamingIdentifyingFamily namingIdentifyingFamily = schema.getMatViews();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.matViews");
                                    $receiver$iv = namingIdentifyingFamily;
                                    $receiver$iv$iv = $receiver$iv;
                                    for (Object element$iv$iv : $receiver$iv$iv) {
                                        BasicElement basicElement19 = it$iv = (BasicElement)element$iv$iv;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)basicElement19, (String)"it");
                                        $receiver = (PgModMatView)basicElement19;
                                        res$iv = ((IdentifyingFamily)$receiver.getRules()).getByObjectId(id);
                                        if (res$iv == null) continue;
                                        v52 = res$iv;
                                        break block48;
                                    }
                                    v52 = null;
                                }
                                basicElement = v52;
                            }
                        } else {
                            Character c7 = c2;
                            if (c7 != null && c7.charValue() == 'S') {
                                basicElement = (BasicElement)schema.getSequences().getByObjectId(id);
                            } else {
                                Character c8 = c2;
                                basicElement = c8 != null && c8.charValue() == 'C' ? (BasicElement)schema.getCollations().getByObjectId(id) : super.findObjectById((PgBaseModSchema)schema, kind, id);
                            }
                        }
                    }
                }
            }
            return basicElement;
        }

        @Override
        protected boolean wasDataTables() {
            return super.wasDataTables() || this.wasMatViews;
        }

        @Override
        protected boolean shouldIntrospectTableRelatedDataIncremental() {
            return super.shouldIntrospectTableRelatedDataIncremental() || ((PgSchema)this.getSchema()).getViews().hasChildren() || ((PgSchema)this.getSchema()).getMatViews().hasChildren();
        }

        @Override
        @Nullable
        protected PgBaseModLikeStoredTable renewTableOrView(@NotNull PgModSchema schema, char relKind, long objectId, @NotNull String objectName) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)objectName, (String)"objectName");
            BasicIdentifiedElement existing = schema.getDatabase().findIdentifiedElement(objectId);
            PgBaseModLikeStoredTable pgBaseModLikeStoredTable = super.renewTableOrView((PgBaseModSchema)schema, relKind, objectId, objectName);
            if (pgBaseModLikeStoredTable == null) {
                PgBaseModLikeStoredTable pgBaseModLikeStoredTable2;
                switch (relKind) {
                    case 'm': {
                        pgBaseModLikeStoredTable2 = (PgBaseModLikeStoredTable)schema.getMatViews().renew(objectId, objectName);
                        break;
                    }
                    case 'f': {
                        pgBaseModLikeStoredTable2 = (PgBaseModLikeStoredTable)schema.getForeignTables().renew(objectId, objectName);
                        break;
                    }
                    default: {
                        pgBaseModLikeStoredTable2 = null;
                    }
                }
                return pgBaseModLikeStoredTable2;
            }
            PgBaseModLikeStoredTable newRelation = pgBaseModLikeStoredTable;
            BasicIdentifiedElement basicIdentifiedElement = existing;
            if (!(basicIdentifiedElement instanceof PgBaseModLikeStoredTable)) {
                basicIdentifiedElement = null;
            }
            return this.preventDuplicates(newRelation, (PgBaseModLikeStoredTable)basicIdentifiedElement);
        }

        @Override
        protected boolean isTableKind(char kind) {
            return super.isTableKind(kind) || kind == 'p';
        }

        private final PgBaseModLikeStoredTable preventDuplicates(PgBaseModLikeStoredTable newRelation, PgBaseModLikeStoredTable existing) {
            if (existing == null || newRelation == null || Intrinsics.areEqual((Object)existing.getSchema(), (Object)((PgSchema)this.getSchema())) ^ true || Intrinsics.areEqual((Object)existing, (Object)newRelation) || !(existing instanceof PgModLocalTable) || !(newRelation instanceof PgModView)) {
                return newRelation;
            }
            this.copyObjects((PgModLocalTable)existing, (PgModView)newRelation);
            existing.drop();
            return newRelation;
        }

        private final void copyObjects(PgModLocalTable existing, PgModView newRelation) {
            this.copyFamily(existing, newRelation, copyObjects.1.INSTANCE, copyObjects.2.INSTANCE);
            this.copyFamily(existing, newRelation, copyObjects.3.INSTANCE, copyObjects.4.INSTANCE);
        }

        private final <T extends BasicModElement, F extends ModFamily<? extends T>> void copyFamily(PgModLocalTable existing, PgModView newRelation, Function1<? super PgModLocalTable, ? extends F> familyGetter, Function2<? super PgModView, ? super T, ? extends T> factory) {
            Iterator iterator = ((ModFamily)familyGetter.invoke((Object)existing)).iterator();
            while (iterator.hasNext()) {
                BasicModElement item;
                BasicModElement basicModElement = item = (BasicModElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicModElement, (String)"item");
                BasicModElement viewItem = (BasicModElement)factory.invoke((Object)newRelation, (Object)basicModElement);
                HashMap properties = new HashMap();
                item.exportProperties(new NameValueConsumer<String>(properties){
                    final /* synthetic */ HashMap $properties;

                    public final void accept(@NotNull String key2, @NotNull String value) {
                        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
                        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                        Map map = this.$properties;
                        String string = key2;
                        String string2 = value;
                        map.put(string, string2);
                    }
                    {
                        this.$properties = hashMap;
                    }
                });
                viewItem.importProperties(properties);
            }
        }

        public MySchemaRetriever(@NotNull DBTransaction transaction, PgSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((PostgresIntrospectorBase)PostgresIntrospector.this, transaction, (PgBaseSchema)schema);
        }

        public static final /* synthetic */ void access$retrieveSequences(MySchemaRetriever $this) {
            $this.retrieveSequences();
        }

        public static final /* synthetic */ void access$retrieveForeignTables(MySchemaRetriever $this) {
            $this.retrieveForeignTables();
        }

        public static final /* synthetic */ void access$retrieveCollations(MySchemaRetriever $this) {
            $this.retrieveCollations();
        }

        public static final /* synthetic */ void access$retrieveEnumLabels(MySchemaRetriever $this) {
            $this.retrieveEnumLabels();
        }

        public static final /* synthetic */ void access$retrieveIndices(MySchemaRetriever $this) {
            $this.retrieveIndices();
        }

        public static final /* synthetic */ void access$retrieveRules(MySchemaRetriever $this) {
            $this.retrieveRules();
        }

        public static final /* synthetic */ void access$retrieveTriggers(MySchemaRetriever $this) {
            $this.retrieveTriggers();
        }

        public static final /* synthetic */ void access$retrieveRulesSources(MySchemaRetriever $this) {
            $this.retrieveRulesSources();
        }

        public static final /* synthetic */ void access$inSchema(MySchemaRetriever $this, @NotNull Function1 modifier) {
            $this.inSchema(modifier);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0010R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PostgresIntrospector$Companion;", "", "()V", "NATIVE_DEFINITIONS_QUERIES", "", "Lcom/intellij/database/model/ObjectKind;", "", "getNATIVE_DEFINITIONS_QUERIES", "()Ljava/util/Map;", "QUERIES", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "setVersionParameters", "", "version", "Lcom/intellij/database/util/Version;", "parameters", "", "intellij.database.dialects"})
    public static final class Companion {
        @NotNull
        public final Map<ObjectKind, String> getNATIVE_DEFINITIONS_QUERIES() {
            return NATIVE_DEFINITIONS_QUERIES;
        }

        public final void setVersionParameters(@NotNull Version version, @NotNull Map<String, Object> parameters) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            int n = 1;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 8, new IntRange(n, 4), parameters);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 9, new IntRange(n, 9), parameters);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 10, new IntRange(n, 0), parameters);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 11, new IntRange(n, 0), parameters);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

