/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgDatabase;
import com.intellij.database.dialects.postgres.model.PgLocalTable;
import com.intellij.database.dialects.postgres.model.PgModelFun;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgSequence;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgTableColumn;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\n\u0010\u0015\u001a\u00020\u000b*\u00020\u0006\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0002*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a \u0010\u0016\u001a\u0004\u0018\u00010\u001a*\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u001a*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u0017*\u00020\u001f\u001a\n\u0010 \u001a\u00020!*\u00020\"\u001a\n\u0010#\u001a\u00020!*\u00020\"\u001a\n\u0010$\u001a\u00020!*\u00020\u0006\u001a\n\u0010%\u001a\u00020!*\u00020\u0006\u001a\n\u0010&\u001a\u00020\u000b*\u00020\u0006\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006'"}, d2={"ancestors", "", "Lcom/intellij/database/dialects/postgres/model/PgTable;", "getAncestors", "(Lcom/intellij/database/dialects/postgres/model/PgTable;)Ljava/util/List;", "callRoutine", "Lcom/intellij/database/dialects/postgres/model/PgRoutine;", "Lcom/intellij/database/dialects/postgres/model/PgTrigger;", "getCallRoutine", "(Lcom/intellij/database/dialects/postgres/model/PgTrigger;)Lcom/intellij/database/dialects/postgres/model/PgRoutine;", "callRoutineName", "", "getCallRoutineName", "(Lcom/intellij/database/dialects/postgres/model/PgTrigger;)Ljava/lang/String;", "successors", "", "getSuccessors", "(Lcom/intellij/database/dialects/postgres/model/PgTable;)Ljava/util/Set;", "floatToString", "f", "", "costAsString", "findTableByObjectId", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "id", "", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;", "preferredSchema", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;", "getSchemaOfDataType", "Lcom/intellij/database/dialects/postgres/model/PgTableColumn;", "hasDefaultCacheSize", "", "Lcom/intellij/database/dialects/postgres/model/PgSequence;", "hasDefaultType", "isCostDefined", "isRowsDefined", "rowsAsString", "intellij.database.dialects"})
@JvmName(name="PgModelFun")
public final class PgModelFun {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PgTable> getAncestors(@NotNull PgTable $receiver) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        List<Long> ancestorIds = $receiver.getAncestorIds();
        if (ancestorIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PgSchema pgSchema = $receiver.getSchema();
        if (pgSchema == null) {
            return CollectionsKt.emptyList();
        }
        PgSchema schema = pgSchema;
        List<Long> list = ancestorIds;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"ancestorIds");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void id;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            PgSchema pgSchema2 = schema;
            Intrinsics.checkExpressionValueIsNotNull((Object)pgSchema2, (String)"schema");
            void v3 = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"id");
            PgTable pgTable = PgModelFun.findTableByObjectId(pgSchema2, v3.longValue());
            collection.add(pgTable);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PgTable> getSuccessors(@NotNull PgTable $receiver) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Set<Long> successorIds = $receiver.getSuccessorIds();
        if (successorIds.isEmpty()) {
            return SetsKt.emptySet();
        }
        PgSchema pgSchema = $receiver.getSchema();
        if (pgSchema == null) {
            return SetsKt.emptySet();
        }
        PgSchema schema = pgSchema;
        Set<Long> set = successorIds;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"successorIds");
        Iterable $receiver$iv = set;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void id;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            PgSchema pgSchema2 = schema;
            Intrinsics.checkExpressionValueIsNotNull((Object)pgSchema2, (String)"schema");
            void v3 = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"id");
            PgTable pgTable = PgModelFun.findTableByObjectId(pgSchema2, v3.longValue());
            collection.add(pgTable);
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    @Nullable
    public static final PgRoutine getCallRoutine(@NotNull PgTrigger $receiver) {
        PgDatabase database;
        PgSchema schema;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        long id = $receiver.getCallRoutineId();
        if (id == 0L) {
            return null;
        }
        PgSchema pgSchema = $receiver.getSchema();
        if (pgSchema == null) {
            return null;
        }
        PgSchema pgSchema2 = schema = pgSchema;
        Intrinsics.checkExpressionValueIsNotNull((Object)pgSchema2, (String)"schema");
        PgRoutine routine = (PgRoutine)pgSchema2.getRoutines().getByObjectId(id);
        if (routine == null && (database = schema.getDatabase()) != null) {
            for (PgSchema s : database.getSchemas()) {
                if (s == schema) continue;
                PgSchema pgSchema3 = s;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgSchema3, (String)"s");
                routine = (PgRoutine)pgSchema3.getRoutines().getByObjectId(id);
                if (routine == null) continue;
                break;
            }
        }
        return routine;
    }

    @Nullable
    public static final String getCallRoutineName(@NotNull PgTrigger $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PgRoutine pgRoutine = PgModelFun.getCallRoutine($receiver);
        return pgRoutine != null ? pgRoutine.getName() : null;
    }

    @Nullable
    public static final PgBaseTable findTableByObjectId(@NotNull PgBaseDatabase $receiver, long id, @Nullable PgBaseSchema preferredSchema) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PgBaseTable table = null;
        if (preferredSchema != null) {
            table = PgModelFun.findTableByObjectId(preferredSchema, id);
        }
        if (table == null) {
            table = (PgBaseTable)$receiver.getSchemas().jbi().filter((Condition)new Condition<PgBaseSchema>(preferredSchema){
                final /* synthetic */ PgBaseSchema $preferredSchema;

                public final boolean value(PgBaseSchema s) {
                    return Intrinsics.areEqual((Object)s, (Object)this.$preferredSchema) ^ true;
                }
                {
                    this.$preferredSchema = pgBaseSchema;
                }
            }).transform(new Function<E, T>(id){
                final /* synthetic */ long $id;

                @Nullable
                public final PgBaseTable fun(PgBaseSchema s) {
                    PgBaseSchema pgBaseSchema = s;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseSchema, (String)"s");
                    return PgModelFun.findTableByObjectId(pgBaseSchema, this.$id);
                }
                {
                    this.$id = l;
                }
            }).filter((Condition)findTableByObjectId.3.INSTANCE).first();
        }
        return table;
    }

    @Nullable
    public static /* synthetic */ PgBaseTable findTableByObjectId$default(PgBaseDatabase pgBaseDatabase, long l, PgBaseSchema pgBaseSchema, int n, Object object) {
        if ((n & 2) != 0) {
            pgBaseSchema = null;
        }
        return PgModelFun.findTableByObjectId(pgBaseDatabase, l, pgBaseSchema);
    }

    @Nullable
    public static final PgTable findTableByObjectId(@NotNull PgSchema $receiver, long id) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PgLocalTable pgLocalTable = (PgLocalTable)$receiver.getTables().getByObjectId(id);
        return pgLocalTable != null ? (PgTable)pgLocalTable : (PgTable)$receiver.getForeignTables().getByObjectId(id);
    }

    @Nullable
    public static final PgBaseTable findTableByObjectId(@NotNull PgBaseSchema $receiver, long id) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PgBaseSchema pgBaseSchema = $receiver;
        return pgBaseSchema instanceof PgSchema ? (PgBaseTable)PgModelFun.findTableByObjectId((PgSchema)$receiver, id) : (PgBaseTable)$receiver.getTables().getByObjectId(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCostDefined(@NotNull PgRoutine $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (Float.compare($receiver.getCost(), 0.0f) == 0) return false;
        if (StringsKt.equals((String)$receiver.getLanguageName(), (String)"c", (boolean)true)) {
            if (Float.compare($receiver.getCost(), 1.0f) == 0) return false;
            return true;
        }
        if (Float.compare($receiver.getCost(), 100) == 0) return false;
        return true;
    }

    @NotNull
    public static final String costAsString(@NotNull PgRoutine $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PgModelFun.floatToString($receiver.getCost());
    }

    public static final boolean isRowsDefined(@NotNull PgRoutine $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Float.compare($receiver.getRows(), 0.0f) != 0 && Float.compare($receiver.getRows(), 1000) != 0;
    }

    @NotNull
    public static final String rowsAsString(@NotNull PgRoutine $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PgModelFun.floatToString($receiver.getRows());
    }

    public static final boolean hasDefaultType(@NotNull PgSequence $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getDataType() == null || StringsKt.equals((String)$receiver.getDataType(), (String)"bigint", (boolean)true);
    }

    public static final boolean hasDefaultCacheSize(@NotNull PgSequence $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        long l = $receiver.getCacheSize();
        return 0L <= l && 1L >= l;
    }

    @Nullable
    public static final PgSchema getSchemaOfDataType(@NotNull PgTableColumn $receiver) {
        BasicSchema basicSchema;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        DataType type = $receiver.getDataType();
        if (type.schemaName == null) {
            return $receiver.getSchema();
        }
        BasicModel basicModel = $receiver.getModel();
        Condition nameCondition = DasUtil.byName((String)type.schemaName, (CasingProvider)(basicModel != null ? (CasingProvider)basicModel : DasUtil.NO_CASING_PROVIDER));
        BasicNode basicNode = $receiver.getDatabase();
        if (!((basicNode != null && (basicNode = basicNode.getSchemas()) != null ? (BasicSchema)basicNode.find((Predicate)new Predicate<BasicSchema>(nameCondition){
            final /* synthetic */ Condition $nameCondition;

            public final boolean test(BasicSchema it) {
                return this.$nameCondition.value((Object)it);
            }
            {
                this.$nameCondition = condition;
            }
        }) : (basicSchema = null)) instanceof PgSchema)) {
            basicSchema = null;
        }
        return (PgSchema)basicSchema;
    }

    private static final String floatToString(float f) {
        float f2 = f;
        return Float.isInfinite(f2) ? "infinity" : String.valueOf((long)f);
    }
}

