/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgDatabase;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgres.model.PgLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgModLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgModSequence;
import com.intellij.database.dialects.postgres.model.PgModelFun;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgSequence;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgTableColumn;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.PgDataTypeSubKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgModelHelper
implements ModelHelper {
    @Override
    @Nullable
    public Icon getIcon(@NotNull BasicElement o) {
        PgRole role;
        if (o == null) {
            PgModelHelper.$$$reportNull$$$0(0);
        }
        if (o instanceof PgDefType) {
            PgDefType pgd = (PgDefType)o;
            switch (pgd.getSubKind()) {
                case ENUM: {
                    return AllIcons.Nodes.Enum;
                }
            }
        } else if (o instanceof PgRole && (role = (PgRole)o).isCanLogin()) {
            return DbPresentation.getIcon(ObjectKind.USER);
        }
        return ModelHelper.super.getIcon(o);
    }

    @Override
    @Nullable
    public String nodeTriggerSuffix(@NotNull BasicTrigger o) {
        if (o == null) {
            PgModelHelper.$$$reportNull$$$0(1);
        }
        if (o instanceof PgTrigger) {
            String routineName = PgModelFun.getCallRoutineName((PgTrigger)o);
            return " " + DbPresentation.arrow() + " " + routineName;
        }
        return null;
    }

    @Override
    @Nullable
    public String nodeTableSuffix(@NotNull BasicTable delegate) {
        if (delegate == null) {
            PgModelHelper.$$$reportNull$$$0(2);
        }
        if (delegate instanceof PgTable) {
            PgTable pt = (PgTable)delegate;
            boolean hasAncestors = !pt.getAncestorIds().isEmpty();
            boolean hasSuccessors = !pt.getSuccessorIds().isEmpty();
            String s = "";
            if (hasAncestors) {
                s = " based on (" + ModelFun.namesAsString(PgModelFun.getAncestors(pt)) + ')';
            }
            if (hasAncestors && hasSuccessors) {
                s = s + " and";
            }
            if (hasSuccessors) {
                s = s + " the base for {" + ModelFun.namesAsString(PgModelFun.getSuccessors(pt)) + '}';
            }
            if (hasAncestors || hasSuccessors) {
                return " " + s;
            }
        }
        return null;
    }

    @Override
    public void exportApplyColumn(@NotNull SchemaApplyHelper helper, @NotNull DeColumn from, @NotNull BasicModTableColumn to) {
        if (helper == null) {
            PgModelHelper.$$$reportNull$$$0(3);
        }
        if (from == null) {
            PgModelHelper.$$$reportNull$$$0(4);
        }
        if (to == null) {
            PgModelHelper.$$$reportNull$$$0(5);
        }
        if (to instanceof PgModLocalTableColumn) {
            PgModelHelper.applyPgColumn(from, (PgModLocalTableColumn)to);
        } else {
            ModelHelper.super.exportApplyColumn(helper, from, to);
        }
    }

    @Override
    public void exportLightExport(@NotNull SchemaExportHelper helper, @NotNull DeColumn to, @NotNull BasicTableColumn from) {
        if (helper == null) {
            PgModelHelper.$$$reportNull$$$0(6);
        }
        if (to == null) {
            PgModelHelper.$$$reportNull$$$0(7);
        }
        if (from == null) {
            PgModelHelper.$$$reportNull$$$0(8);
        }
        if (from instanceof PgLocalTableColumn) {
            PgLocalTableColumn col = (PgLocalTableColumn)from;
            if (col.getSequenceName() != null) {
                to.flags.add(DeColumn.Flag.AUTO_INC);
            }
            helper.export(col.getSequence(), false);
        }
    }

    @Override
    public boolean gridColumnHasDefaultValue(BasicElement column2) {
        if (column2 instanceof PgTableColumn) {
            PgDefType type = ((PgTableColumn)column2).getDefType();
            return type != null && type.getDefaultExpression() != null;
        }
        return ModelHelper.super.gridColumnHasDefaultValue(column2);
    }

    @Override
    public int getJdbcType(BasicTypedElement element2) {
        if (element2 instanceof PgTableColumn) {
            PgDataTypeSubKind kind;
            PgTableColumn modelColumn = (PgTableColumn)element2;
            PgSchema schema = modelColumn.getSchema();
            PgDatabase database = schema == null ? null : schema.getDatabase();
            PgDefType defType = database == null ? null : (PgDefType)ObjectUtils.tryCast((Object)database.findIdentifiedElement(modelColumn.getTypeId()), PgDefType.class);
            PgDataTypeSubKind pgDataTypeSubKind = kind = defType == null ? null : defType.getSubKind();
            if (kind == PgDataTypeSubKind.ENUM) {
                return 12;
            }
        }
        return ModelHelper.super.getJdbcType(element2);
    }

    @Override
    public void ddlPreviewProcessCorrespondence(@NotNull Collection<ElementDelta<?>> correspondence, @NotNull ElementDelta<BasicElement> delta) {
        if (correspondence == null) {
            PgModelHelper.$$$reportNull$$$0(9);
        }
        if (delta == null) {
            PgModelHelper.$$$reportNull$$$0(10);
        }
        if (delta.getSourceElement() instanceof PgLocalTableColumn || delta.getTargetElement() instanceof PgLocalTableColumn) {
            PgSequence s2;
            PgLocalTableColumn c1 = (PgLocalTableColumn)delta.getSourceElement();
            PgLocalTableColumn c2 = (PgLocalTableColumn)delta.getTargetElement();
            PgSequence s1 = c1 == null ? null : c1.getSequence();
            PgSequence pgSequence = s2 = c2 == null ? null : c2.getSequence();
            if (s1 != null || s2 != null) {
                correspondence.add(ElementDelta.create(s1, s2));
            }
        }
    }

    @Override
    public void docAppendInfo(@NotNull BasicElement delegate, @NotNull StringBuilder sb) {
        if (delegate == null) {
            PgModelHelper.$$$reportNull$$$0(11);
        }
        if (sb == null) {
            PgModelHelper.$$$reportNull$$$0(12);
        }
        if (delegate instanceof PgTable) {
            PgTable pgTable = (PgTable)delegate;
            if (!pgTable.getAncestorIds().isEmpty()) {
                List<PgTable> ancestors = PgModelFun.getAncestors(pgTable);
                PgModelHelper.appendPgInheritanceTables(sb, ancestors, "Inherits ");
            }
            if (!pgTable.getSuccessorIds().isEmpty()) {
                Set<PgTable> successors2 = PgModelFun.getSuccessors(pgTable);
                PgModelHelper.appendPgInheritanceTables(sb, successors2, "Base for ");
            }
        }
    }

    private static void appendPgInheritanceTables(@NotNull StringBuilder b2, @NotNull Collection<PgTable> tables, @NotNull String tablesAlias) {
        if (b2 == null) {
            PgModelHelper.$$$reportNull$$$0(13);
        }
        if (tables == null) {
            PgModelHelper.$$$reportNull$$$0(14);
        }
        if (tablesAlias == null) {
            PgModelHelper.$$$reportNull$$$0(15);
        }
        b2.append("<br>").append(tablesAlias).append(' ');
        b2.append(tables.size() >= 2 ? "tables: " : "table: ");
        boolean first = true;
        for (PgTable table : tables) {
            if (first) {
                first = false;
            } else {
                b2.append(',').append(' ');
            }
            b2.append("<b><tt>").append(table.getName()).append("</tt></b>");
        }
        b2.append("<br>");
    }

    private static void applyPgColumn(DeColumn from, PgModLocalTableColumn col) {
        PgSequence prevSeq;
        PgLocalTableColumn prev = (PgLocalTableColumn)ObjectUtils.tryCast((Object)DbRenamePsiElementProcessor.unwrapDeElement(from), PgLocalTableColumn.class);
        String prevSeqName = prev == null ? null : prev.getSequenceName();
        PgSequence pgSequence = prevSeq = prev == null ? null : prev.getSequence();
        if (from.flags.contains((Object)DeColumn.Flag.AUTO_INC)) {
            String seqName = prevSeqName == null ? col.getTableName() + "_" + col.getName() + "_seq" : prevSeqName;
            PgModSequence seq = (PgModSequence)col.getSchema().getSequences().createOrGet(seqName);
            if (prevSeq != null) {
                BasicMetaUtils.copyProperties(prevSeq, seq, false);
            } else {
                seq.setOwnedByColumn(true);
            }
            col.setBelongingSequenceName(seqName);
            String schemaName = col.getSchema().getName();
            col.setDefaultExpression(prevSeqName == null ? "nextval('" + (schemaName.isEmpty() ? "" : schemaName + ".") + seqName + "')" : prev.getDefaultExpression());
        } else {
            col.setBelongingSequenceName(null);
            boolean notChangedSeq = prevSeqName != null && Comparing.equal((String)from.defaultValue, (String)prev.getDefaultExpression());
            col.setDefaultExpression(notChangedSeq ? null : from.defaultValue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "correspondence";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delta";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablesAlias";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/postgres/model/PgModelHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "nodeTriggerSuffix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "nodeTableSuffix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "exportApplyColumn";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "exportLightExport";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "ddlPreviewProcessCorrespondence";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "docAppendInfo";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "appendPgInheritanceTables";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

