/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.PostgresDialectHelper;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.redshift.model.RsMetaModel;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.JBIterable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedshiftDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final RedshiftDialect INSTANCE = new RedshiftDialect();
    private static final int FRACTIONAL_SECONDS_PRECISION_MAX = 6;

    protected RedshiftDialect() {
        super(new TypeHelper.PostgresTypeHelper(), BasicNamespace.LOWER_CASING);
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = RsMetaModel.MODEL;
        if (basicMetaModel == null) {
            RedshiftDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.REDSHIFT;
        if (dbms == null) {
            RedshiftDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Redshift;
        if (icon == null) {
            RedshiftDialect.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Redshift" == null) {
            RedshiftDialect.$$$reportNull$$$0(3);
        }
        return "Redshift";
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            RedshiftDialect.$$$reportNull$$$0(4);
        }
        return kind == ObjectKind.FOREIGN_TABLE ? "EXTERNAL TABLE" : super.getNameForKind(kind);
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> getSupportedFkUpdate() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class);
        if (valuesCapability == null) {
            RedshiftDialect.$$$reportNull$$$0(5);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> getSupportedFkDelete() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class);
        if (valuesCapability == null) {
            RedshiftDialect.$$$reportNull$$$0(6);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> getSupportedFkDeferrable() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class);
        if (valuesCapability == null) {
            RedshiftDialect.$$$reportNull$$$0(7);
        }
        return valuesCapability;
    }

    @Override
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            RedshiftDialect.$$$reportNull$$$0(8);
        }
        return "E'\\\\x" + DialectUtils.toHexString(binaryData) + "'";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            RedshiftDialect.$$$reportNull$$$0(9);
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase(Locale.ENGLISH).startsWith("postgresql");
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            RedshiftDialect.$$$reportNull$$$0(10);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                RedshiftDialect.$$$reportNull$$$0(11);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        if (jdbcType == -7 && "bool".equals(typeName)) {
            if ("bool" == null) {
                RedshiftDialect.$$$reportNull$$$0(12);
            }
            return "bool";
        }
        if (jdbcType == -5 && "oid".equals(typeName)) {
            if ("oid" == null) {
                RedshiftDialect.$$$reportNull$$$0(13);
            }
            return "oid";
        }
        if (jdbcType == 93 || jdbcType == 92) {
            int fractionalSecondsPrecision = dataType.getScale();
            String string = JdbcUtil.getJdbcTypeName((DataType)dataType, (boolean)false) + (fractionalSecondsPrecision != 6 ? "(" + fractionalSecondsPrecision + ")" : "");
            if (string == null) {
                RedshiftDialect.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (jdbcType == 2) {
            String string = "numeric" + (dataType.getLength() == 131089 ? "" : "(" + dataType.getPrecision() + (dataType.getScale() == 0 ? "" : ", " + dataType.getScale()) + ")");
            if (string == null) {
                RedshiftDialect.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            RedshiftDialect.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    public boolean supportsAlterColumnNull() {
        return false;
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(17);
        }
        if (procedure == null) {
            RedshiftDialect.$$$reportNull$$$0(18);
        }
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type);
        builder.space();
        builder.qualifiedRef((DasObject)procedure).symbol("(");
        boolean first = true;
        for (DasArgument arg : DasUtil.getParameters((DasRoutine)procedure)) {
            DasArgument.Direction direction = arg.getArgumentDirection();
            if (direction != DasArgument.Direction.IN && direction != DasArgument.Direction.INOUT) continue;
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.type((DasTypedObject)arg);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(19);
        }
        return ddlBuilder;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(20);
        }
        if (view == null) {
            RedshiftDialect.$$$reportNull$$$0(21);
        }
        if (definition == null) {
            RedshiftDialect.$$$reportNull$$$0(22);
        }
        if (checkOption == null) {
            RedshiftDialect.$$$reportNull$$$0(23);
        }
        builder.keywords("CREATE", "OR", "REPLACE", "VIEW").space().qualifiedRef((DasObject)view).space().keyword("AS").space().plain(definition);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(24);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(25);
        }
        if (view == null) {
            RedshiftDialect.$$$reportNull$$$0(26);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, cascade);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(28);
        }
        if (sequence == null) {
            RedshiftDialect.$$$reportNull$$$0(29);
        }
        throw new UnsupportedOperationException("Drop sequence is not supported by Redshift");
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection2) throws Exception {
        if (table == null) {
            RedshiftDialect.$$$reportNull$$$0(30);
        }
        if (connection2 == null) {
            RedshiftDialect.$$$reportNull$$$0(31);
        }
        String string = PostgresDialectHelper.getTableDefinition(table, connection2);
        if (string == null) {
            RedshiftDialect.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element2, @NotNull DatabaseConnection connection2) throws Exception {
        if (element2 == null) {
            RedshiftDialect.$$$reportNull$$$0(33);
        }
        if (connection2 == null) {
            RedshiftDialect.$$$reportNull$$$0(34);
        }
        Dbms dbms = connection2.getDbms();
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection2, String.format("SELECT CAST(reltuples as INT) as rows FROM pg_catalog.pg_class C\n  LEFT JOIN pg_catalog.pg_namespace N ON (N.oid = C.relnamespace)\nWHERE (relkind = 'r' OR relkind = 'v') AND nspname LIKE '%s' ESCAPE '#' AND relname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element2), true, dbms), DbImplUtil.escapeSql(element2.getName(), true, dbms)), new String[0]);
        if (map == null) {
            RedshiftDialect.$$$reportNull$$$0(35);
        }
        return map;
    }

    @Override
    public boolean supportsSearchPath() {
        return true;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        if (system == null) {
            RedshiftDialect.$$$reportNull$$$0(36);
        }
        if (connection2 == null) {
            RedshiftDialect.$$$reportNull$$$0(37);
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection2, "select current_database() as a, current_schemas(false) as b", new String[0]);
        String db = String.valueOf(map.get("a"));
        Object[] schemas2 = (Object[])ObjectUtils.tryCast((Object)map.get("b"), Object[].class);
        if (StringUtil.isEmpty((String)db) || schemas2 == null || schemas2.length == 0) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create((String)db, (ObjectKind)ObjectKind.DATABASE);
        return SearchPath.of((List)JBIterable.of((Object[])schemas2).filter(String.class).transform(s -> dbPath.append(s, ObjectKind.SCHEMA)).toList());
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            RedshiftDialect.$$$reportNull$$$0(38);
        }
        if (path.getCurrent().kind != ObjectKind.SCHEMA) {
            return null;
        }
        DdlBuilder builder = new DdlBuilder().plain("set search_path = ").quoteIdentifiers(true);
        boolean first = true;
        for (ObjectPath e : path.elements) {
            if (!first) {
                builder.plain(", ");
            }
            first = false;
            builder.identifier(e.getName());
        }
        return builder.getStatement();
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            RedshiftDialect.$$$reportNull$$$0(39);
        }
        return Pair.create((Object)("select view_definition from information_schema.views where table_schema = '" + DasUtil.getSchema((DasObject)element2) + "' and table_name = '" + element2.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            RedshiftDialect.$$$reportNull$$$0(40);
        }
        Pair pair = Pair.create((Object)("select routine_definition from information_schema.routines where routine_schema = '" + DasUtil.getSchema((DasObject)element2) + "' and routine_name = '" + element2.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            RedshiftDialect.$$$reportNull$$$0(41);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnection connection2) throws Exception {
        Version curVersion;
        DdlBuilder builder;
        block6: {
            String string;
            if (proc == null) {
                RedshiftDialect.$$$reportNull$$$0(42);
            }
            if (connection2 == null) {
                RedshiftDialect.$$$reportNull$$$0(43);
            }
            Dbms dbms = connection2.getDbms();
            DatabaseMetaData md = (DatabaseMetaData)ObjectUtils.assertNotNull((Object)connection2.getMetaData());
            builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
            curVersion = Version.of((int[])new int[]{md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()});
            try {
                if (!curVersion.isOrGreater(new int[]{8, 4})) break block6;
                string = DbImplUtil.concatStringResults(connection2, dbms, "SELECT pg_get_functiondef(p.oid) FROM pg_proc p JOIN pg_namespace n ON n.oid=pronamespace WHERE proname = " + PostgresDialectHelper.str(proc.getName()) + " AND nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)proc)), 0, DbImplUtil.ConcatenationProps.LINES);
            }
            catch (Exception e) {
                Logger.getInstance(this.getClass()).info((Throwable)e);
            }
            if (string == null) {
                RedshiftDialect.$$$reportNull$$$0(44);
            }
            return string;
        }
        boolean isPre81 = Version.of((int[])new int[]{8, 0}).isOrGreater(curVersion);
        int limit = Math.max(10, Iterables.size((Iterable)proc.getArguments())) + 5;
        String s = "SELECT proname, proisagg, prosecdef, proisstrict, proretset, provolatile, pronargs, prosrc, probin,\n       lanname, \n" + PostgresDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ",\n" + PostgresDialectHelper.select(limit, isPre81) + "\n       " + (isPre81 ? "null dummy" : "proargmodes, pg_catalog.pg_get_expr(proargdefaults, 0) as proargdefaults") + "\n  FROM pg_proc\n  JOIN pg_namespace nsp ON nsp.oid=pronamespace\n  JOIN pg_language l ON l.oid=prolang\n" + PostgresDialectHelper.joinType("tr", "prorettype", isPre81) + "\n" + PostgresDialectHelper.join(limit, isPre81) + "  WHERE proname = " + PostgresDialectHelper.str(proc.getName()) + " AND nsp.nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)proc)) + "\n";
        SmartStatements.poweredBy(connection2).simple().noisy().execute(s, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<ResultSet, Exception>)((ThrowableConsumer)rs -> {
            if (proc == null) {
                RedshiftDialect.$$$reportNull$$$0(60);
            }
            while (rs.next()) {
                builder.keywords("CREATE", "OR", "REPLACE", "FUNCTION").space().qualifiedRef((DasObject)proc).symbol("(");
                PostgresDialectHelper.SignatureBuilder signatureBuilder = new PostgresDialectHelper.SignatureBuilder(isPre81, (ResultSet)rs);
                signatureBuilder.buildArguments(builder);
                builder.symbol(")").newLine().space(2).keyword("RETURNS").space();
                signatureBuilder.buildReturn(builder);
                String language = rs.getString("lanname");
                String src = ((String)ObjectUtils.notNull((Object)rs.getString("prosrc"), (Object)"")).trim();
                if ("c".equals(language)) {
                    builder.newLine().keyword("AS").newLine().symbol("'").plain(rs.getString("probin")).symbol("'").symbol(",").space().symbol("'").plain(src).symbol("'");
                } else {
                    builder.newLine().keyword("AS").newLine().plain("$BODY$").newLine().plain(src).newLine().plain("$BODY$").newLine().keyword("LANGUAGE").space().plain(language).space();
                }
                String provolatile = rs.getString("provolatile");
                if ("v".equals(provolatile)) {
                    builder.keyword("VOLATILE");
                } else if ("i".equals(provolatile)) {
                    builder.keyword("IMMUTABLE");
                } else {
                    builder.keyword("STABLE");
                }
                if (rs.getBoolean("proisstrict")) {
                    builder.space().keyword("STRICT");
                }
                if (rs.getBoolean("prosecdef")) {
                    builder.space().keyword("SECURITY DEFINER");
                }
                builder.newStatement();
            }
        })));
        String string = builder.getStatement();
        if (string == null) {
            RedshiftDialect.$$$reportNull$$$0(45);
        }
        return string;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            RedshiftDialect.$$$reportNull$$$0(46);
        }
        throw new UnsupportedOperationException("Sequence definition is not supported by Redshift");
    }

    @Override
    public boolean supportsQualifiedAsteriskInCalls() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine, boolean longMode, boolean withReturn) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(47);
        }
        if (routine == null) {
            RedshiftDialect.$$$reportNull$$$0(48);
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)routine);
        boolean returnsTypeExplicit = false;
        String returnsTypeSpec = null;
        DasArgument returnArg = routine.getReturnArgument();
        if (returnArg != null) {
            returnsTypeExplicit = true;
            returnsTypeSpec = returnArg.getDataType().getSpecification();
        }
        int outs2 = 0;
        for (DasArgument parameter : parameters) {
            if (!parameter.getArgumentDirection().isOut()) continue;
            ++outs2;
        }
        builder.symbol("(");
        boolean first = true;
        for (DasArgument parameter : parameters) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            DasArgument.Direction argumentDirection = parameter.getArgumentDirection();
            if (longMode || !argumentDirection.isIn()) {
                if (StringUtil.isNotEmpty((String)parameter.getName())) {
                    builder.identifier((DasObject)parameter, parameter.getName()).space();
                }
                if (argumentDirection.isOut()) {
                    if (argumentDirection.isIn()) {
                        builder.keyword("in").space();
                    }
                    builder.keyword("out").space();
                }
            }
            builder.type((DasTypedObject)parameter);
        }
        builder.symbol(")");
        if (!returnsTypeExplicit) {
            if (outs2 == 1) {
                for (DasArgument parameter : parameters) {
                    if (!parameter.getArgumentDirection().isOut()) continue;
                    returnsTypeSpec = parameter.getDataType().getSpecification();
                }
            } else {
                returnsTypeSpec = "record";
            }
        }
        if (returnsTypeExplicit && withReturn && StringUtil.isNotEmpty((String)returnsTypeSpec)) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type(returnsTypeSpec);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(49);
        }
        return ddlBuilder;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        char c0;
        if (identifier == null) {
            RedshiftDialect.$$$reportNull$$$0(50);
        }
        if (!Character.isLetter(c0 = identifier.charAt(0)) && c0 != '_') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c2 = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '$' || c2 == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        DasObject schema;
        if (identifier == null) {
            RedshiftDialect.$$$reportNull$$$0(51);
        }
        if (qualifier == null) {
            RedshiftDialect.$$$reportNull$$$0(52);
        }
        DasObject schemaOrExternal = (schema = DasUtil.getSchemaObject((DasObject)qualifier)) == null ? DasUtil.getParentOfKind((DasObject)qualifier, (ObjectKind)ObjectKind.EXTERNAL_SCHEMA, (boolean)false) : schema;
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schemaOrExternal, DasUtil.getName((DasObject)schemaOrExternal), null, null, null, null);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(53);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            RedshiftDialect.$$$reportNull$$$0(54);
        }
        if ("character_data".equalsIgnoreCase(nativeColumnTypeName)) {
            return 1;
        }
        if ("cardinal_number".equalsIgnoreCase(nativeColumnTypeName)) {
            return 4;
        }
        if ("xml".equalsIgnoreCase(nativeColumnTypeName)) {
            return 12;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(55);
        }
        if (statement == null) {
            RedshiftDialect.$$$reportNull$$$0(56);
        }
        builder.keywords("explain").space();
        if (analyze) {
            throw new UnsupportedOperationException("EXPLAIN ANALYZE is not supported by Redshift");
        }
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(57);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection2) throws SQLException {
        if (connection2 == null) {
            RedshiftDialect.$$$reportNull$$$0(58);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection2, "SELECT datname as name FROM pg_database WHERE datistemplate = false", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            RedshiftDialect.$$$reportNull$$$0(59);
        }
        return list;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return false;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return "set search_path to default";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/redshift/RedshiftDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 31: 
            case 34: 
            case 37: 
            case 43: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 42: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/redshift/RedshiftDialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDelete";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDeferrable";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryToLoadProcedureDefinition$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

