/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseCreateGenerator;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateTable;
import com.intellij.database.dialects.redshift.model.RsExternalTable;
import com.intellij.database.dialects.redshift.model.RsExternalTableColumn;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.RsExternalTableStorageType;
import com.intellij.database.script.generator.HeaderFooter;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J \u0010\u000f\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001aH\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/redshift/generator/producers/RsCreateExternalTable;", "Lcom/intellij/database/dialects/base/generator/producers/CreateTable;", "Lcom/intellij/database/dialects/redshift/model/RsExternalTable;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/redshift/model/RsExternalTable;)V", "canComment", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "", "elementKindNameForCreate", "", "Lcom/intellij/database/model/basic/BasicElement;", "externalTableFooter", "externalTableHeader", "findProperty", "properties", "", "key", "generateRowFormat", "table", "fieldDelimiter", "generateSerDeRowFormat", "makeTableHeaderFooter", "Lcom/intellij/database/script/generator/HeaderFooter;", "registerColumn", "Lcom/intellij/database/dialects/base/generator/Operation;", "generator", "Lcom/intellij/database/dialects/base/generator/BaseCreateGenerator;", "column", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "root", "intellij.database.dialects"})
public final class RsCreateExternalTable
extends CreateTable<RsExternalTable> {
    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canComment() {
        return AbstractScriptGeneratorKt.getUNSUPPORTED();
    }

    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter() {
        return new HeaderFooter(this.externalTableHeader(), this.externalTableFooter());
    }

    @Override
    @Nullable
    protected Operation registerColumn(@NotNull BaseCreateGenerator generator, @NotNull BasicTableOrViewColumn column2, @NotNull Operation root2) {
        Operation operation2;
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        Operation operation3 = super.registerColumn(generator, column2, root2);
        if (operation3 != null) {
            Operation operation4;
            Operation $receiver = operation4 = operation3;
            $receiver.setProvided(column2 instanceof RsExternalTableColumn && ((RsExternalTableColumn)column2).getPartitionKeyOrder() != 0);
            operation2 = operation4;
        } else {
            operation2 = null;
        }
        return operation2;
    }

    /*
     * WARNING - void declaration
     */
    private final String externalTableHeader() {
        void $receiver$iv;
        void this_$iv;
        String[] stringArray = new String[3];
        ObjectKind objectKind = ((RsExternalTable)this.getElement()).getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
        stringArray[0] = BaseProducersKt.createOrReplace(this, objectKind);
        stringArray[1] = this.elementKindNameForCreate((BasicElement)this.getElement());
        StringBuilder stringBuilder = new StringBuilder();
        String string = ((RsExternalTable)this.getElement()).getSchemaName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.schemaName!!");
        String string2 = string;
        RsCreateExternalTable rsCreateExternalTable = this;
        StringBuilder stringBuilder2 = stringBuilder;
        int n = 2;
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        String string3 = this_$iv.getContext().getNaming().nameToScript((String)$receiver$iv, false);
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append('.');
        String string4 = this.nameScr();
        if (string4 == null) {
            string4 = "???";
        }
        stringArray2[n] = stringBuilder3.append(string4).toString();
        return ScriptingUtilsKt.phrase(stringArray3);
    }

    @Override
    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        ObjectKind objectKind = element2.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE) ? "external table" : super.elementKindNameForCreate(element2);
    }

    private final String externalTableFooter() {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean hasNullStorageFormats;
        boolean unknownStorage;
        block11: {
            boolean bl;
            String[] $receiver$iv2;
            unknownStorage = ((RsExternalTable)this.getElement()).getStorageType() == RsExternalTableStorageType.UNKNOWN;
            for (String element$iv : $receiver$iv2 = new String[]{((RsExternalTable)this.getElement()).getInputFormat(), ((RsExternalTable)this.getElement()).getOutputFormat(), ((RsExternalTable)this.getElement()).getLocation()}) {
                String it = element$iv;
                if (!(it == null)) continue;
                bl = true;
                break block11;
            }
            bl = hasNullStorageFormats = false;
        }
        if (unknownStorage && hasNullStorageFormats) {
            return "-- unable to generate footer: broken storage attributes";
        }
        StringBuilder sb = new StringBuilder();
        PositioningNamingFamily<? extends RsExternalTableColumn> positioningNamingFamily = ((RsExternalTable)this.getElement()).getColumns();
        Intrinsics.checkExpressionValueIsNotNull(positioningNamingFamily, (String)"element.columns");
        Iterable iterable = $receiver$iv = (Iterable)positioningNamingFamily;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            RsExternalTableColumn it;
            RsExternalTableColumn rsExternalTableColumn = it = (RsExternalTableColumn)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)rsExternalTableColumn, (String)"it");
            if (!(rsExternalTableColumn.getPartitionKeyOrder() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        Object object = new Comparator<T>(){

            public final int compare(T a, T b2) {
                RsExternalTableColumn it;
                RsExternalTableColumn rsExternalTableColumn = it = (RsExternalTableColumn)a;
                Intrinsics.checkExpressionValueIsNotNull((Object)rsExternalTableColumn, (String)"it");
                it = (RsExternalTableColumn)b2;
                Comparable comparable = Integer.valueOf(rsExternalTableColumn.getPartitionKeyOrder());
                RsExternalTableColumn rsExternalTableColumn2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)rsExternalTableColumn2, (String)"it");
                Integer n = rsExternalTableColumn2.getPartitionKeyOrder();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        };
        List partitionKeys = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)object);
        if (!($receiver$iv = (Collection)partitionKeys).isEmpty()) {
            sb.append("partitioned by (").append(CollectionsKt.joinToString$default((Iterable)partitionKeys, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<RsExternalTableColumn, String>(this){
                final /* synthetic */ RsCreateExternalTable this$0;

                @NotNull
                public final String invoke(RsExternalTableColumn it) {
                    StringBuilder stringBuilder = new StringBuilder();
                    RsExternalTableColumn rsExternalTableColumn = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)rsExternalTableColumn, (String)"it");
                    StringBuilder stringBuilder2 = stringBuilder.append(BaseProducer.quote$default(this.this$0, rsExternalTableColumn, null, 2, null)).append(' ');
                    DataType dataType = it.getDataType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"it.dataType");
                    return stringBuilder2.append(this.this$0.script(dataType)).toString();
                }
                {
                    this.this$0 = rsCreateExternalTable;
                    super(1);
                }
            }), (int)30, null)).append(")\n");
        }
        List<String> list = ((RsExternalTable)this.getElement()).getSerdeProperties();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.serdeProperties");
        String fieldDelimiter = this.findProperty(list, "field.delim");
        List<String> list2 = ((RsExternalTable)this.getElement()).getSerdeProperties();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.serdeProperties");
        String serializationFormat = this.findProperty(list2, "serialization.format");
        sb.append(Intrinsics.areEqual((Object)((RsExternalTable)this.getElement()).getSerializationLib(), (Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe") && fieldDelimiter != null && Intrinsics.areEqual((Object)fieldDelimiter, (Object)serializationFormat) ? this.generateRowFormat((RsExternalTable)this.getElement(), fieldDelimiter) : this.generateSerDeRowFormat((RsExternalTable)this.getElement()));
        sb.append("stored as\n");
        if (unknownStorage) {
            StringBuilder stringBuilder = new StringBuilder().append("inputformat ");
            String string = ((RsExternalTable)this.getElement()).getInputFormat();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.inputFormat!!");
            StringBuilder stringBuilder2 = sb.append(stringBuilder.append(ScriptGeneratorHelperKt.getSqlString(string)).append('\n').toString());
            StringBuilder stringBuilder3 = new StringBuilder().append("outputformat ");
            String string2 = ((RsExternalTable)this.getElement()).getOutputFormat();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.outputFormat!!");
            StringBuilder stringBuilder4 = stringBuilder2.append(stringBuilder3.append(ScriptGeneratorHelperKt.getSqlString(string2)).append('\n').toString());
            StringBuilder stringBuilder5 = new StringBuilder().append("location ");
            String string3 = ((RsExternalTable)this.getElement()).getLocation();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.location!!");
            stringBuilder4.append(stringBuilder5.append(ScriptGeneratorHelperKt.getSqlString(string3)).append('\n').toString());
        } else {
            sb.append(((RsExternalTable)this.getElement()).getStorageType().getSqlDefinition() + '\n');
        }
        List<String> list3 = ((RsExternalTable)this.getElement()).getProps();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"element.props");
        object = list3;
        if (!object.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("table properties (");
            List<String> list4 = ((RsExternalTable)this.getElement()).getProps();
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"element.props");
            sb.append(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list4, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        Object object2 = object = string;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
    }

    private final String generateRowFormat(RsExternalTable table, String fieldDelimiter) {
        StringBuffer sb = new StringBuffer();
        List<String> list = table.getSerdeProperties();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.serdeProperties");
        String lineDelimiter = this.findProperty(list, "line.delim");
        sb.append("row format delimited\n").append("fields terminated by '" + fieldDelimiter + "'\n");
        if (lineDelimiter != null) {
            sb.append("lines terminated by '" + fieldDelimiter + "'\n");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String generateSerDeRowFormat(RsExternalTable table) {
        StringBuilder sb = new StringBuilder();
        sb.append("row format serde '" + table.getSerializationLib() + "'\n");
        if (!table.getSerdeProperties().isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("with serdeproperties(");
            List<String> list = table.getSerdeProperties();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.serdeProperties");
            sb.append(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)).append(")\n").toString());
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String findProperty(List<String> properties, String key2) {
        Iterator iterator;
        block5: {
            Iterable iterable;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable2 = $receiver$iv = (Iterable)properties;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                void s;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                List list = StringUtil.splitHonorQuotes((String)s, (char)'=');
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"StringUtil.splitHonorQuotes(s, '=')");
                Iterable iterable3 = $receiver$iv2 = (Iterable)list;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv2 : $receiver$iv$iv2) {
                    void var16_16;
                    void it;
                    String string2 = (String)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    void v1 = var16_16;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string3 = StringUtil.unquoteString((String)((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString(), (char)'\'');
                    collection2.add(string3);
                }
                List list2 = (List)destination$iv$iv2;
                collection.add(list2);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                List it = (List)element$iv$iv;
                if (!(it.size() == 2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable2 = iterable = (Iterable)((List)destination$iv$iv);
            for (Iterator iterator2 : iterable2) {
                List it = (List)((Object)iterator2);
                if (!Intrinsics.areEqual((Object)((String)CollectionsKt.first((List)it)), (Object)key2)) continue;
                iterator = iterator2;
                break block5;
            }
            iterator = null;
        }
        List list = (List)((Object)iterator);
        return list != null ? (String)CollectionsKt.last((List)list) : null;
    }

    public RsCreateExternalTable(@NotNull ScriptingContext context, @NotNull RsExternalTable element2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super(context, (BasicTable)element2);
    }
}

