/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBaseKt;
import com.intellij.database.dialects.postgresbase.introspector.PostgresIntrospectorBase;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseModLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseModLikeSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseModLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseModTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.redshift.introspector.RedshiftIntrospector;
import com.intellij.database.dialects.redshift.introspector.RsIntroQueries;
import com.intellij.database.dialects.redshift.introspector.RsIntrospectorKt;
import com.intellij.database.dialects.redshift.model.RsDatabase;
import com.intellij.database.dialects.redshift.model.RsExternalSchema;
import com.intellij.database.dialects.redshift.model.RsModDatabase;
import com.intellij.database.dialects.redshift.model.RsModExternalSchema;
import com.intellij.database.dialects.redshift.model.RsModExternalTable;
import com.intellij.database.dialects.redshift.model.RsModExternalTableColumn;
import com.intellij.database.dialects.redshift.model.RsModModel;
import com.intellij.database.dialects.redshift.model.RsModRoot;
import com.intellij.database.dialects.redshift.model.RsModSchema;
import com.intellij.database.dialects.redshift.model.RsModTable;
import com.intellij.database.dialects.redshift.model.RsModTableColumn;
import com.intellij.database.dialects.redshift.model.RsModUser;
import com.intellij.database.dialects.redshift.model.RsModView;
import com.intellij.database.dialects.redshift.model.RsModViewColumn;
import com.intellij.database.dialects.redshift.model.RsRoot;
import com.intellij.database.dialects.redshift.model.RsSchema;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.RsTableBackupMode;
import com.intellij.database.model.properties.RsTableDistStyle;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 %2,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0001:\u0005%&'()B\u0007\b\u0016\u00a2\u0006\u0002\u0010\tJ<\u0010\n\u001a6\u0012\u0004\u0012\u00020\f0\u000bR,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\rH\u0014JF\u0010\u000e\u001a00\u000fR,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0014JV\u0010\u0013\u001a@\u0012\u0006\b\u0001\u0012\u00020\u0007\u0012\u0006\b\u0001\u0012\u00020\b0\u0014R,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0007H\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J$\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f0\u00182\b\u0010!\u001a\u0004\u0018\u00010 H\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0011H\u0002\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RedshiftIntrospector;", "Lcom/intellij/database/dialects/postgresbase/introspector/PostgresIntrospectorBase;", "Lcom/intellij/database/dialects/redshift/model/RsModModel;", "Lcom/intellij/database/dialects/redshift/model/RsRoot;", "Lcom/intellij/database/dialects/redshift/model/RsModRoot;", "Lcom/intellij/database/dialects/redshift/model/RsDatabase;", "Lcom/intellij/database/dialects/redshift/model/RsModDatabase;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModLikeSchema;", "()V", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "Lcom/intellij/database/dialects/redshift/introspector/RsIntroQueries$RsDbInfo;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "schema", "getSchemasToIntrospect", "", "Lcom/intellij/database/model/basic/BasicSchema;", "it", "Lcom/intellij/database/model/basic/BasicDatabase;", "introspectServerObjects", "", "parseProperties", "Lkotlin/Pair;", "", "properties", "retrievePermissions", "tran", "retrieveUsers", "Companion", "ExternalSchemaRetriever", "Factory", "MyDatabaseRetriever", "MySchemaRetriever", "intellij.database.dialects"})
public final class RedshiftIntrospector
extends PostgresIntrospectorBase<RsModModel, RsRoot, RsModRoot, RsDatabase, RsModDatabase, PgBaseLikeSchema, PgBaseModLikeSchema> {
    @NotNull
    public static final String ARRAY_DELIMITER = "\u001e";
    @JvmField
    @NotNull
    public static final RsIntroQueries QUERIES;
    public static final Companion Companion;

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<RsIntroQueries.RsDbInfo> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<RsIntroQueries.RsDbInfo>(this){
            final /* synthetic */ RedshiftIntrospector this$0;

            @NotNull
            protected List<RsIntroQueries.RsDbInfo> listDatabases(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                return (List)RedshiftIntrospector.access$performQuery(this.this$0, tran, RedshiftIntrospector.QUERIES.getListDatabases());
            }

            @NotNull
            protected RsModDatabase applyDatabase(@NotNull ModNamingIdentifyingFamily<?> databases, @NotNull RsIntroQueries.RsDbInfo db) {
                Intrinsics.checkParameterIsNotNull(databases, (String)"databases");
                Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                MD MD = this.renew(databases, db.id, db.name);
                RsModDatabase $receiver = (RsModDatabase)MD;
                $receiver.setOwner(db.getOwnerName());
                return (RsModDatabase)MD;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Override
    public void introspectServerObjects() {
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ RedshiftIntrospector this$0;

            public final void invoke(@NotNull DBTransaction it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                RedshiftIntrospector.access$retrievePermissions(this.this$0, it);
                RedshiftIntrospector.access$retrieveUsers(this.this$0, it);
            }
            {
                this.this$0 = redshiftIntrospector;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    protected List<BasicSchema> getSchemasToIntrospect(@NotNull BasicDatabase it) {
        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
        Collection collection = super.getSchemasToIntrospect(it);
        NamingIdentifyingFamily<? extends RsExternalSchema> namingIdentifyingFamily = ((RsDatabase)it).getExternalSchemas();
        Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"(it as RsDatabase).externalSchemas");
        return CollectionsKt.plus((Collection)collection, (Iterable)namingIdentifyingFamily);
    }

    private final void retrievePermissions(DBTransaction tran) {
        RsIntroQueries.Permissions permissions = this.performQuery(tran, QUERIES.getRetrievePermissions());
        Map map = this.queryParameters;
        String string = "USER_EXT";
        Boolean bl = permissions.user_ext;
        map.put(string, bl);
    }

    private final void retrieveUsers(DBTransaction tran) {
        this.setQueryParameter("array_delimiter", ARRAY_DELIMITER);
        List<RsIntroQueries.OneUser> users = this.performQuery(tran, QUERIES.getRetrieveUsers());
        ((RsModModel)this.getModel()).modify(RsModRoot.class, new ModelModifier<RsModRoot>(users){
            final /* synthetic */ List $users;

            /*
             * Unable to fully structure code
             */
            public final void perform(RsModRoot it) {
                v0 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
                $receiver = var2_2 = v0.getUsers();
                $receiver.markChildrenAsSyncPending();
                for (RsIntroQueries.OneUser user : this.$users) {
                    var6_6 = $receiver.renew(user.user_id, user.user_name);
                    $receiver = (RsModUser)var6_6;
                    $receiver.setSuperUser(user.is_super);
                    $receiver.setCreateDb(user.can_createdb);
                    v1 = user.conn_limit;
                    $receiver.setConnectionLimit(v1 != null ? v1 : -1L);
                    v2 = user.valid_until;
                    if (v2 == null) ** GOTO lbl-1000
                    var8_8 = v2;
                    switch (var8_8.hashCode()) {
                        case 173173288: {
                            if (var8_8.equals("infinity")) {
                                v3 = null;
                                break;
                            }
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v3 = user.valid_until;
                        }
                    }
                    $receiver.setValidUntil(v3);
                    var8_8 = user.config;
                    var9_9 = $receiver;
                    var10_10 = var8_8 == null || var8_8.length() == 0;
                    var9_9.setConfig(var10_10 != false ? CollectionsKt.emptyList() : ArraysKt.toList((Object[])PgIntrospectorBaseKt.parseArrayOfStrings(user.config, "\u001e")));
                }
                $receiver.removeSyncPendingChildren();
                $receiver.sort();
            }
            {
                this.$users = list;
            }
        });
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.BaseDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull RsDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new MyDatabaseRetriever(transaction, database);
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractSchemaRetriever<? extends PgBaseLikeSchema, ? extends PgBaseModLikeSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull PgBaseLikeSchema schema) {
        BaseIntrospector.AbstractSchemaRetriever abstractSchemaRetriever;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        PgBaseLikeSchema pgBaseLikeSchema = schema;
        if (pgBaseLikeSchema instanceof RsExternalSchema) {
            abstractSchemaRetriever = new ExternalSchemaRetriever(transaction, (RsExternalSchema)schema);
        } else if (pgBaseLikeSchema instanceof RsSchema) {
            abstractSchemaRetriever = new MySchemaRetriever(transaction, (RsSchema)schema);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("unexpected schema: " + schema.getClass())));
        }
        return abstractSchemaRetriever;
    }

    private final List<Pair<String, String>> parseProperties(String properties) {
        List list;
        List it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        String string = properties;
        if (string == null || (string = StringsKt.trimStart((String)string, (char[])new char[]{'{'})) == null || (string = StringsKt.trimEnd((String)string, (char[])new char[]{'}'})) == null) {
            return CollectionsKt.emptyList();
        }
        String clear2 = string;
        List list2 = StringUtil.splitHonorQuotes((String)clear2, (char)',');
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"StringUtil.splitHonorQuotes(clear, ',')");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            list = StringUtil.splitHonorQuotes((String)((Object)it), (char)':');
            collection.add(list);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (List)element$iv$iv;
            if (!(it.size() == 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            List list3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"it");
            list = new Pair((Object)StringUtil.unquoteString((String)((String)CollectionsKt.first((List)list3))), (Object)StringUtil.unquoteString((String)((String)CollectionsKt.last((List)it))));
            collection.add(list);
        }
        return (List)destination$iv$iv;
    }

    public RedshiftIntrospector() {
        Dbms dbms = Dbms.REDSHIFT;
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"Dbms.REDSHIFT");
        super(dbms, RsModModel.class, RsModRoot.class, RsDatabase.class, PgBaseLikeSchema.class, RsModDatabase.class, PgBaseModLikeSchema.class, QUERIES);
    }

    static {
        Companion = new Companion(null);
        Scriptum scriptum = Scriptum.of(RsIntroQueries.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptum, (String)"Scriptum.of(RsIntroQueries::class.java)");
        QUERIES = new RsIntroQueries(scriptum);
    }

    @NotNull
    public static final /* synthetic */ List access$parseProperties(RedshiftIntrospector $this, @Nullable String properties) {
        return $this.parseProperties(properties);
    }

    public static final /* synthetic */ boolean access$isColumnNameSurrogate(RedshiftIntrospector $this, @Nullable String it) {
        return $this.isColumnNameSurrogate(it);
    }

    public static final /* synthetic */ Object access$performQuery(RedshiftIntrospector $this, @NotNull DBTransaction transaction, @NotNull SqlQuery query) {
        return $this.performQuery(transaction, query);
    }

    public static final /* synthetic */ void access$retrievePermissions(RedshiftIntrospector $this, @NotNull DBTransaction tran) {
        $this.retrievePermissions(tran);
    }

    public static final /* synthetic */ void access$retrieveUsers(RedshiftIntrospector $this, @NotNull DBTransaction tran) {
        $this.retrieveUsers(tran);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RedshiftIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            RedshiftIntrospector redshiftIntrospector;
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
            RedshiftIntrospector $receiver = redshiftIntrospector = new RedshiftIntrospector();
            $receiver.setModelFactory$intellij_database_dialects(modelFactory);
            return redshiftIntrospector;
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@NotNull BasicElement e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return PgIntrospectorBaseKt.canCheckOutdated(e);
        }

        @Override
        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative(this);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RedshiftIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects"})
        public static final class VERSION
        extends PerObjectVersion {
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002<\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001R,\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0004B\u0015\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0014J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001c0\u001aH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RedshiftIntrospector$ExternalSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/redshift/model/RsExternalSchema;", "Lcom/intellij/database/dialects/redshift/model/RsModExternalSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "Lcom/intellij/database/dialects/redshift/model/RsModModel;", "Lcom/intellij/database/dialects/redshift/model/RsRoot;", "Lcom/intellij/database/dialects/redshift/model/RsModRoot;", "Lcom/intellij/database/dialects/redshift/model/RsDatabase;", "Lcom/intellij/database/dialects/redshift/model/RsModDatabase;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModLikeSchema;", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/redshift/introspector/RedshiftIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/redshift/model/RsExternalSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "progress", "", "what", "", "retrieveExternalTables", "retrieveExternalTablesColumns", "retrieveMainContent", "toRsProperties", "", "properties", "Lkotlin/Pair;", "intellij.database.dialects"})
    private final class ExternalSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever<RsExternalSchema, RsModExternalSchema> {
        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull RsExternalSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            return false;
        }

        @Override
        protected void retrieveMainContent() {
            this.prepareParameters();
            this.retrieveExternalTables();
            this.retrieveExternalTablesColumns();
        }

        private final void progress(String what) {
            String string = ((RsExternalSchema)this.getSchema()).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schema.name");
            RedshiftIntrospector.this.progress(false, "external schema", string, what);
        }

        private final void retrieveExternalTables() {
            this.progress("external tables");
            List<RsIntroQueries.OneExternalTable> tables = this.performQuery(QUERIES.getRetrieveExternalTables());
            ((RsModModel)this.getModel()).modify((BasicElement)this.getSchema(), RsModExternalSchema.class, new ModelModifier<RsModExternalSchema>(this, tables){
                final /* synthetic */ ExternalSchemaRetriever this$0;
                final /* synthetic */ List $tables;

                /*
                 * WARNING - void declaration
                 */
                public final void perform(RsModExternalSchema schema) {
                    RsModExternalSchema rsModExternalSchema = schema;
                    Intrinsics.checkExpressionValueIsNotNull((Object)rsModExternalSchema, (String)"schema");
                    rsModExternalSchema.getExternalTables().markChildrenAsSyncPending();
                    for (RsIntroQueries.OneExternalTable t : this.$tables) {
                        void $receiver$iv$iv;
                        void $receiver$iv;
                        RsModExternalTable table;
                        RsModExternalTable rsModExternalTable = table = (RsModExternalTable)schema.getExternalTables().renew(Long.MIN_VALUE, t.table_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)rsModExternalTable, (String)"table");
                        rsModExternalTable.setLocation(t.location);
                        table.setSerializationLib(t.serialization_lib);
                        table.setInputFormat(t.input_format);
                        table.setOutputFormat(t.output_format);
                        Iterable iterable = RedshiftIntrospector.access$parseProperties(this.this$0.RedshiftIntrospector.this, t.props);
                        ExternalSchemaRetriever externalSchemaRetriever = this.this$0;
                        RsModExternalTable rsModExternalTable2 = table;
                        void var6_6 = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        for (T element$iv$iv : $receiver$iv$iv) {
                            Pair it = (Pair)element$iv$iv;
                            if (!(!StringsKt.equals((String)((String)it.getFirst()), (String)"external", (boolean)true) && !StringsKt.equals((String)((String)it.getFirst()), (String)"transient_lastDdlTime", (boolean)true))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List list = (List)destination$iv$iv;
                        rsModExternalTable2.setProps(ExternalSchemaRetriever.access$toRsProperties(externalSchemaRetriever, list));
                        table.setSerdeProperties(ExternalSchemaRetriever.access$toRsProperties(this.this$0, RedshiftIntrospector.access$parseProperties(this.this$0.RedshiftIntrospector.this, t.serde_properties)));
                    }
                    schema.getExternalTables().sort();
                    schema.getExternalTables().removeSyncPendingChildren();
                }
                {
                    this.this$0 = externalSchemaRetriever;
                    this.$tables = list;
                }
            });
        }

        private final void retrieveExternalTablesColumns() {
            this.progress("columns");
            List<RsIntroQueries.OneExternalTableColumn> columns = this.performQuery(QUERIES.getRetrieveExternalTablesColumns());
            ((RsModModel)this.getModel()).modify((BasicElement)this.getSchema(), RsModExternalSchema.class, new ModelModifier<RsModExternalSchema>(columns){
                final /* synthetic */ List $columns;

                public final void perform(RsModExternalSchema schema) {
                    RsIntroQueries.OneExternalTableColumn it;
                    Iterable $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable = $receiver$iv = (Iterable)this.$columns;
                    Object destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        it = (RsIntroQueries.OneExternalTableColumn)element$iv$iv;
                        if (it.table_name == null || it.column_name == null) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        Object object;
                        it = (RsIntroQueries.OneExternalTableColumn)element$iv$iv;
                        Object $receiver$iv$iv$iv = destination$iv$iv;
                        String key$iv$iv = it.table_name;
                        V value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            ArrayList<E> answer$iv$iv$iv = new ArrayList<E>();
                            $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    destination$iv$iv.forEach((BiConsumer)new BiConsumer<String, List<? extends RsIntroQueries.OneExternalTableColumn>>(schema){
                        final /* synthetic */ RsModExternalSchema $schema;

                        public final void accept(@Nullable String table_name, @NotNull List<RsIntroQueries.OneExternalTableColumn> externalColumns) {
                            Intrinsics.checkParameterIsNotNull(externalColumns, (String)"externalColumns");
                            RsModExternalSchema rsModExternalSchema = this.$schema;
                            Intrinsics.checkExpressionValueIsNotNull((Object)rsModExternalSchema, (String)"schema");
                            NamingIdentifyingFamily namingIdentifyingFamily = rsModExternalSchema.getExternalTables();
                            String string = table_name;
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            RsModExternalTable rsModExternalTable = (RsModExternalTable)namingIdentifyingFamily.get(string);
                            if (rsModExternalTable == null) {
                                return;
                            }
                            RsModExternalTable table = rsModExternalTable;
                            table.getColumns().markChildrenAsSyncPending();
                            for (RsIntroQueries.OneExternalTableColumn c2 : externalColumns) {
                                RsModExternalTableColumn column2;
                                PositioningNamingFamily positioningNamingFamily = table.getColumns();
                                short s = c2.position;
                                String string2 = c2.column_name;
                                if (string2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                RsModExternalTableColumn rsModExternalTableColumn = column2 = (RsModExternalTableColumn)positioningNamingFamily.renewAt(s, string2);
                                Intrinsics.checkExpressionValueIsNotNull((Object)rsModExternalTableColumn, (String)"column");
                                rsModExternalTableColumn.setPartitionKeyOrder(c2.partition_key);
                                column2.setDataType(PgIntrospectorBaseKt.dataTypeOf(c2.data_type));
                            }
                            table.getColumns().sort();
                            table.getColumns().removeSyncPendingChildren();
                        }
                        {
                            this.$schema = rsModExternalSchema;
                        }
                    });
                }
                {
                    this.$columns = list;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> toRsProperties(List<Pair<String, String>> properties) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)properties;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = '\'' + (String)it.getFirst() + "'='" + (String)it.getSecond() + '\'';
                collection.add(string);
            }
            return (List)destination$iv$iv;
        }

        public ExternalSchemaRetriever(@NotNull DBTransaction tran, RsExternalSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)RedshiftIntrospector.this, tran, (BasicSchema)schema);
        }

        @NotNull
        public static final /* synthetic */ List access$toRsProperties(ExternalSchemaRetriever $this, @NotNull List properties) {
            return $this.toRsProperties(properties);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0002B\u0015\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ,\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RedshiftIntrospector$MyDatabaseRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PostgresIntrospectorBase$DatabaseRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PostgresIntrospectorBase;", "Lcom/intellij/database/dialects/redshift/model/RsModModel;", "Lcom/intellij/database/dialects/redshift/model/RsRoot;", "Lcom/intellij/database/dialects/redshift/model/RsModRoot;", "Lcom/intellij/database/dialects/redshift/model/RsDatabase;", "Lcom/intellij/database/dialects/redshift/model/RsModDatabase;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModLikeSchema;", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "(Lcom/intellij/database/dialects/redshift/introspector/RedshiftIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/redshift/model/RsDatabase;)V", "getProperty", "", "properties", "", "Lkotlin/Pair;", "key", "retrieveExternalSchemas", "", "retrieveSchemas", "intellij.database.dialects"})
    private final class MyDatabaseRetriever
    extends PostgresIntrospectorBase.DatabaseRetriever {
        @Override
        public void retrieveSchemas() {
            super.retrieveSchemas();
            this.retrieveExternalSchemas();
        }

        private final void retrieveExternalSchemas() {
            String dbComment = this.performQuery(QUERIES.getCurrentDbComment());
            List<RsIntroQueries.OneExternalSchema> schemas2 = this.performQuery(QUERIES.getRetrieveExternalSchemas());
            this.inDatabase((Function1)new Function1<RsModDatabase, Unit>(this, dbComment, schemas2){
                final /* synthetic */ MyDatabaseRetriever this$0;
                final /* synthetic */ String $dbComment;
                final /* synthetic */ List $schemas;

                public final void invoke(@NotNull RsModDatabase db) {
                    Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                    db.setComment(this.$dbComment);
                    db.getExternalSchemas().markChildrenAsSyncPending();
                    NamingIdentifyingFamily namingIdentifyingFamily = db.getExternalSchemas();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"db.externalSchemas");
                    boolean empty = namingIdentifyingFamily.isEmpty();
                    boolean first = true;
                    for (RsIntroQueries.OneExternalSchema s : this.$schemas) {
                        RsModExternalSchema schema;
                        RsModExternalSchema rsModExternalSchema = schema = (RsModExternalSchema)db.getExternalSchemas().renew(s.schema_id, s.schema_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)rsModExternalSchema, (String)"schema");
                        rsModExternalSchema.setStateNumber(s.state_number);
                        schema.setCurrent(false);
                        schema.setDatabaseName(s.database_name);
                        schema.setComment(s.description);
                        schema.setSchemaKind(s.schema_kind);
                        List props = RedshiftIntrospector.access$parseProperties(this.this$0.RedshiftIntrospector.this, s.schema_options);
                        schema.setIamRole(MyDatabaseRetriever.access$getProperty(this.this$0, props, "IAM_ROLE"));
                        schema.setRegion(MyDatabaseRetriever.access$getProperty(this.this$0, props, "REGION"));
                        schema.setUri(MyDatabaseRetriever.access$getProperty(this.this$0, props, "URI"));
                        schema.setPort(MyDatabaseRetriever.access$getProperty(this.this$0, props, "PORT"));
                        schema.setOwner(s.getOwnerName());
                        if (!first) continue;
                        if (empty) {
                            schema.setVisible(true);
                        }
                        first = false;
                    }
                    db.getExternalSchemas().sort();
                    db.getExternalSchemas().removeSyncPendingChildren();
                }
                {
                    this.this$0 = myDatabaseRetriever;
                    this.$dbComment = string;
                    this.$schemas = list;
                    super(1);
                }
            });
        }

        private final String getProperty(List<Pair<String, String>> properties, String key2) {
            Object v0;
            block1: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)properties;
                for (Object t : iterable2) {
                    Pair it = (Pair)t;
                    if (!Intrinsics.areEqual((Object)((String)it.getFirst()), (Object)key2)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Pair pair = v0;
            return pair != null ? (String)pair.getSecond() : null;
        }

        public MyDatabaseRetriever(@NotNull DBTransaction tran, RsDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            super((PostgresIntrospectorBase)RedshiftIntrospector.this, tran, (PgBaseDatabase)database);
        }

        @Nullable
        public static final /* synthetic */ String access$getProperty(MyDatabaseRetriever $this, @NotNull List properties, @NotNull String key2) {
            return $this.getProperty(properties, key2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002<\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001R,\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0004B\u0017\b\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J0\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010$\u001a\u00020\u0015H\u0002J\u0013\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0012H\u0014\u00a2\u0006\u0002\u0010'\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RedshiftIntrospector$MySchemaRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PostgresIntrospectorBase$SchemaRetriever;", "Lcom/intellij/database/dialects/redshift/model/RsSchema;", "Lcom/intellij/database/dialects/redshift/model/RsModSchema;", "Lcom/intellij/database/dialects/postgresbase/introspector/PostgresIntrospectorBase;", "Lcom/intellij/database/dialects/redshift/model/RsModModel;", "Lcom/intellij/database/dialects/redshift/model/RsRoot;", "Lcom/intellij/database/dialects/redshift/model/RsModRoot;", "Lcom/intellij/database/dialects/redshift/model/RsDatabase;", "Lcom/intellij/database/dialects/redshift/model/RsModDatabase;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModLikeSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/redshift/introspector/RedshiftIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/redshift/model/RsSchema;)V", "listExistentComments", "Lgnu/trove/TLongObjectHashMap;", "", "", "performNonIncrementalPart", "", "processColumn", "col", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModLikeColumn;", "columns", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "table", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModLikeStoredTable;", "processModTable", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModTable;", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "processModView", "retrieveBoundlessViewsColumns", "steps", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "()[Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "intellij.database.dialects"})
    private final class MySchemaRetriever
    extends PostgresIntrospectorBase.SchemaRetriever<RsSchema, RsModSchema> {
        @Override
        protected void performNonIncrementalPart() {
            super.performNonIncrementalPart();
            this.retrieveBoundlessViewsColumns();
        }

        @Override
        @NotNull
        protected IntroStep[] steps() {
            return (IntroStep[])ArraysKt.plus((Object[])super.steps(), (Object)new IntroStep(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public void perform() {
                    MySchemaRetriever.access$retrieveBoundlessViewsColumns(this.this$0);
                }

                public int priority() {
                    return 21;
                }
                {
                    this.this$0 = $outer;
                }

                public int compareTo(@NotNull IntroStep other) {
                    Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
                    return IntroStep.DefaultImpls.compareTo(this, other);
                }
            });
        }

        private final void retrieveBoundlessViewsColumns() {
            this.progress("late-binding views' columns");
            List<RsIntroQueries.OneBoundlessViewColumn> cols = this.performQuery(QUERIES.getRetrieveBoundlessViewsColumns());
            if (cols.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<RsModSchema, Unit>(this, cols){
                final /* synthetic */ MySchemaRetriever this$0;
                final /* synthetic */ List $cols;

                public final void invoke(@NotNull RsModSchema schema) {
                    RsIntroQueries.OneBoundlessViewColumn it;
                    Iterable $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Iterable iterable = $receiver$iv = (Iterable)this.$cols;
                    Object destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        boolean bl;
                        block5: {
                            String[] $receiver$iv2;
                            it = (RsIntroQueries.OneBoundlessViewColumn)element$iv$iv;
                            for (String element$iv : $receiver$iv2 = new String[]{it.view_name, it.column_name, it.column_type}) {
                                String it2 = element$iv;
                                if (!(it2 == null)) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                        if (bl) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        Object object;
                        it = (RsIntroQueries.OneBoundlessViewColumn)element$iv$iv;
                        Object $receiver$iv$iv$iv = destination$iv$iv;
                        String key$iv$iv = it.view_name;
                        V value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            ArrayList<E> answer$iv$iv$iv = new ArrayList<E>();
                            $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    destination$iv$iv.forEach((BiConsumer)new BiConsumer<String, List<? extends RsIntroQueries.OneBoundlessViewColumn>>(this, schema){
                        final /* synthetic */ retrieveBoundlessViewsColumns.1 this$0;
                        final /* synthetic */ RsModSchema $schema;

                        public final void accept(@Nullable String view_name, @NotNull List<RsIntroQueries.OneBoundlessViewColumn> cols) {
                            Intrinsics.checkParameterIsNotNull(cols, (String)"cols");
                            NamingIdentifyingFamily namingIdentifyingFamily = this.$schema.getViews();
                            String string = view_name;
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            RsModView rsModView = (RsModView)namingIdentifyingFamily.get(string);
                            if (rsModView == null) {
                                return;
                            }
                            RsModView view = rsModView;
                            view.getColumns().markChildrenAsSyncPending();
                            for (RsIntroQueries.OneBoundlessViewColumn c2 : cols) {
                                RsModViewColumn column2;
                                PositioningNamingFamily positioningNamingFamily = view.getColumns();
                                short s = c2.position;
                                String string2 = c2.column_name;
                                if (string2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                RsModViewColumn rsModViewColumn = column2 = (RsModViewColumn)positioningNamingFamily.renewAt(s, string2);
                                Intrinsics.checkExpressionValueIsNotNull((Object)rsModViewColumn, (String)"column");
                                String string3 = c2.column_type;
                                if (string3 == null) {
                                    Intrinsics.throwNpe();
                                }
                                rsModViewColumn.setDataType(PgIntrospectorBaseKt.dataTypeOf(string3));
                                column2.setNameSurrogate(RedshiftIntrospector.access$isColumnNameSurrogate(this.this$0.this$0.RedshiftIntrospector.this, c2.column_name));
                            }
                            view.getColumns().removeSyncPendingChildren();
                        }
                        {
                            this.this$0 = var1_1;
                            this.$schema = rsModSchema;
                        }
                    });
                }
                {
                    this.this$0 = mySchemaRetriever;
                    this.$cols = list;
                    super(1);
                }
            });
        }

        @Override
        protected void processModView(@NotNull PgBaseModLikeStoredTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            PgBaseModLikeStoredTable pgBaseModLikeStoredTable = table;
            if (!(pgBaseModLikeStoredTable instanceof RsModView)) {
                pgBaseModLikeStoredTable = null;
            }
            RsModView rsModView = (RsModView)pgBaseModLikeStoredTable;
            if (rsModView == null) {
                return;
            }
            RsModView view = rsModView;
            view.setBoundless(t.is_boundless_view);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected TLongObjectHashMap<Short[]> listExistentComments() {
            void $receiver$iv$iv;
            Object $receiver$iv;
            TLongObjectHashMap existentComments = new TLongObjectHashMap();
            Object object = $receiver$iv = (Iterable)this.performQuery(QUERIES.getListExistentSchemaComments());
            Map destination$iv$iv = new LinkedHashMap();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Object object2;
                RsIntroQueries.IdAndSubId it = (RsIntroQueries.IdAndSubId)element$iv$iv;
                Map $receiver$iv$iv$iv = destination$iv$iv;
                Long key$iv$iv = it.id;
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = destination$iv$iv;
            object = $receiver$iv;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                existentComments.put(((Number)it.getKey()).longValue(), (Object)RsIntrospectorKt.optimizeFor0((List)it.getValue()));
            }
            return existentComments;
        }

        @Override
        protected void processModTable(@NotNull PgBaseModTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            if (!(table instanceof RsModTable)) {
                return;
            }
            ((RsModTable)table).setDistStyle(RsTableDistStyle.of(t.dist_style));
            ((RsModTable)table).setBackupMode(RsTableBackupMode.of(t.bckp));
        }

        @Override
        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseModLikeColumn column2, @NotNull ModPositioningNamingFamily<? extends PgBaseModLikeColumn> columns, @NotNull PgBaseModLikeStoredTable table) {
            Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
            Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
            Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            super.processColumn(col, column2, columns, table);
            if (!(column2 instanceof RsModTableColumn)) {
                return;
            }
            ((RsModTableColumn)column2).setDistKey(col.distkey);
            ((RsModTableColumn)column2).setSortKeyOrder(col.sortkeyord);
            ((RsModTableColumn)column2).setEncoding(col.encoding);
        }

        public MySchemaRetriever(@NotNull DBTransaction transaction, RsSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((PostgresIntrospectorBase)RedshiftIntrospector.this, transaction, (PgBaseSchema)schema);
        }

        public static final /* synthetic */ void access$retrieveBoundlessViewsColumns(MySchemaRetriever $this) {
            $this.retrieveBoundlessViewsColumns();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RedshiftIntrospector$Companion;", "", "()V", "ARRAY_DELIMITER", "", "QUERIES", "Lcom/intellij/database/dialects/redshift/introspector/RsIntroQueries;", "intellij.database.dialects"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

