/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.SqlValuesExtractor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInsertValuesExtractor
extends SqlValuesExtractor {
    public SqlInsertValuesExtractor(@NotNull ObjectFormatter converter, @Nullable DasTable databaseTable) {
        if (converter == null) {
            SqlInsertValuesExtractor.$$$reportNull$$$0(0);
        }
        super(converter, databaseTable);
    }

    @Override
    public DataExtractor.Extraction startExtraction(CharOut out, Dbms dbms, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new SqlInsertExtraction(out, dbms, forceSkipHeader, allColumns, selectedColumns);
    }

    private static void removeComputedAndAutoVal(int[] selectedColumns, TIntObjectHashMap<DataConsumer.Column> columnsMap, DasTable databaseTable) {
        boolean skipGenerated = DataExtractorProperties.isSkipGeneratedColumns();
        boolean skipComputed = DataExtractorProperties.isSkipComputed();
        for (int selectedColumn : selectedColumns) {
            DasColumn dasColumn;
            DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
            if (column2 == null) continue;
            if (DbImplUtil.isRowId(column2)) {
                columnsMap.remove(selectedColumn);
                continue;
            }
            if (databaseTable == null || (dasColumn = (DasColumn)DasUtil.findChild((DasObject)databaseTable, DasColumn.class, (ObjectKind)ObjectKind.COLUMN, (String)column2.name)) == null || (!skipGenerated || !DasUtil.isAutoGenerated((DasColumn)dasColumn)) && (!skipComputed || !DasUtil.isComputed((DasColumn)dasColumn))) continue;
            columnsMap.remove(selectedColumn);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/database/extractors/SqlInsertValuesExtractor", "<init>"));
    }

    private class SqlInsertExtraction
    extends SqlValuesExtractor.SqlExtractionBase {
        SqlInsertExtraction(CharOut output, Dbms dbms, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(SqlInsertValuesExtractor.this, output, dbms, forceSkipHeader, allColumns, selectedColumnIndices);
        }

        @Override
        protected void appendHeader(boolean appendNewLine) {
            if (!DataExtractorProperties.isIncludeCreateTable()) {
                return;
            }
            if (SqlInsertValuesExtractor.this.myDatabaseTable instanceof DbElement) {
                this.myDdlBuilder.plain(DatabaseEditorHelper.generateDefinition((DbElement)SqlInsertValuesExtractor.this.myDatabaseTable, new StringBuilder()).toString());
            } else if (SqlInsertValuesExtractor.this.myDatabaseTable instanceof BasicElement) {
                this.myDdlBuilder.plain(DatabaseEditorHelper.generateDefinitionUsingScriptingService(null, (BasicElement)SqlInsertValuesExtractor.this.myDatabaseTable).toString());
            } else {
                this.myDdlBuilder.keyword("CREATE").space().keyword("TABLE").space();
                if (SqlInsertValuesExtractor.this.myDatabaseTable == null) {
                    this.myDdlBuilder.identifier("MY_TABLE");
                } else {
                    this.myDdlBuilder.ref((DasObject)SqlInsertValuesExtractor.this.myDatabaseTable, SqlInsertValuesExtractor.this.myDatabaseTable.getName());
                }
                this.myDdlBuilder.space().symbol("(").newLine();
                boolean first = true;
                for (DataConsumer.Column column2 : this.myAllColumns) {
                    if (DbImplUtil.isRowId(column2)) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.myDdlBuilder.symbol(",").newLine();
                    }
                    String typeName = StringUtil.isEmpty((String)column2.typeName) ? "unknown" : column2.typeName;
                    this.myDdlBuilder.space(2).columnRef(column2.name).space().type(typeName);
                }
                this.myDdlBuilder.newLine().symbol(")").newStatement();
            }
        }

        @Override
        protected void appendData(List<DataConsumer.Row> rows) {
            int[] selectedColumns = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
            SqlInsertValuesExtractor.removeComputedAndAutoVal(selectedColumns, (TIntObjectHashMap<DataConsumer.Column>)columnsMap, SqlInsertValuesExtractor.this.myDatabaseTable);
            for (DataConsumer.Row row : rows) {
                DataConsumer.Column column2;
                this.myDdlBuilder.keyword("INSERT").space().keyword("INTO").space();
                if (SqlInsertValuesExtractor.this.myDatabaseTable != null) {
                    this.myDdlBuilder.qualifiedRef((DasObject)SqlInsertValuesExtractor.this.myDatabaseTable).space();
                } else {
                    this.myDdlBuilder.identifier("MY_TABLE");
                }
                boolean first = true;
                this.myDdlBuilder.symbol("(");
                for (int selectedColumn : selectedColumns) {
                    column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column2 == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.myDdlBuilder.symbol(",").space();
                    }
                    this.myDdlBuilder.columnRef(column2.name);
                }
                this.myDdlBuilder.symbol(")").space();
                first = true;
                this.myDdlBuilder.keyword("VALUES").space().symbol("(");
                for (int selectedColumn : selectedColumns) {
                    column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column2 == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.myDdlBuilder.symbol(",").space();
                    }
                    this.myDdlBuilder.literal(SqlInsertValuesExtractor.this.getValueLiteral(row, column2, this.myDbms));
                }
                this.myDdlBuilder.symbol(")");
                this.myDdlBuilder.newStatement();
            }
        }
    }
}

