/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModModelFun;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ModelReader;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseModel
implements BasicModModel {
    private static final AtomicInteger ourModelCounter = new AtomicInteger(0);
    private final int myModelInstanceNumber = ourModelCounter.incrementAndGet();
    @NotNull
    private ModelTextStorage myTextStorage = BlackHoleTextStorage.INSTANCE;
    @NotNull
    private final Logger log = Logger.getInstance(this.getClass());
    private final THashSet<BaseElement> myLastCreatedElements = new THashSet();
    private final THashSet<BaseElement> myLastModifiedElements = new THashSet();
    private final THashSet<BaseElement> myLastRemovedElements = new THashSet();
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private volatile long myModificationThreadId = Long.MIN_VALUE;
    private final CopyOnWriteArrayList<BasicModelListener> myListeners = new CopyOnWriteArrayList();
    private boolean myFastMode;

    @Override
    @NotNull
    public abstract BasicRoot getRoot();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V read(@NotNull ModelReader<? super BasicModel, V> reader) {
        if (reader == null) {
            BaseModel.$$$reportNull$$$0(0);
        }
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            V v = reader.perform(this);
            return v;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public <R extends BasicModRoot> void modify(@NotNull Class<R> rootClass, @NotNull ModelModifier<? super R> modifier) {
        if (rootClass == null) {
            BaseModel.$$$reportNull$$$0(1);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(2);
        }
        this.modify(this.getRoot(), rootClass, modifier);
    }

    @Override
    public <E extends BasicElement, M extends E> void modify(@NotNull E element2, @NotNull Class<M> clazz, @NotNull ModelModifier<? super M> modifier) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            BaseModel.$$$reportNull$$$0(4);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(5);
        }
        this.modify(element2, clazz, this.myFastMode, modifier);
    }

    public <E extends BasicElement, M extends E> void modify(@NotNull E element2, @NotNull Class<M> clazz, boolean fast, @NotNull ModelModifier<? super M> modifier) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(6);
        }
        if (clazz == null) {
            BaseModel.$$$reportNull$$$0(7);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(8);
        }
        if (element2.getModel() == null) {
            throw new IllegalArgumentException("Orphan element (the element doesn't belong to any model)");
        }
        if (element2.getModel() != this) {
            throw new IllegalArgumentException("Alien element (the element belong to another model)");
        }
        Class<?> elementClass = element2.getClass();
        if (!clazz.isAssignableFrom(elementClass)) {
            throw new IllegalArgumentException("Attempt to modify element of " + elementClass.getSimpleName() + " as an instance of " + clazz.getSimpleName());
        }
        E modElement = element2;
        this.modify(modElement, fast, modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends BasicElement> void modify(@NotNull E element2, boolean fast, @NotNull ModelModifier<? super E> modifier) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(9);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(10);
        }
        long time1 = System.currentTimeMillis();
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        writeLock.lock();
        long time2 = System.currentTimeMillis();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Model entered into modifying mode (lock delay was " + (time2 - time1) + " ms)");
        }
        boolean prevFast = this.myFastMode;
        try {
            this.myFastMode = fast;
            this.clearModifications();
            this.myModificationThreadId = Thread.currentThread().getId();
            long time3 = System.currentTimeMillis();
            modifier.perform(element2);
            long time4 = System.currentTimeMillis();
            this.compactListeners();
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.format("Model was modified during %d ms, %d created, %d updated, %d removed ", time4 - time3, this.myLastCreatedElements.size(), this.myLastModifiedElements.size(), this.myLastRemovedElements.size()));
            }
        }
        finally {
            this.myFastMode = prevFast;
            writeLock.unlock();
            this.myModificationThreadId = Integer.MIN_VALUE;
            long time5 = System.currentTimeMillis();
            this.notifyListeners();
            long time6 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Listeners took " + (time6 - time5) + " ms");
            }
            long time7 = System.currentTimeMillis();
            this.removeDroppedSources();
            long time8 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Dropping sources took " + (time8 - time7) + " ms");
            }
        }
    }

    void doingObjectCreate(@NotNull BaseElement element2) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(11);
        }
        this.doingAnyModification();
        if (!this.myFastMode) {
            this.myLastCreatedElements.add((Object)element2);
        }
    }

    void doingObjectModify(@NotNull BaseElement element2) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(12);
        }
        this.doingAnyModification();
        if (!this.myFastMode) {
            this.myLastModifiedElements.add((Object)element2);
        }
    }

    void doingObjectRemove(@NotNull BaseElement element2) {
        if (element2 == null) {
            BaseModel.$$$reportNull$$$0(13);
        }
        this.doingAnyModification();
        if (element2 instanceof BasicSourceAware || element2 instanceof BasicNamespace) {
            this.myTextStorage.queueDelete(element2);
        }
        if (!this.myFastMode) {
            this.myLastRemovedElements.add((Object)element2);
        }
    }

    private void doingAnyModification() {
    }

    @Override
    public void addListener(BasicModelListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(BasicModelListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public void writeSources(@NotNull Runnable r) {
        if (r == null) {
            BaseModel.$$$reportNull$$$0(14);
        }
        this.myTextStorage.writeSession(r);
    }

    private void compactListeners() {
        this.myLastCreatedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastCreatedElements);
    }

    private void notifyListeners() {
        if (this.myLastCreatedElements.isEmpty() && this.myLastModifiedElements.isEmpty() && this.myLastRemovedElements.isEmpty()) {
            return;
        }
        Set<BasicElement> lastCreatedElements = Collections.unmodifiableSet(this.myLastCreatedElements);
        Set<BasicElement> lastModifiedElements = Collections.unmodifiableSet(this.myLastModifiedElements);
        Set<BasicElement> lastRemovedElements = Collections.unmodifiableSet(this.myLastRemovedElements);
        for (BasicModelListener listener : this.myListeners) {
            listener.modified(lastCreatedElements, lastModifiedElements, lastRemovedElements);
        }
    }

    private void removeDroppedSources() {
        this.myTextStorage.processDeleteQueue();
    }

    private void clearModifications() {
        this.myLastCreatedElements.clear();
        this.myLastModifiedElements.clear();
        this.myLastRemovedElements.clear();
    }

    @Override
    public void saveSourceText(@NotNull BasicSourceAware object, @Nullable CompositeText sourceText) {
        if (object == null) {
            BaseModel.$$$reportNull$$$0(15);
        }
        this.myTextStorage.save(object, sourceText);
    }

    @Override
    @Nullable
    public CompositeText loadSourceText(@NotNull BasicSourceAware object) {
        if (object == null) {
            BaseModel.$$$reportNull$$$0(16);
        }
        return this.myTextStorage.load(object);
    }

    @Override
    public void setSchemaSourcesVersion(@NotNull BasicSchema schema, @Nullable Long version) {
        if (schema == null) {
            BaseModel.$$$reportNull$$$0(17);
        }
        this.myTextStorage.setVersion(schema, version);
    }

    @Override
    @Nullable
    public Long getSchemaSourcesVersion(@NotNull BasicSchema schema) {
        if (schema == null) {
            BaseModel.$$$reportNull$$$0(18);
        }
        return this.myTextStorage.getVersion(schema);
    }

    @Override
    public void setTextStorage(@NotNull ModelTextStorage textStorage) {
        if (textStorage == null) {
            BaseModel.$$$reportNull$$$0(19);
        }
        this.myTextStorage = textStorage;
    }

    @Override
    @NotNull
    public ModelTextStorage getTextStorage() {
        ModelTextStorage modelTextStorage = this.myTextStorage;
        if (modelTextStorage == null) {
            BaseModel.$$$reportNull$$$0(20);
        }
        return modelTextStorage;
    }

    @NotNull
    static String deduplicate(@NotNull String str) {
        if (str == null) {
            BaseModel.$$$reportNull$$$0(21);
        }
        String string = str == ModelConsts.NO_NAME ? ModelConsts.NO_NAME : DbUtil.intern((String)str);
        if (string == null) {
            BaseModel.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    @Contract(value="null,_ -> null", pure=true)
    protected static <X> X findFirst(@Nullable Iterable<X> items, @NotNull Predicate<X> predicate) {
        if (predicate == null) {
            BaseModel.$$$reportNull$$$0(23);
        }
        if (items == null) {
            return null;
        }
        for (X item : items) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    protected static boolean eq(@Nullable Object value1, @Nullable Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public int hashCode() {
        return this.myModelInstanceNumber;
    }

    public String toString() {
        return String.format("%s model [instance %d]", this.getDbms().getName(), this.myModelInstanceNumber);
    }

    @Deprecated
    @NotNull
    public JBIterable<? extends BasicForeignKey> getExportedKeys(DasTable t) {
        BasicTable table = (BasicTable)ObjectUtils.tryCast((Object)(t instanceof DbTable ? ((DbTable)t).getDelegate() : t), BasicTable.class);
        JBIterable<BasicForeignKey> jBIterable = table != null ? ModModelFun.findReferencingForeignKeys(table) : JBIterable.empty();
        if (jBIterable == null) {
            BaseModel.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textStorage";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/BaseModel";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/BaseModel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextStorage";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicate";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectCreate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectModify";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectRemove";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeSources";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveSourceText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadSourceText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setSchemaSourcesVersion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaSourcesVersion";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setTextStorage";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deduplicate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class BaseNamingIdentifyingFamily<E extends BaseElement & BasicModIdentifiedElement>
    extends BaseNamingFamily<E>
    implements ModNamingIdentifyingFamily<E> {
        public BaseNamingIdentifyingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public E renew(long objectId, @NotNull String string) {
            void name;
            if (string == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(1);
            }
            E e = this.renew(objectId, (String)name, (String s, String s2) -> {});
            if (e == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(2);
            }
            return e;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public E renew(long objectId, @NotNull String name, @NotNull BiConsumer<String, String> biConsumer) {
            List elements;
            if (name == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(3);
            }
            if (biConsumer == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(4);
            }
            if ((elements = this.myElements) != null) {
                if (objectId != Long.MIN_VALUE) {
                    for (BaseElement e : elements) {
                        if (((BasicIdentifiedElement)((Object)e)).getObjectId() != objectId) continue;
                        String oldName = ((BasicNamedElement)((Object)e)).getName();
                        ((BasicModNamedElement)((Object)e)).setName(name);
                        e.resetSyncPending();
                        String newName = ((BasicNamedElement)((Object)e)).getName();
                        if (!Comparing.equal((String)oldName, (String)newName)) {
                            void renameHandler;
                            renameHandler.accept(oldName, newName);
                        }
                        BaseElement baseElement = e;
                        if (baseElement == null) {
                            BaseNamingIdentifyingFamily.$$$reportNull$$$0(5);
                        }
                        return (E)baseElement;
                    }
                }
                if (name != ModelConsts.NO_NAME) {
                    for (BaseElement e : elements) {
                        if (((BasicIdentifiedElement)((Object)e)).getObjectId() != Long.MIN_VALUE || !((BasicNamedElement)((Object)e)).getName().equals(name)) continue;
                        ((BasicModIdentifiedElement)((Object)e)).setObjectId(objectId);
                        e.resetSyncPending();
                        BaseElement baseElement = e;
                        if (baseElement == null) {
                            BaseNamingIdentifyingFamily.$$$reportNull$$$0(6);
                        }
                        return (E)baseElement;
                    }
                }
            }
            BasicModElement e = this.createNewOne();
            ((BasicModIdentifiedElement)e).setObjectId(objectId);
            ((BasicModNamedElement)e).setName(name);
            BasicModElement basicModElement = e;
            if (basicModElement == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(7);
            }
            return (E)basicModElement;
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            Object element2 = this.getByObjectId(objectId);
            if (element2 == null) {
                element2 = this.createNewOne();
                ((BasicModIdentifiedElement)element2).setObjectId(objectId);
            }
            E e = element2;
            if (e == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(8);
            }
            return e;
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            List elements = this.myElements;
            if (elements == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                if (((BasicIdentifiedElement)((Object)element2)).getObjectId() != objectId) continue;
                return (E)element2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseNamingIdentifyingFamily";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renameHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseNamingIdentifyingFamily";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "renew";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "renew";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BasePositioningNamingFamily<E extends BaseElement & BasicModNamedElement>
    extends BaseNamingFamily<E>
    implements ModPositioningNamingFamily<E> {
        public BasePositioningNamingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        public E renewAt(short position, @NotNull String name) {
            List elements;
            BasicModElement e;
            if (name == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(1);
            }
            if ((e = BaseModel.findFirst(elements = this.myElements, x -> {
                if (name == null) {
                    BasePositioningNamingFamily.$$$reportNull$$$0(3);
                }
                return ((BasicArrangedElement)((Object)x)).getPosition() == position && ((BasicNamedElement)((Object)x)).getName().equals(name);
            })) != null) {
                e.resetSyncPending();
                return (E)e;
            }
            e = BaseModel.findFirst(elements, x -> ((BasicArrangedElement)((Object)x)).getPosition() == position && ((BasicNamedElement)((Object)x)).getName() == ModelConsts.NO_NAME);
            if (e != null) {
                ((BasicModNamedElement)e).setName(name);
                e.resetSyncPending();
                return (E)e;
            }
            e = BaseModel.findFirst(elements, x -> {
                if (name == null) {
                    BasePositioningNamingFamily.$$$reportNull$$$0(2);
                }
                return ((BasicArrangedElement)((Object)x)).getPosition() == 0 && ((BasicNamedElement)((Object)x)).getName().equals(name);
            });
            if (e != null) {
                ((BasicModArrangedElement)e).setPosition(position);
                e.resetSyncPending();
                return (E)e;
            }
            e = this.createNewOne();
            ((BasicModArrangedElement)e).setPosition(position);
            ((BasicModNamedElement)e).setName(name);
            return (E)e;
        }

        @Override
        public E createOrGetAt(short position) {
            List elements = this.myElements;
            if (elements == null) {
                BasicModElement element2 = this.createNewOne();
                ((BasicModArrangedElement)element2).setPosition(position);
                CopyOnWriteArrayList<BasicModElement> newElements = new CopyOnWriteArrayList<BasicModElement>();
                newElements.add(element2);
                this.myElements = newElements;
                return (E)element2;
            }
            for (BaseElement element3 : elements) {
                if (((BasicArrangedElement)((Object)element3)).getPosition() != position) continue;
                element3.resetSyncPending();
                return (E)element3;
            }
            BasicModElement element2 = this.createNewOne();
            ((BasicModArrangedElement)element2).setPosition(position);
            return (E)element2;
        }

        @Override
        @Nullable
        public E getByNaturalPosition(short position) {
            List elements = this.myElements;
            return (E)BaseModel.findFirst(elements, e -> ((BasicArrangedElement)((Object)e)).getPosition() == position);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/BaseModel$BasePositioningNamingFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renewAt";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$renewAt$2";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$renewAt$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class BaseIdentifyingFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModIdentifyingFamily<E> {
        public BaseIdentifyingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            Object element2 = this.getByObjectId(objectId);
            if (element2 == null) {
                element2 = this.createNewOne();
                ((BasicModIdentifiedElement)element2).setObjectId(objectId);
            }
            E e = element2;
            if (e == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(1);
            }
            return e;
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            List elements = this.myElements;
            if (elements == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                if (((BasicIdentifiedElement)((Object)element2)).getObjectId() != objectId) continue;
                return (E)element2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseIdentifyingFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseIdentifyingFamily";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseNamingFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModNamingFamily<E> {
        public BaseNamingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BaseNamingFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        public E createOrGet(@NotNull String name) {
            Object element2;
            if (name == null) {
                BaseNamingFamily.$$$reportNull$$$0(1);
            }
            if ((element2 = this.get(name)) == null) {
                element2 = this.createNewOne();
                ((BasicModNamedElement)element2).setName(name);
            } else {
                element2.resetSyncPending();
            }
            return element2;
        }

        @Override
        @Nullable
        public E get(@NotNull String name) {
            if (name == null) {
                BaseNamingFamily.$$$reportNull$$$0(2);
            }
            return this.get(name, true);
        }

        @Override
        @Nullable
        public E get(@NotNull String name, boolean caseSensitive) {
            List elements;
            if (name == null) {
                BaseNamingFamily.$$$reportNull$$$0(3);
            }
            if ((elements = this.myElements) == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                boolean matched = caseSensitive ? ((BasicNamedElement)((Object)element2)).getName().equals(name) : ((BasicNamedElement)((Object)element2)).getName().equalsIgnoreCase(name);
                if (!matched) continue;
                return (E)element2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/BaseModel$BaseNamingFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createOrGet";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class BasePositioningFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModPositioningFamily<E> {
        public BasePositioningFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BasePositioningFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        public E createOrGetAt(short position) {
            List elements = this.myElements;
            if (elements == null) {
                BasicModElement element2 = this.createNewOne();
                ((BasicModArrangedElement)element2).setPosition(position);
                CopyOnWriteArrayList<BasicModElement> newElements = new CopyOnWriteArrayList<BasicModElement>();
                newElements.add(element2);
                this.myElements = newElements;
                return (E)element2;
            }
            for (BaseElement element3 : elements) {
                if (((BasicArrangedElement)((Object)element3)).getPosition() != position) continue;
                element3.resetSyncPending();
                return (E)element3;
            }
            BasicModElement element2 = this.createNewOne();
            ((BasicModArrangedElement)element2).setPosition(position);
            return (E)element2;
        }

        @Override
        @Nullable
        public E getByNaturalPosition(short position) {
            List elements = this.myElements;
            if (elements == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                if (((BasicArrangedElement)((Object)element2)).getPosition() != position) continue;
                return (E)element2;
            }
            return null;
        }

        @Override
        protected Comparator<? super E> getElementsComparator() {
            return ModelUtil.POSITIONS_COMPARATOR;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/BaseModel$BasePositioningFamily", "<init>"));
        }
    }

    public static abstract class BaseSingletonFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModSingletonFamily<E> {
        public BaseSingletonFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BaseSingletonFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        @Nullable
        public E get() {
            List elements = this.myElements;
            return (E)(elements == null ? null : (BaseElement)elements.get(0));
        }

        @Override
        @NotNull
        public E createNewOne() {
            this.owner.modifying();
            assert (this.myElements == null);
            Object newOne = this.instantiate();
            this.myElements = Collections.singletonList(newOne);
            Object e = newOne;
            if (e == null) {
                BaseSingletonFamily.$$$reportNull$$$0(1);
            }
            return e;
        }

        @Override
        @NotNull
        public E createOrGet() {
            if (this.isEmpty()) {
                BasicModElement basicModElement = this.createNewOne();
                if (basicModElement == null) {
                    BaseSingletonFamily.$$$reportNull$$$0(2);
                }
                return (E)basicModElement;
            }
            BasicElement basicElement = this.first();
            if (basicElement == null) {
                BaseSingletonFamily.$$$reportNull$$$0(3);
            }
            return (E)basicElement;
        }

        @Override
        public void sort() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseSingletonFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseSingletonFamily";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseFamily<E extends BaseElement>
    implements ModFamily<E> {
        @NotNull
        public final BaseElement owner;
        @Nullable
        protected volatile List<E> myElements;

        public BaseFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BaseFamily.$$$reportNull$$$0(0);
            }
            this.myElements = null;
            this.owner = owner;
        }

        @NotNull
        protected abstract E instantiate();

        @Override
        @NotNull
        public E createNewOne() {
            BaseModel model = this.owner.getModel();
            this.owner.modifying();
            E newOne = this.instantiate();
            if (this.myElements == null) {
                this.myElements = new CopyOnWriteArrayList();
            }
            this.myElements.add(newOne);
            model.doingObjectCreate((BaseElement)newOne);
            E e = newOne;
            if (e == null) {
                BaseFamily.$$$reportNull$$$0(1);
            }
            return e;
        }

        @Override
        @NotNull
        public BasicModModel getModel() {
            BaseModel baseModel = this.owner.getModel();
            if (baseModel == null) {
                BaseFamily.$$$reportNull$$$0(2);
            }
            return baseModel;
        }

        @Override
        @NotNull
        public E first() {
            List<E> elements = this.myElements;
            if (elements == null || elements.isEmpty()) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(0);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(3);
            }
            return (E)baseElement;
        }

        @Override
        @NotNull
        public E last() {
            List<E> elements = this.myElements;
            if (elements == null || elements.isEmpty()) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(elements.size() - 1);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(4);
            }
            return (E)baseElement;
        }

        @Override
        public int indexOf(@Nullable BasicElement element2) {
            if (element2 == null) {
                return -1;
            }
            List<E> elements = this.myElements;
            if (elements == null) {
                return -1;
            }
            return elements.indexOf(element2);
        }

        @Override
        public boolean hasChildren() {
            List<E> elements = this.myElements;
            return elements != null && !elements.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            List<E> elements = this.myElements;
            return elements == null || elements.isEmpty();
        }

        @Override
        public int size() {
            List<E> elements = this.myElements;
            return elements != null ? elements.size() : 0;
        }

        @Override
        @Nullable
        public E find(@NotNull Predicate<? super E> predicate) {
            List<E> elements;
            if (predicate == null) {
                BaseFamily.$$$reportNull$$$0(5);
            }
            if ((elements = this.myElements) == null) {
                return null;
            }
            for (BaseElement element2 : elements) {
                if (!predicate.test(element2)) continue;
                return (E)element2;
            }
            return null;
        }

        @Override
        public Iterator<E> iterator() {
            List<E> elements = this.myElements;
            if (elements != null) {
                return elements.iterator();
            }
            return Collections.emptyListIterator();
        }

        @Override
        public void remove(@NotNull Predicate<? super E> condition) {
            List<E> elements;
            if (condition == null) {
                BaseFamily.$$$reportNull$$$0(6);
            }
            if ((elements = this.myElements) == null) {
                return;
            }
            int n = elements.size();
            boolean modificationSent = false;
            for (int i2 = n - 1; i2 >= 0; --i2) {
                BaseElement e = (BaseElement)elements.get(i2);
                if (!condition.test(e)) continue;
                if (!modificationSent) {
                    modificationSent = true;
                    this.owner.modifying();
                }
                e.internalDrop(false);
                if (elements.size() >= 2) {
                    elements.remove(i2);
                    continue;
                }
                this.myElements = null;
            }
            if (elements.isEmpty()) {
                this.myElements = null;
            }
        }

        @Override
        public void sort() {
            List<E> elements = this.myElements;
            if (elements == null || elements.size() < 2) {
                return;
            }
            this.owner.modifying();
            if (!(elements instanceof ArrayList) && !(elements instanceof CopyOnWriteArrayList)) {
                throw new IllegalStateException("Unknown how to reorder elements inside a " + elements.getClass().getSimpleName());
            }
            Comparator<E> comparator = this.getElementsComparator();
            elements.sort(comparator);
        }

        protected Comparator<? super E> getElementsComparator() {
            return ModelUtil.DISPLAY_ORDER_COMPARATOR;
        }

        @Override
        public void clear() {
            List<E> elements = this.myElements;
            if (elements == null) {
                return;
            }
            this.owner.modifying();
            this.myElements = null;
            for (int i2 = elements.size() - 1; i2 >= 0; --i2) {
                BaseElement e = (BaseElement)elements.get(i2);
                e.internalDrop(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseFamily";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseFamily";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "first";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "last";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseRegularNamedElement
    extends BaseRegularElement
    implements BasicModNamedElement {
        @NotNull
        private String myName;
        private short myFlags;

        public BaseRegularNamedElement(@NotNull BaseFamily<?> parentFamily) {
            if (parentFamily == null) {
                BaseRegularNamedElement.$$$reportNull$$$0(0);
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myFlags = 0;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                BaseRegularNamedElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                BaseRegularNamedElement.$$$reportNull$$$0(2);
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.getFlag((short)1);
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            this.setFlagProperty((short)1, nameSurrogate);
        }

        @Override
        public boolean isNameScripted() {
            return this.getFlag((short)2);
        }

        @Override
        public void setNameScripted(boolean nameScripted) {
            this.setFlagProperty((short)2, nameScripted);
        }

        @Override
        public boolean isNameQuoted() {
            return this.getFlag((short)4);
        }

        @Override
        public void setNameQuoted(boolean nameQuoted) {
            this.setFlagProperty((short)4, nameQuoted);
        }

        @Override
        public boolean isOutdated() {
            return this.getFlag((short)8);
        }

        @Override
        public void setOutdated(boolean outdated) {
            this.setFlagProperty((short)8, outdated);
        }

        private void setFlagProperty(short flag, boolean value) {
            if (this.getFlag(flag) == value) {
                return;
            }
            this.modifying();
            this.setFlag(flag, value);
        }

        private boolean getFlag(short flag) {
            return (this.myFlags & flag) != 0;
        }

        private void setFlag(short flag, boolean value) {
            this.myFlags = value ? (short)(this.myFlags | flag) : (short)(this.myFlags & ~flag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFamily";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseRegularNamedElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseRegularNamedElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseRegularElement
    extends BaseElement {
        @NotNull
        protected final BaseFamily<?> myParentFamily;
        @Nullable
        private transient String myDisplayOrder;
        private transient boolean myDropped;
        private transient boolean mySyncPending;

        public BaseRegularElement(@NotNull BaseFamily<?> parentFamily) {
            if (parentFamily == null) {
                BaseRegularElement.$$$reportNull$$$0(0);
            }
            this.myDisplayOrder = null;
            this.myDropped = false;
            this.mySyncPending = false;
            this.myParentFamily = parentFamily;
        }

        @Override
        protected void modifying() {
            super.modifying();
            this.myDisplayOrder = null;
        }

        @Override
        @NotNull
        public final String getDisplayOrder() {
            String o = this.myDisplayOrder;
            if (o == null) {
                this.myDisplayOrder = o = this.calculateDisplayOrder();
            }
            String string = o;
            if (string == null) {
                BaseRegularElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
            this.mySyncPending = syncPending;
        }

        @Override
        public boolean isSyncPending() {
            return this.mySyncPending;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            this.getModel().doingObjectRemove(this);
            this.dropChildren();
            if (removeFromParent) {
                this.myParentFamily.remove(e -> e == this);
            }
            this.myDropped = true;
        }

        @Override
        public boolean isDropped() {
            return this.myDropped;
        }

        public String toString() {
            return this.identity(true) + ": " + this.getKind().name().toLowerCase(Locale.ROOT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFamily";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseRegularElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseRegularElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayOrder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseRoot
    extends BaseElement
    implements BasicModRoot {
        @Nullable
        private Version myServerVersion = null;
        @NotNull
        private Dbms myDbms;

        public BaseRoot() {
            this.myDbms = this.getModel().getMetaModel().dbms;
        }

        @Override
        public void setDbms(@NotNull Dbms dbms) {
            if (dbms == null) {
                BaseRoot.$$$reportNull$$$0(0);
            }
            if (this.getModel().getMetaModel() != DbImplUtil.getMetaModel(dbms)) {
                throw new AssertionError((Object)(dbms.getName() + " does not match " + this.getModel().getMetaModel().dbms));
            }
            this.myDbms = dbms;
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = this.myDbms;
            if (dbms == null) {
                BaseRoot.$$$reportNull$$$0(1);
            }
            return dbms;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
            if (syncPending) {
                throw new IllegalStateException("Cannot set the root element as sync pending");
            }
        }

        @Override
        public boolean isSyncPending() {
            return false;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            throw new IllegalStateException("Cannot drop a root element");
        }

        @Override
        public boolean isDropped() {
            return false;
        }

        @Override
        @NotNull
        public String calculateDisplayOrder() {
            if ("ROOT" == null) {
                BaseRoot.$$$reportNull$$$0(2);
            }
            return "ROOT";
        }

        public String toString() {
            return "ROOT";
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull String> getDbPath() {
            List<String> list = Collections.emptyList();
            if (list == null) {
                BaseRoot.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @Nullable
        public Version getServerVersion() {
            return this.myServerVersion;
        }

        @Override
        public void setServerVersion(@Nullable Version version) {
            if (Objects.equals(this.myServerVersion, version)) {
                return;
            }
            this.modifying();
            this.myServerVersion = version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/BaseModel$BaseRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/BaseModel$BaseRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculateDisplayOrder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setDbms";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseElement
    implements BasicModElement {
        @Override
        @NotNull
        public abstract BaseModel getModel();

        @Override
        @NotNull
        public BasicMetaObject getMetaObject() {
            Family<? extends BasicElement> p2 = this.getParentFamily();
            if (p2 == null) {
                BasicMetaObject basicMetaObject = this.getModel().getMetaModel().root;
                if (basicMetaObject == null) {
                    BaseElement.$$$reportNull$$$0(0);
                }
                return basicMetaObject;
            }
            BasicMetaObject basicMetaObject = ((ModFamily)p2).getMetaObject();
            if (basicMetaObject == null) {
                BaseElement.$$$reportNull$$$0(1);
            }
            return basicMetaObject;
        }

        protected void modifying() {
            this.getModel().doingObjectModify(this);
        }

        @Override
        public void drop() {
            this.internalDrop(true);
        }

        abstract void internalDrop(boolean var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/BaseModel$BaseElement", "getMetaObject"));
        }
    }
}

