/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.DescriptionService$WhenMappings;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicDistTableColumn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicToggleable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.StringFun;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 a2\u00020\u0001:\u0002abB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0018\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001aH\u0004J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0004J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\"H\u0004J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020$H\u0004J\u000e\u0010%\u001a\u00020\b2\u0006\u0010 \u001a\u00020&J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020*H\u0004J\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010+\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020.H\u0014J\u000e\u0010/\u001a\u00020\b2\u0006\u0010,\u001a\u00020-J\u0018\u00100\u001a\u00020\b2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\fH\u0004J\u0018\u00104\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u000205H\u0004J\u001a\u00106\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u00107\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u00020\fH\u0004J\u0010\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020=H\u0004J \u0010;\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0004J\u0010\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020CH\u0004J\u0018\u0010A\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020CH\u0004J\u0010\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020FH\u0004J\u0018\u0010D\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020GH\u0004J\u0010\u0010H\u001a\u00020\b2\u0006\u0010I\u001a\u00020JH\u0004J \u0010H\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020K2\u0006\u0010?\u001a\u00020@H\u0004J\u0018\u0010L\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020MH\u0004J\u0010\u0010N\u001a\u00020\b2\u0006\u0010 \u001a\u00020OH\u0004J\u0010\u0010P\u001a\u00020\b2\u0006\u0010Q\u001a\u00020RH\u0004J\u0018\u0010P\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020RH\u0004J\u0018\u0010S\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020TH\u0004J\u0010\u0010U\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020VH\u0004J\u000e\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020YJ\u0018\u0010Z\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010[\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\b2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\b0]H\u0004J\u0018\u0010^\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010_\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020@2\u0006\u0010\u001e\u001a\u00020`2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006c"}, d2={"Lcom/intellij/database/model/DescriptionService;", "", "()V", "eoln", "", "getEoln", "()C", "indentStep", "", "getIndentStep", "()Ljava/lang/String;", "cascadeRuleIsMeaningful", "", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "e", "Lcom/intellij/database/model/basic/BasicElement;", "content", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeArgument", "a", "Lcom/intellij/database/model/basic/BasicArgument;", "describeBasicElement", "describeCheck", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "o", "describeColumn", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "Lcom/intellij/database/model/DasColumn;", "describeCustomType", "Lcom/intellij/database/model/DasUserDefinedType;", "describeDistColumn", "Lcom/intellij/database/model/basic/BasicDistTableColumn;", "describeForeignKey", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "Lcom/intellij/database/model/DasForeignKey;", "describeIndex", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "Lcom/intellij/database/model/DasIndex;", "describeIndexingItems", "describeKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "withSurrogates", "describeOperator", "Lcom/intellij/database/model/DasOperator;", "describePredicate", "predicate", "describeRoot", "root", "Lcom/intellij/database/model/basic/BasicRoot;", "describeRoutine", "r", "Lcom/intellij/database/model/basic/BasicRoutine;", "Lcom/intellij/database/model/DasRoutine;", "project", "Lcom/intellij/openapi/project/Project;", "describeSequence", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "describeSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "Lcom/intellij/database/model/DasSynonym;", "describeTable", "table", "Lcom/intellij/database/model/basic/BasicTable;", "Lcom/intellij/database/model/DasTable;", "describeTableKey", "Lcom/intellij/database/model/DasTableKey;", "describeTableOrViewColumn", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "describeTrigger", "trig", "Lcom/intellij/database/model/basic/BasicTrigger;", "describeTyped", "Lcom/intellij/database/model/DasTypedObject;", "describeTypedElement", "Lcom/intellij/database/model/basic/BasicTypedElement;", "describeView", "view", "Lcom/intellij/database/model/basic/BasicView;", "options", "presentIndexColumn", "descendants", "", "suffix", "updatePresentation", "Lcom/intellij/database/model/DasObject;", "Companion", "Context", "intellij.database.impl"})
public abstract class DescriptionService {
    @NotNull
    private final String indentStep = "    ";
    private final char eoln = (char)10;
    @JvmField
    @NotNull
    public static final DescriptionService DUMMY;
    public static final Companion Companion;

    @NotNull
    protected final String getIndentStep() {
        return this.indentStep;
    }

    protected final char getEoln() {
        return this.eoln;
    }

    @NotNull
    public String suffix(@NotNull BasicElement e, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return "";
    }

    @NotNull
    public String options(@NotNull BasicElement e, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (e.isAutoCreated() ? " [auto]" : "") + (e instanceof BasicToggleable && ((BasicToggleable)e).isDisabled() ? " [disabled]" : "") + (e instanceof BasicSourceAware && ((BasicSourceAware)e).isInvalid() ? " [invalid]" : "");
    }

    @NotNull
    public String content(@NotNull BasicElement e, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof BasicSequence ? this.describeSequence((BasicSequence)e) : (basicElement instanceof BasicTable ? this.describeTable((BasicTable)e) : (basicElement instanceof BasicView ? this.describeView((BasicView)e) : (basicElement instanceof BasicIndex ? this.describeIndex((BasicIndex)e) : (basicElement instanceof BasicKey ? this.describeKey((BasicKey)e, context.getWithSurrogates()) : (basicElement instanceof BasicForeignKey ? this.describeForeignKey((BasicForeignKey)e) : (basicElement instanceof BasicCheck ? this.describeCheck((BasicCheck)e) : (basicElement instanceof BasicTrigger ? this.describeTrigger((BasicTrigger)e) : (basicElement instanceof BasicRoutine ? this.describeRoutine((BasicRoutine)e) : (basicElement instanceof BasicDistTableColumn ? this.describeDistColumn((BasicDistTableColumn)e) : (basicElement instanceof BasicTableOrViewColumn ? this.describeTableOrViewColumn((BasicTableOrViewColumn)e) : (basicElement instanceof BasicLikeColumn ? this.describeColumn((BasicLikeColumn)e) : (basicElement instanceof BasicArgument ? this.describeArgument((BasicArgument)e) : (basicElement instanceof BasicTypedElement ? this.describeTypedElement((BasicTypedElement)e) : (basicElement instanceof BasicSynonym ? this.describeSynonym((BasicSynonym)e) : (basicElement instanceof BasicRoot ? this.describeRoot((BasicRoot)e, context.getWithSurrogates()) : this.describeBasicElement(e))))))))))))))));
    }

    @NotNull
    protected final String describeSequence(@NotNull BasicSequence sequence) {
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        StringBuilder stringBuilder = new StringBuilder().append("sequence: ");
        Object object = sequence.getSequenceIdentity();
        if (object == null || (object = ((SequenceIdentity)object).getSpecification()) == null) {
            object = "???";
        }
        return stringBuilder.append(object).toString();
    }

    @NotNull
    protected final String describeTable(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String res2 = "";
        if (table.isTemporary()) {
            res2 = res2 + "temporary ";
        }
        if (table.isSystem()) {
            res2 = res2 + "system ";
        }
        return res2 + "table";
    }

    @NotNull
    public final String describeView(@NotNull BasicView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return this.describeBasicElement(view);
    }

    @NotNull
    public String describeIndex(@NotNull BasicIndex index2) {
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        String inner = this.describeIndexingItems(index2);
        String condition = index2.getCondition();
        String d2 = (index2.isUnique() ? "unique" : "index") + " (" + inner + ')';
        if (condition != null) {
            d2 = d2 + " when " + condition;
        }
        return d2;
    }

    @NotNull
    public final String describeIndexingItems(@NotNull BasicIndex index2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        List<String> names = index2.getColNames();
        Set<String> ds = index2.getReverseColNames();
        if (names.isEmpty()) {
            string = "???";
        } else {
            List<String> list = names;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"names");
            CharSequence charSequence = ", ";
            CharSequence charSequence2 = null;
            int n = 0;
            CharSequence charSequence3 = null;
            CharSequence charSequence4 = null;
            Function1 function1 = (Function1)new Function1<String, String>(this, ds){
                final /* synthetic */ DescriptionService this$0;
                final /* synthetic */ Set $ds;

                @NotNull
                public final String invoke(String it) {
                    Set set = this.$ds;
                    Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ds");
                    return this.this$0.presentIndexColumn(it, set);
                }
                {
                    this.this$0 = descriptionService;
                    this.$ds = set;
                    super(1);
                }
            };
            string = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)charSequence, charSequence4, charSequence3, (int)n, charSequence2, (Function1)function1, (int)30, null);
        }
        return string;
    }

    @NotNull
    protected final String presentIndexColumn(@Nullable String column2, @NotNull Set<String> descendants) {
        Object object;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull(descendants, (String)"descendants");
        if (column2 == null || (charSequence = (CharSequence)column2).length() == 0) {
            return "???";
        }
        String s = column2;
        if (s.charAt(0) == '\u001b') {
            object = s;
            int n = 1;
            int n2 = s.length();
            StringBuilder stringBuilder = new StringBuilder().append("fun:");
            String string = ((String)object).substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string2 = string;
            s = stringBuilder.append(string2).toString();
        }
        if (descendants.contains(column2)) {
            s = s + " desc";
        } else {
            object = descendants;
            if (!object.isEmpty()) {
                s = s + " asc";
            }
        }
        return s;
    }

    @NotNull
    protected final String describeKey(@NotNull BasicKey key2, boolean withSurrogates) {
        String string;
        String string2;
        String string3;
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        List<String> names = key2.getColNames();
        String k = key2.isPrimary() ? "PK" : "AK";
        List<String> list = names;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"names");
        Collection collection = list;
        String inner = !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        BasicIndex index2 = key2.getUnderlyingIndex();
        String name = index2 == null || !index2.isNameSurrogate() || withSurrogates ? key2.getUnderlyingIndexName() : index2.identity(false);
        String string4 = StringFun.notSame(key2.getUnderlyingIndexName(), key2.getName());
        if (string4 != null) {
            String it = string3 = string4;
            string2 = name;
        } else {
            string2 = null;
        }
        if ((string = (string3 = StringFun.decorate(string2, " (underlying index ", ")"))) == null) {
            string = "";
        }
        String underlying = string;
        return k + " (" + inner + ')' + underlying;
    }

    private final String describeForeignKey(BasicForeignKey fk) {
        String deferrable;
        List<String> refCols;
        List<String> names;
        String string;
        boolean toQualify;
        String domSchemaName = ModelFun.getSchemaName(fk);
        String refSchemaName = fk.getRefSchemaName();
        boolean bl = toQualify = refSchemaName != null && Intrinsics.areEqual((Object)refSchemaName, (Object)domSchemaName) ^ true;
        if (toQualify) {
            string = refSchemaName + "" + fk.getRefTableName();
        } else {
            string = fk.getRefTableName();
            if (string == null) {
                string = "???";
            }
        }
        String refTableScr = string;
        List<String> list = names = fk.getColNames();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"names");
        Collection collection = list;
        String inner = !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        BasicKey basicKey = fk.getRefKey();
        String string2 = StringFun.decorate(basicKey != null ? basicKey.getNaturalName() : null, "[.", "]");
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String refKey = string3;
        List<String> list2 = refCols = fk.getRefColNames();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"refCols");
        Collection collection2 = list2;
        String refInner = !collection2.isEmpty() ? CollectionsKt.joinToString$default((Iterable)refCols, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        CascadeRule cascadeRule = fk.getOnUpdate();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)cascadeRule), (String)"fk.onUpdate");
        String onUpdate = this.cascadeRuleIsMeaningful(cascadeRule, fk) ? " u:" + (Object)((Object)fk.getOnUpdate()) : "";
        CascadeRule cascadeRule2 = fk.getOnDelete();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)cascadeRule2), (String)"fk.onDelete");
        String onDelete = this.cascadeRuleIsMeaningful(cascadeRule2, fk) ? " d:" + (Object)((Object)fk.getOnDelete()) : "";
        String string4 = deferrable = fk.isDeferrable() ? " deferrable" : "";
        String deferred = fk.isInitiallyDeferred() && !fk.isDeferrable() ? " [deferred]" : (!fk.isInitiallyDeferred() && fk.isDeferrable() ? "[immediate]" : "");
        return "foreign key (" + inner + ") -> " + refTableScr + refKey + " (" + refInner + ')' + onUpdate + onDelete + deferrable + deferred;
    }

    private final boolean cascadeRuleIsMeaningful(CascadeRule rule, BasicElement e) {
        boolean bl;
        Dbms dbms;
        BasicModel basicModel = e.getModel();
        Dbms it = dbms = basicModel != null ? basicModel.getDbms() : null;
        boolean yesItIs = Intrinsics.areEqual((Object)it, (Object)Dbms.POSTGRES) || Intrinsics.areEqual((Object)it, (Object)Dbms.SQLITE);
        switch (DescriptionService$WhenMappings.$EnumSwitchMapping$0[rule.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = yesItIs;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    protected final String describeCheck(@NotNull BasicCheck check) {
        Intrinsics.checkParameterIsNotNull((Object)check, (String)"check");
        StringBuilder stringBuilder = new StringBuilder().append("check (");
        String string = check.getPredicate();
        if (string == null) {
            string = "???";
        }
        return stringBuilder.append((Object)string).append(")").toString();
    }

    @NotNull
    protected final String describeTrigger(@NotNull BasicTrigger trig) {
        String string;
        String string2;
        String string3;
        Intrinsics.checkParameterIsNotNull((Object)trig, (String)"trig");
        String string4 = trig.getKind().name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"trig.kind.name()");
        String string5 = string3 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
        String k = string6;
        String string7 = string2 = String.valueOf(trig.getTurn());
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
        String wn = StringsKt.replace$default((String)string8, (char)'_', (char)' ', (boolean)false, (int)4, null);
        String wt = ModelFun.eventsPhrase(trig);
        String cond = trig.getCondition() == null ? "" : "c:" + trig.getCondition();
        String string9 = string = k + ' ' + wn + ' ' + wt + ' ' + cond;
        if (string9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string9)).toString();
    }

    @NotNull
    protected final String describeRoutine(@NotNull BasicRoutine r) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        switch (DescriptionService$WhenMappings.$EnumSwitchMapping$1[r.getRoutineKind().ordinal()]) {
            case 1: {
                string = "procedure";
                break;
            }
            case 2: {
                string = "function";
                break;
            }
            default: {
                string = "routine";
            }
        }
        return string;
    }

    @NotNull
    protected final String describeTableOrViewColumn(@NotNull BasicTableOrViewColumn column2) {
        SequenceIdentity sequenceIdentity;
        BasicTableOrViewColumn basicTableOrViewColumn;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        DataType dataType = column2.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        String s = dataType.getSpecification();
        if (column2.isComputed()) {
            s = "computed " + s;
        }
        if (column2.isNotNull()) {
            s = s + " NN";
        }
        if (!((basicTableOrViewColumn = column2) instanceof BasicTableColumn)) {
            basicTableOrViewColumn = null;
        }
        BasicTableColumn basicTableColumn = (BasicTableColumn)basicTableOrViewColumn;
        SequenceIdentity sequenceIdentity2 = sequenceIdentity = basicTableColumn != null ? basicTableColumn.getSequenceIdentity() : null;
        if (sequenceIdentity != null) {
            s = s + " identity " + sequenceIdentity;
        }
        if (column2.getDefaultExpression() != null) {
            s = s + " default " + column2.getDefaultExpression();
        }
        String string = s;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s");
        return string;
    }

    @NotNull
    protected final String describeColumn(@NotNull BasicLikeColumn column2) {
        SequenceIdentity sequenceIdentity;
        BasicLikeColumn basicLikeColumn;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        DataType dataType = column2.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        String s = dataType.getSpecification();
        if (column2.isNotNull()) {
            s = s + " NN";
        }
        if (!((basicLikeColumn = column2) instanceof BasicTableColumn)) {
            basicLikeColumn = null;
        }
        BasicTableColumn basicTableColumn = (BasicTableColumn)basicLikeColumn;
        SequenceIdentity sequenceIdentity2 = sequenceIdentity = basicTableColumn != null ? basicTableColumn.getSequenceIdentity() : null;
        if (sequenceIdentity != null) {
            s = s + " identity " + sequenceIdentity;
        }
        if (column2.getDefaultExpression() != null) {
            s = s + " default " + column2.getDefaultExpression();
        }
        String string = s;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s");
        return string;
    }

    @NotNull
    protected final String describeArgument(@NotNull BasicArgument a) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        String string2 = string = a.getArgumentDirection().name();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String argWord = string3;
        String dataType = a.getDataType().toString();
        String def2 = a.getDefaultExpression();
        String s = argWord + ' ' + dataType;
        if (def2 != null) {
            s = s + " default " + def2;
        }
        return s;
    }

    @NotNull
    protected final String describeTypedElement(@NotNull BasicTypedElement e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String string = e.getDataType().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.dataType.toString()");
        return string;
    }

    @NotNull
    protected final String describeSynonym(@NotNull BasicSynonym synonym) {
        String string;
        String objectName;
        Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
        BasicMajorObject targetObject = synonym.getTargetObject();
        if (targetObject != null) {
            return "synonym -> " + targetObject.getKind().code() + ' ' + targetObject.getName();
        }
        String schemaName = synonym.getTargetSchemaName() != null && Intrinsics.areEqual((Object)synonym.getTargetSchemaName(), (Object)synonym.getSchemaName()) ^ true ? synonym.getTargetSchemaName() : null;
        String string2 = synonym.getTargetObjectName();
        if (string2 == null) {
            string2 = objectName = "<unnamed-object>";
        }
        if (schemaName != null) {
            string = schemaName + '.' + objectName;
        } else {
            String string3 = objectName;
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"objectName");
        }
        String x = string;
        return "synonym -> <unknown> " + x;
    }

    @NotNull
    protected final String describeRoot(@NotNull BasicRoot root2, boolean withSurrogates) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        if (withSurrogates) {
            StringBuilder stringBuilder = new StringBuilder().append("root (server version: ").append(root2.getServerVersion()).append(", dbms: ");
            Dbms dbms = root2.getDbms();
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"root.dbms");
            string = stringBuilder.append(dbms.getName()).append(')').toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("root (dbms: ");
            Dbms dbms = root2.getDbms();
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"root.dbms");
            string = stringBuilder.append(dbms.getName()).append(')').toString();
        }
        return string;
    }

    @NotNull
    protected final String describeBasicElement(@NotNull BasicElement e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String string = e.getKind().code();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.kind.code()");
        return string;
    }

    @NotNull
    public final String describeDistColumn(@NotNull BasicDistTableColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String d2 = this.describeColumn(column2);
        if (column2.isDistKey()) {
            d2 = d2 + " distkey";
        }
        return d2;
    }

    public void updatePresentation(@NotNull Project project, @NotNull DasObject o, @NotNull PresentationData presentation) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        DasObject dasObject = o;
        if (dasObject instanceof DasUserDefinedType) {
            this.describeCustomType(presentation, (DasUserDefinedType)o);
        } else if (dasObject instanceof DasColumn) {
            this.describeColumn(presentation, (DasColumn)o);
        } else if (dasObject instanceof DasTable) {
            this.describeTable(presentation, (DasTable)o, project);
        } else if (dasObject instanceof DasRoutine) {
            this.describeRoutine(presentation, (DasRoutine)o, project);
        } else if (dasObject instanceof DasTableKey) {
            this.describeTableKey(presentation, (DasTableKey)o);
        } else if (dasObject instanceof DasForeignKey) {
            this.describeForeignKey(presentation, (DasForeignKey)o);
        } else if (dasObject instanceof DasIndex) {
            this.describeIndex(presentation, (DasIndex)o);
        } else if (dasObject instanceof DasSynonym) {
            this.describeSynonym(presentation, (DasSynonym)o);
        } else if (dasObject instanceof DasTypedObject) {
            this.describeTyped(presentation, (DasTypedObject)o);
        } else if (dasObject instanceof DasOperator) {
            this.describeOperator(presentation, (DasOperator)o);
        } else if (dasObject instanceof BasicSequence) {
            this.describeSequence(presentation, (BasicSequence)o);
        } else if (dasObject instanceof BasicTrigger) {
            this.describeTrigger(presentation, (BasicTrigger)o);
        } else if (dasObject instanceof BasicCheck) {
            this.describeCheck(presentation, (BasicCheck)o);
        }
    }

    protected final void describeCheck(@NotNull PresentationData presentation, @NotNull BasicCheck o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        this.describePredicate(presentation, o.getPredicate());
    }

    private final void describePredicate(PresentationData presentation, String predicate) {
        String predicate2;
        String string = predicate;
        if (string == null) {
            return;
        }
        String string2 = predicate2 = string;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String adjusted = StringsKt.startsWith$default((String)string2, (String)"(", (boolean)false, (int)2, null) ? predicate2 : '(' + predicate2 + ')';
        predicate2 = StringUtil.shortenTextWithEllipsis((String)adjusted, (int)20, (int)1, (boolean)true);
        presentation.addText(' ' + predicate2, DbNodeDescriptor.getGrayAttrs());
    }

    protected final void describeTrigger(@NotNull PresentationData presentation, @NotNull BasicTrigger o) {
        Set<TrigEvent> events;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        TrigTurn turn = o.getTurn();
        if (turn != null) {
            List list;
            Collection $receiver$iv;
            String string = StringUtil.toLowerCase((String)turn.toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.toLowerCase(turn.toString())");
            Object object = string;
            String string2 = "_";
            string2 = new Regex(string2);
            int n = 0;
            object = string2.split((CharSequence)object, n);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    CharSequence charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $receiver$iv = list;
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String turnText2 = StringUtil.join((Iterable)((Iterable)JBIterable.of((Object[])Arrays.copyOf(stringArray, stringArray.length)).filter((Condition)describeTrigger.turnText.2.INSTANCE)), (String)" ");
            presentation.addText(' ' + turnText2, DbNodeDescriptor.getGrayAttrs());
        }
        if (!(events = o.getEvents()).isEmpty()) {
            String eventsText2 = StringUtil.join((Iterable)((Iterable)JBIterable.from((Iterable)events).transform(new Function<E, T>(o){
                final /* synthetic */ BasicTrigger $o;

                public final String fun(TrigEvent e) {
                    List<String> cols = this.$o.getColNames();
                    if (e == TrigEvent.UPDATE && !cols.isEmpty()) {
                        return "update of " + StringUtil.join((Collection)cols, (String)", ");
                    }
                    return StringUtil.toLowerCase((String)e.toString());
                }
                {
                    this.$o = basicTrigger;
                }
            })), (String)", ");
            presentation.addText(' ' + eventsText2, DbNodeDescriptor.getGrayAttrs());
        }
        String condition = o.getCondition();
        this.describePredicate(presentation, condition);
        String suffix = DbImplUtil.getModelHelper(o).nodeTriggerSuffix(o);
        if (suffix != null) {
            presentation.addText(suffix, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected final void describeOperator(@NotNull PresentationData presentation, @NotNull DasOperator o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        DasOperator.OperatorNotation notation = o.getOperatorNotation();
        StringBuilder res2 = new StringBuilder();
        List args2 = o.getArgumentTypes();
        DataType dataType = o.getResultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"o.resultType");
        String resType = dataType.getSpecification();
        if (notation == DasOperator.OperatorNotation.INFIX) {
            res2.append(StringUtil.join((Collection)args2, (Function)describeOperator.1.INSTANCE, (String)(" " + o.getName() + " ")));
        } else {
            if (notation == DasOperator.OperatorNotation.PREFIX) {
                res2.append(o.getName());
            }
            if (args2.size() != 1) {
                res2.append("(");
            }
            res2.append(StringUtil.join((Collection)args2, (Function)describeOperator.2.INSTANCE, (String)", "));
            if (args2.size() != 1) {
                res2.append(")");
            }
            if (notation == DasOperator.OperatorNotation.POSTFIX) {
                res2.append(o.getName());
            }
        }
        presentation.addText("    " + res2 + " " + DbPresentation.arrow() + " " + resType, DbNodeDescriptor.getGrayAttrs());
    }

    protected final void describeSequence(@NotNull PresentationData presentation, @NotNull BasicSequence o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        SequenceIdentity si = o.getSequenceIdentity();
        if (si != null) {
            String specification = si.getSpecification();
            presentation.addText(' ' + specification, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected final void describeTyped(@NotNull PresentationData presentation, @NotNull DasTypedObject o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        DataType dataType = o.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"o.dataType");
        String type = dataType.getSpecification();
        presentation.addText(' ' + type, DbNodeDescriptor.getGrayAttrs());
    }

    protected final void describeSynonym(@NotNull PresentationData presentation, @NotNull DasSynonym o) {
        String pathString;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Iterable path = o.getTargetPath();
        String string = pathString = StringUtil.join((Iterable)path, (String)".");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathString");
        CharSequence charSequence = string;
        if (charSequence.length() > 0) {
            String text2 = " " + DbPresentation.arrow() + " " + pathString;
            presentation.addText(text2, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected void describeIndex(@NotNull PresentationData presentation, @NotNull DasIndex o) {
        String unique;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String string = unique = o.isUnique() ? " UNIQUE" : "";
        if (o instanceof BasicIndex) {
            String indexingItems = this.describeIndexingItems((BasicIndex)o);
            String columnsText = " (" + indexingItems + ')' + unique;
            presentation.addText(columnsText, DbNodeDescriptor.getGrayAttrs());
            String condition = ((BasicIndex)o).getCondition();
            if (condition != null) {
                presentation.addText(" where " + condition, DbNodeDescriptor.getGrayAttrs());
            }
        } else {
            String columns = DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)o.getColumnsRef());
            presentation.addText(' ' + columns + unique, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected final void describeForeignKey(@NotNull PresentationData presentation, @NotNull DasForeignKey o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String referencingColumns = DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)o.getColumnsRef());
        String refSchemaName = null;
        if (o instanceof BasicForeignKey && ((BasicForeignKey)o).isReferencingAnotherSchema()) {
            refSchemaName = ((BasicForeignKey)o).getRefSchemaName();
        }
        String arrowToReferenced = DbPresentation.arrowToColumns(refSchemaName, o.getRefTableName(), (MultiRef<? extends DasTypedObject>)o.getRefColumns());
        presentation.addText(' ' + referencingColumns + ' ' + arrowToReferenced, DbNodeDescriptor.getGrayAttrs());
    }

    protected final void describeTableKey(@NotNull PresentationData presentation, @NotNull DasTableKey o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        presentation.addText(" " + DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)o.getColumnsRef()), DbNodeDescriptor.getGrayAttrs());
    }

    protected final void describeRoutine(@NotNull PresentationData presentation, @NotNull DasRoutine o, @NotNull Project project) {
        DdlBuilder builder;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        StringBuilder sb = new StringBuilder();
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)o);
        DatabaseDialectEx dialect = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)dataSource) : DatabaseDialects.getGenericDialect();
        DdlBuilder ddlBuilder = builder = new DdlBuilder(sb).applyCodeStyle(project).withDialect(dialect);
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder");
        ddlBuilder.getDialect().sqlDefinePrototype(builder, o, false, true);
        presentation.addText(sb.toString(), DbNodeDescriptor.getGrayAttrs());
        JBIterable columns = o.getDasChildren(ObjectKind.COLUMN);
        StringBuilder b2 = new StringBuilder();
        StringUtil.join((Iterable)((Iterable)columns), (Function)describeRoutine.1.INSTANCE, (String)", ", (StringBuilder)b2);
        CharSequence charSequence = b2;
        if (charSequence.length() > 0) {
            b2.insert(0, ": table (");
            b2.append(')');
            presentation.addText(b2.toString(), DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected final void describeTable(@NotNull PresentationData presentation, @NotNull DasTable o, @NotNull Project project) {
        String suffix;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ObjectKind type = o.getKind();
        if (!DbImplUtil.isDataTable(type)) {
            DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)o);
            DatabaseDialectEx dialect = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)dataSource) : DatabaseDialects.getGenericDialect();
            String typeName = DbPresentation.getPresentableName(o.getKind(), dialect);
            presentation.addText(' ' + typeName, DbNodeDescriptor.getGrayAttrs());
        }
        if (o instanceof BasicTable && (suffix = DbImplUtil.getModelHelper((BasicElement)o).nodeTableSuffix((BasicTable)o)) != null) {
            presentation.addText(suffix, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected final void describeColumn(@NotNull PresentationData presentation, @NotNull DasColumn o) {
        String d2;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        DataType dataType = o.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"o.dataType");
        String string = d2 = dataType.getSpecification();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"d");
        CharSequence charSequence = string;
        if (charSequence.length() > 0) {
            presentation.addText(' ' + d2, DbNodeDescriptor.getGrayAttrs());
        }
        if (DasUtil.isAutoGenerated((DasColumn)o)) {
            presentation.addText(" (auto increment)", DbNodeDescriptor.getGrayAttrs());
        }
        if (o instanceof BasicDistTableColumn && ((BasicDistTableColumn)o).isDistKey()) {
            presentation.addText(" (in dist key)", DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected final void describeCustomType(@NotNull PresentationData presentation, @NotNull DasUserDefinedType o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String description = DbImplUtil.getCustomTypeShortDescription(o);
        if (description != null) {
            presentation.addText(' ' + description, DbNodeDescriptor.getGrayAttrs());
        }
    }

    static {
        Companion = new Companion(null);
        DUMMY = new DescriptionService(){};
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/model/DescriptionService$Context;", "", "()V", "indent", "", "getIndent", "()Ljava/lang/String;", "setIndent", "(Ljava/lang/String;)V", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOut", "()Ljava/lang/StringBuilder;", "setOut", "(Ljava/lang/StringBuilder;)V", "withSurrogates", "", "getWithSurrogates", "()Z", "setWithSurrogates", "(Z)V", "intellij.database.impl"})
    public static final class Context {
        private boolean withSurrogates;
        @NotNull
        public StringBuilder out;
        @NotNull
        private String indent = "";

        public final boolean getWithSurrogates() {
            return this.withSurrogates;
        }

        public final void setWithSurrogates(boolean bl) {
            this.withSurrogates = bl;
        }

        @NotNull
        public final StringBuilder getOut() {
            StringBuilder stringBuilder = this.out;
            if (stringBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"out");
            }
            return stringBuilder;
        }

        public final void setOut(@NotNull StringBuilder stringBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)stringBuilder, (String)"<set-?>");
            this.out = stringBuilder;
        }

        @NotNull
        public final String getIndent() {
            return this.indent;
        }

        public final void setIndent(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.indent = string;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/model/DescriptionService$Companion;", "", "()V", "DUMMY", "Lcom/intellij/database/model/DescriptionService;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

