/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.util.containers.WeakInterner;
import gnu.trove.TObjectHashingStrategy;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Objects;

public class BasicMetaProperty {
    private static final WeakInterner<BasicMetaProperty> ourInterner = new WeakInterner((TObjectHashingStrategy)new TObjectHashingStrategy<BasicMetaProperty>(){

        public int computeHashCode(BasicMetaProperty o) {
            return Objects.hash(o.name, o.def, o.slowGetter, o.slowSetter);
        }

        public boolean equals(BasicMetaProperty o1, BasicMetaProperty o2) {
            if (o1 == o2) {
                return true;
            }
            if (o2 == null || o1.getClass() != o2.getClass()) {
                return false;
            }
            return Objects.equals(o1.name, o2.name) && Objects.equals(o1.def, o2.def) && Objects.equals(o1.slowGetter, o2.slowGetter) && Objects.equals(o1.slowSetter, o2.slowSetter);
        }
    });
    public final String name;
    public final Object def;
    public final MethodHandle getter;
    public final MethodHandle setter;
    private final Method slowSetter;
    private final Method slowGetter;

    private BasicMetaProperty(String name, Object def2, Method getter, Method setter) {
        this.name = name;
        this.def = def2;
        this.slowGetter = getter;
        this.slowSetter = setter;
        try {
            this.getter = MethodHandles.publicLookup().unreflect(getter);
            this.setter = MethodHandles.publicLookup().unreflect(setter);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static BasicMetaProperty create(String name, Object def2, Method getter, Method setter) {
        return (BasicMetaProperty)ourInterner.intern((Object)new BasicMetaProperty(name, def2, getter, setter));
    }

    public static <T> BasicMetaProperty create(String name, Class<T> clazz, T def2, Class<?> modApi) {
        try {
            Method getter = modApi.getMethod((clazz == Boolean.TYPE ? "is" : "get") + name, new Class[0]);
            Method setter = modApi.getMethod("set" + name, clazz);
            return BasicMetaProperty.create(name, def2, getter, setter);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("model error", e);
        }
    }
}

