/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.database.model.serialization.converters.RelativeReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0005*\u00020\rH\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u0004\u0018\u00010\u0005H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_0;", "Lcom/intellij/database/model/serialization/Converter;", "()V", "SimpleRenamedProperties", "", "", "getSimpleRenamedProperties", "()Ljava/util/Map;", "adjustColumns", "", "mm", "Lcom/intellij/database/model/serialization/ModelMem;", "node", "Lcom/intellij/database/model/serialization/ModelElementMem;", "property", "Lcom/intellij/database/model/serialization/MutableNameAndValue;", "adjustRefKey", "adjustRenamedProperty", "adjustSequence", "adjustUnderlyingIndex", "convertMem", "modelMem", "colNames", "removeProperty", "", "name", "representedShortNumber", "Ljava/lang/Short;", "intellij.database.impl"})
public final class Converter_4_0
implements Converter {
    @NotNull
    private final Map<String, String> SimpleRenamedProperties = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"mandatory", (Object)"not-null"), TuplesKt.to((Object)"direction", (Object)"argument-direction"), TuplesKt.to((Object)"cascade-update-rule", (Object)"on-update"), TuplesKt.to((Object)"cascade-delete-rule", (Object)"on-delete"), TuplesKt.to((Object)"trig-turn", (Object)"turn"), TuplesKt.to((Object)"trig-events", (Object)"events"), TuplesKt.to((Object)"trig-columns", (Object)"col-names"), TuplesKt.to((Object)"desc-columns", (Object)"reverse-col-names")});

    @NotNull
    public final Map<String, String> getSimpleRenamedProperties() {
        return this.SimpleRenamedProperties;
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)modelMem, (String)"modelMem");
        Dbms dbms = modelMem.getDbms();
        Collection collection = $receiver$iv = (Collection)modelMem.getNodes();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        ModelElementMem[] modelElementMemArray = thisCollection$iv.toArray(new ModelElementMem[0]);
        if (modelElementMemArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (ModelElementMem node : modelElementMemArray) {
            MutableNameAndValue[] properties;
            Collection thisCollection$iv2;
            Object object = dbms;
            if (Intrinsics.areEqual((Object)object, (Object)Dbms.ORACLE)) {
                if (Intrinsics.areEqual((Object)node.getKind(), (Object)"foreign-key")) {
                    ModelSerializationFun.remove(node.getProperties(), "ref-col-names");
                }
            } else if (Intrinsics.areEqual((Object)object, (Object)Dbms.MSSQL)) {
                if (Intrinsics.areEqual((Object)node.getKind(), (Object)"routine")) {
                    MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(node.getProperties(), "type");
                    if (mutableNameAndValue != null) {
                        mutableNameAndValue.setName("routine-type");
                    }
                }
            } else if (Intrinsics.areEqual((Object)object, (Object)Dbms.SYBASE) && Intrinsics.areEqual((Object)node.getKind(), (Object)"routine")) {
                this.removeProperty(node, "routine-kind");
                Short num = this.representedShortNumber(node.getName());
                if (num != null) {
                    List<MutableNameAndValue> list = node.getProperties();
                    String string = num.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"num.toString()");
                    list.add(new MutableNameAndValue("position", string));
                }
            }
            object = node.getKind();
            switch (((String)object).hashCode()) {
                case 1349547969: {
                    if (!((String)object).equals("sequence")) break;
                    this.adjustSequence(node);
                }
            }
            Collection $receiver$iv2 = node.getProperties();
            if ($receiver$iv2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            if (thisCollection$iv2.toArray(new MutableNameAndValue[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            for (MutableNameAndValue property : properties) {
                String propName;
                switch (propName = property.getName()) {
                    case "columns": {
                        this.adjustColumns(modelMem, node, property);
                        break;
                    }
                    case "ref-key": {
                        this.adjustRefKey(modelMem, node, property);
                        break;
                    }
                    case "underlying-index": {
                        this.adjustUnderlyingIndex(modelMem, node, property);
                        break;
                    }
                    default: {
                        this.adjustRenamedProperty(property);
                    }
                }
                String string = modelMem.getDbms();
                if (!Intrinsics.areEqual((Object)string, (Object)Dbms.ORACLE) || !Intrinsics.areEqual((Object)propName, (Object)"on-update") && !Intrinsics.areEqual((Object)propName, (Object)"cascade-update-rule")) continue;
                node.getProperties().remove(property);
            }
        }
    }

    private final void adjustSequence(ModelElementMem node) {
        String s;
        MutableNameAndValue minP = ModelSerializationFun.find(node.getProperties(), "min-value");
        MutableNameAndValue maxP = ModelSerializationFun.find(node.getProperties(), "max-value");
        MutableNameAndValue incP = ModelSerializationFun.find(node.getProperties(), "increment-by");
        MutableNameAndValue nextP = ModelSerializationFun.find(node.getProperties(), "next-value");
        if (minP == null && maxP == null && incP == null && nextP == null) {
            return;
        }
        MutableNameAndValue mutableNameAndValue = minP;
        String min = mutableNameAndValue != null ? mutableNameAndValue.getValue() : null;
        MutableNameAndValue mutableNameAndValue2 = maxP;
        String max = mutableNameAndValue2 != null ? mutableNameAndValue2.getValue() : null;
        MutableNameAndValue mutableNameAndValue3 = incP;
        String inc = mutableNameAndValue3 != null ? mutableNameAndValue3.getValue() : null;
        MutableNameAndValue mutableNameAndValue4 = nextP;
        String next = mutableNameAndValue4 != null ? mutableNameAndValue4.getValue() : null;
        String string = min;
        if (string == null) {
            string = s = "1";
        }
        if (next != null) {
            s = s + '(' + next + ')';
        }
        if (inc != null) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder().append(s);
            if (ModelSerializationFun.startsWith(inc, '-') || ModelSerializationFun.startsWith(inc, '+')) {
                string2 = inc;
            } else {
                char c2 = '+';
                StringBuilder stringBuilder2 = stringBuilder;
                String string3 = String.valueOf(c2) + inc;
                stringBuilder = stringBuilder2;
                string2 = string3;
            }
            s = stringBuilder.append(string2).toString();
        }
        if (max != null) {
            s = s + ".." + max;
        }
        if (minP != null) {
            node.getProperties().remove(minP);
        }
        if (maxP != null) {
            node.getProperties().remove(maxP);
        }
        if (incP != null) {
            node.getProperties().remove(incP);
        }
        if (nextP != null) {
            node.getProperties().remove(nextP);
        }
        ModelSerializationFun.add(node.getProperties(), "sequence-identity", s);
    }

    /*
     * Unable to fully structure code
     */
    private final void adjustColumns(ModelMem mm, ModelElementMem node, MutableNameAndValue property) {
        var4_4 = node.getKind();
        switch (var4_4.hashCode()) {
            case 100346066: {
                if (!var4_4.equals("index")) break;
                ** GOTO lbl14
            }
            case -1449326106: {
                if (!var4_4.equals("foreign-key")) break;
                ** GOTO lbl14
            }
            case 94627080: {
                if (!var4_4.equals("check")) break;
                ** GOTO lbl14
            }
            case 106079: {
                if (!var4_4.equals("key")) break;
lbl14:
                // 4 sources

                property.setName("col-names");
            }
        }
    }

    private final void adjustRefKey(ModelMem mm, ModelElementMem node, MutableNameAndValue property) {
        ModelElementMem tableMem = ModelSerializationFun.findParentOf(mm, node);
        RelativeReference ref = RelativeReference.of(property.getValue());
        String[] path = ref.path;
        int n = path.length;
        boolean ora = Intrinsics.areEqual((Object)mm.getDbms(), (Object)Dbms.ORACLE);
        switch (n) {
            case 1: {
                ModelElementMem refKeyMem = ModelSerializationFun.findChildOf(mm, tableMem, "key", path[0]);
                ModelElementMem modelElementMem = tableMem;
                ModelSerializationFun.add(node.getProperties(), "ref-table-name", modelElementMem != null ? modelElementMem.getName() : null);
                ModelSerializationFun.add(node.getProperties(), "ref-key-name", path[0]);
                if (ora) break;
                ModelElementMem modelElementMem2 = refKeyMem;
                ModelSerializationFun.add(node.getProperties(), "ref-col-names", modelElementMem2 != null ? this.colNames(modelElementMem2) : null);
                break;
            }
            case 2: {
                ModelElementMem refTableMem = ModelSerializationFun.findSibling(mm, tableMem, path[0]);
                ModelElementMem refKeyMem = ModelSerializationFun.findChildOf(mm, refTableMem, "key", path[1]);
                ModelElementMem modelElementMem = refTableMem;
                ModelSerializationFun.add(node.getProperties(), "ref-table-name", modelElementMem != null ? modelElementMem.getName() : null);
                ModelSerializationFun.add(node.getProperties(), "ref-key-name", path[1]);
                if (ora) break;
                ModelElementMem modelElementMem3 = refKeyMem;
                ModelSerializationFun.add(node.getProperties(), "ref-col-names", modelElementMem3 != null ? this.colNames(modelElementMem3) : null);
                break;
            }
            case 3: {
                ModelElementMem schemaMem = ModelSerializationFun.findParentOf(mm, tableMem);
                ModelElementMem refSchemaMem = ModelSerializationFun.findSibling(mm, schemaMem, path[0]);
                ModelElementMem refTableMem = ModelSerializationFun.findChildOf(mm, refSchemaMem, "table", path[1]);
                ModelElementMem refKeyMem = ModelSerializationFun.findChildOf(mm, refTableMem, "key", path[2]);
                ModelElementMem modelElementMem = refSchemaMem;
                ModelSerializationFun.add(node.getProperties(), "ref-schema-name", modelElementMem != null ? modelElementMem.getName() : null);
                ModelElementMem modelElementMem4 = refTableMem;
                ModelSerializationFun.add(node.getProperties(), "ref-table-name", modelElementMem4 != null ? modelElementMem4.getName() : null);
                ModelSerializationFun.add(node.getProperties(), "ref-key-name", path[2]);
                if (ora) break;
                ModelElementMem modelElementMem5 = refKeyMem;
                ModelSerializationFun.add(node.getProperties(), "ref-col-names", modelElementMem5 != null ? this.colNames(modelElementMem5) : null);
            }
        }
        node.getProperties().remove(property);
    }

    private final void adjustUnderlyingIndex(ModelMem mm, ModelElementMem node, MutableNameAndValue property) {
        String refStr = property.getValue();
        if (!ModelSerializationFun.startsWith(refStr, '#') && !ModelSerializationFun.startsWith(refStr, '~')) {
            property.setName("underlying-index-name");
        }
    }

    private final void adjustRenamedProperty(MutableNameAndValue property) {
        String name1 = property.getName();
        String name2 = this.SimpleRenamedProperties.get(name1);
        if (name2 != null && Intrinsics.areEqual((Object)name2, (Object)name1) ^ true) {
            property.setName(name2);
        }
    }

    private final String colNames(@NotNull ModelElementMem $receiver) {
        MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find($receiver.getProperties(), "col-names");
        if (mutableNameAndValue == null) {
            mutableNameAndValue = ModelSerializationFun.find($receiver.getProperties(), "columns");
        }
        return mutableNameAndValue != null ? mutableNameAndValue.getValue() : null;
    }

    private final boolean removeProperty(@NotNull ModelElementMem $receiver, String name) {
        return CollectionsKt.removeAll($receiver.getProperties(), (Function1)((Function1)new Function1<MutableNameAndValue, Boolean>(name){
            final /* synthetic */ String $name;

            public final boolean invoke(@NotNull MutableNameAndValue it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$name);
            }
            {
                this.$name = string;
                super(1);
            }
        }));
    }

    private final Short representedShortNumber(@Nullable String $receiver) {
        CharSequence charSequence;
        if ($receiver == null || (charSequence = (CharSequence)$receiver).length() == 0) {
            return null;
        }
        char c2 = $receiver.charAt(0);
        if ('0' <= c2 && '9' >= c2) {
            try {
                return new Short($receiver);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void convertModel(@NotNull BasicModModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Converter.DefaultImpls.convertModel(this, model);
    }
}

