/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.RenameQueryGenerator;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.SqlPreviewPanel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.sql.psi.SqlElement;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.UsageView;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbRenamePsiElementProcessor
extends RenamePsiElementProcessor {
    private static final String SEARCH_FOR_STORAGE_OCCURRENCES = "sql.rename.search.for.storage.occurrences";
    private static final Logger LOG = Logger.getInstance(DbRenamePsiElementProcessor.class);
    private static Function<String, CompletionStage<Void>> ourRunStatementsHook = null;

    public static void setRunStatementsHook(Function<String, CompletionStage<Void>> runStatementsHook) {
        ourRunStatementsHook = runStatementsHook;
    }

    public boolean canProcessElement(@NotNull PsiElement element2) {
        DbElement dbElement;
        if (element2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(0);
        }
        if ((dbElement = (DbElement)ObjectUtils.tryCast((Object)element2, DbElement.class)) == null) {
            return false;
        }
        LocalDataSource dataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dbElement.getDataSource());
        BaseModel model = dataSource == null ? null : (BaseModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BaseModel.class);
        BasicNamedElement e = (BasicNamedElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicNamedElement.class);
        return e != null && model != null && RenameQueryGenerator.canRename(model, e);
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element2, PsiElement nameSuggestionContext, Editor editor) {
        DbElement dbElement;
        if (project == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(2);
        }
        if ((dbElement = (DbElement)ObjectUtils.tryCast((Object)element2, DbElement.class)) == null) {
            RenameDialog renameDialog = super.createRenameDialog(project, element2, nameSuggestionContext, editor);
            if (renameDialog == null) {
                DbRenamePsiElementProcessor.$$$reportNull$$$0(3);
            }
            return renameDialog;
        }
        LocalDataSource dataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dbElement.getDataSource());
        BasicNamedElement target = (BasicNamedElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicNamedElement.class);
        if (dataSource == null || target == null) {
            RenameDialog renameDialog = super.createRenameDialog(project, element2, nameSuggestionContext, editor);
            if (renameDialog == null) {
                DbRenamePsiElementProcessor.$$$reportNull$$$0(4);
            }
            return renameDialog;
        }
        DbRenameDialog dbRenameDialog = new DbRenameDialog(project, dbElement, nameSuggestionContext, editor);
        if (dbRenameDialog == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(5);
        }
        return dbRenameDialog;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element2, @Nullable Editor editor) {
        if (element2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(6);
        }
        return (PsiElement)ObjectUtils.chooseNotNull((Object)DbSqlUtil.getSqlElement((DbElement)ObjectUtils.tryCast((Object)element2, DbElement.class)), (Object)element2);
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2) {
        if (element2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(7);
        }
        final boolean checkStorage = DbRenamePsiElementProcessor.getSearchReferencesInStorage(element2.getProject());
        final String prefix = DbRenamePsiElementProcessor.getDbFsPrefix(element2);
        DelegatingGlobalSearchScope scope = new DelegatingGlobalSearchScope(GlobalSearchScope.projectScope((Project)element2.getProject())){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DbSrcUtils.isDbSrcFile(file)) {
                    if (!checkStorage) {
                        return false;
                    }
                    if (DbSrcUtils.isOriginal(file)) {
                        return false;
                    }
                    if (!file.getPath().startsWith(prefix)) {
                        return false;
                    }
                }
                return super.contains(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/psi/DbRenamePsiElementProcessor$1", "contains"));
            }
        };
        Collection collection = ReferencesSearch.search((PsiElement)element2, (SearchScope)scope).findAll();
        if (collection == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static String getDbFsPrefix(PsiElement element2) {
        DbElement e = (DbElement)ObjectUtils.tryCast((Object)element2, DbElement.class);
        String id = e == null ? null : e.getDataSource().getUniqueId();
        return DbSrcFileSystem.getDataSourcePath(element2.getProject(), id) + "/";
    }

    @NotNull
    public static JBIterable<Pair<PsiElement, String>> collectRenameElements(@NotNull DeModel model, @Nullable DbDataSource dataSource) {
        if (model == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(9);
        }
        JBIterable jBIterable = DbRenamePsiElementProcessor.collectRenames(model).filterMap(de -> {
            BasicElement object;
            SqlElement sqlElement;
            if (model == null) {
                DbRenamePsiElementProcessor.$$$reportNull$$$0(15);
            }
            if ((sqlElement = GenericEditingResultProcessor.getSqlElement(object = DbRenamePsiElementProcessor.unwrapDeElement(de), model.getExportHelper().getContext())) != null) {
                return Pair.create((Object)sqlElement, (Object)de.name);
            }
            DbElement dbElement = DbImplUtil.findElement(dataSource, object);
            return dbElement == null ? null : Pair.create((Object)dbElement, (Object)de.name);
        });
        if (jBIterable == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    public static boolean getSearchReferencesInStorage(Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(SEARCH_FOR_STORAGE_OCCURRENCES, false);
    }

    public static void setSearchReferencesInStorage(Project project, boolean val) {
        PropertiesComponent.getInstance((Project)project).setValue(SEARCH_FOR_STORAGE_OCCURRENCES, val, false);
    }

    @NotNull
    public static NonFocusableCheckBox createDbSrcSearchBox(Project project) {
        NonFocusableCheckBox box = new NonFocusableCheckBox(UIUtil.replaceMnemonicAmpersand((String)"Search in &loaded sources"));
        box.setSelected(DbRenamePsiElementProcessor.getSearchReferencesInStorage(project));
        NonFocusableCheckBox nonFocusableCheckBox = box;
        if (nonFocusableCheckBox == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(11);
        }
        return nonFocusableCheckBox;
    }

    @NotNull
    public static JBIterable<DeObject> collectRenames(@NotNull DeModel model) {
        if (model == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(12);
        }
        JBIterable jBIterable = model.traverser().filter(DeObject.class).filter(object -> {
            if (model == null) {
                DbRenamePsiElementProcessor.$$$reportNull$$$0(14);
            }
            return object.getEditedObject() != null && !DasUtil.nameEqual((DasObject)object, (String)object.getEditedObject().getName(), (CasingProvider)model);
        });
        if (jBIterable == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @Nullable
    public static SqlElement getSqlElement(@Nullable DasObject object, @Nullable DbDataSource dataSource) {
        return (SqlElement)ObjectUtils.tryCast((Object)DbRenamePsiElementProcessor.getPsiElement(object, dataSource), SqlElement.class);
    }

    @Nullable
    public static BasicElement unwrapDeElement(@Nullable DasObject object) {
        DasObject tmp = object;
        while (tmp instanceof DeObject) {
            tmp = ((DeObject)tmp).getEditedObject();
        }
        return (BasicElement)ObjectUtils.tryCast((Object)tmp, BasicElement.class);
    }

    @Nullable
    public static PsiElement getPsiElement(@Nullable DasObject object, @Nullable DbDataSource dataSource) {
        BasicElement tmp = DbRenamePsiElementProcessor.unwrapDeElement(object);
        if (dataSource == null) {
            return null;
        }
        DbElement db = ((DbDataSourceImpl)dataSource).findElement(tmp);
        SqlElement element2 = DbSqlUtil.getSqlElement(db);
        return element2 == null ? db : element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbRenamePsiElementProcessor";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRenameElements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDbSrcSearchBox";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRenames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectRenameElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectRenames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectRenames$1";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectRenameElements$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyRenameProcessor
    extends RenameProcessor {
        private final DatabaseRefactoringHandler myHandler;
        private boolean myExecuteSql;
        private VirtualFile myExcludedFile;

        public MyRenameProcessor(@NotNull Project project, @NotNull PsiElement element2, DatabaseRefactoringHandler handler, @NotNull String newName, @Nullable Iterable<Pair<PsiElement, String>> secondaryRenames, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            if (project == null) {
                MyRenameProcessor.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(1);
            }
            if (newName == null) {
                MyRenameProcessor.$$$reportNull$$$0(2);
            }
            super(project, element2, newName, isSearchInComments, isSearchTextOccurrences);
            this.myExecuteSql = true;
            this.myHandler = handler;
            if (secondaryRenames != null) {
                for (Pair<PsiElement, String> rename2 : secondaryRenames) {
                    this.addElement((PsiElement)rename2.first, (String)rename2.second);
                    this.trackNamespaceRename((PsiElement)rename2.first, (String)rename2.second);
                }
            }
            this.trackNamespaceRename(element2, newName);
            DasObject object = (DasObject)ObjectUtils.tryCast((Object)element2, DasObject.class);
            if (object != null) {
                this.myHandler.getContext().include(object.getDasParent());
            }
        }

        private void trackNamespaceRename(@NotNull PsiElement element2, @NotNull String name) {
            if (element2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(3);
            }
            if (name == null) {
                MyRenameProcessor.$$$reportNull$$$0(4);
            }
            if (!(element2 instanceof DasObject)) {
                return;
            }
            this.scheduleIntrospectionScopeUpdate((DasObject)element2, name);
        }

        private void scheduleIntrospectionScopeUpdate(@NotNull DasObject object, @NotNull String newName) {
            if (object == null) {
                MyRenameProcessor.$$$reportNull$$$0(5);
            }
            if (newName == null) {
                MyRenameProcessor.$$$reportNull$$$0(6);
            }
            if (object.getKind() == ObjectKind.SCHEMA) {
                DasObject p2 = object.getDasParent();
                if (p2 != null && p2.getKind() != ObjectKind.DATABASE) {
                    p2 = null;
                }
                ObjectName db = ObjectName.quoted((String)(p2 == null ? null : p2.getName()));
                this.myHandler.getContext().getScopeUpdater().toRemove(db, ObjectName.quoted((String)object.getName()));
                this.myHandler.getContext().getScopeUpdater().toAdd(db, ObjectName.plain((String)newName));
            } else if (object.getKind() == ObjectKind.DATABASE) {
                this.myHandler.getContext().getScopeUpdater().toRemove(ObjectName.quoted((String)object.getName()), null);
                this.myHandler.getContext().getScopeUpdater().toAdd(ObjectName.plain((String)newName), null);
            }
        }

        protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
            if (viewDescriptor == null) {
                MyRenameProcessor.$$$reportNull$$$0(7);
            }
            if (usageView == null) {
                MyRenameProcessor.$$$reportNull$$$0(8);
            }
            super.customizeUsagesView(viewDescriptor, usageView);
            JPanel scriptPanel = new JPanel(new BorderLayout());
            scriptPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
            final JBCheckBox box = new JBCheckBox(UIUtil.replaceMnemonicAmpersand((String)"&Execute SQL Script"), this.myExecuteSql);
            box.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    myExecuteSql = box.isSelected();
                }
            });
            JButton manually = new JButton(new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)"&Open in Console")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (myExcludedFile == null) {
                        myExcludedFile = DbUIUtil.openInConsole(myHandler.getDataSource(), null, myHandler.getStatement(), false);
                    } else {
                        DbUIUtil.openInConsole(myHandler.getDataSource().getProject(), myExcludedFile, myHandler.getStatement(), null);
                    }
                    box.setSelected(false);
                }
            });
            scriptPanel.add((Component)box, "West");
            scriptPanel.add((Component)manually, "East");
            usageView.setAdditionalComponent((JComponent)scriptPanel);
        }

        protected void execute(@NotNull UsageInfo[] usages2) {
            if (usages2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(9);
            }
            if (this.myExecuteSql) {
                this.runStatements(usages2);
            } else {
                super.execute(usages2);
            }
        }

        @NotNull
        protected CompletionStage<?> runStatements(@NotNull UsageInfo[] usages2) {
            if (usages2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(10);
            }
            CompletionStage<?> execResult = null;
            if (ourRunStatementsHook != null) {
                execResult = (CompletionStage<?>)ourRunStatementsHook.fun((Object)this.myHandler.getStatement());
            }
            if (execResult == null) {
                execResult = this.myHandler.runStatements(true);
            }
            CompletionStage<Object> completionStage = execResult.thenApplyAsync(res2 -> {
                if (usages2 == null) {
                    MyRenameProcessor.$$$reportNull$$$0(13);
                }
                super.execute(usages2);
                return res2;
            }, AsyncUtil.transactionExecutor((Disposable)this.myProject));
            if (completionStage == null) {
                MyRenameProcessor.$$$reportNull$$$0(11);
            }
            return completionStage;
        }

        @NotNull
        public UsageInfo[] findUsages() {
            JBIterable usages2 = JBIterable.of((Object[])super.findUsages());
            if (this.myExcludedFile != null) {
                usages2 = usages2.filter(info -> !Comparing.equal((Object)info.getVirtualFile(), (Object)this.myExcludedFile));
            }
            List res2 = usages2.toList();
            UsageInfo[] usageInfoArray = res2.toArray(UsageInfo.EMPTY_ARRAY);
            if (usageInfoArray == null) {
                MyRenameProcessor.$$$reportNull$$$0(12);
            }
            return usageInfoArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewDescriptor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageView";
                    break;
                }
                case 9: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runStatements";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "trackNamespaceRename";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "scheduleIntrospectionScopeUpdate";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeUsagesView";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "runStatements";
                    break;
                }
                case 11: 
                case 12: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$runStatements$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbRenameDialog
    extends RenameDialog {
        private RenameQueryGenerator myRenameGenerator;
        private SqlPreviewPanel myDdlPreview;
        private JCheckBox myRenameInStorage;

        public DbRenameDialog(@NotNull Project project, @NotNull DbElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor) {
            if (project == null) {
                DbRenameDialog.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                DbRenameDialog.$$$reportNull$$$0(1);
            }
            super(project, (PsiElement)psiElement, nameSuggestionContext, editor);
        }

        @Nullable
        private BasicNamespace getCurrentNamespace() {
            return (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.getSearchPathObjectForSwitch(this.getPsiElement().getDataSource(), this.getBasicElement()), BasicNamespace.class);
        }

        @NotNull
        private BasicNamedElement getBasicElement() {
            BasicNamedElement basicNamedElement = (BasicNamedElement)this.getPsiElement().getDelegate();
            if (basicNamedElement == null) {
                DbRenameDialog.$$$reportNull$$$0(2);
            }
            return basicNamedElement;
        }

        @NotNull
        public DbElement getPsiElement() {
            DbElement dbElement = (DbElement)super.getPsiElement();
            if (dbElement == null) {
                DbRenameDialog.$$$reportNull$$$0(3);
            }
            return dbElement;
        }

        protected boolean areButtonsValid() {
            return true;
        }

        protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
            gbConstraints.insets = JBUI.insetsBottom((int)4);
            gbConstraints.gridwidth = 1;
            gbConstraints.gridx = 0;
            gbConstraints.weighty = 0.0;
            gbConstraints.weightx = 1.0;
            gbConstraints.fill = 1;
            this.myRenameInStorage = DbRenamePsiElementProcessor.createDbSrcSearchBox(this.getProject());
            panel.add((Component)this.myRenameInStorage, gbConstraints);
            super.createCheckboxes(panel, gbConstraints);
        }

        protected void doAction() {
            DbRenamePsiElementProcessor.setSearchReferencesInStorage(this.getProject(), this.myRenameInStorage.isSelected());
            super.doAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            BasicNamedElement element2 = this.getBasicElement();
            this.myRenameGenerator = new RenameQueryGenerator((BasicModel)ObjectUtils.assertNotNull((Object)element2.getModel()), element2);
            this.myRenameGenerator.setCurrentNamespace(this.getCurrentNamespace());
            this.myDdlPreview = new SqlPreviewPanel(this.getProject(), this.getPsiElement().getDataSource(), this.getSearchPath(), this.generateQuery(this.getNewName()), "DbRenameDialog", () -> this.close(1)){

                @Override
                @NotNull
                public List<AnAction> createActions(@NotNull DbDataSource delegate) {
                    if (delegate == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<AnAction> res2 = super.createActions(delegate);
                    res2.add(0, DatabaseScriptDialog.createSettingsPopupAction((Getter<ScriptingTask>)((Getter)() -> myRenameGenerator.createTask(null)), (Consumer<ScriptingOptions>)((Consumer)o -> {
                        myRenameGenerator.setOptions((ScriptingOptions)o);
                        this.regenerateQuery(myRenameGenerator.getTargetElement().getName());
                    })));
                    List<AnAction> list = res2;
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "delegate";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createActions";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createActions";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            return this.myDdlPreview;
        }

        @Nullable
        private SearchPath getSearchPath() {
            return ObjectPaths.searchPathOf(this.getCurrentNamespace());
        }

        @NotNull
        private String generateQuery(@NotNull String name) {
            DatabaseDialectEx dialect;
            boolean quoted;
            if (name == null) {
                DbRenameDialog.$$$reportNull$$$0(4);
            }
            if (quoted = (dialect = DbImplUtil.getDatabaseDialect(this.getPsiElement())).isQuotedIdentifier(name)) {
                name = dialect.unquoteIdentifier(name);
            }
            this.myRenameGenerator.setQuoted(quoted);
            String string = this.myRenameGenerator.generate(name).getScriptText();
            if (string == null) {
                DbRenameDialog.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getCanonicalName();
        }

        protected void processNewNameChanged() {
            this.updateName(this.getNewName());
            super.processNewNameChanged();
        }

        private void updateName(String name) {
            if (this.myDdlPreview != null && this.myRenameGenerator != null && !Comparing.equal((String)this.myRenameGenerator.getTargetElement().getName(), (String)name)) {
                this.regenerateQuery(name);
            }
        }

        private void regenerateQuery(String name) {
            String query = this.generateQuery(name);
            boolean undo = UndoManager.getInstance((Project)this.getProject()).isUndoInProgress();
            if (!undo) {
                this.myDdlPreview.setQuery(query);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.myDdlPreview.setQuery(query));
            }
        }

        protected void canRun() throws ConfigurationException {
            if (this.myRenameGenerator == null || !this.myRenameGenerator.isRenamed()) {
                throw new ConfigurationException("Nothing to rename");
            }
            super.canRun();
        }

        protected RenameProcessor createRenameProcessor(String newName) {
            this.updateName(newName);
            DatabaseRefactoringHandler handler = this.createHandler();
            return new MyRenameProcessor(this.getProject(), (PsiElement)this.getPsiElement(), handler, newName, null, this.isSearchInComments(), this.isSearchInNonJavaFiles());
        }

        private DatabaseRefactoringHandler createHandler() {
            DbElement element2 = this.getPsiElement();
            DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(element2.getDataSource(), this.getSearchPath()).setStatement(this.myDdlPreview.getQuery());
            handler.getContext().include(element2);
            return handler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBasicElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generateQuery";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

