/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.ui.DatabasePreviewDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecuteRoutineActionBase
extends AnAction
implements DumbAware {
    protected ExecuteRoutineActionBase() {
        super("Execute Routine", "Executes routine", DatabaseIcons.FunctionRun);
    }

    public void update(@NotNull AnActionEvent e) {
        Icon icon;
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        ActionData actionData = this.getActionData(e);
        boolean available = actionData != ActionData.DISABLED && actionData.routine != null && this.isAvailable(e, actionData);
        presentation.setEnabledAndVisible(available);
        if (!available) {
            return;
        }
        DasRoutine.Kind kind = actionData.routine.getRoutineKind();
        boolean isProcedure = kind == DasRoutine.Kind.PROCEDURE;
        boolean isFunction = kind == DasRoutine.Kind.FUNCTION;
        Icon icon2 = icon = isProcedure ? DatabaseIcons.ProcedureRun : DatabaseIcons.FunctionRun;
        String text2 = isProcedure ? "Procedure" : (isFunction ? "Function" : "Routine");
        presentation.setIcon(icon);
        presentation.setText(String.format("Execute %s", text2));
    }

    protected boolean isAvailable(@NotNull AnActionEvent e, @NotNull ActionData data) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(1);
        }
        if (data == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(2);
        }
        return data.routine != null && data.dataSource != null && ExecutionHelper.HELPERS.forDbms(data.dataSource.getDbms()) != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(3);
        }
        this.doPerformAction(e, this.getActionData(e));
    }

    public void doPerformAction(@NotNull AnActionEvent e, ActionData data) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(4);
        }
        if (data.dataSource == null || data.routine == null) {
            return;
        }
        Dbms dbms = data.dataSource.getDbms();
        BasicRoutine routine = data.routine;
        BasicModel model = routine.getModel();
        ExecutionHelper provider = (ExecutionHelper)ExecutionHelper.HELPERS.forDbms(dbms);
        if (provider == null) {
            return;
        }
        ExecuteRoutineActionBase.withConsole(e, data, (Consumer<JdbcConsole>)((Consumer)console -> ExecuteRoutineActionBase.perform(routine, model, data.dataSource.getProject(), console, console.getSearchPath(), console.getDataSource(), new PreviewDialogRunner((JdbcConsole)console))));
    }

    public static void perform(@NotNull BasicRoutine routine, @NotNull BasicModel model, @NotNull Project project, @NotNull DataRequest.OwnerEx owner, @Nullable SearchPath searchPath, @NotNull LocalDataSource localDataSource, @NotNull RequestRunner executor) {
        ExecutionHelper provider;
        if (routine == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(5);
        }
        if (model == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(7);
        }
        if (owner == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(8);
        }
        if (localDataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(9);
        }
        if (executor == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(10);
        }
        if ((provider = (ExecutionHelper)ExecutionHelper.HELPERS.forDbms(localDataSource.getDbms())) == null) {
            return;
        }
        DbDataSource dataSource = (DbDataSource)ObjectUtils.notNull((Object)DbImplUtil.getDbDataSource(project, localDataSource));
        ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
        ScriptingSingleModelTask task = ExecuteRoutineActionBase.makeTask(routine, model, searchPath, localDataSource, dataSource);
        String statements2 = StringUtil.join((String[])service.makeScript(task).getScriptStatements(), (String)";\n");
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(localDataSource);
        DasNamespace searchPathObject = DbImplUtil.getSearchPathObjectForSwitch(dataSource, routine);
        SearchPath path = ObjectPaths.searchPathOf((DasObject)searchPathObject);
        String script = executor.editScript(statements2, path);
        if (script == null || StringUtil.isEmptyOrSpaces((String)script)) {
            return;
        }
        DataRequest request = provider.makeRequest(project, localDataSource, owner, script, dialect, routine, path);
        if (request != null) {
            executor.runRequest(request);
        }
    }

    @NotNull
    private static ScriptingSingleModelTask makeTask(@NotNull BasicRoutine routine, @NotNull BasicModel model, @Nullable SearchPath searchPath, @NotNull LocalDataSource localDataSource, @NotNull DbDataSource dataSource) {
        if (routine == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(11);
        }
        if (model == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(12);
        }
        if (localDataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(13);
        }
        if (dataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(14);
        }
        ScriptingSingleModelTaskBuilder taskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.EXECUTE);
        ObjectPath path = (ObjectPath)ObjectUtils.doIfNotNull((Object)searchPath, p2 -> p2.getCurrent());
        ObjectPath databasePath = path == null ? null : path.findParent(ObjectKind.DATABASE, false);
        ObjectPath schemaPath = path == null ? null : path.findParent(ObjectKind.SCHEMA, false);
        BasicDatabase database = databasePath == null ? null : (BasicDatabase)DbSqlUtil.findObjects(dataSource, databasePath).filter(BasicDatabase.class).first();
        BasicSchema schema = schemaPath == null ? null : (BasicSchema)DbSqlUtil.findObjects(dataSource, schemaPath).filter(BasicSchema.class).first();
        taskBuilder.setCurrentSchema(schema);
        taskBuilder.setCurrentDatabase(database);
        taskBuilder.setVersion(localDataSource.getVersion());
        taskBuilder.setElements(ContainerUtil.list((Object[])new BasicElement[]{routine}));
        taskBuilder.setOptions(new CustomScriptingOptions(ContainerUtil.map2Map((Collection)ContainerUtil.list((Object[])new Pair[]{Pair.create(ScriptingOptionStatic.CALL, (Object)true)}))));
        ScriptingSingleModelTask scriptingSingleModelTask = taskBuilder.build();
        if (scriptingSingleModelTask == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(15);
        }
        return scriptingSingleModelTask;
    }

    private static void withConsole(@NotNull AnActionEvent e, @NotNull ActionData data, @NotNull Consumer<JdbcConsole> consumer2) {
        List<PersistenceConsoleProvider.Runner> runners;
        JdbcConsole console;
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(16);
        }
        if (data == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(17);
        }
        if (consumer2 == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(18);
        }
        if ((console = data.console()) != null) {
            consumer2.consume((Object)console);
        }
        if ((runners = data.runners(consumer2)).isEmpty()) {
            return;
        }
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, null, e);
    }

    @NotNull
    protected abstract ActionData getActionData(@NotNull AnActionEvent var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ExecuteRoutineActionBase";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "makeTask";
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withConsole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class FilledData
    extends ActionData {
        protected FilledData(@NotNull DbDataSource dataSource, @NotNull BasicRoutine routine) {
            if (dataSource == null) {
                FilledData.$$$reportNull$$$0(0);
            }
            if (routine == null) {
                FilledData.$$$reportNull$$$0(1);
            }
            super(dataSource, routine);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "routine";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$FilledData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class ActionData {
        public static final ActionData DISABLED = new ActionData(null, null){};
        public final DbDataSource dataSource;
        public final BasicRoutine routine;

        protected ActionData(@Nullable DbDataSource source, @Nullable BasicRoutine routine) {
            this.dataSource = source;
            this.routine = routine;
        }

        @Nullable
        public JdbcConsole console() {
            return null;
        }

        @NotNull
        public List<PersistenceConsoleProvider.Runner> runners(@NotNull Consumer<JdbcConsole> consumer2) {
            if (consumer2 == null) {
                ActionData.$$$reportNull$$$0(0);
            }
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                ActionData.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$ActionData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$ActionData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "runners";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PreviewDialogRunner
    implements RequestRunner {
        private final JdbcConsole myConsole;

        PreviewDialogRunner(@NotNull JdbcConsole console) {
            if (console == null) {
                PreviewDialogRunner.$$$reportNull$$$0(0);
            }
            this.myConsole = console;
        }

        @Override
        @Nullable
        public String editScript(@NotNull String script, @Nullable SearchPath path) {
            Project project;
            DatabasePreviewDialog previewDialog;
            if (script == null) {
                PreviewDialogRunner.$$$reportNull$$$0(1);
            }
            return (previewDialog = new DatabasePreviewDialog(project = this.myConsole.getProject(), (DbDataSource)ObjectUtils.notNull((Object)DbImplUtil.getDbDataSource(project, this.myConsole.getDataSource())), path, "Execute Routine", "", script, ContainerUtil.emptyList())).showAndGet() ? previewDialog.getStatement() : null;
        }

        @Override
        public void runRequest(@NotNull DataRequest request) {
            if (request == null) {
                PreviewDialogRunner.$$$reportNull$$$0(2);
            }
            this.myConsole.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$PreviewDialogRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editScript";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface RequestRunner {
        @Nullable
        public String editScript(@NotNull String var1, @Nullable SearchPath var2);

        public void runRequest(@NotNull DataRequest var1);
    }

    public static interface ExecutionHelper {
        public static final DbmsExtension<ExecutionHelper> HELPERS = new DbmsExtension("com.intellij.database.routineExecutionHelper");

        @Nullable
        public DataRequest makeRequest(@NotNull Project var1, @NotNull LocalDataSource var2, @NotNull DataRequest.OwnerEx var3, @NotNull String var4, @NotNull SqlLanguageDialect var5, @NotNull BasicRoutine var6, @Nullable SearchPath var7);
    }
}

