/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.DatabasePreviewDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcMigration {
    private static final Logger LOG = Logger.getInstance(DbSrcMigration.class);
    private static final Set<ObjectKind> DEPENDANT_OBJECTS = ContainerUtil.immutableSet((Object[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.FOREIGN_KEY, ObjectKind.KEY, ObjectKind.CHECK, ObjectKind.INDEX});

    public static boolean isSupported(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcMigration.$$$reportNull$$$0(0);
        }
        if (!DbSrcUtils.isDbSrcFile(file)) {
            return false;
        }
        BasicElement element2 = DbSrcUtils.findObject(null, file.getPath(), BasicElement.class);
        return DbSrcMigration.isSupported(element2);
    }

    public static boolean isSupported(@Nullable BasicElement element2) {
        BasicModel model;
        BasicModel basicModel = model = element2 == null ? null : element2.getModel();
        if (model == null) {
            return false;
        }
        ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
        return DbSrcMigration.canRefactor(service, element2);
    }

    private static boolean canRefactor(ScriptGenerator service, BasicElement element2) {
        BasicModel model = element2.getModel();
        return service.capabilities(element2).getAlterAnything().get(model == null ? null : model.getRoot().getServerVersion());
    }

    public static ScriptingResult perform(@NotNull ScriptingTask task) {
        if (task == null) {
            DbSrcMigration.$$$reportNull$$$0(1);
        }
        ScriptGenerator ss = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(ScriptingTaskKt.getDbms(task));
        return ss.makeScript(task);
    }

    @NotNull
    public static List<Pair<BasicElement, VirtualFile>> getObjects(@NotNull Project project, @NotNull Iterable<VirtualFile> files) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(2);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(3);
        }
        ArrayList objects = ContainerUtil.newArrayList();
        BasicModel model = null;
        ScriptGenerator ss = null;
        for (VirtualFile file : files) {
            BasicElement element2;
            if (!DbSrcUtils.isDbSrcFile(file) || (element2 = DbSrcUtils.findObject(project, file.getPath(), BasicElement.class)) == null) continue;
            if (model == null) {
                model = element2.getModel();
            }
            if (model != null) {
                ss = ScriptGenerators.INSTANCE.byModel(model);
            }
            if (ss == null || !DbSrcMigration.canRefactor(ss, element2)) continue;
            objects.add(Pair.create((Object)element2, (Object)file));
        }
        ArrayList arrayList = objects;
        if (arrayList == null) {
            DbSrcMigration.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static ScriptingResult migrate(@NotNull Project project, @NotNull BasicModel model, @NotNull Iterable<Pair<BasicElement, VirtualFile>> files, @Nullable BasicNamespace currentNamespace) {
        ScriptingAlterTask task;
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(5);
        }
        if (model == null) {
            DbSrcMigration.$$$reportNull$$$0(6);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(7);
        }
        if ((task = DbSrcMigration.buildMigrationTask(project, model, files, currentNamespace)) == null || task.getCorrespondence().isEmpty()) {
            return null;
        }
        return DbSrcMigration.perform(task);
    }

    @Nullable
    public static ScriptingAlterTask buildMigrationTask(@NotNull Project project, @NotNull BasicModel model, @NotNull Iterable<Pair<BasicElement, VirtualFile>> files, @Nullable BasicNamespace currentNamespace) {
        List<Pair<BasicElement, SqlFile>> objects;
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(8);
        }
        if (model == null) {
            DbSrcMigration.$$$reportNull$$$0(9);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(10);
        }
        if ((objects = DbSrcMigration.findObjects(project, files)).isEmpty()) {
            return null;
        }
        BasicModModel targetModel = new ModelFactory(new MemoryTextStorage()).createModel(model.getDbms());
        ScriptingAlterTaskBuilder task = new ScriptingAlterTaskBuilder(model, targetModel);
        HashMap copied = ContainerUtil.newHashMap();
        DbSrcMigration.buildFromSql(project, model, objects, targetModel, copied);
        DbSrcMigration.fillCorrespondence(task, copied, objects);
        task.setCurrentNamespace(currentNamespace);
        return task.build();
    }

    private static void fillCorrespondence(ScriptingAlterTaskBuilder task, Map<BasicModElement, BasicElement> copied, List<Pair<BasicElement, SqlFile>> objects) {
        HashMap rev = ContainerUtil.newHashMap();
        for (Map.Entry<BasicModElement, BasicElement> entry : copied.entrySet()) {
            task.getCorrespondence().add(ElementDelta.create(entry.getValue(), (BasicElement)entry.getKey()));
            rev.put(entry.getValue(), entry.getKey());
        }
        for (Pair pair : objects) {
            JBTreeTraverser<BasicElement> traverser2 = task.getModel().traverser(true);
            for (BasicElement element2 : ((JBTreeTraverser)traverser2.withRoot(pair.first)).traverse()) {
                if (rev.containsKey(element2)) continue;
                BasicModElement object = (BasicModElement)DbSrcMigration.findObject(element2, rev);
                if (object != null) {
                    rev.put(element2, object);
                    copied.put(object, element2);
                    task.getCorrespondence().add(ElementDelta.create(element2, object));
                    continue;
                }
                ObjectKind kind = element2.getKind();
                if (!DEPENDANT_OBJECTS.contains(kind)) continue;
                task.getCorrespondence().add(ElementDelta.create(element2, null));
            }
            for (BasicModElement element2 : ((JBTreeTraverser)traverser2.withRoot(rev.get(pair.first))).traverse().filter(BasicModElement.class)) {
                if (copied.containsKey(element2)) continue;
                task.getCorrespondence().add(ElementDelta.create(null, element2));
            }
        }
    }

    private static void buildFromSql(@NotNull Project project, @NotNull BasicModel model, List<Pair<BasicElement, SqlFile>> objects, BasicModModel targetModel, Map<BasicModElement, BasicElement> copied) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(11);
        }
        if (model == null) {
            DbSrcMigration.$$$reportNull$$$0(12);
        }
        ArrayList files = ContainerUtil.newArrayListWithCapacity((int)objects.size());
        HashMap topObjects = ContainerUtil.newHashMap();
        HashSet rootBranch = ContainerUtil.newHashSet();
        for (Pair<BasicElement, SqlFile> p2 : objects) {
            files.add(p2.second);
            BasicElement e = (BasicElement)p2.first;
            rootBranch.add(e);
            for (DasObject def2 = DbSrcMigration.findObjectDefinition((SqlFile)p2.second, e); def2 != null && e != null && def2.getKind() == e.getKind(); def2 = def2.getDasParent(), e = e.getParent()) {
                ContainerUtil.putIfNotNull((Object)def2, (Object)e, (Map)topObjects);
            }
        }
        SqlPsiFacade.getInstance((Project)project).buildModel((DasModel)targetModel, (List)files, (t, s) -> {
            BasicModElement mod;
            if (model == null) {
                DbSrcMigration.$$$reportNull$$$0(22);
            }
            if (copied.containsKey(mod = (BasicModElement)t)) {
                return true;
            }
            BasicElement src = (BasicElement)topObjects.get(s);
            if (src == null) {
                src = DbSrcMigration.findObject(mod, copied);
                if (src != null && !rootBranch.contains(src.getParent())) {
                    src = null;
                }
                if (src != null) {
                    rootBranch.add(src);
                }
            }
            if (src == null) {
                return true;
            }
            BasicModElement root2 = (BasicModElement)((Object)mod.getModel().getRoot());
            if (!copied.containsKey(root2)) {
                BasicMetaUtils.copyProperties(model.getRoot(), root2, true);
                copied.put(root2, model.getRoot());
            }
            BasicMetaUtils.copyProperties(src, mod, true);
            copied.put(mod, src);
            return rootBranch.contains(src);
        });
    }

    @Nullable
    private static BasicElement findObject(@Nullable BasicElement mod, Map<? extends BasicElement, ? extends BasicElement> copied) {
        if (mod == null) {
            return null;
        }
        BasicElement element2 = copied.get(mod);
        if (element2 != null) {
            return element2;
        }
        BasicElement p2 = DbSrcMigration.findObject(mod.getParent(), copied);
        Family<? extends BasicElement> family = p2 == null ? null : p2.familyOf(mod.getKind());
        return family == null ? null : ModelUtil.findObject(family, mod);
    }

    private static DasObject findObjectDefinition(SqlFile file, BasicElement target) {
        return (DasObject)JBIterable.from((Iterable)file.getDdl()).filter(DasObject.class).filter(DasUtil.byKind((ObjectKind)target.getKind())).first();
    }

    @NotNull
    private static List<Pair<BasicElement, SqlFile>> findObjects(@NotNull Project project, @NotNull Iterable<Pair<BasicElement, VirtualFile>> files) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(13);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(14);
        }
        FileDocumentManager dm = FileDocumentManager.getInstance();
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)project);
        ArrayList objects = ContainerUtil.newArrayList();
        for (Pair<BasicElement, VirtualFile> file : files) {
            SqlFile psiFile;
            Document doc = dm.getDocument((VirtualFile)file.second);
            SqlFile sqlFile = psiFile = doc == null ? null : (SqlFile)ObjectUtils.tryCast((Object)pdm.getPsiFile(doc), SqlFile.class);
            if (psiFile == null) continue;
            objects.add(Pair.create((Object)file.first, (Object)psiFile));
        }
        ArrayList arrayList = objects;
        if (arrayList == null) {
            DbSrcMigration.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public static void showMigrationDialog(@NotNull DbDataSource dataSource, @NotNull Iterable<VirtualFile> files) {
        SearchPath searchPath;
        DatabasePreviewDialog dialog;
        if (dataSource == null) {
            DbSrcMigration.$$$reportNull$$$0(16);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(17);
        }
        Project project = dataSource.getProject();
        List<Pair<BasicElement, VirtualFile>> objects = DbSrcMigration.getObjects(project, files);
        BasicElement any = (BasicElement)JBIterable.from(objects).filterMap(Functions.pairFirst()).first();
        BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.getSearchPathObjectForSwitch(dataSource, any), BasicNamespace.class);
        ScriptingAlterTask task = null;
        if (!objects.isEmpty()) {
            BasicModel model = (BasicModel)ObjectUtils.assertNotNull((Object)((BasicElement)objects.get((int)0).first).getModel());
            task = DbSrcMigration.buildMigrationTask(project, model, objects, namespace);
        }
        CompositeText text2 = null;
        if (task != null && !task.getCorrespondence().isEmpty()) {
            text2 = DbSrcMigration.perform(task).getScript();
        }
        if (text2 != null) {
            try {
                text2 = DbSrcMigration.formatCompositeText(project, DbSqlUtil.getSqlDialect((DbElement)dataSource), text2);
            }
            catch (Throwable th) {
                LOG.warn("Formatting failed", th);
            }
        }
        if ((dialog = new DatabasePreviewDialog(project, dataSource, searchPath = ObjectPaths.searchPathOf(namespace), "Object Migration", "Script", text2 == null ? "" : text2.getText().toString(), text2 == null ? Collections.singletonList("Generation failed") : Collections.emptyList())).showAndGet()) {
            DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(dataSource, searchPath).setStatement(dialog.getStatement());
            LoaderContext context = handler.getContext();
            for (VirtualFile file : files) {
                DbElement item = DbSrcUtils.findDbElement(project, file.getPath(), DbElement.class);
                if (item == null) continue;
                context.include(item);
            }
            handler.runStatements(false);
        }
    }

    @NotNull
    public static PersistentMarkup formatCompositeText(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CompositeText text2) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            DbSrcMigration.$$$reportNull$$$0(19);
        }
        if (text2 == null) {
            DbSrcMigration.$$$reportNull$$$0(20);
        }
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        ArrayList ranges = ContainerUtil.newArrayList();
        for (CompositeText.Fragment fragment : text2.getFragments()) {
            int start = document.getTextLength();
            document.insertString(start, (CharSequence)StringUtil.convertLineSeparators((String)fragment.getText().toString()));
            int end = document.getTextLength();
            CompositeText.Kind kind = fragment.getKind();
            RangeMarker marker = kind.getReformattable() ? document.createRangeMarker(start, end) : document.createGuardedBlock(start, end);
            ranges.add(Pair.create((Object)marker, (Object)fragment));
        }
        SqlPsiFacade.getInstance((Project)project).format(project, dialect, (Document)document);
        PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
        for (Pair range : ranges) {
            if (!((RangeMarker)range.first).isValid()) {
                LOG.warn("Range marker died during formatting");
                continue;
            }
            builder.add(((CompositeText.Fragment)range.second).getKind(), ((RangeMarker)range.first).getStartOffset(), ((RangeMarker)range.first).getEndOffset(), ((CompositeText.Fragment)range.second).getError());
        }
        PersistentMarkup persistentMarkup = builder.build(document.getText());
        if (persistentMarkup == null) {
            DbSrcMigration.$$$reportNull$$$0(21);
        }
        return persistentMarkup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 15: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 15: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/script/DbSrcMigration";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/script/DbSrcMigration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjects";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCompositeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getObjects";
                break;
            }
            case 4: 
            case 15: 
            case 21: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildMigrationTask";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildFromSql";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showMigrationDialog";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "formatCompositeText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildFromSql$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 15: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

