/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.PgJdbcHelper;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcInjectable;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.Version;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectHashingStrategy;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.rmi.ConnectException;
import java.rmi.UnmarshalException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public class DbImplUtil {
    private static final int UNLIMITED_PAGE_SIZE = -1;
    public static final Condition<DbElement> CAN_CONNECT_TO = DbImplUtil::canConnectTo;
    private static final DbmsExtension<JdbcHelper> JDBC_HELPER_EP = new DbmsExtension("com.intellij.database.jdbcHelper");
    private static final char ESCAPE_CHAR = '#';
    public static final ThrowableConvertor<ResultSet, List<String>, SQLException> RS_AS_STRING_LIST = rs -> {
        ArrayList res2 = ContainerUtil.newArrayList();
        while (rs.next()) {
            res2.add(rs.getString(1));
        }
        return res2;
    };
    private static final String ROW_ID = "ROW_ID";
    private static final VfsDependentEnum<String> myDialectAndDataSourcesEnumerator = new VfsDependentEnum("sql_dialects_and_data_sources", (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 1);

    private DbImplUtil() {
    }

    public static boolean valuesEqual(Object v1, Object v2) {
        ThreeState result2;
        if (v1 == ReservedCellValue.NULL) {
            v1 = null;
        }
        if (v2 == ReservedCellValue.NULL) {
            v2 = null;
        }
        if ((result2 = DbImplUtil.simpleEquals(v1, v2)) == ThreeState.UNSURE) {
            result2 = DbImplUtil.numberEquals(v1, v2);
        }
        if (result2 == ThreeState.UNSURE) {
            result2 = DbImplUtil.arrayEquals(v1, v2);
        }
        if (result2 == ThreeState.UNSURE) {
            result2 = DbImplUtil.clobEquals(v1, v2);
        }
        if (result2 == ThreeState.UNSURE) {
            result2 = ThreeState.NO;
        }
        return result2.toBoolean();
    }

    public static int valueHashCode(Object v) {
        if (v == ReservedCellValue.NULL) {
            v = null;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return Long.valueOf(n.longValue()).hashCode() * 31 + Double.valueOf(n.doubleValue()).hashCode();
        }
        if (v instanceof byte[]) {
            return Arrays.hashCode((byte[])v);
        }
        if (v instanceof char[]) {
            return Arrays.hashCode((char[])v);
        }
        if (v instanceof LobInfo.ClobInfo) {
            return Comparing.hashcode((Object)((LobInfo.ClobInfo)v).data);
        }
        return Comparing.hashcode((Object)v);
    }

    private static ThreeState simpleEquals(Object v1, Object v2) {
        return Comparing.equal((Object)v1, (Object)v2) ? ThreeState.YES : ThreeState.UNSURE;
    }

    private static ThreeState numberEquals(Object v1, Object v2) {
        Number n1 = (Number)ObjectUtils.tryCast((Object)v1, Number.class);
        Number n2 = (Number)ObjectUtils.tryCast((Object)v2, Number.class);
        if (n1 != null && n2 != null) {
            long l1 = n1.longValue();
            long l2 = n2.longValue();
            double d1 = n1.doubleValue();
            double d2 = n2.doubleValue();
            return ThreeState.fromBoolean((l1 == l2 && (d1 == d2 || Double.isNaN(d1) && Double.isNaN(d2)) ? 1 : 0) != 0);
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState arrayEquals(Object v1, Object v2) {
        if (v1 != null && v2 != null && v1.getClass() == v2.getClass() && v1.getClass().isArray()) {
            if (v1 instanceof byte[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((byte[])v1, (byte[])v2));
            }
            if (v1 instanceof char[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((char[])v1, (char[])v2));
            }
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState clobEquals(Object v1, Object v2) {
        LobInfo.ClobInfo info1 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v1, LobInfo.ClobInfo.class);
        LobInfo.ClobInfo info2 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v2, LobInfo.ClobInfo.class);
        if (info1 != null && info2 != null) {
            return ThreeState.fromBoolean((!info2.isTruncated() && DbImplUtil.clobStringEquals(info1, info2.data) ? 1 : 0) != 0);
        }
        if (info1 != null && v2 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtil.clobStringEquals(info1, (String)v2));
        }
        if (info2 != null && v1 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtil.clobStringEquals(info2, (String)v1));
        }
        return ThreeState.UNSURE;
    }

    private static boolean clobStringEquals(@NotNull LobInfo.ClobInfo lob, @Nullable String s) {
        if (lob == null) {
            DbImplUtil.$$$reportNull$$$0(0);
        }
        return !lob.isTruncated() && Comparing.equal((String)lob.data, (String)s);
    }

    @Nullable
    public static DbElement findElement(@Nullable DbDataSource dataSource, @Nullable DasObject object) {
        if (dataSource == null || object == null) {
            return null;
        }
        return ((DbDataSourceImpl)dataSource).findElement(object);
    }

    public static DdlBuilder createBuilderForExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(1);
        }
        return new DdlBuilder().withDialect(dialect).qualifyReferences(true).quoteIdentifiers(true);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull DatabaseDialectEx dialect, @Nullable DasObject object) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(2);
        }
        DdlBuilder builder = DbImplUtil.createBuilderForExec(dialect).quoteIdentifiers(false);
        DbElement element2 = DbImplUtil.getDbElement(object);
        return element2 != null ? builder.withCasingFor(element2) : builder;
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull Dbms dbms, @Nullable DasDataSource system) {
        if (databaseTable == null) {
            DbImplUtil.$$$reportNull$$$0(3);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(4);
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dbms, system, false, -1);
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull Dbms dbms, @Nullable DasDataSource system, int rows) {
        if (databaseTable == null) {
            DbImplUtil.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(6);
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dbms, system, false, rows);
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull Dbms dbms, @Nullable DasDataSource system, boolean appendRowId, int rows) {
        if (databaseTable == null) {
            DbImplUtil.$$$reportNull$$$0(7);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(8);
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dbms, system, appendRowId, rows, Collections.emptyList(), Collections.emptyList());
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull Dbms dbms, @Nullable DasDataSource system, int rows, @NotNull Iterable<String> columnNames, @NotNull Iterable<?> values2) {
        if (databaseTable == null) {
            DbImplUtil.$$$reportNull$$$0(9);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(10);
        }
        if (columnNames == null) {
            DbImplUtil.$$$reportNull$$$0(11);
        }
        if (values2 == null) {
            DbImplUtil.$$$reportNull$$$0(12);
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dbms, system, false, rows, columnNames, values2);
    }

    private static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull Dbms dbms, @Nullable DasDataSource system, boolean appendRowId, int rows, @NotNull Iterable<String> columnNames, @NotNull Iterable<?> values2) {
        if (databaseTable == null) {
            DbImplUtil.$$$reportNull$$$0(13);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(14);
        }
        if (columnNames == null) {
            DbImplUtil.$$$reportNull$$$0(15);
        }
        if (values2 == null) {
            DbImplUtil.$$$reportNull$$$0(16);
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(dbms);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)databaseTable);
        BiConsumer<String, DdlBuilder> appendWhereClause = Iterables.isEmpty(columnNames) ? null : (tableNameAlias, ddlBuilder) -> {
            if (columnNames == null) {
                DbImplUtil.$$$reportNull$$$0(204);
            }
            if (values2 == null) {
                DbImplUtil.$$$reportNull$$$0(205);
            }
            if (dbms == null) {
                DbImplUtil.$$$reportNull$$$0(206);
            }
            ddlBuilder.space().keyword("WHERE").space();
            DbImplUtil.composeWhereCondition(ddlBuilder, columnNames, values2, tableNameAlias, dbms);
        };
        return DbImplUtil.createSelectAllQuery(builder, databaseTable, dialect, system, appendWhereClause, appendRowId, rows);
    }

    @Nullable
    private static DbElement getDbElement(@Nullable DasObject object) {
        return (DbElement)DasUtil.getParentOfClass((DasObject)object, DbDataSource.class, (boolean)false);
    }

    @NotNull
    public static List<ColumnQueryData> createSelectAllQueryWithParameters(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull Dbms dbms, @Nullable DasDataSource system, @NotNull List<ColumnQueryData> datas, int rows) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(17);
        }
        if (table == null) {
            DbImplUtil.$$$reportNull$$$0(18);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(19);
        }
        if (datas == null) {
            DbImplUtil.$$$reportNull$$$0(20);
        }
        if (datas.isEmpty()) {
            DbImplUtil.createSelectAllQuery(table, dbms, system, rows);
            ImmutableList immutableList = ContainerUtil.immutableList((Object[])new ColumnQueryData[0]);
            if (immutableList == null) {
                DbImplUtil.$$$reportNull$$$0(21);
            }
            return immutableList;
        }
        ArrayList newData = ContainerUtil.newArrayList();
        BiConsumer<String, DdlBuilder> appendWhereClauseFunction = (tableNameAlias, ddlBuilder) -> {
            if (datas == null) {
                DbImplUtil.$$$reportNull$$$0(202);
            }
            if (dbms == null) {
                DbImplUtil.$$$reportNull$$$0(203);
            }
            ddlBuilder.space().keyword("WHERE").space();
            newData.addAll(DbImplUtil.composeWhereConditionWithParameters(ddlBuilder, datas, tableNameAlias, dbms));
        };
        DbImplUtil.createSelectAllQuery(builder, table, DbImplUtil.getDatabaseDialect(dbms), system, appendWhereClauseFunction, false, rows);
        ArrayList arrayList = newData;
        if (arrayList == null) {
            DbImplUtil.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    private static DdlBuilder createSelectAllQuery(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, @NotNull DatabaseDialectEx dialect, @Nullable DasDataSource system, @Nullable BiConsumer<String, DdlBuilder> appendWhereClause, boolean appendRowId, int rows) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(23);
        }
        if (dasTable == null) {
            DbImplUtil.$$$reportNull$$$0(24);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(25);
        }
        DdlBuilder ddlBuilder = dialect.sqlSelectAll(builder, dasTable, system, appendWhereClause, null, appendRowId, rows);
        if (ddlBuilder == null) {
            DbImplUtil.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    @NotNull
    public static String findFreeAlias(@NotNull Project project, @NotNull Dbms dbms, @NotNull String query, @NotNull String alias) {
        SqlResultSetExpression expression;
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(27);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(28);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(29);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(30);
        }
        if ((expression = DbSqlUtil.parseQuery(project, DbSqlUtil.getSqlDialect(dbms), query, null)) == null) {
            String string = alias;
            if (string == null) {
                DbImplUtil.$$$reportNull$$$0(31);
            }
            return string;
        }
        Set names = SyntaxTraverser.psiTraverser((PsiElement)expression).filter(SqlIdentifier.class).transform(SqlNameElement::getName).toSet();
        String result2 = alias;
        int index2 = 1;
        while (names.contains(result2)) {
            result2 = alias + index2++;
        }
        String string = result2;
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Nullable
    public static String createSelectCountQuery(@NotNull Project project, @NotNull Dbms dbms, @Nullable String queryText, @Nullable DbDataSource dataSource) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(33);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(34);
        }
        Pair<String, Integer> pair = DbImplUtil.createSelectCountQueryWithOffset(project, dbms, queryText, dataSource);
        return (String)Pair.getFirst(pair);
    }

    @Nullable
    public static String createSelectCountQuery(@NotNull Project project, @NotNull Dbms dbms, @Nullable String queryText, @Nullable DbDataSource dataSource, @NotNull String alias) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(35);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(36);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(37);
        }
        Pair<String, Integer> result2 = DbImplUtil.createSelectCountQueryWithOffset(project, dbms, queryText, dataSource, alias);
        return (String)Pair.getFirst(result2);
    }

    @Nullable
    public static Pair<String, Integer> createSelectCountQueryWithOffset(@NotNull Project project, @NotNull Dbms dbms, @Nullable String queryText, @Nullable DbDataSource dataSource) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(38);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(39);
        }
        return DbImplUtil.createSelectCountQueryWithOffset(project, dbms, queryText, dataSource, "t");
    }

    @Nullable
    public static Pair<String, Integer> createSelectCountQueryWithOffset(@NotNull Project project, @NotNull Dbms dbms, @Nullable String queryText, @Nullable DbDataSource dataSource, @NotNull String alias) {
        OptionalInt offset;
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(40);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(41);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(42);
        }
        queryText = queryText != null ? StringUtil.trimEnd((String)queryText, (String)";") : "";
        SqlResultSetExpression e = DbSqlUtil.parseQuery(project, DbSqlUtil.getSqlDialect(dbms), queryText, null);
        if (e == null) {
            return null;
        }
        SqlQueryExpression query = e instanceof SqlWithQueryExpression ? (SqlQueryExpression)ObjectUtils.tryCast((Object)((SqlWithQueryExpression)e).getExpression(), SqlQueryExpression.class) : (e instanceof SqlQueryExpression ? (SqlQueryExpression)e : null);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(DbImplUtil.getDatabaseDialect(dbms), (DasObject)dataSource);
        if (query == null || !(offset = DbImplUtil.buildOptimizedCountQuery(builder, query, queryText)).isPresent()) {
            DdlBuilder head = DbImplUtil.countQueryHead(builder).symbol("(");
            int currentHeadLength = head.length();
            offset = OptionalInt.of(currentHeadLength + (Integer)DbImplUtil.appendWrappedQueryTail((DdlBuilder)head, (SqlResultSetExpression)e, (String)queryText, (String)alias).second);
        }
        return Pair.create((Object)builder.getStatement(), (Object)offset.orElse(0));
    }

    @Nullable
    public static DdlBuilder wrapSelectQuery(@NotNull Project project, @NotNull Dbms dbms, @NotNull String query, @NotNull String alias) {
        SqlResultSetExpression expression;
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(43);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(44);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(45);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(46);
        }
        if ((expression = DbSqlUtil.parseQuery(project, DbSqlUtil.getSqlDialect(dbms), query, null)) == null) {
            return null;
        }
        DdlBuilder builder = DbImplUtil.createBuilderForExec(DbImplUtil.getDatabaseDialect(dbms));
        builder.keyword("SELECT").space().symbol("*").space().keyword("FROM").space().symbol("(");
        return (DdlBuilder)DbImplUtil.appendWrappedQueryTail((DdlBuilder)builder, (SqlResultSetExpression)expression, (String)query, (String)alias).first;
    }

    @NotNull
    private static Pair<DdlBuilder, Integer> appendWrappedQueryTail(@NotNull DdlBuilder head, @NotNull SqlResultSetExpression e, @NotNull String query, @NotNull String alias) {
        if (head == null) {
            DbImplUtil.$$$reportNull$$$0(47);
        }
        if (e == null) {
            DbImplUtil.$$$reportNull$$$0(48);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(49);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(50);
        }
        boolean subqueryIsBuilt = false;
        boolean needSelectTargetAliases = head.getDialect().getDbms().isMicrosoft();
        int placeholdersOffset = 0;
        if (needSelectTargetAliases) {
            TIntArrayList endOffsets = new TIntArrayList();
            for (SqlSelectClause selectClause : SyntaxTraverser.psiTraverser((PsiElement)e).filter(SqlSelectClause.class)) {
                for (SqlExpression expression : selectClause.getExpressions()) {
                    if (expression instanceof SqlAsExpression || expression instanceof SqlReferenceExpression) continue;
                    endOffsets.add(expression.getTextRange().getEndOffset());
                }
            }
            endOffsets.sort();
            int prevIdx = 0;
            int count2 = 0;
            int len = endOffsets.size();
            for (int i2 = 0; i2 < len; ++i2) {
                int offset = endOffsets.get(i2);
                head.plain(query.substring(prevIdx, offset));
                String name = "_" + ++count2;
                placeholdersOffset += name.length();
                head.space().columnRef(name);
                prevIdx = offset;
            }
            head.plain(e.getText().substring(prevIdx));
            subqueryIsBuilt = true;
        }
        if (!subqueryIsBuilt) {
            head.plain(query);
        }
        Pair pair = Pair.create((Object)head.symbol(")").space().alias(alias), (Object)placeholdersOffset);
        if (pair == null) {
            DbImplUtil.$$$reportNull$$$0(51);
        }
        return pair;
    }

    @NotNull
    private static DdlBuilder countQueryHead(@NotNull DdlBuilder builder) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(52);
        }
        DdlBuilder ddlBuilder = builder.keyword("SELECT").space().keyword("COUNT").symbol("(").symbol("*").symbol(")").space().keyword("FROM").space();
        if (ddlBuilder == null) {
            DbImplUtil.$$$reportNull$$$0(53);
        }
        return ddlBuilder;
    }

    @NotNull
    private static OptionalInt buildOptimizedCountQuery(@NotNull DdlBuilder builder, @NotNull SqlQueryExpression query, @NotNull String queryText) {
        SqlSelectClause selectClause;
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(54);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(55);
        }
        if (queryText == null) {
            DbImplUtil.$$$reportNull$$$0(56);
        }
        if ((selectClause = query.getSelectClause()) == null) {
            OptionalInt optionalInt = OptionalInt.empty();
            if (optionalInt == null) {
                DbImplUtil.$$$reportNull$$$0(57);
            }
            return optionalInt;
        }
        for (SqlSelectOption option : selectClause.getOptions()) {
            if (!StringUtil.startsWithIgnoreCase((String)option.getOptionName(), (String)"DISTINCT") && option.getClause() == null) continue;
            OptionalInt optionalInt = OptionalInt.empty();
            if (optionalInt == null) {
                DbImplUtil.$$$reportNull$$$0(58);
            }
            return optionalInt;
        }
        SqlTableExpression tableExp = query.getTableExpression();
        if (tableExp == null || tableExp.getHavingClause() != null || tableExp.getGroupByClause() != null) {
            OptionalInt optionalInt = OptionalInt.empty();
            if (optionalInt == null) {
                DbImplUtil.$$$reportNull$$$0(59);
            }
            return optionalInt;
        }
        List expressions = selectClause.getExpressions();
        for (SqlExpression e : expressions) {
            if (((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)e)).preOrderDfsTraversal().filter(SqlFunctionCallExpression.class).isEmpty()) continue;
            OptionalInt optionalInt = OptionalInt.empty();
            if (optionalInt == null) {
                DbImplUtil.$$$reportNull$$$0(60);
            }
            return optionalInt;
        }
        SqlExpression firstExpression = (SqlExpression)ContainerUtil.getFirstItem((List)expressions);
        SqlExpression lastExpression = (SqlExpression)ContainerUtil.getLastItem((List)expressions);
        if (firstExpression == null || lastExpression == null) {
            OptionalInt optionalInt = OptionalInt.empty();
            if (optionalInt == null) {
                DbImplUtil.$$$reportNull$$$0(61);
            }
            return optionalInt;
        }
        int expressionsStartOffset = firstExpression.getTextRange().getStartOffset();
        int expressionsEndOffset = lastExpression.getTextRange().getEndOffset();
        builder.clear().plain(queryText.substring(0, expressionsStartOffset)).keyword("COUNT").symbol("(").symbol("*").symbol(")").plain(queryText.substring(expressionsEndOffset));
        OptionalInt optionalInt = OptionalInt.of(builder.length() - queryText.length());
        if (optionalInt == null) {
            DbImplUtil.$$$reportNull$$$0(62);
        }
        return optionalInt;
    }

    public static void resultSetToString(String title, ResultSet rs, int size, Dbms dbms, DataExtractor extractor, CharOut out) throws Exception {
        DataConsumer.Column[] columns = JdbcEngine.getColumnDescriptors(rs, dbms);
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)rs, RemoteResultSet.class);
        int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
        RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(Calendar.getInstance(), size, maxLobLength, false);
        List objects = remoteResultSet.getObjects(options);
        List data = (List)RemoteUtil.handleRemoteResult((Object)objects, List.class, (Object)extractor);
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(data.size());
        if (data.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < data.size(); ++i2) {
            rows.add(DataConsumer.Row.create(i2 + 1, (Object[])data.get(i2)));
        }
        out.append(String.format(title, data.size()));
        ExtractorsUtil.extract(out, dbms, false, Arrays.asList(columns), extractor, rows, new int[0]);
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull DasDataSource database) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(63);
        }
        if (database == null) {
            DbImplUtil.$$$reportNull$$$0(64);
        }
        return database instanceof DbDataSource ? (DbDataSource)database : DbPsiFacade.getInstance((Project)project).findDataSource(database.getUniqueId());
    }

    public static boolean isConnected(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(65);
        }
        Object delegate = element2.getDelegate();
        Project project = element2.getProject();
        return delegate instanceof LocalDataSource && DbImplUtil.isConnected(project, (LocalDataSource)delegate);
    }

    public static boolean isConnected(@NotNull Project project, @NotNull LocalDataSource delegate) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(66);
        }
        if (delegate == null) {
            DbImplUtil.$$$reportNull$$$0(67);
        }
        return !JdbcDriverManager.getDriverManager(project).getActiveConfigurations(delegate).isEmpty();
    }

    public static int getActiveConnectionCount(@NotNull LocalDataSource delegate) {
        if (delegate == null) {
            DbImplUtil.$$$reportNull$$$0(68);
        }
        int result2 = 0;
        for (DatabaseConnection connection2 : DatabaseConnectionManager.getInstance().getActiveConnections()) {
            if (delegate != connection2.getConnectionPoint().getDataSource()) continue;
            ++result2;
        }
        return result2;
    }

    public static boolean canConnectTo(@Nullable DbElement element2) {
        DatabaseSystem ds = element2 == null ? null : element2.getDataSource().getDelegate();
        return ds instanceof LocalDataSource && DbImplUtil.canConnectTo((LocalDataSource)ds);
    }

    public static boolean isInLocalDataSource(@Nullable DbElement element2) {
        DatabaseSystem ds = element2 == null ? null : element2.getDataSource().getDelegate();
        return ds instanceof LocalDataSource;
    }

    public static boolean hasDriverFiles(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(69);
        }
        return !dataSource.getClasspathElements().isEmpty();
    }

    public static boolean canConnectTo(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(70);
        }
        if (StringUtil.isEmptyOrSpaces((String)dataSource.getUrl())) {
            return false;
        }
        if (!DbImplUtil.hasDriverFiles(dataSource)) {
            return false;
        }
        String driverClass = dataSource.getDriverClass();
        return !StringUtil.isEmptyOrSpaces((String)driverClass);
    }

    public static boolean canConnectToAndModify(@Nullable DbElement element2) {
        return element2 != null && element2.isWritable() && DbImplUtil.canConnectTo(element2) && !DataImporter.isBusy(element2);
    }

    public static boolean canModify(@Nullable DbElement element2) {
        return element2 != null && element2.isWritable() && !DataImporter.isBusy(element2);
    }

    @Deprecated
    @Nullable
    public static Connection getConnection(@NotNull DbElement element2) throws Exception {
        GuardedRef<DatabaseConnection> connection2;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(71);
        }
        return (connection2 = DbImplUtil.getDatabaseConnection(element2)) == null ? null : connection2.get().getJdbcConnection();
    }

    @Deprecated
    @Nullable
    public static GuardedRef<DatabaseConnection> getDatabaseConnection(@NotNull DbElement element2) throws Exception {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(72);
        }
        return DbImplUtil.getDatabaseConnection(element2, DGDepartment.UNKNOWN);
    }

    @Nullable
    public static GuardedRef<DatabaseConnection> getDatabaseConnection(@NotNull DbElement element2, @NotNull DatabaseDepartment department) throws Exception {
        DatabaseSystem ds;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(73);
        }
        if (department == null) {
            DbImplUtil.$$$reportNull$$$0(74);
        }
        if (!((ds = element2.getDataSource().getDelegate()) instanceof LocalDataSource)) {
            return null;
        }
        SearchPath path = SearchPath.of((ObjectPath)ObjectPaths.of((DasObject)DasUtil.getNamespace((DasObject)element2)));
        Project project = element2.getProject();
        LocalDataSource localDataSource = (LocalDataSource)ds;
        GuardedRef<DatabaseConnection> connection2 = DatabaseSessionManager.facade(project, localDataSource, path, null, department).connect();
        JdbcUtil.setCatalogSafe((Connection)connection2.get().getJdbcConnection(), (String)DasUtil.getCatalog((DasObject)element2));
        return connection2;
    }

    public static boolean isRemoteProcessDown(@NotNull Throwable e) {
        if (e == null) {
            DbImplUtil.$$$reportNull$$$0(75);
        }
        if (ExceptionUtil.findCause((Throwable)e, ConnectException.class) != null) {
            return true;
        }
        UnmarshalException unmarshal = (UnmarshalException)ExceptionUtil.findCause((Throwable)e, UnmarshalException.class);
        return unmarshal != null && unmarshal.getCause() instanceof EOFException;
    }

    public static void setStatementParameter(@NotNull PreparedStatement statement, @NotNull ColumnDescriptor column2, @Nullable Object value, @NotNull Dbms dbms, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            DbImplUtil.$$$reportNull$$$0(76);
        }
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(77);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(78);
        }
        RemotePreparedStatement remoteStatement = (RemotePreparedStatement)RemoteUtil.castToRemoteNotNull((Object)statement, RemotePreparedStatement.class);
        ColumnInfo info = new ColumnInfo(column2.getJavaClassName(), column2.getTypeName(), column2.getType(), idx);
        remoteStatement.setObject(DbImplUtil.prepareValue(dbms, value), info, needsEscaping, idx);
    }

    @NotNull
    public static MetaModel getMetaModel(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(79);
        }
        MetaModel metaModel = ModelFacade.forDbms(dbms).getMetaModel();
        if (metaModel == null) {
            DbImplUtil.$$$reportNull$$$0(80);
        }
        return metaModel;
    }

    @NotNull
    public static JdbcHelper getJdbcHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(81);
        }
        JdbcHelper jdbcHelper = (JdbcHelper)JDBC_HELPER_EP.forDbms(dbms);
        if (jdbcHelper == null) {
            DbImplUtil.$$$reportNull$$$0(82);
        }
        return jdbcHelper;
    }

    @NotNull
    public static Dbms getDbms(@NotNull BasicElement element2) {
        BasicModel model;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(83);
        }
        Dbms dbms = (model = element2.getModel()) == null ? Dbms.UNKNOWN : model.getDbms();
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(84);
        }
        return dbms;
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull BasicElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(85);
        }
        ModelHelper modelHelper = DbImplUtil.getModelHelper(DbImplUtil.getDbms(element2));
        if (modelHelper == null) {
            DbImplUtil.$$$reportNull$$$0(86);
        }
        return modelHelper;
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(87);
        }
        ModelHelper modelHelper = ModelFacade.forDbms(dbms).getModelHelper();
        if (modelHelper == null) {
            DbImplUtil.$$$reportNull$$$0(88);
        }
        return modelHelper;
    }

    public static CascadeRule asCascadeRule(DasForeignKey.RuleAction ac) {
        if (ac == DasForeignKey.RuleAction.CASCADE) {
            return CascadeRule.cascade;
        }
        if (ac == DasForeignKey.RuleAction.NO_ACTION) {
            return CascadeRule.no_action;
        }
        if (ac == DasForeignKey.RuleAction.RESTRICT) {
            return CascadeRule.restrict;
        }
        if (ac == DasForeignKey.RuleAction.SET_DEFAULT) {
            return CascadeRule.set_default;
        }
        if (ac == DasForeignKey.RuleAction.SET_NULL) {
            return CascadeRule.set_null;
        }
        return CascadeRule.no_action;
    }

    public static <T extends BasicModNamedElement> ModNamingFamily<T> familyOf(@Nullable BasicModElement element2, @NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtil.$$$reportNull$$$0(89);
        }
        Family res2 = element2 == null ? null : element2.familyOf(kind);
        return res2 instanceof ModNamingFamily ? (ModNamingFamily)res2 : null;
    }

    public static void resolveKey(@NotNull BasicModForeignKey fkey, @NotNull List<String> refColNames) {
        BasicTableOrView table;
        if (fkey == null) {
            DbImplUtil.$$$reportNull$$$0(90);
        }
        if (refColNames == null) {
            DbImplUtil.$$$reportNull$$$0(91);
        }
        if (!refColNames.isEmpty() && (table = fkey.getRefTable()) != null) {
            for (BasicKey key2 : JBIterable.from(table.familyOf(ObjectKind.KEY)).filter(BasicKey.class)) {
                if (!refColNames.equals(key2.getColNames())) continue;
                fkey.setRefKeyName(key2.getName());
                return;
            }
        }
        fkey.setRefKeyName(null);
    }

    public static boolean isSchemaDbMode(BasicModModel model, Dbms family) {
        return model.getRoot().familyOf(ObjectKind.DATABASE) == null && family.isMysql();
    }

    public static Casing getCasing(@NotNull Dbms dbms, @NotNull DatabaseMetaData metaData) throws SQLException {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(92);
        }
        if (metaData == null) {
            DbImplUtil.$$$reportNull$$$0(93);
        }
        boolean supportsMixedCase = metaData.supportsMixedCaseIdentifiers();
        boolean storesUpperCase = metaData.storesUpperCaseIdentifiers();
        boolean storesLowerCase = metaData.storesLowerCaseIdentifiers();
        boolean storesMixedCase = metaData.storesMixedCaseIdentifiers();
        boolean supportsMixedCaseQuoted = metaData.supportsMixedCaseQuotedIdentifiers();
        boolean storesUpperCaseQuoted = metaData.storesUpperCaseQuotedIdentifiers();
        boolean storesLowerCaseQuoted = metaData.storesLowerCaseQuotedIdentifiers();
        boolean storesMixedCaseQuoted = metaData.storesMixedCaseQuotedIdentifiers();
        Case plain = DbImplUtil.getCaseMode(dbms, supportsMixedCase, storesLowerCase, storesUpperCase, storesMixedCase);
        Case quoted = DbImplUtil.getCaseMode(dbms, supportsMixedCaseQuoted, storesLowerCaseQuoted, storesUpperCaseQuoted, storesMixedCaseQuoted);
        return Casing.create((Case)plain, (Case)quoted);
    }

    private static Case getCaseMode(@NotNull Dbms dbms, boolean sensitive, boolean forceLower, boolean forceUpper, boolean asIs) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(94);
        }
        if (sensitive && asIs) {
            return dbms.isSqlite() || dbms.isMicrosoft() ? Case.MIXED : Case.EXACT;
        }
        return asIs && dbms.isSybase() || sensitive ? Case.EXACT : (forceLower ? Case.LOWER : (forceUpper && !dbms.isMysql() ? Case.UPPER : Case.MIXED));
    }

    @Nullable
    public static Object prepareValue(@NotNull Dbms family, @Nullable Object value) {
        if (family == null) {
            DbImplUtil.$$$reportNull$$$0(95);
        }
        return value == null || value == ReservedCellValue.NULL ? null : (value instanceof JdbcInjectable ? ((JdbcInjectable)value).injection(family) : (value instanceof ObjectFormatter.ImageInfo ? (JdbcInjection)((ObjectFormatter.ImageInfo)value).bytes : (value instanceof ObjectFormatter.TextInfo ? (JdbcInjection)((ObjectFormatter.TextInfo)value).bytes : (value instanceof BitString ? (JdbcInjection)((BitString)value).getBytes() : (value instanceof Date ? DbImplUtil.prepareDate(family, (Date)value) : value)))));
    }

    @NotNull
    private static Object prepareDate(@NotNull Dbms dbms, @NotNull Date value) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(96);
        }
        if (value == null) {
            DbImplUtil.$$$reportNull$$$0(97);
        }
        Date date = dbms.isClickHouse() ? value : (value instanceof Timestamp ? value : (value instanceof Time ? value : new JdbcInjection.DateInjection(Calendar.getInstance(), JdbcNativeUtil.createSqlDate((Date)value))));
        if (date == null) {
            DbImplUtil.$$$reportNull$$$0(98);
        }
        return date;
    }

    public static boolean canInsertBlob(@NotNull DataConsumer.Column column2) {
        int type;
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(99);
        }
        return (type = ExtractorsUtil.guessJdbcType(column2)) == -2 || type == 2004 || type == -4 || type == -3;
    }

    public static boolean canInsertClob(@NotNull DataConsumer.Column column2) {
        int type;
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(100);
        }
        return (type = ExtractorsUtil.guessJdbcType(column2)) == 2005 || type == 2011 || type == -1 || type == -16 || type == -15 || type == 1 || type == 12 || type == -9 || type == 2009;
    }

    public static LobInfo.FileClobInfo clobFromFile(@NotNull VirtualFile virtualFile) {
        Charset encoding;
        if (virtualFile == null) {
            DbImplUtil.$$$reportNull$$$0(101);
        }
        String charset = (encoding = EncodingManager.getInstance().getEncoding(virtualFile, true)) != null ? encoding.name() : null;
        File file = new File(virtualFile.getPath());
        return new LobInfo.FileClobInfo(file, charset);
    }

    @NotNull
    public static LobInfo.FileBlobInfo blobFromFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DbImplUtil.$$$reportNull$$$0(102);
        }
        LobInfo.FileBlobInfo fileBlobInfo = new LobInfo.FileBlobInfo(new File(virtualFile.getPath()));
        if (fileBlobInfo == null) {
            DbImplUtil.$$$reportNull$$$0(103);
        }
        return fileBlobInfo;
    }

    public static void tryLoadFirstNRows(DatabaseConnection connection2, String query, StringBuilder sb, int rows) {
        try {
            DbImplUtil.tryLoadFirstNRows("", connection2, query, CharOut.Util.newSink(sb), rows);
        }
        catch (Exception e) {
            DbImplUtil.exceptionToHtml(e, "Unable to load table data", sb);
        }
    }

    public static void tryLoadFirstNRows(String title, DatabaseConnection connection2, String query, CharOut sb, int rows) throws Exception {
        if (connection2 == null) {
            return;
        }
        SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<ResultSet, Exception>)((ThrowableConsumer)rs -> {
            ObjectFormatter converter = new ObjectFormatter(){

                @Override
                @Nullable
                public String objectToString(@Nullable Object o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                    Object o1 = 1.objectToObject(o, column2);
                    if (o1 instanceof ObjectFormatter.ImageInfo) {
                        ObjectFormatter.ImageInfo info = (ObjectFormatter.ImageInfo)o1;
                        o1 = new ObjectFormatter.ImageInfo(info.format, info.width, info.height, info.size, null);
                    }
                    return super.objectToString(o1, column2, dbms, forDisplay);
                }
            };
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(DocumentationComponent.COLOR_KEY.getDefaultColor(), converter){

                @Override
                protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms, boolean forDisplay) {
                    String unescaped;
                    if (row == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (column2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (dbms == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return this.escapeChars((unescaped = super.getValueAsString(2.getOriginalRow(row, column2), 2.getOriginalColumn(row, column2), dbms, forDisplay, false)) != null && unescaped.length() > 50 ? unescaped.substring(0, 50) + "..." : unescaped);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "row";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "column";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dbms";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/util/DbImplUtil$2";
                    objectArray[2] = "getValueAsString";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            DbImplUtil.resultSetToString(title, rs, rows, connection2.getDbms(), extractor, sb);
        })));
    }

    public static StringBuilder exceptionToHtml(Exception e, String str, StringBuilder sb) {
        sb.append(str).append(":<br>");
        sb.append("<code>").append(e).append("</code><br>");
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadViewDefinition(ConnectionProvider provider, @NotNull DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(104);
        }
        if (!(dialect = DbImplUtil.getDatabaseDialect((DbElement)element2)).supportsViewDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            Dbms dbms = element2.getDataSource().getDbms();
            Pair<String, ConcatenationProps> query = dialect.sqlViewDefinition((DasObject)element2);
            int initialLength = sb.length();
            DbImplUtil.concatStringResults(provider.getConnection(), dbms, 0, (String)query.first, sb, (ConcatenationProps)query.second);
            if (sb.length() > initialLength) {
                if (dbms.isMysql() || dbms.isPostgres() || dbms.isOracle()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false);
                    String fullDefinition = dialect.sqlCreateView(builder, (DasTable)element2, sb.substring(initialLength), "").getStatement();
                    sb.setLength(initialLength);
                    sb.append(fullDefinition);
                } else if (dbms.isDerby()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, (DasTable)element2, true).getStatement() + ";\n");
                } else if (dbms.isMicrosoft()) {
                    DbImplUtil.replaceTokenInDefinition((DbElement)element2, sb, dbms, SqlCreateViewStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
                } else if (dbms.isSybase()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, (DasTable)element2, true).newLine().keyword("GO").getStatement() + "\n");
                } else if (dbms.isH2()) {
                    sb.insert(initialLength + "CREATE ".length(), "OR REPLACE ");
                }
            }
        }
        finally {
            provider.release();
        }
    }

    public static DasNamespace getSearchPathObjectForSwitch(@NotNull DbDataSource dataSource, @Nullable DasObject dasObject) {
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(105);
        }
        return DbImplUtil.getSearchPathObjectForSwitch(DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource), DbImplUtil.getDatabaseDialect((DbElement)dataSource), dasObject);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@Nullable LocalDataSource dataSource, @NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        DatabaseDriver.SchemaControl control;
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(106);
        }
        if (dasObject == null) {
            return null;
        }
        DatabaseDriver.SchemaControl schemaControl = control = dataSource == null ? DatabaseDriver.SchemaControl.AUTOMATIC : dataSource.getSchemaControl();
        if (control != DatabaseDriver.SchemaControl.AUTOMATIC) {
            if (!dialect.getDbms().isPostgres()) {
                return null;
            }
            DasNamespace object = DbImplUtil.getSearchPathObject(dialect, dasObject);
            if (dasObject.getKind() == ObjectKind.DATABASE) {
                return (DasNamespace)ObjectUtils.tryCast((Object)dasObject, DasNamespace.class);
            }
            if (object == null || object.getKind() != ObjectKind.SCHEMA) {
                return object;
            }
            return (DasNamespace)ObjectUtils.tryCast((Object)object.getDasParent(), DasNamespace.class);
        }
        return DbImplUtil.getSearchPathObject(dialect, dasObject);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@Nullable DbElement element2) {
        return element2 == null ? null : DbImplUtil.getSearchPathObjectForSwitch(element2.getDataSource(), (DasObject)element2);
    }

    @Nullable
    public static DasNamespace getSearchPathObject(@NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(107);
        }
        if (dialect.getDbms().isSqlite()) {
            return (DasNamespace)ObjectUtils.tryCast((Object)DasUtil.getSchemaObject((DasObject)dasObject), DasNamespace.class);
        }
        ObjectKind kind = dialect.getSearchPathObjectKind();
        List<ObjectKind> path = kind == null ? null : (List<ObjectKind>)dialect.getMetaModel().getPathsToRoot(kind).first();
        List<ObjectKind> pathsToRoot = path == null ? Collections.singletonList(kind) : path;
        return kind == null ? null : (DasNamespace)DasUtil.dasParents((DasObject)dasObject).filter(DasNamespace.class).find(o -> pathsToRoot.contains(o.getKind()));
    }

    @Nullable
    public static DasNamespace getSearchPathObject(@Nullable DbElement element2) {
        return element2 == null ? null : DbImplUtil.getSearchPathObject(DbImplUtil.getDatabaseDialect(element2), (DasObject)element2);
    }

    public static DdlBuilder endStatement(@NotNull DdlBuilder builder) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(108);
        }
        if (builder.getDialect().getDbms().isTransactSql()) {
            builder.newLine().keyword("go").newStatement();
        } else {
            builder.newStatement();
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void tryLoadProcedureDefinition(@NotNull ConnectionProvider provider, @NotNull DbRoutine element2, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            DbImplUtil.$$$reportNull$$$0(109);
        }
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(110);
        }
        if (sb == null) {
            DbImplUtil.$$$reportNull$$$0(111);
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
        if (!provider.acquire()) {
            provider.release();
            return;
        }
        String fromDialect = dialect.tryToLoadProcedureDefinition((DasRoutine)element2, provider.getConnection());
        if (StringUtil.isNotEmpty((String)fromDialect)) {
            sb.append(fromDialect);
            provider.release();
            return;
        }
        if (!dialect.supportsProcedureDefinition()) {
            return;
        }
        Dbms dbms = DbImplUtil.getDbms((DbElement)element2);
        Pair<String, ConcatenationProps> query = dialect.sqlProcedureDefinition((DasRoutine)element2);
        StringBuilder definition = DbImplUtil.concatStringResults(provider.getConnection(), dbms, (String)query.first, 0, new StringBuilder(), (ConcatenationProps)query.second);
        if (StringUtil.isEmptyOrSpaces((String)definition.toString())) return;
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false);
        if (dbms.isOracle()) {
            definition.insert(0, builder.keywords("create", "or", "replace").space().getStatement());
        } else if (dbms.isH2()) {
            definition.insert(0, builder.keywords("create", "alias").space().qualifiedRef((DasObject)element2).space().keyword("as").space().symbol("$$").getStatement()).append("$$");
        } else if (dbms.isDb2()) {
            definition.insert(0, dialect.sqlDropProcedure(builder, (DasRoutine)element2).getStatement() + ";\n");
        } else if (dbms.isMicrosoft()) {
            DbImplUtil.replaceTokenInDefinition((DbElement)element2, definition, dbms, SqlCreateStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
        } else if (dbms.isSybase()) {
            builder.keyword("drop").space().keyword(StringUtil.startsWithIgnoreCase((String)definition.toString().trim(), (String)"create function") ? "function" : "procedure").space();
            dialect.qualifiedIdentifier(builder, element2.getName(), (DasObject)element2, (DasObject)element2);
            builder.newLine();
            builder.keyword("go").newLine();
            definition.insert(0, builder.getStatement());
        }
        String trim = definition.toString().trim();
        sb.append(trim);
        if (dbms.isTransactSql()) {
            sb.append(DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false).clear().newLine().keyword("go").getStatement());
            return;
        }
        if (trim.endsWith(";")) return;
        sb.append(";");
        return;
    }

    private static void replaceTokenInDefinition(@NotNull DbElement element2, @NotNull StringBuilder sb, @NotNull Dbms dbms, @NotNull Class<? extends SqlDefinition> defClazz, @NotNull SqlTokenType fromToken, @NotNull SqlTokenType toToken) {
        SqlFile psi;
        SyntaxTraverser st;
        PsiElement keyword;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(112);
        }
        if (sb == null) {
            DbImplUtil.$$$reportNull$$$0(113);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(114);
        }
        if (defClazz == null) {
            DbImplUtil.$$$reportNull$$$0(115);
        }
        if (fromToken == null) {
            DbImplUtil.$$$reportNull$$$0(116);
        }
        if (toToken == null) {
            DbImplUtil.$$$reportNull$$$0(117);
        }
        if ((keyword = (PsiElement)(st = SyntaxTraverser.psiTraverser((PsiElement)(psi = SqlPsiFacade.getInstance((Project)element2.getProject()).createROFile(DbSqlUtil.getSqlDialect(dbms), (CharSequence)sb.toString())))).traverse().skipWhile(Conditions.notInstanceOf(defClazz)).filter(Conditions.compose((Function)st.api.TO_TYPE, (Condition)Conditions.equalTo((Object)fromToken))).first()) != null) {
            TextRange r = st.api.rangeOf((Object)keyword);
            int i0 = r.getStartOffset();
            int i1 = r.getEndOffset();
            String replacement = ((Case)ObjectUtils.notNull((Object)Case.forString((String)sb.substring(i0, i1)), (Object)Case.EXACT)).apply(toToken.toString());
            sb.replace(i0, i1, replacement);
        }
    }

    public static boolean isDataTable(@Nullable DasTable info) {
        if (info == null) {
            return false;
        }
        return DbImplUtil.isDataTable(info.getKind());
    }

    public static boolean isDataTable(@Nullable ObjectKind kind) {
        return ArrayUtil.contains((Object)kind, (Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.FOREIGN_TABLE, ObjectKind.VIRTUAL_TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW});
    }

    public static boolean isEditableTable(@NotNull Dbms dbms, @Nullable ObjectKind kind) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(118);
        }
        return kind == ObjectKind.TABLE || kind == ObjectKind.VIRTUAL_TABLE || kind == ObjectKind.FOREIGN_TABLE && !dbms.isRedshift();
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull DbElement element2) {
        DbDataSource dataSource;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(119);
        }
        DatabaseDialectEx databaseDialectEx = (dataSource = element2.getDataSource()) instanceof DbDataSourceImpl ? ((DbDataSourceImpl)dataSource).getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(120);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static Dbms getDbms(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(121);
        }
        Dbms dbms = element2.getDataSource().getDbms();
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(122);
        }
        return dbms;
    }

    @NotNull
    public static Dbms getDbms(@NotNull JdbcConsole console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(123);
        }
        Dbms dbms = console.getDataSource().getDbms();
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(124);
        }
        return dbms;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull JdbcConsole console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(125);
        }
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(console.getDataSource());
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(126);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull RawConnectionConfig connectionInfo) {
        if (connectionInfo == null) {
            DbImplUtil.$$$reportNull$$$0(127);
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(connectionInfo), (Object)DatabaseDialects.getGenericDialect());
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(128);
        }
        return databaseDialectEx;
    }

    @Nullable
    public static DatabaseDialectEx guessDatabaseDialect(@Nullable RawConnectionConfig connectionInfo) {
        Dbms dbms = DbImplUtil.guessDbms(connectionInfo);
        return DbImplUtil.guessDatabaseDialect(dbms);
    }

    @NotNull
    public static Dbms guessDbms(@Nullable RawConnectionConfig connectionInfo) {
        Dbms dbms = connectionInfo instanceof DasDataSource ? ((DasDataSource)connectionInfo).getDbms() : Dbms.forConnection((RawConnectionConfig)connectionInfo);
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(129);
        }
        return dbms;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable Dbms dbms) {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.chooseNotNull((Object)DbImplUtil.guessDatabaseDialect(dbms), (Object)DatabaseDialects.getGenericDialect());
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(130);
        }
        return databaseDialectEx;
    }

    @Nullable
    public static DatabaseDialectEx guessDatabaseDialect(@Nullable Dbms dbms) {
        return dbms == Dbms.UNKNOWN || dbms == null ? null : DatabaseDialects.findByDbms(dbms);
    }

    @Nullable
    public static DatabaseDialect guessDatabaseDialect(@Nullable DasObject object) {
        return DbImplUtil.guessDatabaseDialect(DbImplUtil.guessDbms(object));
    }

    @Nullable
    public static Dbms guessDbms(@Nullable DasObject object) {
        Language language;
        BasicModel model;
        DasObject o;
        Object object2 = o = object instanceof DbElement ? ((DbElement)object).getDelegate() : object;
        Dbms dbms = o instanceof BasicElement ? ((model = ((BasicElement)o).getModel()) == null ? null : model.getDbms()) : (o instanceof SqlElement ? ((language = ((SqlElement)o).getContainingFile().getLanguage()) instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDbms() : null) : null);
        return dbms;
    }

    public static boolean supportsDynamicSchemaSwitching(@NotNull LocalDataSource dataSource) {
        DatabaseDialectEx dialect;
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(131);
        }
        return (dialect = DbImplUtil.guessDatabaseDialect(dataSource)) == null || !dataSource.getDbms().isMysql() || !dataSource.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadPackageDefinition(ConnectionProvider provider, @NotNull DbPackage element2, boolean spec, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(132);
        }
        if (!(dialect = DbImplUtil.getDatabaseDialect((DbElement)element2)).supportsPackageDefinition()) {
            return;
        }
        Dbms dbms = element2.getDataSource().getDbms();
        try {
            if (!provider.acquire()) {
                return;
            }
            Pair<String, ConcatenationProps> query = spec ? dialect.sqlPackageDefinition((DasObject)element2) : dialect.sqlPackageBodyDefinition((DasObject)element2);
            StringBuilder def2 = DbImplUtil.concatStringResults(provider.getConnection(), dbms, (String)query.first, 0, new StringBuilder(), (ConcatenationProps)query.second);
            Case caseMode = (Case)ObjectUtils.notNull((Object)Case.forString((String)def2.substring(0, Math.min(sb.length(), 7))), (Object)Case.EXACT);
            if (StringUtil.startsWith((CharSequence)def2, (CharSequence)"package") || StringUtil.startsWith((CharSequence)def2, (CharSequence)"PACKAGE")) {
                def2.insert(0, caseMode.apply("CREATE OR REPLACE "));
            }
            sb.append((CharSequence)def2);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSequenceDefinition(ConnectionProvider provider, DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
        if (!dialect.supportsSequenceDefinition()) {
            return;
        }
        Dbms dbms = element2.getDataSource().getDbms();
        StringBuilder builder = new StringBuilder();
        String drop = dialect.sqlDropSequence(DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false), (DasObject)element2, false).getStatement() + ";\n";
        builder.append(drop);
        try {
            if (!provider.acquire()) {
                return;
            }
            Pair<String, ConcatenationProps> query = dialect.sqlSequenceDefinition((DasObject)element2);
            DbImplUtil.concatStringResults(provider.getConnection(), dbms, (String)query.first, 0, builder, (ConcatenationProps)query.second);
            sb.append((CharSequence)builder);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadTableDefinition(ConnectionProvider provider, DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = dialect.tryToLoadTableDefinition((DasTable)element2, provider.getConnection());
            if (!StringUtil.isEmptyOrSpaces((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> tryLoadTableInfo(ConnectionProvider provider, DbTable element2) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
        if (!dialect.supportsTableInfo()) {
            return Collections.emptyMap();
        }
        try {
            if (!provider.acquire()) {
                Map<String, Object> map = Collections.emptyMap();
                return map;
            }
            Map<String, Object> map = dialect.tryToLoadTableInfo(element2, provider.getConnection());
            return map;
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSynonymDefinition(ConnectionProvider provider, DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = dialect.tryToLoadSynonymDefinition((DasTable)element2, provider.getConnection());
            if (!StringUtil.isEmpty((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    @Nullable
    public static String getCustomTypeShortDescription(@Nullable Object delegate) {
        JBIterable names;
        if (delegate instanceof DasTypedObject) {
            DataType type = ((DasTypedObject)delegate).getDataType();
            if (type != DataType.UNKNOWN) {
                return DbPresentation.arrow() + " " + type.toString();
            }
        } else if (delegate instanceof DasTable && !(names = DasUtil.getColumns((DasObject)((DasTable)delegate)).transform(DasUtil.TO_NAME)).isEmpty()) {
            return "(" + StringUtil.join((Iterable)names, (String)", ") + ')';
        }
        return null;
    }

    public static boolean isDatabaseVirtualFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return DbSrcUtils.isDbSrcFile(file) || file instanceof DatabaseElementVirtualFileImpl;
    }

    @Nullable
    public static DbDataSource findDataSource(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(133);
        }
        if (DbSrcUtils.isDbSrcFile(file)) {
            return DbPsiFacade.getInstance((Project)project).findDataSource(DbSrcUtils.getDataSource(file));
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            return dbFile.findDataSource(project);
        }
        return null;
    }

    @Nullable
    public static DbElement findElement(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(134);
        }
        if (DbSrcUtils.isDbSrcFile(file)) {
            return DbSrcUtils.findDbElement(project, file.getPath(), DbElement.class);
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).findElement(project);
        }
        return null;
    }

    @Nullable
    public static ObjectKind getKind(@NotNull VirtualFile file) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(135);
        }
        if (DbSrcUtils.isDbSrcFile(file)) {
            return DbSrcUtils.getKind(file.getPath());
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).getObjectKind();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceVirtualFile(@NotNull DbElement o, boolean refresh) {
        if (o == null) {
            DbImplUtil.$$$reportNull$$$0(136);
        }
        ObjectKind kind = o.getKind();
        VirtualFile file = DbImplUtil.findVirtualFileInSourceStorage(o, false, refresh);
        if (file != null) {
            return file;
        }
        if (kind == ObjectKind.NONE || kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA) {
            return null;
        }
        if (DbImplUtil.isDataTable(kind)) {
            return DatabaseElementVirtualFileImpl.findFile(o, true);
        }
        return o.getVirtualFile();
    }

    @Nullable
    public static VirtualFile findVirtualFileInSourceStorage(@Nullable DbElement o, boolean original, boolean refresh) {
        VirtualFile vf;
        Object delegate;
        Object object = delegate = o != null ? o.getDelegate() : null;
        if (delegate instanceof BasicSourceAware && (vf = DbSrcUtils.findDbSrcFile(o.getDataSource(), o, refresh)) != null) {
            return original ? DbSrcFileSystem.getInstance().getBaseFile(vf, false) : vf;
        }
        return null;
    }

    @Nullable
    public static String loadDefinitionFromStorage(@Nullable DbElement o) {
        VirtualFile file = DbImplUtil.findVirtualFileInSourceStorage(o, true, false);
        if (file == null) {
            return null;
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean canSwitchTo(@NotNull SearchPath to, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(137);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(138);
        }
        return dialect.sqlSetSearchPath(to) != null;
    }

    @Nullable
    public static String getSearchPathSql(@NotNull SearchPath to, @NotNull LocalDataSource dataSource, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(139);
        }
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(140);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(141);
        }
        if (dataSource.getSchemaControl() == DatabaseDriver.SchemaControl.FORBID) {
            return null;
        }
        String setSchemaSql = dialect.sqlSetSearchPath(to);
        if (setSchemaSql != null) {
            return setSchemaSql;
        }
        ObjectPath current = to.getCurrent();
        ObjectPath db = current.kind != ObjectKind.SCHEMA ? null : current.findParent(ObjectKind.DATABASE, true);
        return db == null ? null : dialect.sqlSetSearchPath(SearchPath.of((ObjectPath)db));
    }

    public static boolean switchSchemaThroughJdbc(@NotNull SearchPath path, @NotNull DatabaseConnection connection2, @NotNull LocalDataSource dataSource) throws SQLException {
        if (path == null) {
            DbImplUtil.$$$reportNull$$$0(142);
        }
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(143);
        }
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(144);
        }
        if (dataSource.getSchemaControl() == DatabaseDriver.SchemaControl.FORBID || !dataSource.getDbms().isClickHouse()) {
            return false;
        }
        ObjectPath schema = path.getCurrent().findParent(ObjectKind.SCHEMA, false);
        if (schema == null) {
            return false;
        }
        String name = schema.name;
        connection2.getJdbcConnection().setCatalog(name);
        return true;
    }

    @NotNull
    public static <T extends ColumnDescriptor> List<T> getWhereClauseColumns(@Nullable DasTable table, @NotNull List<T> descriptors, @NotNull Dbms dbms) {
        if (descriptors == null) {
            DbImplUtil.$$$reportNull$$$0(145);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(146);
        }
        DasTableKey primaryKey = table == null ? null : DasUtil.getPrimaryKey((DasTable)table);
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)descriptors.size());
        if (primaryKey != null) {
            THashSet set = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            ContainerUtil.addAll((Collection)set, (Iterable)primaryKey.getColumnsRef().names());
            result2.addAll(ContainerUtil.filter(descriptors, arg_0 -> DbImplUtil.lambda$getWhereClauseColumns$5((Set)set, arg_0)));
        }
        if (!result2.isEmpty()) {
            ArrayList arrayList = result2;
            if (arrayList == null) {
                DbImplUtil.$$$reportNull$$$0(147);
            }
            return arrayList;
        }
        result2.addAll(ContainerUtil.filter(descriptors, descriptor -> {
            if (dbms == null) {
                DbImplUtil.$$$reportNull$$$0(201);
            }
            return DbImplUtil.isSuitable(descriptor, dbms);
        }));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DbImplUtil.$$$reportNull$$$0(148);
        }
        return arrayList;
    }

    public static boolean supportsDomainAuth(@Nullable DatabaseDriver driver) {
        return SystemInfo.isWindows && driver != null && ("sqlserver.ms".equals(driver.getId()) || "sqlserver.jtds".equals(driver.getId()) || "com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driver.getDriverClass()) || "net.sourceforge.jtds.jdbc.Driver".equals(driver.getDriverClass()));
    }

    public static boolean isSchema(@NotNull DasObject object) {
        if (object == null) {
            DbImplUtil.$$$reportNull$$$0(149);
        }
        return DbImplUtil.isSchema(object.getKind());
    }

    public static boolean isSchema(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtil.$$$reportNull$$$0(150);
        }
        return kind == ObjectKind.SCHEMA || kind == ObjectKind.EXTERNAL_SCHEMA;
    }

    public static boolean isRoutine(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtil.$$$reportNull$$$0(151);
        }
        return kind == ObjectKind.ROUTINE || kind == ObjectKind.AGGREGATE;
    }

    @Nullable
    public static DasNamespace getTopSingleNamespace(@Nullable DasObject object) {
        ObjectKind kind;
        ObjectKind objectKind = kind = object == null ? null : object.getKind();
        if (kind != ObjectKind.ROOT && kind != ObjectKind.DATABASE) {
            return (DasNamespace)DasUtil.dasParents((DasObject)object).filter(DasNamespace.class).first();
        }
        JBIterable ns = ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)object)).expand(Conditions.compose((Function)DasUtil.TO_KIND, k -> k == ObjectKind.ROOT || k == ObjectKind.DATABASE))).traverse();
        DasObject result2 = (DasObject)ns.filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA)).single();
        if (result2 == null) {
            result2 = (DasObject)ns.filter(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).single();
        }
        return result2 instanceof DasNamespace ? (DasNamespace)result2 : null;
    }

    public static boolean supportsReadOnlyChangeOnTheFly(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(152);
        }
        return !dbms.isSqlite();
    }

    public static boolean supportsReadOnlyChangeDuringTx(@NotNull Dbms family) {
        if (family == null) {
            DbImplUtil.$$$reportNull$$$0(153);
        }
        return family == Dbms.MYSQL;
    }

    @Nullable
    public static DbDataSource findDataSourceByFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(154);
        }
        if (file == null) {
            return null;
        }
        for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            String adjusted;
            LocalDataSource d2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource);
            JdbcUrlParser parsed = JdbcUrlParserUtil.parsed(d2);
            String path = parsed == null ? null : parsed.getParameter("file");
            if (path == null || !Comparing.equal((String)(adjusted = FileUtil.toSystemIndependentName((String)PathManager.getAbsolutePath((String)path))), (String)file.getPath())) continue;
            return dataSource;
        }
        return null;
    }

    public static String concatStringResults(DatabaseConnection connection2, Dbms dbms, String query, int forcedColumn, ConcatenationProps props) throws SQLException {
        return DbImplUtil.concatStringResults(connection2, dbms, query, forcedColumn, new StringBuilder(), props).toString().trim();
    }

    public static StringBuilder concatStringResults(DatabaseConnection connection2, Dbms dbms, int forcedColumn, String query, StringBuilder sb, ConcatenationProps props) throws SQLException {
        return DbImplUtil.concatStringResults(connection2, dbms, query, forcedColumn, sb, props);
    }

    public static StringBuilder concatStringResults(DatabaseConnection connection2, Dbms dbms, String query, int forcedColumn, StringBuilder sb, ConcatenationProps props) throws SQLException {
        SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.allResults((ThrowableConsumer<ResultSet, Exception>)((ThrowableConsumer)rs -> DbImplUtil.concatStringResults(rs, dbms, forcedColumn, sb, props))));
        return sb;
    }

    protected static void concatStringResults(ResultSet rs, Dbms dbms, int forcedColumn, StringBuilder sb, ConcatenationProps props) throws SQLException {
        int trimmedLen;
        DataConsumer.Column[] columns = JdbcEngine.getColumnDescriptors(rs, dbms);
        int columnCount = columns.length;
        int start = sb.length();
        while (rs.next()) {
            if (start != sb.length()) {
                sb.append(props.rowSep);
            }
            int rowStart = sb.length();
            for (int i2 = forcedColumn > 0 ? forcedColumn : 1; i2 <= (forcedColumn > 0 ? forcedColumn : columnCount); ++i2) {
                CharSequence s = DbImplUtil.extractString(rs.getObject(i2));
                if (s == null) continue;
                if (props.lTrim) {
                    s = StringUtil.trimLeading((CharSequence)s);
                }
                if (props.rTrim) {
                    s = StringUtil.trimTrailing((CharSequence)s);
                }
                if (rowStart != sb.length()) {
                    sb.append(props.colSep);
                }
                sb.append(s);
            }
        }
        for (trimmedLen = sb.length(); trimmedLen != 0 && sb.charAt(trimmedLen - 1) == ' '; --trimmedLen) {
        }
        sb.setLength(trimmedLen);
    }

    @Nullable
    private static CharSequence extractString(@Nullable Object object) throws SQLException {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return clob.getSubString(1L, (int)clob.length());
        }
        return null;
    }

    public static <T> T executeAndGetResult(DatabaseConnection connection2, String query, ThrowableConvertor<ResultSet, T, SQLException> result2) throws SQLException {
        return SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.resultsTransformer(result2));
    }

    public static long getCount(@NotNull DatabaseConnection connection2, @NotNull String query) throws SQLException {
        Runnable exception;
        Long result2;
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(155);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(156);
        }
        if ((result2 = (Long)DbImplUtil.executeAndGetResult(connection2, query, arg_0 -> DbImplUtil.lambda$getCount$10(exception = () -> {
            throw new AssertionError((Object)"Incorrect count query!");
        }, arg_0))) == null) {
            exception.run();
        }
        return result2;
    }

    public static Map<String, Object> resultRowAsMap(DatabaseConnection connection2, String query, String ... columnSelection) throws SQLException {
        return SmartStatements.poweredBy(connection2).simple().noisy().execute(query, StandardResultsProcessors.resultsTransformer(rs -> {
            if (!rs.next()) {
                return Collections.emptyMap();
            }
            Map result2 = JdbcUtil.resultSetRowToMapSafe((ResultSet)rs);
            if (columnSelection.length > 0 && !result2.isEmpty()) {
                assert (columnSelection.length % 2 == 0);
                LinkedHashMap map = ContainerUtil.newLinkedHashMap();
                for (int i2 = 0; i2 < columnSelection.length; i2 += 2) {
                    Object o = result2.get(columnSelection[i2]);
                    if (o == null) continue;
                    map.put(columnSelection[i2 + 1], o);
                }
                result2 = map;
            }
            return result2;
        }, Collections.emptyMap()));
    }

    @Nullable
    public static DbDataSource getForcedDataSource(@Nullable PsiFile psiFile) {
        DbDataSource element2;
        VirtualFileSystem fileSystem;
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = virtualFile = psiFile == null ? null : psiFile.getViewProvider().getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = PsiUtilCore.getVirtualFile((PsiElement)InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getTopLevelFile((PsiElement)psiFile));
        }
        VirtualFileSystem virtualFileSystem = fileSystem = virtualFile == null ? null : virtualFile.getFileSystem();
        if (virtualFile == null) {
            element2 = null;
        } else if (virtualFile instanceof DatabaseElementVirtualFileImpl) {
            element2 = ((DatabaseElementVirtualFileImpl)virtualFile).findDataSource(psiFile.getProject());
        } else if (DbConsoleRootType.isConsoleFile(virtualFile)) {
            element2 = DbConsoleRootType.getDataSource(psiFile.getProject(), virtualFile);
        } else if (fileSystem instanceof DbSrcFileSystem) {
            String dataSourceId = DbSrcUtils.getDataSource(virtualFile);
            element2 = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)psiFile.getProject()).findDataSource(dataSourceId);
        } else {
            JdbcConsole console = JdbcConsoleProvider.getAttachedConsole(psiFile.getProject(), virtualFile);
            DbDataSource dbDataSource = element2 = console == null ? (DbDataSource)DatabaseDataKeys.DATA_SOURCE_KEY.get((UserDataHolder)psiFile) : DbImplUtil.getDbDataSource(console.getProject(), console.getDataSource());
            if (element2 == null && ApplicationManager.getApplication().isUnitTestMode()) {
                return (DbDataSource)DatabaseDataKeys.DATA_SOURCE_KEY.get((UserDataHolder)virtualFile);
            }
        }
        return element2 != null && element2.isValid() ? element2 : null;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForExec(@NotNull PsiFile file, boolean ignoreForced, boolean matchingOnly) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(157);
        }
        DbDataSource forced = ignoreForced ? null : DbImplUtil.getForcedDataSource(file);
        JBIterable<DbDataSource> result2 = forced != null ? JBIterable.of((Object)forced) : DbSqlUtil.getAppropriateDataSources(file, false, matchingOnly);
        JBIterable jBIterable = result2.filter(CAN_CONNECT_TO);
        if (jBIterable == null) {
            DbImplUtil.$$$reportNull$$$0(158);
        }
        return jBIterable;
    }

    public static DdlBuilder composeWhereCondition(@NotNull DdlBuilder builder, @NotNull List<DataConsumer.Column> columns, @NotNull List<Object> values2, @NotNull Dbms dbms, @Nullable String tableAlias) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(159);
        }
        if (columns == null) {
            DbImplUtil.$$$reportNull$$$0(160);
        }
        if (values2 == null) {
            DbImplUtil.$$$reportNull$$$0(161);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(162);
        }
        for (int i2 = 0; i2 < columns.size(); ++i2) {
            if (i2 > 0) {
                builder.space().keyword("AND").space();
            }
            DataConsumer.Column column2 = columns.get(i2);
            boolean useLike = "java.lang.String".equals(column2.clazz);
            DbImplUtil.composeWhereItem(builder, column2.name, values2.get(i2), useLike, tableAlias, dbms);
        }
        return builder;
    }

    public static DdlBuilder composeWhereCondition(DdlBuilder builder, Iterable<String> names, Iterable<?> values2, String alias, Dbms dbms) {
        boolean first = true;
        Iterator<String> it1 = names.iterator();
        Iterator<?> it2 = values2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (first) {
                first = false;
            } else {
                builder.space().keyword("AND").space();
            }
            DbImplUtil.composeWhereItem(builder, it1.next(), it2.next(), true, alias, dbms);
        }
        return builder;
    }

    public static DdlBuilder composeWhereItem(@NotNull DdlBuilder builder, @NotNull String columnName, Object value, boolean useLike, String alias, @NotNull Dbms dbms) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(163);
        }
        if (columnName == null) {
            DbImplUtil.$$$reportNull$$$0(164);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(165);
        }
        if (alias != null) {
            builder.alias(alias).symbol(".");
        }
        builder.identifier(columnName).space();
        if (value == null) {
            builder.keywords("IS", "NULL");
        } else {
            JdbcHelper helper = DbImplUtil.getJdbcHelper(dbms);
            boolean isString = value instanceof String;
            boolean bl = useLike = useLike && isString && helper.supportsLike();
            if (useLike) {
                builder.keyword("LIKE");
            } else {
                builder.symbol("=");
            }
            String literal = isString ? (String)helper.escapeSql((Object)((String)value), useLike) : value.toString();
            builder.space().literal(isString ? "'" + literal.replace("'", "''") + "'" : literal);
            if (useLike && literal.indexOf(35) > -1 && helper.supportsEscape()) {
                builder.space().keyword("ESCAPE").space().plain("'#'");
            }
        }
        return builder;
    }

    @NotNull
    public static List<ColumnQueryData> composeWhereConditionWithParameters(@NotNull DdlBuilder builder, @NotNull Iterable<ColumnQueryData> datas, @Nullable String alias, @NotNull Dbms dbms) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(166);
        }
        if (datas == null) {
            DbImplUtil.$$$reportNull$$$0(167);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(168);
        }
        ArrayList parameters = ContainerUtil.newArrayList();
        boolean first = true;
        for (ColumnQueryData data : datas) {
            if (first) {
                first = false;
            } else {
                builder.space().keyword("AND").space();
            }
            ThreeState nullability = data.getObject() == null ? ThreeState.YES : ThreeState.NO;
            int placeholdersAdded = DbImplUtil.composeWhereItemWithParameters(builder, data.getColumn(), nullability, alias, dbms);
            parameters.addAll(Collections.nCopies(placeholdersAdded, data));
        }
        ArrayList arrayList = parameters;
        if (arrayList == null) {
            DbImplUtil.$$$reportNull$$$0(169);
        }
        return arrayList;
    }

    public static int composeWhereItemWithParameters(@NotNull DdlBuilder builder, @NotNull DataConsumer.Column column2, @NotNull ThreeState nullability, @Nullable String alias, @NotNull Dbms dbms) {
        boolean useLike;
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(170);
        }
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(171);
        }
        if (nullability == null) {
            DbImplUtil.$$$reportNull$$$0(172);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(173);
        }
        if (nullability == ThreeState.UNSURE) {
            builder.symbol("(");
        }
        if (DbImplUtil.isRowId(column2)) {
            builder.plain(column2.name);
        } else {
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column2.name);
        }
        builder.space();
        if (nullability == ThreeState.YES) {
            builder.keywords("IS", "NULL");
            return 0;
        }
        JdbcHelper helper = DbImplUtil.getJdbcHelper(dbms);
        boolean bl = useLike = helper.supportsLike() && "java.lang.String".equals(column2.clazz);
        if (useLike) {
            builder.keyword("LIKE");
        } else if (dbms.isPostgres() && PgJdbcHelper.isCustomOperatorType((String)column2.getTypeName())) {
            builder.symbol("~=");
        } else {
            builder.symbol("=");
        }
        builder.space().placeholder();
        if (useLike && helper.supportsEscape()) {
            builder.space().keyword("ESCAPE").space().plain("'#'");
        }
        if (nullability == ThreeState.UNSURE) {
            builder.space().keyword("OR").space().symbol("(");
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column2.name).space().keywords("IS", "NULL", "AND").space().placeholder().space().keywords("IS", "NULL");
            builder.symbol(")");
            builder.symbol(")");
            return 2;
        }
        return 1;
    }

    public static String escapeStr(String value) {
        return StringUtil.notNullize((String)value).replace("'", "''");
    }

    public static <T> T escapeSql(T value, boolean needsEscaping, @NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(174);
        }
        return (T)DbImplUtil.getJdbcHelper(dbms).escapeSql(value, needsEscaping);
    }

    public static boolean isRowId(DataConsumer.Column column2) {
        return ROW_ID == column2.table;
    }

    public static DataConsumer.Column makeRowId(DataConsumer.Column column2) {
        return new DataConsumer.Column(column2.columnNum, column2.name, column2.type, column2.typeName, column2.clazz, -1, -1, ROW_ID, ROW_ID, ROW_ID);
    }

    public static boolean isPageSizeUnlimited(int pageSize) {
        return pageSize < 1;
    }

    public static int getPageSize() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        return settings.isLimitPageSize() ? settings.getPageSize() : -1;
    }

    public static boolean writeVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute, @Nullable String value) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(175);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(176);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return false;
        }
        try {
            return DbImplUtil.writeVFSAttribute(file, attribute, value);
        }
        catch (IOException ex) {
            DataSourceUiUtil.LOG.warn((Throwable)ex);
            return false;
        }
    }

    @Nullable
    public static String readVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(177);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(178);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try {
            return DbImplUtil.readVFSAttribute(file, attribute);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean writeVFSAttribute(@NotNull VirtualFile fileOrDir, @NotNull FileAttribute attribute, @Nullable String value) throws IOException {
        String oldValue;
        if (fileOrDir == null) {
            DbImplUtil.$$$reportNull$$$0(179);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(180);
        }
        if (Comparing.equal((String)(oldValue = DbImplUtil.readVFSAttribute(fileOrDir, attribute)), (String)value)) {
            return false;
        }
        try (DataOutputStream oStream = attribute.writeAttribute(fileOrDir);){
            DataInputOutputUtil.writeINT((DataOutput)oStream, (int)myDialectAndDataSourcesEnumerator.getId((Object)StringUtil.notNullize((String)value)));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readVFSAttribute(VirtualFile fileOrDir, FileAttribute attribute) throws IOException {
        DataInputStream iStream = attribute.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                String string = StringUtil.nullize((String)((String)myDialectAndDataSourcesEnumerator.getById(DataInputOutputUtil.readINT((DataInput)iStream))));
                return string;
            }
            finally {
                iStream.close();
            }
        }
        return null;
    }

    public static boolean isAuthRequired(@NotNull LocalDataSource info) {
        if (info == null) {
            DbImplUtil.$$$reportNull$$$0(181);
        }
        return info.isAuthRequired();
    }

    public static void initLanguageComboBox(JComboBox comboBox, boolean allowNull) {
        ArrayList<SqlLanguageDialect> langs = new ArrayList<SqlLanguageDialect>();
        if (allowNull) {
            langs.add(null);
        }
        langs.addAll(SqlDialects.getTopLevelSqlDialects());
        comboBox.setModel(new CollectionComboBoxModel(langs));
        comboBox.setEditable(false);
        comboBox.setRenderer(new ListCellRendererWrapper<Language>(){

            public void customize(JList list, Language language, int index2, boolean selected, boolean hasFocus) {
                if (language == null) {
                    this.setText("<default>");
                    this.setIcon(null);
                } else {
                    if (language instanceof SqlLanguageDialect) {
                        this.setIcon(((SqlLanguageDialect)language).getIcon());
                    } else {
                        LanguageFileType fileType = language.getAssociatedFileType();
                        this.setIcon(fileType == null ? null : fileType.getIcon());
                    }
                    this.setText(language.getDisplayName());
                }
            }
        });
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(182);
        }
        return dbms == Dbms.UNKNOWN ? null : (DatabaseDriver)JBIterable.from(DatabaseDriverManager.getInstance().getDrivers()).filter(o -> {
            if (dbms == null) {
                DbImplUtil.$$$reportNull$$$0(200);
            }
            return DbImplUtil.getDbms(o) == dbms;
        }).sort((o1, o2) -> o1.isPredefined() ? (o2.isPredefined() ? 0 : -1) : (o2.isPredefined() ? 1 : 0)).first();
    }

    @NotNull
    public static Dbms getDbms(@NotNull DatabaseDriver o) {
        if (o == null) {
            DbImplUtil.$$$reportNull$$$0(183);
        }
        Dbms dbms = Dbms.fromString((String)(o.isPredefined() ? o.getId() : o.getDriverClass()));
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(184);
        }
        return dbms;
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull RawConnectionConfig info) {
        if (info == null) {
            DbImplUtil.$$$reportNull$$$0(185);
        }
        return DbImplUtil.guessDatabaseDriver(DatabaseDriverManager.getInstance().getDrivers(), info);
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull Collection<? extends DatabaseDriver> allDrivers, @NotNull RawConnectionConfig info) {
        if (allDrivers == null) {
            DbImplUtil.$$$reportNull$$$0(186);
        }
        if (info == null) {
            DbImplUtil.$$$reportNull$$$0(187);
        }
        List matchedDrivers = ContainerUtil.newSmartList();
        if (info.getDriverClass() == null) {
            matchedDrivers.addAll(allDrivers);
        } else {
            for (DatabaseDriver databaseDriver : allDrivers) {
                if (!Comparing.equal((String)info.getDriverClass(), (String)databaseDriver.getDriverClass())) continue;
                matchedDrivers.add(databaseDriver);
            }
        }
        if (matchedDrivers.isEmpty()) {
            return null;
        }
        if (matchedDrivers.size() == 1) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        String url = StringUtil.notNullize((String)info.getUrl());
        ArrayList arrayList = ContainerUtil.newArrayListWithCapacity((int)matchedDrivers.size());
        for (DatabaseDriver driver : matchedDrivers) {
            if (!driver.matchesUrl(url)) continue;
            arrayList.add(driver);
        }
        if (arrayList.isEmpty()) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        if (arrayList.size() == 1) {
            return (DatabaseDriver)arrayList.get(0);
        }
        return DbImplUtil.disambiguate(url, (JBIterable<DatabaseDriver>)JBIterable.from((Iterable)arrayList));
    }

    @Nullable
    public static DatabaseDriver disambiguate(@NotNull String url, @NotNull JBIterable<DatabaseDriver> drivers) {
        if (url == null) {
            DbImplUtil.$$$reportNull$$$0(188);
        }
        if (drivers == null) {
            DbImplUtil.$$$reportNull$$$0(189);
        }
        if (StringUtil.containsIgnoreCase((String)url, (String)"database.windows.net")) {
            return (DatabaseDriver)drivers.filter(d2 -> DbImplUtil.likelyAzureDriver(d2)).append(drivers).first();
        }
        if (StringUtil.containsIgnoreCase((String)url, (String)"redshift.amazonaws.com")) {
            return (DatabaseDriver)drivers.filter(d2 -> DbImplUtil.likelyRedshiftDriver(d2)).append(drivers).first();
        }
        return (DatabaseDriver)drivers.filter(d2 -> !DbImplUtil.likelyAzureDriver(d2) && !DbImplUtil.likelyRedshiftDriver(d2)).append(drivers).first();
    }

    private static boolean likelyRedshiftDriver(DatabaseDriver driver) {
        return StringUtil.containsIgnoreCase((String)driver.getId(), (String)"redshift") || StringUtil.containsIgnoreCase((String)driver.getName(), (String)"redshift");
    }

    private static boolean likelyAzureDriver(DatabaseDriver driver) {
        return StringUtil.containsIgnoreCase((String)driver.getId(), (String)"azure") || StringUtil.containsIgnoreCase((String)driver.getName(), (String)"azure");
    }

    @Nullable
    public static BasicElement getMaybeBasicElement(@Nullable DasObject o) {
        Object delegate = DbImplUtil.unwrap(o);
        return delegate instanceof BasicElement ? (BasicElement)delegate : null;
    }

    @Nullable
    public static LocalDataSource getMaybeLocalDataSource(@Nullable DasDataSource info) {
        DasDataSource dataSource = DbImplUtil.unwrapDS(info);
        return dataSource instanceof LocalDataSource ? (LocalDataSource)dataSource : null;
    }

    @NotNull
    public static LocalDataSource getLocalDataSource(@Nullable DasDataSource info) {
        DasDataSource dataSource = DbImplUtil.unwrapDS(info);
        if (dataSource instanceof LocalDataSource) {
            LocalDataSource localDataSource = (LocalDataSource)dataSource;
            if (localDataSource == null) {
                DbImplUtil.$$$reportNull$$$0(190);
            }
            return localDataSource;
        }
        throw new AssertionError(info);
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @Nullable String reason) {
        if (callback == null) {
            return;
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            if (done) {
                callback.setResult(null);
            } else {
                callback.setError(StringUtil.isEmptyOrSpaces((String)reason) ? "not done" : reason);
            }
        });
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done) {
        DbImplUtil.setActionCallbackDone(callback, done, null);
    }

    @NotNull
    public static EnumSet<ReservedCellValue> getSpecialValues(@Nullable DasColumn databaseColumn) {
        if (databaseColumn == null) {
            EnumSet<ReservedCellValue> enumSet = EnumSet.of(ReservedCellValue.NULL);
            if (enumSet == null) {
                DbImplUtil.$$$reportNull$$$0(191);
            }
            return enumSet;
        }
        EnumSet<ReservedCellValue> result2 = EnumSet.noneOf(ReservedCellValue.class);
        if (DasUtil.isAutoGenerated((DasColumn)databaseColumn)) {
            result2.add(ReservedCellValue.GENERATED);
        }
        if (DasUtil.isComputed((DasColumn)databaseColumn)) {
            result2.add(ReservedCellValue.COMPUTED);
        }
        if (!databaseColumn.isNotNull()) {
            result2.add(ReservedCellValue.NULL);
        }
        if (databaseColumn.getDefault() != null) {
            result2.add(ReservedCellValue.DEFAULT);
        }
        EnumSet<ReservedCellValue> enumSet = result2;
        if (enumSet == null) {
            DbImplUtil.$$$reportNull$$$0(192);
        }
        return enumSet;
    }

    public static boolean isZonedTimestampColumn(@NotNull ColumnDescriptor column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(193);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(194);
        }
        return DbImplUtil.getJdbcHelper(dbms).isZonedTimestampColumn(column2.getTypeName(), column2.getType());
    }

    public static boolean isZonedTimeColumn(@NotNull ColumnDescriptor column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(195);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(196);
        }
        return DbImplUtil.getJdbcHelper(dbms).isZonedTimeColumn(column2.getTypeName());
    }

    @Nullable
    public static DasDataSource unwrapDS(@Nullable DasDataSource database) {
        DasDataSource o;
        Object object = o = database instanceof DbDataSource ? ((DbDataSource)database).getDelegate() : database;
        if (o == null || o instanceof LocalDataSource || o instanceof SqlDataSource) {
            return o;
        }
        throw new AssertionError(database);
    }

    @Contract(value="null -> null")
    public static Object unwrap(@Nullable DasObject object) {
        Object tmp = object;
        while (tmp != null) {
            if (!(tmp instanceof DbElement)) {
                return tmp;
            }
            tmp = ((DbElement)tmp).getDelegate();
        }
        return object;
    }

    @Nullable
    public static SearchPath getAutoSwitchPath(@Nullable LocalDataSource dataSource, @Nullable SearchPath path) {
        DatabaseDriver.SchemaControl control;
        if (path == null) {
            return null;
        }
        DatabaseDriver.SchemaControl schemaControl = control = dataSource == null ? DatabaseDriver.SchemaControl.AUTOMATIC : dataSource.getSchemaControl();
        if (control == DatabaseDriver.SchemaControl.AUTOMATIC) {
            return path;
        }
        return DbImplUtil.getDatabaseToSwitch(dataSource, path);
    }

    @Nullable
    public static SearchPath getDatabaseToSwitch(@Nullable LocalDataSource dataSource, @Nullable SearchPath path) {
        return path == null ? null : SearchPath.of((ObjectPath)path.getCurrent().findParent(ObjectKind.DATABASE, false));
    }

    public static void performSrcOperation(@Nullable DasModel model, @Nullable TransactionId transactionId, boolean asyncRefresh, @NotNull Runnable runnable) {
        BasicModModel basicModel;
        DbSrcModelStorage storage;
        if (runnable == null) {
            DbImplUtil.$$$reportNull$$$0(197);
        }
        DbSrcModelStorage dbSrcModelStorage = storage = (basicModel = (BasicModModel)ObjectUtils.tryCast((Object)model, BasicModModel.class)) == null ? null : (DbSrcModelStorage)ObjectUtils.tryCast((Object)basicModel.getTextStorage(), DbSrcModelStorage.class);
        if (storage == null) {
            runnable.run();
        } else {
            try (GuardedRef ignored = storage.startWriteSession(basicModel, transactionId, asyncRefresh);){
                runnable.run();
            }
        }
    }

    private static boolean isSuitable(@NotNull ColumnDescriptor descriptor, @NotNull Dbms dbms) {
        if (descriptor == null) {
            DbImplUtil.$$$reportNull$$$0(198);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(199);
        }
        int type = descriptor.getType();
        String typeName = descriptor.getTypeName();
        return !(type == 2004 || type == 2005 || type == 2011 || StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"xml") && dbms.isMicrosoft() || type == 2009 && (dbms.isPostgres() || dbms.isOracle()) || dbms.isPostgres() && !PgBaseJdbcHelper.canCompare((String)typeName));
    }

    public static boolean isTypeKind(@Nullable ObjectKind kind) {
        return kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.COLLECTION_TYPE || kind == ObjectKind.ALIAS_TYPE || kind == ObjectKind.TABLE_TYPE;
    }

    @Nullable
    public static Version getDatabaseVersion(@Nullable DasDataSource dataSource) {
        return dataSource == null ? null : dataSource.getVersion();
    }

    private static /* synthetic */ Long lambda$getCount$10(Runnable exception, ResultSet resultSet) throws SQLException {
        if (!resultSet.next()) {
            exception.run();
        }
        return resultSet.getLong(1);
    }

    private static /* synthetic */ boolean lambda$getWhereClauseColumns$5(Set set, ColumnDescriptor descriptor) {
        return set.contains(descriptor.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 51: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 98: 
            case 103: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 147: 
            case 148: 
            case 158: 
            case 169: 
            case 184: 
            case 190: 
            case 191: 
            case 192: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 51: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 98: 
            case 103: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 147: 
            case 148: 
            case 158: 
            case 169: 
            case 184: 
            case 190: 
            case 191: 
            case 192: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lob";
                break;
            }
            case 1: 
            case 2: 
            case 25: 
            case 106: 
            case 107: 
            case 138: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseTable";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 19: 
            case 28: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 78: 
            case 79: 
            case 81: 
            case 87: 
            case 92: 
            case 94: 
            case 96: 
            case 114: 
            case 118: 
            case 146: 
            case 152: 
            case 162: 
            case 165: 
            case 168: 
            case 173: 
            case 174: 
            case 182: 
            case 194: 
            case 196: 
            case 199: 
            case 200: 
            case 201: 
            case 203: 
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 11: 
            case 15: 
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 12: 
            case 16: 
            case 161: 
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 17: 
            case 23: 
            case 52: 
            case 54: 
            case 108: 
            case 159: 
            case 163: 
            case 166: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 20: 
            case 167: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datas";
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 51: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 98: 
            case 103: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 147: 
            case 148: 
            case 158: 
            case 169: 
            case 184: 
            case 190: 
            case 191: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasTable";
                break;
            }
            case 27: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 43: 
            case 63: 
            case 66: 
            case 133: 
            case 134: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 29: 
            case 45: 
            case 49: 
            case 55: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 30: 
            case 37: 
            case 42: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 48: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 65: 
            case 71: 
            case 72: 
            case 73: 
            case 83: 
            case 85: 
            case 104: 
            case 110: 
            case 112: 
            case 119: 
            case 121: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 69: 
            case 70: 
            case 105: 
            case 131: 
            case 140: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 77: 
            case 99: 
            case 100: 
            case 171: 
            case 193: 
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 89: 
            case 150: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkey";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refColNames";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 95: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 101: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defClazz";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromToken";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toToken";
                break;
            }
            case 123: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionInfo";
                break;
            }
            case 135: 
            case 157: 
            case 175: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 136: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 137: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 143: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 176: 
            case 178: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 181: 
            case 185: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDrivers";
                break;
            }
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drivers";
                break;
            }
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectAllQueryWithParameters";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectAllQuery";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findFreeAlias";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "appendWrappedQueryTail";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "countQueryHead";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOptimizedCountQuery";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcHelper";
                break;
            }
            case 84: 
            case 122: 
            case 124: 
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 86: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelHelper";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDate";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "blobFromFile";
                break;
            }
            case 120: 
            case 126: 
            case 128: 
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDbms";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhereClauseColumns";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourcesForExec";
                break;
            }
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "composeWhereConditionWithParameters";
                break;
            }
            case 190: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalDataSource";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "clobStringEquals";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForExec";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForUIExec";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createSelectAllQuery";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSelectAllQueryWithParameters";
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 51: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 98: 
            case 103: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 147: 
            case 148: 
            case 158: 
            case 169: 
            case 184: 
            case 190: 
            case 191: 
            case 192: {
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findFreeAlias";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createSelectCountQuery";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createSelectCountQueryWithOffset";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "wrapSelectQuery";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "appendWrappedQueryTail";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "countQueryHead";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "buildOptimizedCountQuery";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getDbDataSource";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isConnected";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConnectionCount";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "hasDriverFiles";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "canConnectTo";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseConnection";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteProcessDown";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getMetaModel";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getJdbcHelper";
                break;
            }
            case 83: 
            case 121: 
            case 123: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 85: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getModelHelper";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "familyOf";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "resolveKey";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getCaseMode";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "prepareValue";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "prepareDate";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "canInsertBlob";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "canInsertClob";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "clobFromFile";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "blobFromFile";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadViewDefinition";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObjectForSwitch";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObject";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "endStatement";
                break;
            }
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadProcedureDefinition";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "replaceTokenInDefinition";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isEditableTable";
                break;
            }
            case 119: 
            case 125: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "supportsDynamicSchemaSwitching";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadPackageDefinition";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "findSourceVirtualFile";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "canSwitchTo";
                break;
            }
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathSql";
                break;
            }
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "switchSchemaThroughJdbc";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "getWhereClauseColumns";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "isSchema";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "isRoutine";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "supportsReadOnlyChangeOnTheFly";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "supportsReadOnlyChangeDuringTx";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "findDataSourceByFile";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getCount";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesForExec";
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereCondition";
                break;
            }
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereItem";
                break;
            }
            case 166: 
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereConditionWithParameters";
                break;
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereItemWithParameters";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "escapeSql";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "writeVFSAttributeSafe";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "readVFSAttributeSafe";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "writeVFSAttribute";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "isAuthRequired";
                break;
            }
            case 182: 
            case 185: 
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "guessDatabaseDriver";
                break;
            }
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "disambiguate";
                break;
            }
            case 193: 
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimestampColumn";
                break;
            }
            case 195: 
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimeColumn";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "performSrcOperation";
                break;
            }
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "lambda$guessDatabaseDriver$12";
                break;
            }
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getWhereClauseColumns$6";
                break;
            }
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSelectAllQueryWithParameters$2";
                break;
            }
            case 204: 
            case 205: 
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSelectAllQuery$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 51: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 98: 
            case 103: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 147: 
            case 148: 
            case 158: 
            case 169: 
            case 184: 
            case 190: 
            case 191: 
            case 192: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConcatenationProps {
        public String rowSep;
        public String colSep;
        public boolean lTrim;
        public boolean rTrim;
        public static final ConcatenationProps LINES = new ConcatenationProps("\n", " ", false, false);
        public static final ConcatenationProps TIGHT = new ConcatenationProps("", "", false, false);
        public static final ConcatenationProps NO_CONCAT = LINES;

        public ConcatenationProps(String rowSep, String colSep, boolean lTrim, boolean rTrim) {
            this.rowSep = rowSep;
            this.colSep = colSep;
            this.lTrim = lTrim;
            this.rTrim = rTrim;
        }

        public String toString() {
            return "ConcatenationProps{rowSep='" + this.rowSep + '\'' + ", colSep='" + this.colSep + '\'' + ", lTrim=" + this.lTrim + ", rTrim=" + this.rTrim + '}';
        }
    }
}

