/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropQueryGenerator {
    private final BasicModel myModel;
    private ScriptingOptions myOptions;
    private Set<BasicElement> myItems;
    private BasicNamespace myCurrentNamespace;

    public static boolean canDeleteAnything(@NotNull BasicModel model, @NotNull Iterable<BasicElement> elements) {
        if (model == null) {
            DropQueryGenerator.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            DropQueryGenerator.$$$reportNull$$$0(1);
        }
        return !JBIterable.from(elements).filter(e -> {
            if (model == null) {
                DropQueryGenerator.$$$reportNull$$$0(11);
            }
            return DropQueryGenerator.canDelete(model, e);
        }).isEmpty();
    }

    private static boolean canDelete(@NotNull BasicModel model, @NotNull BasicElement element2) {
        if (model == null) {
            DropQueryGenerator.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            DropQueryGenerator.$$$reportNull$$$0(3);
        }
        return ScriptGenerators.INSTANCE.byModel(model).capabilities(element2).getDrop().get(model.getRoot().getServerVersion());
    }

    public DropQueryGenerator(@NotNull BasicModel model) {
        if (model == null) {
            DropQueryGenerator.$$$reportNull$$$0(4);
        }
        this.myOptions = DefaultScriptingOptions.INSTANCE;
        this.myItems = Collections.emptySet();
        this.myModel = model;
    }

    public void setItems(@NotNull Iterable<BasicElement> items) {
        if (items == null) {
            DropQueryGenerator.$$$reportNull$$$0(5);
        }
        this.myItems = JBIterable.from(items).filter(e -> e.getModel() == this.myModel).toSet();
    }

    @NotNull
    public Set<BasicElement> getItems() {
        Set<BasicElement> set = this.myItems;
        if (set == null) {
            DropQueryGenerator.$$$reportNull$$$0(6);
        }
        return set;
    }

    public void setCurrentNamespace(@Nullable BasicNamespace currentNamespace) {
        this.myCurrentNamespace = currentNamespace;
    }

    public void setOptions(@NotNull ScriptingOptions o) {
        if (o == null) {
            DropQueryGenerator.$$$reportNull$$$0(7);
        }
        this.myOptions = o;
    }

    @NotNull
    public ScriptingResult generate() {
        ScriptingResult scriptingResult = this.generate(this.myModel.getRoot().getServerVersion());
        if (scriptingResult == null) {
            DropQueryGenerator.$$$reportNull$$$0(8);
        }
        return scriptingResult;
    }

    @NotNull
    public ScriptingResult generate(@Nullable Version version) {
        ScriptingResult scriptingResult = ScriptGenerators.INSTANCE.byModel(this.myModel).makeScript(this.createTask(version));
        if (scriptingResult == null) {
            DropQueryGenerator.$$$reportNull$$$0(9);
        }
        return scriptingResult;
    }

    @NotNull
    public ScriptingSingleModelTask createTask(@Nullable Version version) {
        ScriptingSingleModelTaskBuilder task = new ScriptingSingleModelTaskBuilder(this.myModel, ScriptCategory.DROP_COMPLETE);
        task.getElements().addAll(this.myItems);
        task.setCurrentNamespace(this.myCurrentNamespace);
        task.setOptions(this.myOptions);
        if (version != null) {
            task.setVersion(version);
        }
        ScriptingSingleModelTask scriptingSingleModelTask = task.build();
        if (scriptingSingleModelTask == null) {
            DropQueryGenerator.$$$reportNull$$$0(10);
        }
        return scriptingSingleModelTask;
    }

    public void fillNamespacesToRemove(List<Pair<ObjectName, ObjectName>> toRemove) {
        for (BasicElement namespace : this.myItems) {
            ObjectKind kind = namespace.getKind();
            if (kind == ObjectKind.DATABASE) {
                toRemove.add((Pair<ObjectName, ObjectName>)Pair.create((Object)ObjectName.quoted((String)namespace.getName()), null));
                continue;
            }
            if (kind != ObjectKind.SCHEMA) continue;
            BasicElement parent2 = namespace.getDasParent();
            if (parent2 != null && parent2.getKind() != ObjectKind.DATABASE) {
                parent2 = null;
            }
            toRemove.add((Pair<ObjectName, ObjectName>)Pair.create((Object)ObjectName.quoted((String)(parent2 == null ? null : parent2.getName())), (Object)ObjectName.quoted((String)namespace.getName())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DropQueryGenerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DropQueryGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteAnything";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canDelete";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$canDeleteAnything$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

