/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/view/RenameHelper;", "", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "(Lcom/intellij/database/model/basic/BasicModModel;)V", "revDeps", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/model/basic/BasicElement;", "kotlin.jvm.PlatformType", "scriptingService", "Lcom/intellij/database/script/generator/ScriptGenerator;", "fixReferences", "", "e", "old", "", "rename", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "newName", "intellij.database.impl"})
public final class RenameHelper {
    private final ScriptGenerator scriptingService;
    private final MultiMap<BasicElement, BasicElement> revDeps;
    private final BasicModModel model;

    public final void rename(@NotNull BasicModNamedElement e, @NotNull String newName) {
        CompositeText src;
        BasicModSourceAware sa;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        if (Intrinsics.areEqual((Object)e.getName(), (Object)newName)) {
            return;
        }
        BasicModNamedElement basicModNamedElement = e;
        if (!(basicModNamedElement instanceof BasicModSourceAware)) {
            basicModNamedElement = null;
        }
        BasicModSourceAware basicModSourceAware = sa = (BasicModSourceAware)((Object)basicModNamedElement);
        CompositeText compositeText = src = basicModSourceAware != null ? basicModSourceAware.getSourceText() : null;
        if (src != null) {
            this.model.writeSources(new Runnable(this, sa, e, newName, src){
                final /* synthetic */ RenameHelper this$0;
                final /* synthetic */ BasicModSourceAware $sa;
                final /* synthetic */ BasicModNamedElement $e;
                final /* synthetic */ String $newName;
                final /* synthetic */ CompositeText $src;

                public final void run() {
                    block1: {
                        CompositeText compositeText;
                        this.$sa.setSourceText(null);
                        RenameHelper.access$fixReferences(this.this$0, this.$e, this.$newName);
                        BasicModNamedElement basicModNamedElement = this.$e;
                        if (basicModNamedElement == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModNamedElement");
                        }
                        basicModNamedElement.setName(this.$newName);
                        this.$sa.setSourceText(this.$src);
                        CompositeText compositeText2 = RenameHelper.access$getScriptingService$p(this.this$0).reviseSource(this.$sa);
                        if (compositeText2 == null) break block1;
                        CompositeText it = compositeText = compositeText2;
                        this.$sa.setSourceText(it);
                    }
                }
                {
                    this.this$0 = renameHelper;
                    this.$sa = basicModSourceAware;
                    this.$e = basicModNamedElement;
                    this.$newName = string;
                    this.$src = compositeText;
                }
            });
        } else {
            this.fixReferences(e, newName);
            e.setName(newName);
        }
    }

    private final void fixReferences(BasicElement e, String old) {
        Collection collection = this.revDeps.get((Object)e);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"revDeps[e]");
        Iterable $receiver$iv = collection;
        for (Object element$iv : $receiver$iv) {
            BasicElement it = (BasicElement)element$iv;
            BasicElement basicElement = it;
            if (!(basicElement instanceof BasicModElement)) {
                basicElement = null;
            }
            BasicModElement basicModElement = (BasicModElement)basicElement;
            if (basicModElement == null) continue;
            basicModElement.fixReference(e, old);
        }
    }

    public RenameHelper(@NotNull BasicModModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.model = model;
        this.scriptingService = ScriptGenerators.INSTANCE.byModel(this.model);
        this.revDeps = MultiMap.createSet();
        Iterator iterator = this.model.traverser(true).iterator();
        while (iterator.hasNext()) {
            Iterable<? extends BasicElement> $receiver$iv;
            BasicElement e;
            BasicElement basicElement = e = (BasicElement)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"e");
            Intrinsics.checkExpressionValueIsNotNull(basicElement.getPredecessors(), (String)"e.predecessors");
            for (BasicElement basicElement2 : $receiver$iv) {
                BasicElement it = basicElement2;
                if (it == null) continue;
                this.revDeps.putValue((Object)it, (Object)e);
            }
        }
    }

    public static final /* synthetic */ void access$fixReferences(RenameHelper $this, @NotNull BasicElement e, @NotNull String old) {
        $this.fixReferences(e, old);
    }

    @NotNull
    public static final /* synthetic */ ScriptGenerator access$getScriptingService$p(RenameHelper $this) {
        return $this.scriptingService;
    }
}

