/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.util.Version;
import com.intellij.database.view.ModelLightCopier;
import com.intellij.database.view.RenameHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameQueryGenerator {
    private final BasicModel myModel;
    private final BasicNamedElement myElement;
    private final BasicModModel myTargetModel;
    private final BasicModNamedElement myTargetElement;
    private final ScriptGenerator myScriptGenerator;
    private final List<ElementDelta<?>> myCorrespondence;
    private final RenameHelper myRenameHelper;
    private BasicNamespace myCurrentNamespace;
    private ScriptingOptions myOptions;

    public RenameQueryGenerator(@NotNull BasicModel model, @NotNull BasicNamedElement element2) {
        if (model == null) {
            RenameQueryGenerator.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            RenameQueryGenerator.$$$reportNull$$$0(1);
        }
        this.myOptions = DefaultScriptingOptions.INSTANCE;
        this.myModel = model;
        this.myElement = element2;
        this.myTargetModel = new ModelFactory(new MemoryTextStorage()).createModel(model.getMetaModel().dbms);
        this.myCorrespondence = ContainerUtil.newArrayList();
        this.myTargetElement = (BasicModNamedElement)ModelLightCopier.copy(this.myTargetModel, element2);
        this.myTargetElement.setNameScripted(true);
        this.myTargetElement.setNameQuoted(false);
        BasicElement e1 = this.myElement;
        for (BasicElement e2 = this.myTargetElement; e1 != null && e2 != null; e1 = e1.getParent(), e2 = e2.getParent()) {
            if (e1.getKind() == ObjectKind.ROOT) continue;
            this.myCorrespondence.add(ElementDelta.create(e1, e2));
        }
        this.myScriptGenerator = ScriptGenerators.INSTANCE.byModel(model);
        this.myRenameHelper = new RenameHelper(this.myTargetModel);
    }

    public void setQuoted(boolean quoted) {
        this.myTargetElement.setNameQuoted(quoted);
    }

    public void setOptions(@NotNull ScriptingOptions o) {
        if (o == null) {
            RenameQueryGenerator.$$$reportNull$$$0(2);
        }
        this.myOptions = o;
    }

    @NotNull
    public ScriptingResult generate(@NotNull String newName, @Nullable Version ver) {
        if (newName == null) {
            RenameQueryGenerator.$$$reportNull$$$0(3);
        }
        this.myTargetModel.modify(BasicModRoot.class, r -> {
            if (newName == null) {
                RenameQueryGenerator.$$$reportNull$$$0(16);
            }
            this.myRenameHelper.rename(this.myTargetElement, newName);
        });
        ScriptingResult scriptingResult = this.myScriptGenerator.makeScript(this.createTask(ver));
        if (scriptingResult == null) {
            RenameQueryGenerator.$$$reportNull$$$0(4);
        }
        return scriptingResult;
    }

    public static boolean canRename(@NotNull BasicModel model, @NotNull BasicNamedElement element2) {
        if (model == null) {
            RenameQueryGenerator.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            RenameQueryGenerator.$$$reportNull$$$0(6);
        }
        return RenameQueryGenerator.canRename(model, element2, model.getRoot().getServerVersion());
    }

    public static boolean canRename(@NotNull BasicModel model, @NotNull BasicNamedElement element2, @Nullable Version ver) {
        if (model == null) {
            RenameQueryGenerator.$$$reportNull$$$0(7);
        }
        if (element2 == null) {
            RenameQueryGenerator.$$$reportNull$$$0(8);
        }
        return RenameQueryGenerator.getCapabilities(model, element2).getRename().get(ver);
    }

    public boolean isRenamed() {
        return !this.myTargetElement.getName().equals(this.myElement.getName());
    }

    @NotNull
    public ScriptingResult generate(@NotNull String newName) {
        if (newName == null) {
            RenameQueryGenerator.$$$reportNull$$$0(9);
        }
        ScriptingResult scriptingResult = this.generate(newName, this.myModel.getRoot().getServerVersion());
        if (scriptingResult == null) {
            RenameQueryGenerator.$$$reportNull$$$0(10);
        }
        return scriptingResult;
    }

    @NotNull
    public static ScriptingCapabilities getCapabilities(@NotNull BasicModel model, @NotNull BasicElement element2) {
        if (model == null) {
            RenameQueryGenerator.$$$reportNull$$$0(11);
        }
        if (element2 == null) {
            RenameQueryGenerator.$$$reportNull$$$0(12);
        }
        ScriptingCapabilities scriptingCapabilities = ScriptGenerators.INSTANCE.byModel(model).capabilities(element2);
        if (scriptingCapabilities == null) {
            RenameQueryGenerator.$$$reportNull$$$0(13);
        }
        return scriptingCapabilities;
    }

    @NotNull
    public BasicNamedElement getTargetElement() {
        BasicModNamedElement basicModNamedElement = this.myTargetElement;
        if (basicModNamedElement == null) {
            RenameQueryGenerator.$$$reportNull$$$0(14);
        }
        return basicModNamedElement;
    }

    @NotNull
    public ScriptingAlterTask createTask(@Nullable Version ver) {
        ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(this.myModel, this.myTargetModel);
        builder.setCorrespondence(this.myCorrespondence);
        builder.setCurrentNamespace(this.myCurrentNamespace);
        builder.setOptions(this.myOptions);
        if (ver != null) {
            builder.setVersion(ver);
        }
        ScriptingAlterTask scriptingAlterTask = builder.build();
        if (scriptingAlterTask == null) {
            RenameQueryGenerator.$$$reportNull$$$0(15);
        }
        return scriptingAlterTask;
    }

    @Nullable
    public BasicElement getCurrentNamespace() {
        return this.myCurrentNamespace;
    }

    public void setCurrentNamespace(@Nullable BasicNamespace currentNamespace) {
        assert (currentNamespace == null || currentNamespace.getModel() == this.myModel);
        this.myCurrentNamespace = currentNamespace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/RenameQueryGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/RenameQueryGenerator";
                break;
            }
            case 4: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapabilities";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 3: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canRename";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCapabilities";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

