/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a(\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\u0002H\u00062\u0006\u0010\u0007\u001a\u0002H\u00062\u0006\u0010\b\u001a\u0002H\u0006H\u0086\b\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\f\u001a\n\u0010\r\u001a\u00020\f*\u00020\f\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\f*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0001*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\f*\u00020\f\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\f*\u00020\f\u001a\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\f2\u0006\u0010\u0000\u001a\u00020\u0001H\u0086\u0004\u001aH\u0010\u0016\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00102\b\b\u0002\u0010\u001a\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u00102\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u00150\u001d\u001a\n\u0010\u001e\u001a\u00020\u0015*\u00020\f\u001a\n\u0010\u001f\u001a\u00020\u0015*\u00020\f\u001a\n\u0010 \u001a\u00020\u0015*\u00020\f\u001a\f\u0010!\u001a\u00020\u0015*\u0004\u0018\u00010\f\u001a\u0014\u0010!\u001a\u00020\u0015*\u0004\u0018\u00010\f2\u0006\u0010\"\u001a\u00020#\u001a\f\u0010$\u001a\u00020\u0015*\u0004\u0018\u00010\f\u001a\u0018\u0010$\u001a\u00020\u0015*\u0004\u0018\u00010\f2\n\u0010%\u001a\u00020&\"\u00020'\u001a\f\u0010$\u001a\u00020\u0015*\u00020'H\u0002\u001a\n\u0010(\u001a\u00020\u0015*\u00020\f\u001a\n\u0010)\u001a\u00020\u0015*\u00020\f\u001a\n\u0010*\u001a\u00020\f*\u00020\f\u001a1\u0010+\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010,\u001a\u00020\u00102\u0012\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010.\"\u00020\u0001\u00a2\u0006\u0002\u0010/\u001a\n\u00100\u001a\u00020\u0010*\u00020\u0015\"\u0019\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u00061"}, d2={"type", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/psi/PsiElement;", "getType", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/tree/IElementType;", "change", "T", "what", "with", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "children", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/lang/ASTNode;", "firstLeaf", "getMeaningfulChild", "index", "", "getMeaningfulChildType", "getNextMeaningfulNode", "getPrevMeaningfulNode", "hasChildNode", "", "indexOf", "E", "", "since", "till", "notFound", "predicate", "Lkotlin/Function1;", "isComment", "isComplex", "isFollowingAfterLineBreak", "isKeyWord", "text", "", "isSymbol", "symbols", "", "", "isWhitespace", "isWhitespaceOrComment", "lastLeaf", "matchPhrase", "offset", "pattern", "", "(Ljava/util/List;I[Lcom/intellij/psi/tree/IElementType;)I", "toInt", "intellij.database.sql.impl"})
@JvmName(name="SqlUtilFun")
public final class SqlUtilFun {
    @Nullable
    public static final IElementType getType(@Nullable PsiElement $receiver) {
        return PsiUtilCore.getElementType((PsiElement)$receiver);
    }

    public static final boolean hasChildNode(@NotNull ASTNode $receiver, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return SqlImplUtil.sqlChildren($receiver.getPsi()).find((Condition)new Condition<PsiElement>(type){
            final /* synthetic */ IElementType $type;

            public final boolean value(PsiElement it) {
                return SqlUtilFun.getType(it) == this.$type;
            }
            {
                this.$type = iElementType;
            }
        }) != null;
    }

    @NotNull
    public static final JBIterable<ASTNode> children(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        JBIterable jBIterable = ((SyntaxTraverser)SyntaxTraverser.astTraverser((ASTNode)$receiver).expandAndSkip((Condition)new Condition<ASTNode>($receiver){
            final /* synthetic */ ASTNode receiver$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean value(ASTNode it) {
                if (it == this.receiver$0) return true;
                ASTNode aSTNode = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it");
                if (aSTNode.getElementType() != SqlElementTypes.SQL_DUMMY_BLOCK) return false;
                return true;
            }
            {
                this.receiver$0 = aSTNode;
            }
        })).traverse();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SyntaxTraverser\n    .ast\u2026Y_BLOCK }\n    .traverse()");
        return jBIterable;
    }

    @Nullable
    public static final ASTNode getMeaningfulChild(@NotNull ASTNode $receiver, int index2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (index2 < 0) {
            return null;
        }
        return (ASTNode)((SyntaxTraverser)SyntaxTraverser.astTraverser((ASTNode)$receiver).expandAndSkip((Condition)new Condition<ASTNode>($receiver){
            final /* synthetic */ ASTNode receiver$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean value(ASTNode it) {
                if (it == this.receiver$0) return true;
                ASTNode aSTNode = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it");
                if (aSTNode.getElementType() != SqlElementTypes.SQL_DUMMY_BLOCK) return false;
                return true;
            }
            {
                this.receiver$0 = aSTNode;
            }
        })).traverse().filter((Condition)getMeaningfulChild.2.INSTANCE).get(index2);
    }

    @Nullable
    public static final IElementType getMeaningfulChildType(@NotNull ASTNode $receiver, int index2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ASTNode aSTNode = SqlUtilFun.getMeaningfulChild($receiver, index2);
        return aSTNode != null ? aSTNode.getElementType() : null;
    }

    @Nullable
    public static final ASTNode getPrevMeaningfulNode(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        for (ASTNode n = $receiver.getTreePrev(); n != null; n = n.getTreePrev()) {
            if (SqlUtilFun.isWhitespaceOrComment(n)) continue;
            return n;
        }
        return null;
    }

    @Nullable
    public static final ASTNode getNextMeaningfulNode(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        for (ASTNode n = $receiver.getTreeNext(); n != null; n = n.getTreeNext()) {
            if (SqlUtilFun.isWhitespaceOrComment(n)) continue;
            return n;
        }
        return null;
    }

    @NotNull
    public static final ASTNode firstLeaf(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ASTNode n = $receiver;
        ASTNode c2;
        while ((c2 = n.getFirstChildNode()) != null) {
            n = c2;
        }
        return n;
    }

    @NotNull
    public static final ASTNode lastLeaf(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ASTNode n = $receiver;
        ASTNode c2;
        while ((c2 = n.getLastChildNode()) != null) {
            n = c2;
        }
        return n;
    }

    public static final boolean isKeyWord(@Nullable ASTNode $receiver) {
        if ($receiver == null) {
            return false;
        }
        IElementType type = $receiver.getElementType();
        IElementType iElementType = type;
        if (iElementType instanceof SqlKeywordTokenType) {
            return true;
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_BLOCK_COMMENT) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_LINE_COMMENT) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.MYSQL_LINE_COMMENT)) {
            return false;
        }
        ASTNode aSTNode = $receiver.getFirstChildNode();
        if (aSTNode == null) {
            return false;
        }
        ASTNode child1 = aSTNode;
        ASTNode child2 = child1.getTreeNext();
        if (child2 != null) {
            return false;
        }
        return SqlUtilFun.isKeyWord(child1);
    }

    public static final boolean isKeyWord(@Nullable ASTNode $receiver, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return $receiver != null && SqlUtilFun.isKeyWord($receiver) && StringsKt.equals((String)$receiver.getText(), (String)text2, (boolean)true);
    }

    public static final boolean isSymbol(@Nullable ASTNode $receiver) {
        String text2;
        if ($receiver == null) {
            return false;
        }
        if (SqlFormattingFunKt.getMEANINGLESS_TYPES().contains($receiver.getElementType())) {
            return false;
        }
        int n = $receiver.getTextLength();
        if (n == 1) {
            char c2 = $receiver.getText().charAt(0);
            return SqlUtilFun.isSymbol(c2);
        }
        if ($receiver.getFirstChildNode() != null) {
            return false;
        }
        String string = text2 = $receiver.getText();
        int n2 = string.length();
        for (int j = 0; j < n2; ++j) {
            char c3 = string.charAt(j);
            if (SqlUtilFun.isSymbol(c3)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSymbol(@Nullable ASTNode $receiver, char ... symbols) {
        Intrinsics.checkParameterIsNotNull((Object)symbols, (String)"symbols");
        if ($receiver == null) {
            return false;
        }
        if (SqlFormattingFunKt.getMEANINGLESS_TYPES().contains($receiver.getElementType())) {
            return false;
        }
        int n = $receiver.getTextLength();
        if (n == 1) {
            char c2 = $receiver.getText().charAt(0);
            for (char symbol : symbols) {
                if (c2 != symbol) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isSymbol(char $receiver) {
        char c2 = $receiver;
        if (Character.isLetterOrDigit(c2)) {
            return false;
        }
        return $receiver != '_';
    }

    public static final boolean isComplex(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ASTNode aSTNode = $receiver.getFirstChildNode();
        if (aSTNode == null) {
            return false;
        }
        ASTNode child1 = aSTNode;
        if (child1.getTreeNext() != null) {
            return true;
        }
        return SqlUtilFun.isComplex(child1);
    }

    public static final boolean isComment(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return SqlTokens.COMMENT_TOKENS.contains($receiver.getElementType());
    }

    public static final boolean isWhitespace(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getTextLength() <= 0 || $receiver.getElementType() == SqlTokens.ORAP_DELIMITER_TOKEN || $receiver.getPsi() instanceof PsiWhiteSpace;
    }

    public static final boolean isWhitespaceOrComment(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return SqlUtilFun.isWhitespace($receiver) || SqlUtilFun.isComment($receiver);
    }

    public static final boolean isFollowingAfterLineBreak(@NotNull ASTNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiElement p2 = PsiTreeUtil.prevLeaf((PsiElement)$receiver.getPsi());
        if (p2 == null) {
            return false;
        }
        if (SqlTokens.WS_TOKENS.contains(SqlUtilFun.getType(p2))) {
            return p2.textContains('\n');
        }
        return false;
    }

    public static final int matchPhrase(@NotNull List<? extends ASTNode> $receiver, int offset, IElementType ... pattern) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        int m = pattern.length;
        int n = $receiver.size();
        if (offset + m > n) {
            return -1;
        }
        int k = offset;
        for (IElementType pt : pattern) {
            IElementType t;
            while (k < n && (t = $receiver.get(k++).getElementType()) != pt) {
                if (SqlElementTypes.WS_OR_COMMENTS.contains(t)) continue;
                return -1;
            }
        }
        return k - offset;
    }

    public static final <T> T change(T $receiver, T what, T with) {
        return Intrinsics.areEqual($receiver, what) ? with : $receiver;
    }

    /*
     * WARNING - void declaration
     */
    public static final <E> int indexOf(@NotNull List<? extends E> $receiver, int since, int till, int notFound, @NotNull Function1<? super E, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        if (since < 0) {
            throw (Throwable)new IllegalArgumentException("Called List.indexOf() with negative since: " + since);
        }
        if ($receiver.isEmpty()) {
            return notFound;
        }
        int n = $receiver.size();
        if (till <= since || since >= n) {
            return notFound;
        }
        int n2 = since;
        int n3 = Math.min(till, n);
        while (n2 < n3) {
            void i2;
            if (((Boolean)predicate.invoke($receiver.get((int)i2))).booleanValue()) {
                return (int)i2;
            }
            ++i2;
        }
        return notFound;
    }

    public static /* synthetic */ int indexOf$default(List list, int n, int n2, int n3, Function1 function1, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = list.size();
        }
        if ((n4 & 4) != 0) {
            n3 = -1;
        }
        return SqlUtilFun.indexOf(list, n, n2, n3, function1);
    }

    public static final int toInt(boolean $receiver) {
        return $receiver ? 1 : 0;
    }
}

