/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.Case;
import com.intellij.database.util.SqlDialects;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.SqlInsertHandlers;
import com.intellij.sql.completion.SqlTypesStatisticIndex;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCodeFragmentImpl;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.ui.KeyboardLayoutUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlKeywordCompletionContributor
extends CompletionContributor {
    public static final int USAGE_THRESHOLD = 2;
    private static final TokenSet DO_NOT_BALANCE = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_IDENT_DELIMITED, SqlTokens.SQL_STRING_TOKEN, SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN});
    private static final Pattern WHITESPACES = Pattern.compile("[\\u00A0\\s]+");

    public SqlKeywordCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet _result) {
                PsiFile file;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (_result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
                    return;
                }
                PsiElement position = parameters.getPosition();
                if (position instanceof SqlStringTokenElement || position instanceof PsiComment) {
                    return;
                }
                PsiElement prevSibling = position.getParent().getPrevSibling();
                if (prevSibling instanceof ASTNode && ((ASTNode)prevSibling).getElementType() == SqlCommonTokens.SQL_PERIOD) {
                    return;
                }
                SqlLanguageDialect dialect = ((SqlFile)file).getSqlLanguage();
                SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(position.getContainingFile());
                Case keywordCase = SqlCodeStyleSettings.getCaseMode((int)(settings == null ? 2 : settings.KEYWORD_CASE));
                Case typeCase = settings == null ? SqlCodeStyleSettings.getCaseMode((int)2) : settings.getCaseModeExt(settings.TYPE_CASE);
                CompletionResultSet result2 = _result.caseInsensitive();
                if (dialect == SqlDialects.getGenericDialect()) {
                    for (String s : dialect.getKeywords()) {
                        if (!result2.getPrefixMatcher().prefixMatches(s)) continue;
                        result2.addElement(SqlCompletionUtil.createKeywordLookupElement(keywordCase, s, (InsertHandler<LookupElement>)SqlKeywordCompletionContributor.wrapHandlerIfNeeded(s, (InsertHandler<LookupElement>)SqlInsertHandlers.WHITESPACE_PROTECTED), 0.0));
                    }
                } else {
                    SqlKeywordCompletionContributor.suggestKeywords(result2, position, parameters, keywordCase, typeCase);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "_result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlKeywordCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static InsertHandler<LookupElement> wrapWithMoveIntoParenIfNeeded(String text2, InsertHandler<LookupElement> prevHandler) {
        if (!StringUtil.endsWith((CharSequence)text2, (CharSequence)" )")) {
            return prevHandler;
        }
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                int c2;
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    2.$$$reportNull$$$0(1);
                }
                int offset = context.getEditor().getCaretModel().getOffset() - 2;
                CharSequence charSequence = context.getDocument().getCharsSequence();
                int n = c2 = offset < 1 ? 120 : (int)charSequence.charAt(offset - 1);
                if (c2 != 32) {
                    context.getDocument().insertString(offset, (CharSequence)" ");
                    context.getEditor().getCaretModel().moveToOffset(offset + 1);
                } else {
                    context.getEditor().getCaretModel().moveToOffset(offset);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlKeywordCompletionContributor$2";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static InsertHandler<LookupElement> wrapHandlerIfNeeded(final String text2, InsertHandler<LookupElement> prevHandler) {
        boolean braceHandler;
        final InsertHandler<LookupElement> handler = SqlKeywordCompletionContributor.wrapWithMoveIntoParenIfNeeded(text2, prevHandler);
        boolean bl = braceHandler = handler != prevHandler;
        if (text2.indexOf(32) == -1) {
            return handler;
        }
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!this.handleMultiwordInsertion(context) || braceHandler) {
                    handler.handleInsert(context, item);
                }
            }

            private boolean handleMultiwordInsertion(@NotNull InsertionContext context) {
                String part;
                CharSequence docContent;
                if (context == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (context.getCompletionChar() != '\t') {
                    return false;
                }
                int offset = context.getTailOffset();
                if (offset >= (docContent = context.getDocument().getCharsSequence()).length()) {
                    return false;
                }
                if (docContent.charAt(offset) != ' ') {
                    return false;
                }
                ++offset;
                List parts = StringUtil.split((String)text2, (String)" ", (boolean)true, (boolean)true);
                int dropStart = -1;
                int dropEnd = -1;
                int mismatchCount = 0;
                for (int i2 = 1; i2 < parts.size() && offset + (part = (String)parts.get(i2)).length() <= docContent.length(); ++i2) {
                    CharSequence word = docContent.subSequence(offset, offset + part.length());
                    if (!StringUtil.equalsIgnoreCase((CharSequence)word, (CharSequence)part)) {
                        if (i2 + 1 < parts.size() && StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)parts.get(i2 + 1)), (CharSequence)docContent.subSequence(offset, offset + ((String)parts.get(i2 + 1)).length()))) continue;
                        if (mismatchCount != 0) break;
                        ++mismatchCount;
                        int nextWs = StringUtil.indexOf((CharSequence)docContent, (char)' ', (int)(offset + part.length()));
                        if (nextWs == -1) {
                            return false;
                        }
                        if (dropStart == -1) {
                            dropStart = offset;
                        }
                        offset = nextWs + 1;
                        --i2;
                        continue;
                    }
                    if (dropStart == -1) {
                        dropStart = offset;
                    }
                    dropEnd = offset + part.length();
                    offset = dropEnd + 1;
                }
                if (dropStart > 0 && dropEnd != -1 && dropStart < dropEnd) {
                    context.getEditor().getCaretModel().moveToOffset(dropEnd);
                    context.getDocument().deleteString(dropStart - 1, dropEnd);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/completion/SqlKeywordCompletionContributor$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleInsert";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleMultiwordInsertion";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(1);
        }
        if (SqlCompletionUtil.isCompletionAllowed(parameters)) {
            super.fillCompletionVariants(parameters, result2);
        }
    }

    public static boolean isSupported(SqlLanguageDialect dialect) {
        return dialect != SqlDialects.getGenericDialect();
    }

    @NotNull
    private static Pair<Map<String, Integer>, Long> getTypeWeightMap(@NotNull PsiElement file, @NotNull Language dialect) {
        if (file == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(3);
        }
        Pair pair = (Pair)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (file == null) {
                SqlKeywordCompletionContributor.$$$reportNull$$$0(57);
            }
            if (dialect == null) {
                SqlKeywordCompletionContributor.$$$reportNull$$$0(58);
            }
            return CachedValueProvider.Result.create(SqlKeywordCompletionContributor.calcTypeWeightMap(file, dialect), (Object[])new Object[]{file});
        });
        if (pair == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @NotNull
    private static Pair<Map<String, Integer>, Long> calcTypeWeightMap(@NotNull PsiElement file, @NotNull Language dialect) {
        if (file == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(5);
        }
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(6);
        }
        String id = dialect.getID();
        FileBasedIndex index2 = FileBasedIndex.getInstance();
        Collection keys = index2.getAllKeys(SqlTypesStatisticIndex.NAME, file.getProject());
        THashMap map = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)file.getProject());
        long total = 0L;
        for (String key2 : keys) {
            if (!key2.startsWith(id)) continue;
            List values2 = index2.getValues(SqlTypesStatisticIndex.NAME, (Object)key2, scope);
            int subTotal = 0;
            for (Integer value : values2) {
                subTotal += value.intValue();
            }
            total += (long)subTotal;
            map.put(key2.substring(id.length() + 2), subTotal);
        }
        Pair pair = Pair.create((Object)map, (Object)total);
        if (pair == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(7);
        }
        return pair;
    }

    public static void suggestKeywords(final @NotNull CompletionResultSet result2, final @NotNull PsiElement position, final @NotNull CompletionParameters parameters, final @NotNull Case keywordCase, final @NotNull Case typeCase) {
        if (result2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(8);
        }
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(10);
        }
        if (keywordCase == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(11);
        }
        if (typeCase == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(12);
        }
        final PsiElement root2 = SqlKeywordCompletionContributor.getStatementsRoot(position);
        final Language dialect = SqlKeywordCompletionContributor.getLanguage(root2);
        Pair<String, String> prefSuf = SqlKeywordCompletionContributor.extractFragment(position, root2, dialect);
        String fragment = (String)prefSuf.first;
        String tailText = StringUtil.notNullize((String)InjectedLanguageUtil.getUnescapedLeafText((PsiElement)position, (boolean)false));
        String tailTextTrimmed = StringUtil.trimEnd((String)tailText, (String)"IntellijIdeaRulezzz");
        boolean empty = StringUtil.isEmptyOrSpaces((String)(fragment = fragment + tailTextTrimmed));
        String text2 = empty ? "" : fragment + (String)prefSuf.second;
        int offset = parameters.getOffset();
        int completionOffset = empty ? 0 : fragment.length() - (tailTextTrimmed.length() - (offset - position.getTextRange().getStartOffset()));
        SqlCodeFragmentImpl file = root2 instanceof SqlCodeFragmentImpl ? new SqlCodeFragmentImpl((SqlCodeFragmentImpl)root2, text2) : PsiFileFactory.getInstance((Project)root2.getProject()).createFileFromText("a.sql", dialect, (CharSequence)text2, true, false);
        final HashSet addedKeywords = ContainerUtil.newHashSet();
        GeneratedParserUtilBase.CompletionState state = new GeneratedParserUtilBase.CompletionState(completionOffset){
            private final Set<String> literalItemsNoWs;
            private final Set<String> frameTrailingWords;
            private final Set<String> RAISE_PRIORITY;
            {
                super(x0);
                this.literalItemsNoWs = this.createKeywordsSet("default", "true", "false", "null", "unknown");
                this.frameTrailingWords = this.createKeywordsSet("preceding", "following");
                this.RAISE_PRIORITY = ContainerUtil.set((Object[])new String[]{"left join", "right join", "not null"});
            }

            public String convertItem(Object o) {
                Object keywordItem = this.transformKeywordItem(o);
                return keywordItem != null ? super.convertItem(keywordItem) : null;
            }

            private Object transformKeywordItem(Object o) {
                IElementType elementType;
                Object item;
                if (o instanceof String || o instanceof SqlKeywordTokenType) {
                    return o;
                }
                if (o == SqlCommonTokens.SQL_LEFT_PAREN) {
                    return "(";
                }
                if (o == SqlCommonTokens.SQL_RIGHT_PAREN) {
                    return ")";
                }
                if (!(o instanceof IElementType[])) {
                    return null;
                }
                IElementType[] elementTypes = (IElementType[])o;
                ArrayList types = ContainerUtil.newArrayListWithCapacity((int)elementTypes.length);
                boolean hasParens = false;
                IElementType[] iElementTypeArray = elementTypes;
                int n = iElementTypeArray.length;
                for (int j = 0; j < n && (item = this.transformKeywordItem(elementType = iElementTypeArray[j])) != null; ++j) {
                    if (item instanceof String) {
                        hasParens = true;
                    }
                    types.add(item);
                }
                return !hasParens && types.size() == elementTypes.length ? elementTypes : ContainerUtil.toArray((Collection)types, Object[]::new);
            }

            private Set<String> createKeywordsSet(String ... elements) {
                if (elements == null) {
                    4.$$$reportNull$$$0(0);
                }
                return ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE, (Object[])elements);
            }

            private boolean skipWhitespace(@Nullable String frameName, @NotNull String itemText) {
                if (itemText == null) {
                    4.$$$reportNull$$$0(1);
                }
                return "<type>".equals(frameName) || "<privilege>".equals(frameName) || "<literal>".equals(frameName) && this.literalItemsNoWs.contains(itemText) || "<frame clause>".equals(frameName) && this.frameTrailingWords.contains(itemText);
            }

            public void addItem(@NotNull PsiBuilder builder, @NotNull String itemText) {
                int count2;
                LookupElement element2;
                Case mode;
                if (builder == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (itemText == null) {
                    4.$$$reportNull$$$0(3);
                }
                String frameName = this.frameName(builder);
                boolean type = "<type>".equals(frameName);
                boolean funArg = "<function call expression>".equals(frameName);
                String trimForCorrection = this.trimForCorrection(itemText);
                double correction = this.correction(type, trimForCorrection);
                Case case_ = mode = type ? typeCase : keywordCase;
                if (!result2.getPrefixMatcher().prefixMatches(mode.apply(trimForCorrection))) {
                    return;
                }
                String completionPrefix = StringUtil.notNullize((String)this.buildSearchText(builder, Math.max(this.offset - builder.getCurrentOffset(), 0)));
                int lastParen = itemText.lastIndexOf(40);
                if (lastParen != -1 && !StringUtil.contains((CharSequence)completionPrefix, (CharSequence)itemText.substring(0, lastParen))) {
                    itemText = itemText + " )";
                }
                if (StringUtil.isEmptyOrSpaces((String)StringUtil.trimEnd((String)StringUtil.trimStart((String)itemText, (String)"("), (char)')'))) {
                    return;
                }
                int errorReportedAt = this.findReportedError(builder);
                if (errorReportedAt == builder.rawTokenIndex()) {
                    correction -= 0.1;
                }
                if ((element2 = SqlKeywordCompletionContributor.createKeywordLookupElement(mode, completionPrefix, itemText, dialect, builder, frameName, !this.skipWhitespace(frameName, itemText), correction + (double)(funArg ? 1 : 0), addedKeywords, position, parameters.getEditor())) == null) {
                    return;
                }
                if (type && (count2 = StatisticsWeigher.getBaseStatisticsInfo((LookupElement)element2, (CompletionLocation)new CompletionLocation(parameters)).getUseCount()) >= 2) {
                    element2 = SqlKeywordCompletionContributor.createKeywordLookupElement(mode, completionPrefix, itemText, dialect, builder, frameName, false, correction + 1.0, ContainerUtil.newHashSet(), position, parameters.getEditor());
                }
                assert (element2 != null);
                result2.addElement(element2);
            }

            @NotNull
            private String trimForCorrection(@NotNull String itemText) {
                if (itemText == null) {
                    4.$$$reportNull$$$0(4);
                }
                String string = StringUtil.endsWithChar((CharSequence)itemText, (char)'(') ? itemText.substring(0, itemText.length() - 1).trim() : itemText;
                if (string == null) {
                    4.$$$reportNull$$$0(5);
                }
                return string;
            }

            private int findReportedError(PsiBuilder builder) {
                GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
                while (frame != null) {
                    if (frame.errorReportedAt != -1) {
                        return frame.errorReportedAt;
                    }
                    frame = frame.parentFrame;
                }
                return -1;
            }

            private double correction(boolean type, @NotNull String text2) {
                if (text2 == null) {
                    4.$$$reportNull$$$0(6);
                }
                if (type) {
                    Pair map = SqlKeywordCompletionContributor.getTypeWeightMap(root2, dialect);
                    Integer count2 = (Integer)((Map)map.first).get(text2);
                    return count2 != null && (Long)map.second != 0L ? 1.0 * (double)count2.intValue() / (double)((Long)map.second).longValue() : 0.0;
                }
                if (this.RAISE_PRIORITY.contains(StringUtil.toLowerCase((String)text2))) {
                    return 0.1;
                }
                return 0.0;
            }

            @Nullable
            private String buildSearchText(@NotNull PsiBuilder builder, int maxLength) {
                int builderOffset;
                if (builder == null) {
                    4.$$$reportNull$$$0(7);
                }
                if (this.offset == (builderOffset = builder.getCurrentOffset())) {
                    return "";
                }
                StringBuilder compText = new StringBuilder();
                int i2 = 0;
                while (true) {
                    IElementType type = builder.rawLookup(i2);
                    int tokenStart = builder.rawTokenTypeStart(i2);
                    if (tokenStart > this.offset || type == null) {
                        compText.append(" ");
                        break;
                    }
                    if (!GeneratedParserUtilBase.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) {
                        int tokenEnd = Math.min(builder.rawTokenTypeStart(i2 + 1), this.offset);
                        CharSequence token = builder.getOriginalText().subSequence(tokenStart, tokenEnd);
                        if (compText.length() > 0 || this.convertItem(type) != null) {
                            if (compText.length() != 0) {
                                compText.append(" ");
                            }
                            compText.append(token);
                        }
                        if (compText.length() >= maxLength && tokenEnd != this.offset) {
                            return null;
                        }
                        if (tokenEnd == this.offset) break;
                    }
                    ++i2;
                }
                return compText.length() > 0 ? compText.toString() : "";
            }

            public boolean prefixMatches(@NotNull PsiBuilder builder, @NotNull String text2) {
                String searchText;
                if (builder == null) {
                    4.$$$reportNull$$$0(8);
                }
                if (text2 == null) {
                    4.$$$reportNull$$$0(9);
                }
                return (searchText = this.buildSearchText(builder, text2.length())) != null && (searchText.isEmpty() || super.prefixMatches(this.convertLayout(searchText), text2));
            }

            private String convertLayout(String s) {
                char[] alternatePattern = new char[s.length()];
                for (int i2 = 0; i2 < s.length(); ++i2) {
                    char c2 = s.charAt(i2);
                    Character newC = KeyboardLayoutUtil.getAsciiForChar((char)c2);
                    alternatePattern[i2] = newC == null ? c2 : newC.charValue();
                }
                return new String(alternatePattern);
            }

            @Nullable
            private String frameName(@NotNull PsiBuilder builder) {
                if (builder == null) {
                    4.$$$reportNull$$$0(10);
                }
                GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
                while (frame != null) {
                    if (!StringUtil.isEmpty((String)frame.name)) {
                        return frame.name;
                    }
                    frame = frame.parentFrame;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elements";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "itemText";
                        break;
                    }
                    case 2: 
                    case 7: 
                    case 8: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/completion/SqlKeywordCompletionContributor$4";
                        break;
                    }
                    case 6: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/completion/SqlKeywordCompletionContributor$4";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "trimForCorrection";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createKeywordsSet";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "skipWhitespace";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "addItem";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "trimForCorrection";
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "correction";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "buildSearchText";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "prefixMatches";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "frameName";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        file.putUserData(GeneratedParserUtilBase.COMPLETION_STATE_KEY, state);
        TreeUtil.ensureParsed((ASTNode)file.getNode());
    }

    @Nullable
    private static <T extends PsiElement> T getTopmostParentOfType(@Nullable PsiElement element2, @NotNull Class<T> clazz, @NotNull PsiElement ceil) {
        if (clazz == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(13);
        }
        if (ceil == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(14);
        }
        if (ceil == element2) {
            return null;
        }
        return (T)((PsiElement)ObjectUtils.chooseNotNull(element2 == null ? null : SqlKeywordCompletionContributor.getTopmostParentOfType(element2.getParent(), clazz, ceil), (Object)ObjectUtils.tryCast((Object)element2, clazz)));
    }

    @NotNull
    private static Pair<String, String> extractFragment(@NotNull PsiElement position, @NotNull PsiElement root2, @NotNull Language dialect) {
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(15);
        }
        if (root2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(16);
        }
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(17);
        }
        PsiFile rootFile = root2.getContainingFile();
        SqlStatement loBound = SqlKeywordCompletionContributor.getTopmostParentOfType(position, SqlStatement.class, root2);
        if (loBound != null) {
            loBound = SqlKeywordCompletionContributor.findGoodStatement((PsiElement)loBound, root2);
        }
        if (loBound != null) {
            loBound = loBound.getFirstChild();
        }
        if (loBound == null) {
            loBound = (PsiElement)ObjectUtils.chooseNotNull((Object)SqlKeywordCompletionContributor.getFragmentBorderElement(dialect, root2, position, true), (Object)root2);
        }
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)root2).expand(Conditions.alwaysTrue());
        s = (SyntaxTraverser)ScriptModelUtil.inRange(s, TextRange.create((int)loBound.getTextRange().getStartOffset(), (int)position.getTextRange().getStartOffset())).filter(element2 -> {
            LeafPsiElement leaf = (LeafPsiElement)ObjectUtils.tryCast((Object)element2, LeafPsiElement.class);
            return leaf != null && !DO_NOT_BALANCE.contains(leaf.getElementType());
        });
        int balance = 0;
        for (PsiElement element3 : s) {
            balance += SqlKeywordCompletionContributor.getParenBalance(element3.getText());
        }
        String text2 = InjectedLanguageUtil.getUnescapedText((PsiFile)rootFile, (PsiElement)loBound, (PsiElement)position);
        Pair pair = Pair.create((Object)text2, (Object)(balance > 0 ? StringUtil.repeat((String)")", (int)balance) : ""));
        if (pair == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @Nullable
    private static SqlStatement getPrevStatementSameLevel(@NotNull PsiElement stmt) {
        if (stmt == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(19);
        }
        PsiElement parent2 = SqlKeywordCompletionContributor.blockRoot(stmt);
        SyntaxTraverser s = ScriptModelUtil.inRange((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)parent2), TextRange.create((int)0, (int)stmt.getTextOffset()));
        return (SqlStatement)((SyntaxTraverser)s.expandAndSkip(Conditions.or((Condition)Conditions.is((Object)parent2), (Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.is((Object)GeneratedParserUtilBase.DUMMY_BLOCK))))).filter(SqlStatement.class).first();
    }

    @Nullable
    private static PsiElement blockRoot(@NotNull PsiElement stmt) {
        PsiElement parent2;
        if (stmt == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(20);
        }
        for (parent2 = stmt.getParent(); parent2 != null && parent2.getNode() != null && parent2.getNode().getElementType() == GeneratedParserUtilBase.DUMMY_BLOCK; parent2 = parent2.getParent()) {
        }
        return parent2;
    }

    @NotNull
    static PsiElement findGoodStatement(@NotNull PsiElement stmt, @NotNull PsiElement ceil) {
        if (stmt == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(21);
        }
        if (ceil == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(22);
        }
        PsiElement levelStatement = stmt;
        while (levelStatement != null && PsiTreeUtil.isContextAncestor((PsiElement)ceil, (PsiElement)levelStatement, (boolean)true)) {
            SqlStatement prev = SqlKeywordCompletionContributor.getPrevStatementSameLevel(levelStatement);
            if (prev != null && SqlKeywordCompletionContributor.findError((PsiElement)prev, stmt) != null) {
                SqlStatement sqlStatement = prev;
                if (sqlStatement == null) {
                    SqlKeywordCompletionContributor.$$$reportNull$$$0(23);
                }
                return sqlStatement;
            }
            levelStatement = PsiTreeUtil.getParentOfType((PsiElement)levelStatement, SqlStatement.class);
        }
        PsiElement psiElement = stmt;
        if (psiElement == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(24);
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement findError(@NotNull PsiElement stmt, @NotNull PsiElement end) {
        if (stmt == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(25);
        }
        if (end == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(26);
        }
        HashSet checked = ContainerUtil.newHashSet();
        PsiElement tmp = PsiTreeUtil.prevLeaf((PsiElement)end, (boolean)false);
        while (tmp != null) {
            if (SqlKeywordCompletionContributor.isError(tmp, checked)) {
                return tmp;
            }
            if (!(tmp instanceof PsiComment) && !StringUtil.isEmptyOrSpaces((String)tmp.getText()) && tmp.getTextRange().getStartOffset() < stmt.getTextRange().getEndOffset()) break;
            tmp = PsiTreeUtil.prevLeaf((PsiElement)tmp, (boolean)false);
        }
        return null;
    }

    private static boolean isError(@NotNull PsiElement el, @NotNull Set<PsiElement> checked) {
        if (el == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(27);
        }
        if (checked == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(28);
        }
        if (el instanceof PsiErrorElement) {
            return true;
        }
        PsiElement parent2 = el.getParent();
        if (parent2 == null || checked.contains(parent2)) {
            return false;
        }
        checked.add(parent2);
        return SqlKeywordCompletionContributor.isError(parent2, checked);
    }

    @NotNull
    private static Language getLanguage(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(29);
        }
        if (element2 instanceof LazyParseablePsiElement) {
            Language language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)element2, (Object)PlainTextLanguage.INSTANCE);
            if (language == null) {
                SqlKeywordCompletionContributor.$$$reportNull$$$0(30);
            }
            return language;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
        if (sqlLanguageDialectEx == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(31);
        }
        return sqlLanguageDialectEx;
    }

    @NotNull
    private static PsiElement getStatementsRoot(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(32);
        }
        LazyParseablePsiElement root2 = (LazyParseablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)element2, LazyParseablePsiElement.class);
        PsiElement psiElement = (PsiElement)ObjectUtils.chooseNotNull((Object)root2, (Object)element2.getContainingFile());
        if (psiElement == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(33);
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static LookupElement createKeywordLookupElement(@NotNull Case keywordCase, @NotNull String filePrefix, @NotNull String str, @NotNull Language dialect, @NotNull PsiBuilder builder, @Nullable String frameName, boolean addWhitespace, double correction, @NotNull Set<String> addedKeywords, @NotNull PsiElement position, @NotNull Editor editor) {
        String keyword;
        InsertHandler<LookupElement> handler;
        void editor2;
        if (keywordCase == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(34);
        }
        if (filePrefix == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(35);
        }
        if (str == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(36);
        }
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(37);
        }
        if (builder == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(38);
        }
        if (addedKeywords == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(39);
        }
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(40);
        }
        if (editor == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(41);
        }
        String k = SqlKeywordCompletionContributor.findMultiWordKeyword(filePrefix, str);
        InsertHandler<LookupElement> customHandler = SqlKeywordCompletionContributor.findCustomInsertHandler(str, builder, frameName, dialect, position, (Editor)editor2);
        Object object = handler = customHandler != null ? customHandler : (addWhitespace ? SqlKeywordCompletionContributor.wrapHandlerIfNeeded(str, SqlInsertHandlers.WHITESPACE_PROTECTED) : null);
        if (!addedKeywords.add(k == null ? str : k)) {
            return null;
        }
        String string = keyword = k != null ? k : str;
        if (StringUtil.startsWithChar((CharSequence)keyword, (char)'(')) {
            return null;
        }
        List aliases = k != null ? ContainerUtil.emptyList() : ContainerUtil.list((Object[])new String[]{str.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_"), str.replaceAll(" ", "_")});
        return SqlCompletionUtil.createKeywordLookupElement(keywordCase, keyword, handler, correction, aliases);
    }

    private static boolean isInsideAnalyticClause(@NotNull PsiBuilder builder) {
        if (builder == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(42);
        }
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        while (frame != null) {
            if (frame.elementType == SqlCompositeElementTypes.SQL_ANALYTIC_CLAUSE) {
                return true;
            }
            frame = frame.parentFrame;
        }
        return false;
    }

    @Nullable
    private static InsertHandler<LookupElement> findCustomInsertHandler(@NotNull String str, @NotNull PsiBuilder builder, @Nullable String frameName, @NotNull Language dialect, @NotNull PsiElement position, @NotNull Editor editor) {
        if (str == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(43);
        }
        if (builder == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(44);
        }
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(45);
        }
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(46);
        }
        if (editor == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(47);
        }
        if (SqlKeywordCompletionContributor.isInsideAnalyticClause(builder)) {
            return null;
        }
        if (str.equalsIgnoreCase("AUTO_INCREMENT") || frameName != null && frameName.endsWith("paren argument list>")) {
            return SqlInsertHandlers.DUMMY_HANDLER;
        }
        if (str.equalsIgnoreCase("VARCHAR") || str.equalsIgnoreCase("VARCHAR2")) {
            return ParenthesesInsertHandler.WITH_PARAMETERS;
        }
        if (str.equalsIgnoreCase("WHERE") || str.equalsIgnoreCase("FROM") || str.equalsIgnoreCase("ON") || StringUtil.endsWithIgnoreCase((String)str, (String)"JOIN") && "<join>".equals(frameName)) {
            return SqlKeywordCompletionContributor.wrapHandlerIfNeeded(str, SqlKeywordCompletionContributor.isTemplateOrHasFollowingTail(editor, position) ? SqlInsertHandlers.WHITESPACE_PROTECTED : SqlInsertHandlers.WHITESPACE_POPUP_PROTECTED);
        }
        if (str.equalsIgnoreCase("GO")) {
            return SqlInsertHandlers.NEW_LINE_INSERT_HANDLER;
        }
        return null;
    }

    private static boolean isTemplateOrHasFollowingTail(@NotNull Editor editor, @NotNull PsiElement position) {
        if (editor == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(48);
        }
        if (position == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(49);
        }
        if (TemplateManager.getInstance((Project)position.getProject()).getActiveTemplate(editor) != null) {
            return true;
        }
        SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlQueryExpression.class);
        return PsiTreeUtil.skipWhitespacesForward((PsiElement)queryExpression) != null;
    }

    @Nullable
    public static String findMultiWordKeyword(@NotNull String filePrefix, @NotNull String str) {
        List<CharSequence> kwSeq;
        if (filePrefix == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(50);
        }
        if (str == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(51);
        }
        if ((kwSeq = SqlKeywordCompletionContributor.splitSpaces(str)) == null) {
            return null;
        }
        List<CharSequence> fileSeq = SqlKeywordCompletionContributor.splitSpaces(filePrefix);
        if (fileSeq == null) {
            fileSeq = Collections.singletonList(filePrefix);
        }
        for (int i2 = Math.min(kwSeq.size(), fileSeq.size()); i2 > 0; --i2) {
            ThreeState comparison = SqlKeywordCompletionContributor.compareFileSuffixWithKwPrefix(fileSeq, kwSeq, i2);
            if (comparison == ThreeState.NO) continue;
            int matched = comparison == ThreeState.UNSURE ? i2 - 1 : i2;
            return StringUtil.join(kwSeq.subList(matched, kwSeq.size()), (String)" ");
        }
        return null;
    }

    private static ThreeState compareFileSuffixWithKwPrefix(@NotNull List<CharSequence> fileSeq, @NotNull List<CharSequence> kwSeq, int size) {
        if (fileSeq == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(52);
        }
        if (kwSeq == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(53);
        }
        assert (size > 0);
        int end = size - 1;
        for (int i2 = 0; i2 < end; ++i2) {
            CharSequence keyWord;
            CharSequence fileWord = fileSeq.get(fileSeq.size() - size + i2);
            if (StringUtil.equalsIgnoreCase((CharSequence)fileWord, (CharSequence)(keyWord = kwSeq.get(i2)))) continue;
            return ThreeState.NO;
        }
        CharSequence fileWord = fileSeq.get(fileSeq.size() - 1);
        CharSequence keyWord = kwSeq.get(size - 1);
        if (keyWord.length() >= fileWord.length() && StringUtil.equalsIgnoreCase((CharSequence)fileWord, (CharSequence)keyWord.subSequence(0, fileWord.length()))) {
            return keyWord.length() == fileWord.length() ? ThreeState.YES : ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    @Nullable
    private static PsiElement getFragmentBorderElement(@NotNull Language dialect, PsiElement root2, PsiElement position, boolean backward) {
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(54);
        }
        int count2 = 0;
        PsiElement cur = position;
        while (cur != null && cur != root2) {
            PsiElement next;
            PsiElement psiElement = next = backward ? cur.getPrevSibling() : cur.getNextSibling();
            if (next instanceof SqlStatement) {
                if (backward && SqlKeywordCompletionContributor.isStatementClosingToken(dialect, next.getLastChild())) {
                    return SqlKeywordCompletionContributor.getNextElement(next);
                }
                return next;
            }
            if (next instanceof SqlBatchBlock || next instanceof GeneratedParserUtilBase.DummyBlock) {
                PsiElement psiElement2 = next = backward ? PsiTreeUtil.getDeepestLast((PsiElement)next) : PsiTreeUtil.getDeepestFirst((PsiElement)next);
                if (backward && SqlKeywordCompletionContributor.isStatementClosingToken(dialect, next)) {
                    return SqlKeywordCompletionContributor.getNextElement(next);
                }
            } else if (next == null) {
                next = cur.getParent();
            } else if (SqlKeywordCompletionContributor.isStatementClosingToken(dialect, next)) {
                return SqlKeywordCompletionContributor.getNextElement(next);
            }
            cur = next;
            ++count2;
        }
        return null;
    }

    private static PsiElement getNextElement(PsiElement next) {
        for (PsiElement e = next; e != null; e = e.getParent()) {
            PsiElement p2 = e.getNextSibling();
            if (p2 == null) continue;
            return p2;
        }
        return next;
    }

    private static boolean isStatementClosingToken(@NotNull Language dialect, PsiElement child) {
        if (dialect == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(55);
        }
        return dialect instanceof SqlLanguageDialect && child instanceof LeafPsiElement && ((SqlLanguageDialect)dialect).getStatementSeparators().contains(((LeafPsiElement)child).getElementType());
    }

    private static int getParenBalance(@NotNull CharSequence text2) {
        if (text2 == null) {
            SqlKeywordCompletionContributor.$$$reportNull$$$0(56);
        }
        int count2 = 0;
        int len = text2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = text2.charAt(i2);
            if (c2 == '(') {
                ++count2;
            }
            if (c2 != ')') continue;
            --count2;
        }
        return count2;
    }

    private static List<CharSequence> splitSpaces(CharSequence input) {
        List res2 = null;
        Matcher matcher = WHITESPACES.matcher(input);
        if (!matcher.find()) {
            return null;
        }
        int start = 0;
        int end = matcher.start();
        while (true) {
            if (res2 == null) {
                res2 = ContainerUtil.newSmartList();
            }
            res2.add(new CharSequenceSubSequence(input, start, end));
            if (end == input.length()) break;
            start = matcher.end();
            end = matcher.find() ? matcher.start() : input.length();
        }
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 30: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 30: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 5: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 17: 
            case 37: 
            case 45: 
            case 54: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 4: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/SqlKeywordCompletionContributor";
                break;
            }
            case 9: 
            case 15: 
            case 40: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 11: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordCase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCase";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ceil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checked";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePrefix";
                break;
            }
            case 36: 
            case 43: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 38: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedKeywords";
                break;
            }
            case 41: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSeq";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kwSeq";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/SqlKeywordCompletionContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWeightMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTypeWeightMap";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractFragment";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findGoodStatement";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWeightMap";
                break;
            }
            case 4: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 30: 
            case 31: 
            case 33: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcTypeWeightMap";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suggestKeywords";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentOfType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractFragment";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPrevStatementSameLevel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "blockRoot";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findGoodStatement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findError";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isError";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getStatementsRoot";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordLookupElement";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isInsideAnalyticClause";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findCustomInsertHandler";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateOrHasFollowingTail";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findMultiWordKeyword";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "compareFileSuffixWithKwPrefix";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentBorderElement";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isStatementClosingToken";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getParenBalance";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTypeWeightMap$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 18: 
            case 23: 
            case 24: 
            case 30: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

